/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.dao.PubContactOrgMiddleLogDao;
import com.guochuang.imp.pub.entity.PubContactOrgMiddleLog;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class PubContactOrgMiddleLogService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubContactOrgMiddleLogDao pubContactOrgMiddleLogDao;

    public PageObject pageAll(String logType, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtil.isEmpty(logType)) {
            params.put("logType", logType);
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("pub.PubContactOrgMiddleLog.pageAll", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            map.put("logTypeText", MemCache.getDicText("MIDDLE_LOG", StringUtil.null2String(map.get("logType"))));
            map.put("createAccountText", MemCache.getEmpAccountName(StringUtil.null2String(map.get("createAccount"))));
        }
        return pageObject;
    }

    @Transactional
    public void savePubContactOrgMiddleLog(PubContactOrgMiddleLog entity) {
        entity.setIsUse("Y");
        this.pubContactOrgMiddleLogDao.save(entity);
    }

    public PubContactOrgMiddleLog findPubContactOrgMiddleLog(Long id) {
        PubContactOrgMiddleLog entity = (PubContactOrgMiddleLog)this.pubContactOrgMiddleLogDao.findById(id).get();
        return entity;
    }

    public void delPubContactOrgMiddleLog(Long id) {
        PubContactOrgMiddleLog entity = (PubContactOrgMiddleLog)this.pubContactOrgMiddleLogDao.findById(id).get();
        entity.setIsUse("N");
        this.pubContactOrgMiddleLogDao.save(entity);
    }
}

