/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.dao.PubContactOrgAccountDao;
import com.guochuang.imp.pub.dao.PubOrgConAccountRelationDao;
import com.guochuang.imp.pub.entity.PubContactOrgAccount;
import com.guochuang.imp.pub.entity.PubOrgConAccountRelation;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.jsoup.internal.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubContactOrgAccountService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubContactOrgAccountDao pubcontactorgaccountDao;
    @Autowired
    private PubOrgConAccountRelationDao pubOrgConAccountRelationDao;

    public PubContactOrgAccount findPubContactOrgAccount(Long id) {
        PubContactOrgAccount entity = (PubContactOrgAccount)this.pubcontactorgaccountDao.findById(id).get();
        return entity;
    }

    public PubContactOrgAccount findByOrgAccountIdZcAndIsUse(String id) {
        PubContactOrgAccount entity = this.pubcontactorgaccountDao.findByOrgAccountIdZcAndIsUse(id, "Y");
        return entity;
    }

    public PubContactOrgAccount findPubContactOrgAccountByNoAndCardNo(String accountNo, String accountUnitNo) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isNotBlank((String)accountNo)) {
            return null;
        }
        params.put("accountNo", accountNo);
        params.put("accountUnitNo", accountUnitNo);
        PubContactOrgAccount entity = this.bSqlHelper.getEntity("pub.PubContactOrgAccount.findPubContactOrgAccountByNoAndCardNo", params, PubContactOrgAccount.class);
        return entity;
    }

    public void savePubContactOrgAccount(PubContactOrgAccount entity) {
        this.pubcontactorgaccountDao.save(entity);
        if (entity.getDataList() != null) {
            for (PubOrgConAccountRelation relation : entity.getDataList()) {
                relation.setOrgAccountId(entity.getOrgAccountId());
                relation.setContactOrgId(entity.getContactOrgId());
                if (StrKit.isBlank(relation.getIsUse())) {
                    relation.setIsUse("Y");
                }
                if (relation.getRelationId() == null) {
                    relation.setCreateAccount(entity.getModifyAccount());
                    relation.setCreateTime(new Date());
                }
                relation.setModifyAccount(entity.getModifyAccount());
                relation.setModifyTime(new Date());
                this.pubOrgConAccountRelationDao.save(relation);
            }
        }
    }

    public void delPubContactOrgAccount(Long id) {
        PubContactOrgAccount entity = (PubContactOrgAccount)this.pubcontactorgaccountDao.findById(id).get();
        entity.setIsUse("N");
        this.pubcontactorgaccountDao.save(entity);
        List<PubOrgConAccountRelation> relations = this.pubOrgConAccountRelationDao.findByOrgAccountIdAndIsUse(id, "Y");
        for (PubOrgConAccountRelation relation : relations) {
            relation.setIsUse("N");
            this.pubOrgConAccountRelationDao.save(relation);
        }
    }

    public PageObject PageAll(String contactOrgIdText, String contactOrgId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)contactOrgId)) {
            params.put("contactOrgId", contactOrgId);
        } else if (!StringUtils.isEmpty((String)contactOrgIdText)) {
            params.put("contactOrgIdText", "%" + contactOrgIdText.toUpperCase() + "%");
        } else {
            return null;
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrgAccount.selectWin", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject selectAll(Long id, Long flowDone, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (flowDone != null) {
            params.put("flowsql", " and " + SysUtils.genFlowDoneStatusSQL("t.workflow_status", flowDone) + " \n");
        }
        PageObject<Map<String, Object>> mapPageObject = this.bSqlHelper.serachPage("pub.PubContactOrgAccount.selectAll", params, PageRequest.of((int)page, (int)rows));
        List<Map<String, Object>> rows1 = mapPageObject.getRows();
        rows1.forEach(o -> {
            String status = (String)o.get("status");
            String pubContactOrgAccountStatus = MemCache.getDicText("pub_contact_org_account_status", status);
            o.put("statusText", pubContactOrgAccountStatus);
        });
        return mapPageObject;
    }

    public PageObject PageSelect(String contactOrgId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)contactOrgId)) {
            params.put("contactOrgId", contactOrgId);
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrgAccount.PageSelect", params, PageRequest.of((int)page, (int)rows));
    }

    public String findHiddenPanel(Long id, Boolean isdetail) {
        String excludepanels = "";
        if (id == null) {
            return excludepanels;
        }
        PubContactOrgAccount entity = this.findPubContactOrgAccount(id);
        if (entity.getWorkflowStatus() != null && entity.getWorkflowStatus().toString().indexOf(1) == -1 && isdetail.booleanValue()) {
            if ("N".equals(entity.getIsCancellationAccount()) && "N".equals(entity.getIsAllCon())) {
                return excludepanels;
            }
            excludepanels = "relationPanelId,";
        }
        return excludepanels;
    }

    public List<Map<String, Object>> findBanksByContactOrgId(Long contactOrgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contactOrgId", contactOrgId);
        return this.bSqlHelper.getMapList("pub.PubContactOrgAccount.selectWin", params);
    }

    public JsonMsg checkRepeat(PubContactOrgAccount entity) {
        JsonMsg msg = new JsonMsg();
        List<PubContactOrgAccount> list = this.pubcontactorgaccountDao.findByOrgBankAccountAndIsUse(entity.getOrgBankAccount(), "Y");
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u94f6\u884c\u8d26\u53f7\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list.size() == 1 && !list.get(0).getOrgAccountId().equals(entity.getOrgAccountId())) {
            msg.setSuccess(false);
            msg.setMsg("\u94f6\u884c\u8d26\u53f7\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        }
        return msg;
    }

    public boolean hasRepeatAccount(String accountNo, String accountUnitNo) {
        int o;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isBlank((String)accountNo)) {
            return false;
        }
        params.put("accountNo", accountNo);
        if (!StringUtil.isBlank((String)accountUnitNo)) {
            params.put("accountUnitNo", accountUnitNo);
        }
        return (o = this.bSqlHelper.getIntValue("pub.PubContactOrgAccount.hasRepeatAccount", params).intValue()) > 0;
    }

    public Map<String, Object> getMatchType(String orgBankAccount, String name, String orgOpenBank, String orgUnionpayNo) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<PubContactOrgAccount> list1 = this.pubcontactorgaccountDao.findByOrgBankAccountAndPayeeNameAndOrgOpenBankAndOrgUnionpayNoAndIsUse(orgBankAccount, name, orgOpenBank, orgUnionpayNo, "Y");
        List<PubContactOrgAccount> list2 = this.pubcontactorgaccountDao.findByOrgBankAccountAndIsUse(orgBankAccount, "Y");
        if (!list1.isEmpty()) {
            map.put("type", "1");
            map.put("entity", list1.get(0));
            return map;
        }
        if (!list2.isEmpty()) {
            map.put("type", "2");
            map.put("entity", list2.get(0));
            return map;
        }
        map.put("type", "0");
        map.put("entity", null);
        return map;
    }
}

