/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.pub.dao.PubAssetsAttrDao;
import com.guochuang.imp.pub.dao.PubAssetsCategoryDao;
import com.guochuang.imp.pub.entity.PubAssetsCategory;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubAssetsCategoryService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubAssetsCategoryDao pubAssetsCategoryDao;
    @Autowired
    private PubAssetsAttrDao pubAssetsAttrDao;

    public PubAssetsCategory findPubAssetsCategory(Long id) {
        PubAssetsCategory entity = (PubAssetsCategory)this.pubAssetsCategoryDao.findById(id).get();
        return entity;
    }

    public String findPubAssetsCategoryByIds(String ids) {
        String name = "";
        if (StringUtil.isNotEmpty(ids)) {
            for (String id : ids.split(",")) {
                PubAssetsCategory entity;
                if (!StringUtil.isNotEmpty(id) || (entity = (PubAssetsCategory)this.pubAssetsCategoryDao.findById(Long.parseLong(id)).get()) == null) continue;
                name = name + "," + entity.getCategoryName();
            }
        }
        if (StringUtils.isNotBlank((String)name)) {
            name = name.substring(1);
        }
        return name;
    }

    public void savePubAssetsCategory(PubAssetsCategory entity) {
        if (entity.getCategoryPid() != null && entity.getCategoryPid().intValue() != 0) {
            entity.setpCode(this.findPubAssetsCategory(entity.getCategoryPid()).getCategoryCode());
        }
        this.pubAssetsCategoryDao.save(entity);
        if (entity.getAttrs() != null) {
            entity.getAttrs().forEach(attr -> {
                attr.setCategoryId(entity.getCategoryId());
                attr.setIsUse("Y");
                attr.setOrgId(SysContent.GROUP_ORG);
            });
            this.pubAssetsAttrDao.saveAll(entity.getAttrs());
        }
    }

    public void delPubAssetsCategory(Long id) {
        PubAssetsCategory entity = this.findPubAssetsCategory(id);
        entity.setIsUse("N");
        this.pubAssetsCategoryDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", search);
        }
        return this.bSqlHelper.serachPage("pub.PubAssetsCategory.PageAll", params);
    }

    public void delPubAssetsCategoryAndChild(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.bSqlHelper.updateOrDelete("pub.PubAssetsCategory.delPubAssetsCategoryAndChild", params);
    }

    public List<ComBoxTreeNode> treePubAssetsCategory(Long pid, String bizType, String isCard) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        if (!StringUtils.isEmpty((String)bizType)) {
            params.put("bizType", bizType);
        }
        if (!StringUtils.isEmpty((String)isCard)) {
            params.put("isCard", isCard);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("pub.PubAssetsCategory.select", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public String getCategoryTextById(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        return this.bSqlHelper.getStringValue("pub.PubAssetsCategory.getCategoryTextById", params);
    }
}

