/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.controller;

import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.pub.entity.PubFlowRelate;
import com.guochuang.imp.pub.service.PubFlowRelateService;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/PubFlowRelate"})
public class PubFlowRelateController
extends BaseController {
    @Autowired
    private PubFlowRelateService pubflowrelateService;

    @RequestMapping(value={"/findPubFlowRelate"})
    @ResponseBody
    public Object findPubFlowRelate(Long id) {
        PubFlowRelate entity = this.pubflowrelateService.findPubFlowRelate(id);
        return entity;
    }

    @RequestMapping(value={"/savePubFlowRelate"})
    @ResponseBody
    public Object savePubFlowRelate(HttpServletRequest request, PubFlowRelate entity) throws GEPSBisException {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getFlowRelateId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.pubflowrelateService.savePubFlowRelate(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delPubFlowRelate"})
    @ResponseBody
    public Object delPubFlowRelate(Long id) {
        this.pubflowrelateService.delPubFlowRelate(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/editPubFlowRelate"})
    public Object editPubFlowRelate(Model model, Long id, String formcode) {
        if (id != null && StrKit.notBlank(formcode)) {
            List<Map<String, Object>> pfrList = this.pubflowrelateService.findByRelateBizId(id, formcode);
            model.addAttribute("pfrList", pfrList);
        } else {
            model.addAttribute("pfrList", (Object)Collections.EMPTY_LIST);
        }
        return "/pub/PubFlowRelate";
    }

    @RequestMapping(value={"/checkPubFlowRelate"})
    public Object checkPubFlowRelate(Model model, Long id, String formcode) {
        if (id != null && StrKit.notBlank(formcode)) {
            List<Map<String, Object>> checkFlowList = this.pubflowrelateService.findByRelateBizId(id, formcode);
            model.addAttribute("checkFlowList", checkFlowList);
        }
        return "/pub/PubFlowRelateForCheck";
    }

    @RequestMapping(value={"/pagePubFlowRelateWin"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubFlowRelateWin(HttpServletRequest request, @RequestParam(value="filterflowid", defaultValue="") String filterflowid, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.pubflowrelateService.pagePubFlowRelateWin(filterflowid, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/pageCheckFlowRelateWin"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageCheckFlowRelateWin(HttpServletRequest request, @RequestParam(value="filterflowid", defaultValue="") String filterflowid, String conId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.pubflowrelateService.pageCheckFlowRelateWin(filterflowid, conId, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/pagConnectFlow"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagConnectFlow(HttpServletRequest request, String formCode, String busiMainId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.pubflowrelateService.pagConnectFlow(formCode, busiMainId, search, page, rows, sort, order);
    }
}

