/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.controller;

import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.pub.dao.PubContactOrgAccountDao;
import com.guochuang.imp.pub.dao.PubContactOrgDao;
import com.guochuang.imp.pub.entity.PubContactOrgAccount;
import com.guochuang.imp.pub.service.PubContactOrgAccountService;
import com.guochuang.imp.pub.service.PubContactOrgService;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/PubContactOrgAccount"})
public class PubContactOrgAccountController
extends BaseController {
    @Autowired
    private PubContactOrgAccountService pubcontactorgaccountService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private PubContactOrgAccountDao pubContactOrgAccountDao;
    @Autowired
    private PubContactOrgDao pubContactOrgDao;
    @Autowired
    private PubContactOrgService pubContactOrgService;

    @RequestMapping(value={"/pagePubContactOrgAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubContactOrgAccount(HttpServletRequest request, String contactOrgId, String contactOrgIdText, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.pubcontactorgaccountService.PageAll(contactOrgIdText, contactOrgId, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/selectPubContactOrgAccount"}, method={RequestMethod.POST})
    @ResponseBody
    public Object selectPubContactOrgAccount(HttpServletRequest request, Long id, Long flowDone, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.pubcontactorgaccountService.selectAll(id, flowDone, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/pagePubOrgAccountSelect"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pagePubOrgAccountSelect(HttpServletRequest request, String contactOrgId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.pubcontactorgaccountService.PageSelect(contactOrgId, search, page, rows, sort, order);
    }

    @RequestMapping(value={"/findPubContactOrgAccount"})
    @ResponseBody
    public Object findPubContactOrgAccount(Long id) {
        PubContactOrgAccount entity = this.pubcontactorgaccountService.findPubContactOrgAccount(id);
        return entity;
    }

    @RequestMapping(value={"/savePubContactOrgAccount"})
    @ResponseBody
    public Object savePubContactOrgAccount(HttpServletRequest request, PubContactOrgAccount entity, String formcode) throws GEPSBisException {
        JsonMsg msg = this.pubcontactorgaccountService.checkRepeat(entity);
        if (msg.isSuccess()) {
            entity.setModifyAccount(this.getLoginUser(request).getAccountid());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            this.pubcontactorgaccountService.savePubContactOrgAccount(entity);
        }
        return msg;
    }

    @RequestMapping(value={"/delPubContactOrgAccount"})
    @ResponseBody
    public Object delPubContactOrgAccount(Long id) {
        this.pubcontactorgaccountService.delPubContactOrgAccount(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/setContactAccount"})
    @ResponseBody
    public Object setContactAccount(Long id, Long contactOrgId) {
        PubContactOrgAccount entity = this.pubcontactorgaccountService.findPubContactOrgAccount(id);
        List<PubContactOrgAccount> accounts = this.pubContactOrgAccountDao.findByContactOrgIdAndIsUse(contactOrgId, "Y");
        if (accounts != null && accounts.size() > 0) {
            for (PubContactOrgAccount account : accounts) {
                account.setIsDefaultAccount("N");
                this.pubcontactorgaccountService.savePubContactOrgAccount(account);
            }
        }
        entity.setIsDefaultAccount("Y");
        this.pubcontactorgaccountService.savePubContactOrgAccount(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/stopContactAccount"})
    @ResponseBody
    public Object stopContactAccount(Long id) {
        PubContactOrgAccount entity = this.pubcontactorgaccountService.findPubContactOrgAccount(id);
        entity.setStatus("0");
        this.pubcontactorgaccountService.savePubContactOrgAccount(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/startContactAccount"})
    @ResponseBody
    public Object startContactAccount(Long id) {
        PubContactOrgAccount entity = this.pubcontactorgaccountService.findPubContactOrgAccount(id);
        entity.setStatus("1");
        this.pubcontactorgaccountService.savePubContactOrgAccount(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/findHiddenPanel"})
    @ResponseBody
    public String findHiddenPanel(Long id, Boolean isdetail) {
        return this.pubcontactorgaccountService.findHiddenPanel(id, isdetail);
    }

    @RequestMapping(value={"/getBanksByContactOrgId"})
    @ResponseBody
    public JsonMsg getBanksByContactOrgId(Long contactOrgId, @RequestParam(value="distinct", defaultValue="false") String distinct) {
        JsonMsg msg = new JsonMsg();
        List<Map<String, Object>> banks = this.pubcontactorgaccountService.findBanksByContactOrgId(contactOrgId);
        if (banks == null) {
            msg.setMsg("\u8be5\u5355\u4f4d\u76ee\u524d\u6ca1\u6709\u5f00\u6237\u884c\u53ca\u8d26\u53f7\u4fe1\u606f");
            msg.setSuccess(false);
            return msg;
        }
        if (banks.size() > 0) {
            if (!"false".equals(distinct)) {
                if (banks.size() == 1) {
                    msg.setO(banks.get(0));
                    msg.setSuccess(true);
                    return msg;
                }
                msg.setSuccess(false);
                return msg;
            }
            msg.setO(banks.get(0));
            msg.setSuccess(true);
            return msg;
        }
        return msg;
    }
}

