/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.controller;

import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.pub.entity.PubAssetsSource;
import com.guochuang.imp.pub.service.PubAssetsSourceService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/pubAssetsSource"})
public class PubAssetsSourceController
extends BaseController {
    @Autowired
    private PubAssetsSourceService pubAssetsSourceService;

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public PageObject pageAll(String fuzzy, String status, int page, int rows, String sort, String order) {
        return this.pubAssetsSourceService.pageAll(fuzzy, status, page, rows, sort, order);
    }

    @PostMapping(value={"/savePubAssetsSource"})
    @ResponseBody
    public JsonMsg savePubAssetsSource(HttpServletRequest request, PubAssetsSource entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getSourceId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.pubAssetsSourceService.savePubAssetsSource(entity);
        return msg;
    }

    @PostMapping(value={"/findPubAssetsSource"})
    @ResponseBody
    public PubAssetsSource findPubAssetsSource(Long id) {
        PubAssetsSource entity = this.pubAssetsSourceService.findPubAssetsSource(id);
        return entity;
    }

    @PostMapping(value={"/delPubAssetsSource"})
    @ResponseBody
    public JsonMsg delPubAssetsSource(Long id) {
        this.pubAssetsSourceService.delPubAssetsSource(id);
        return new JsonMsg();
    }

    @PostMapping(value={"/getAssetsSourceCombo"})
    @ResponseBody
    public List<ComboxNode> getAssetsSourceCombo(String bizType, String isHandWork) {
        return this.pubAssetsSourceService.getAssetsSourceCombo(bizType, isHandWork);
    }
}

