/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.pub.controller;

import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.pub.entity.PubArea;
import com.guochuang.imp.pub.service.PubAreaService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/PubArea"})
public class PubAreaController
extends BaseController {
    @Autowired
    private PubAreaService basareaService;

    @RequestMapping(value={"/pagePubArea"})
    @ResponseBody
    public Object pagePubArea(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basareaService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findPubArea"})
    @ResponseBody
    public Object findPubArea(Long id) {
        return this.basareaService.findPubArea(id);
    }

    @RequestMapping(value={"/savePubArea"})
    @ResponseBody
    public Object savePubArea(PubArea entity) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        this.basareaService.savePubArea(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delPubArea"})
    @ResponseBody
    public Object delPubArea(Long id) {
        PubArea entity = this.basareaService.findPubArea(id);
        entity.setIsUse("N");
        this.basareaService.savePubArea(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treePubAreaWithRoot"})
    @ResponseBody
    public Object treePubAreaWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid) {
        List<ComBoxTreeNode> treelist = this.basareaService.treePubArea(pid);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treePubArea"})
    @ResponseBody
    public Object treePubArea(@RequestParam(value="pid", defaultValue="0") Long pid) {
        return this.basareaService.treePubArea(pid);
    }

    @RequestMapping(value={"/treePubAreaAnsy"})
    @ResponseBody
    public Object listPubArea(@RequestParam(value="id", defaultValue="0") Long id) {
        if (id == 0L) {
            List<ComBoxTreeNode> treelist = this.basareaService.treePubAreaAnsy(id);
            ComBoxTreeNode root = new ComBoxTreeNode();
            root.setId("0");
            root.setText("\u6839\u8282\u70b9");
            root.setChecked(false);
            root.setChildren(treelist);
            root.setState("open");
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
            list.add(root);
            return list;
        }
        return this.basareaService.treePubAreaAnsy(id);
    }

    @RequestMapping(value={"/delPubAreaAndChild"})
    @ResponseBody
    public Object delPubAreaAndChild(Long id) {
        this.basareaService.delPubAreaAndChild(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/queryPubAreaByCity"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryPubAreaByCity(HttpServletRequest request, String levels, @RequestParam(value="pid", defaultValue="0") Long pid, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail) {
        LoginUser user = this.getLoginUser(request);
        List<ComboxNode> itemList = this.basareaService.queryPubAreaByCity(levels);
        return itemList;
    }

    @RequestMapping(value={"/getCityPickerData"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getCityPickerData(HttpServletRequest request, String levels, @RequestParam(value="pid", defaultValue="0") Long pid, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail) {
        JsonMsg msg = new JsonMsg();
        msg.setO(this.basareaService.getCityPickerData());
        return msg;
    }
}

