/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.gen.service;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.DateUtils;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LayuiPageObject;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.common.util.ValueText;
import com.guochuang.imp.base.entity.BasDept;
import com.guochuang.imp.base.entity.BasDic;
import com.guochuang.imp.base.entity.BasDicType;
import com.guochuang.imp.base.entity.BasMessage;
import com.guochuang.imp.base.service.BasDeptService;
import com.guochuang.imp.base.service.BasDicService;
import com.guochuang.imp.base.service.BasDicTypeService;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasMessageService;
import com.guochuang.imp.base.service.BasSysCodeService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.doc.dao.DocFileTypeDao;
import com.guochuang.imp.doc.entity.DocFileType;
import com.guochuang.imp.doc.entity.DocFileVersion;
import com.guochuang.imp.doc.entity.DocFormFile;
import com.guochuang.imp.doc.service.DocFileTypeService;
import com.guochuang.imp.doc.service.DocFileVersionService;
import com.guochuang.imp.doc.service.DocFormFileService;
import com.guochuang.imp.gen.common.BuildFile;
import com.guochuang.imp.gen.common.BuildForm;
import com.guochuang.imp.gen.common.BuildGroup;
import com.guochuang.imp.gen.common.BuildItem;
import com.guochuang.imp.gen.common.BuildPanel;
import com.guochuang.imp.gen.common.BuildType;
import com.guochuang.imp.gen.dao.GenFormDao;
import com.guochuang.imp.gen.dao.GenPanelFileDao;
import com.guochuang.imp.gen.dao.GenPanelItemDao;
import com.guochuang.imp.gen.entity.DBTable;
import com.guochuang.imp.gen.entity.GenAppFile;
import com.guochuang.imp.gen.entity.GenAppFileType;
import com.guochuang.imp.gen.entity.GenAppForm;
import com.guochuang.imp.gen.entity.GenAppItem;
import com.guochuang.imp.gen.entity.GenForm;
import com.guochuang.imp.gen.entity.GenFormAdvices;
import com.guochuang.imp.gen.entity.GenFormFlow;
import com.guochuang.imp.gen.entity.GenFormPanel;
import com.guochuang.imp.gen.entity.GenPanelFile;
import com.guochuang.imp.gen.entity.GenPanelGroup;
import com.guochuang.imp.gen.entity.GenPanelItem;
import com.guochuang.imp.gen.entity.GenPanleItemType;
import com.guochuang.imp.gen.service.GenFormAdvicesService;
import com.guochuang.imp.gen.service.GenFormFlowService;
import com.guochuang.imp.gen.service.GenFormPanelService;
import com.guochuang.imp.gen.service.GenPanelGroupService;
import com.guochuang.imp.gen.service.GenPanelItemService;
import com.guochuang.imp.gen.service.GenPanleItemTypeService;
import com.guochuang.imp.gen.service.GeneratorService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.gen.util.FreeMarkerUtil;
import com.guochuang.imp.pub.service.PubContactOrgService;
import com.guochuang.imp.sys.util.BeanCompareUtils;
import com.guochuang.imp.sys.util.ListUtils;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.workflow.service.FlowUtilService;
import com.ustcsoft.usiflow.engine.model.ProcessInstance;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@Transactional
public class GenFormService {
    private static final Logger logger = Logger.getLogger(GenFormService.class);
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private GenFormPanelService formPanelService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private DocFileVersionService docFileVersionService;
    @Autowired
    private GenPanelItemDao panelItemDao;
    @Autowired
    private GenFormDao genformDao;
    @Autowired
    private GenFormService genFormService;
    @Autowired
    private GenPanelItemService genpanelitemService;
    @Autowired
    private GenPanleItemTypeService genpanleitemTypeService;
    @Autowired
    private GenPanelItemDao genpanelitemDao;
    @Autowired
    private BasSysCodeService basSysCodeService;
    @Autowired
    private DocFileTypeDao docfiletypeDao;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private BasDeptService basDeptService;
    @Autowired
    private BasMessageService basMessageService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private PubContactOrgService pubContactOrgService;
    @Autowired
    private GenPanelFileDao genpanelfileDao;
    @Autowired
    private DocFileTypeService docfiletypeService;
    @Autowired
    private GenFormFlowService genFormFlowService;
    @Autowired
    private GenPanelGroupService genpanelgroupService;
    @Autowired
    private BasDicTypeService basdictypeService;
    @Autowired
    private GeneratorService generatorService;
    @Autowired
    private BasDicService basdiceService;
    @Value(value="${formBorder:yes}")
    private String formBorder;
    @Autowired
    private GenFormAdvicesService genFormAdvicesService;

    public GenForm findGenFormByCode(String formcode) {
        List<GenForm> list = this.genformDao.findByFormCodeAndIsUse(formcode, "Y");
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public StringBuilder findGenFormByCodes(String formcodes) {
        String[] formcode;
        StringBuilder formName = new StringBuilder();
        for (String s : formcode = formcodes.split(",")) {
            List<GenForm> list = this.genformDao.findByFormCodeAndIsUse(s, "Y");
            if (list == null || list.size() <= 0) continue;
            if (formName.length() > 0) {
                formName.append(",");
            }
            formName.append(list.get(0).getFormName());
        }
        return formName;
    }

    public GenForm findByFlowCode(String flowCode) {
        List<GenForm> list = this.genformDao.findByFlowCodeAndIsUse(flowCode, "Y");
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public GenForm findByFormCode(String formCode) {
        List<GenForm> list = this.genformDao.findByFormCodeAndIsUse(formCode, "Y");
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public GenForm findGenForm(String id) {
        return (GenForm)this.genformDao.findById(id).get();
    }

    public void saveGenForm(GenForm entity) {
        this.genformDao.save(entity);
    }

    public void delGenForm(String id) {
        this.genformDao.deleteById(id);
    }

    public PageObject PageAll(String search, String formCodes, int page, int rows, boolean isContainUrl, boolean isContainColum) {
        PageObject pageobject = new PageObject();
        StringBuffer sql = new StringBuffer();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select t.*,\n           a.catalog_name,\n           case when b.design_name   is null then null else CONCAT( b.design_name , '(' , b.flow_name , ')') end flow_name\n  from GEN_FORM t\n  left join doc_catalog a\n  on t.catalog_id = a.catalog_id\n  left join stf_business_process b\n    on t.flow_code = b.design_name\n");
        sql.append(" WHERE T.IS_USE = 'Y' ");
        if (!StringUtils.isEmpty((CharSequence)formCodes)) {
            sql.append(" AND FIND_IN_SET(t.FORM_CODE,'" + formCodes + "') ");
        }
        if (!StringUtils.isEmpty((CharSequence)search)) {
            sql.append(" and ( upper(t.FORM_CODE) like :search  or upper(t.FORM_NAME) like :search  or upper(t.FLOW_CODE) like :search  or upper(t.FORM_URL) like :search  or upper(t.LOADDATA_URL) like :search  or upper(t.BUSI_TABLE) like :search or upper(t.MEMO) like :search " + (isContainUrl ? " or exists(select 1 from gen_form_panel p where p.form_id= t.id and p.is_use='Y' and (upper(p.PANEL_TITLE) like :search or upper(p.PANEL_URL) like :search or upper(p.PANEL_HTMLID) like :search) )" : "") + (isContainColum ? " or exists(select 1 from gen_form_panel p,gen_panel_item i  where p.form_id= t.id  and i.panel_id = p.panel_id and i.is_use='Y' and p.is_use='Y' and (upper(i.ITEM_LABEL) like :search or upper(i.ITEM_HTMLID) like :search or upper(i.COMBO_URL) like :search or upper(i.DIC_CODE) like :search or upper(i.DATAOPTIONS) like :search\t or upper(i.ITEM_HTMLNAME) like :search\t) )  " : "") + ")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append("  order by t.FORM_CODE");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("FORM_TYPE", "FORM_TYPE");
        dicmapper.put("FORM_STYLE", "FORM_STYLE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllFlow(String search, int page, int rows, String orgId) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.design_name, concat( t.design_name,'(',GETORGNAME(t.APPLY_ORGS) ,t.flow_name,')')text,GETORGNAME(t.APPLY_ORGS) org_name,concat( t.design_name,'(',t.flow_name,')')flow_name  from STF_BUSINESS_PROCESS t,Stf_Business_Type y where y.res_id=t.business_type_id ");
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            sql.append("and ( t.APPLY_ORGS is null or concat(',',t.APPLY_ORGS,',') like concat('%,',:orgId,',%'))");
            params.put("orgId", orgId);
        }
        if (!StringUtils.isEmpty((CharSequence)search)) {
            sql.append(" and (upper(t.design_name) like :search  or upper(concat( t.design_name,'(',GETORGNAME(t.APPLY_ORGS) ,t.flow_name,')')) like :search  or upper(GETORGNAME(t.APPLY_ORGS) like :search )) ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.design_name");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        return pageobject;
    }

    public List allFlow(String type, String orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sql = "select t.design_name,t.business_type_id , concat( t.design_name,'(',GETORGNAME(t.APPLY_ORGS) ,t.flow_name,')')text,CASE WHEN t.SHARE_TYPE = 1 THEN '\u96c6\u56e2\u7ef4\u62a4\uff0c\u5168\u5c40\u5171\u4eab' ELSE GETORGNAME ( t.APPLY_ORGS ) END AS org_name,concat( t.design_name,'(',t.flow_name,')')flow_name  from STF_BUSINESS_PROCESS t,Stf_Business_Type y where y.res_id=t.business_type_id ";
        if (StringUtils.isNotBlank((CharSequence)orgId)) {
            sql = sql + "and ( t.APPLY_ORGS is null or concat(',',t.APPLY_ORGS,',') like concat('%,',:orgId,',%'))";
            params.put("orgId", orgId);
        }
        sql = sql + " order by t.design_name";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, new int[0]);
        return list;
    }

    public JsonMsg checkRepeat(GenForm entity) {
        JsonMsg msg = new JsonMsg();
        List<GenForm> list = this.genformDao.findByFormCodeAndIsUse(entity.getFormCode(), "Y");
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u6709\u91cd\u590d\u6570\u636e,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list.size() == 1 && !list.get(0).getId().equals(entity.getId())) {
            msg.setSuccess(false);
            msg.setMsg("\u6709\u91cd\u590d\u6570\u636e,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        }
        return msg;
    }

    /*
     * WARNING - void declaration
     */
    public GenAppForm buildAppForm(String formcode, String id, HttpServletRequest request, HttpServletResponse response, boolean isdetail) throws Exception {
        GenAppForm appform = new GenAppForm();
        GenForm form = this.findGenFormByCode(formcode);
        Map<Object, Object> flowInfo = new HashMap<String, String>();
        GenFormFlow gflow = null;
        String flowCode = null;
        Long orgId = SysUtils.getLoginUser().getOrgid();
        if (form != null) {
            String pkCol = this.generatorService.getPK(form.getBusiTable());
            appform.setPk(DBPropertyUtil.columnToProperty2(pkCol));
            LoginUser user = (LoginUser)request.getSession().getAttribute("LOGIN_USER");
            HashMap<String, LoginUser> freemarkmap = new HashMap<String, LoginUser>();
            freemarkmap.put("loginuser", user);
            appform.setAppDetailUrl(form.getAppDetailUrl());
            appform.setCatalogid(form.getCatalogId());
            appform.setFormId(form.getId());
            appform.setFormName(form.getFormName());
            List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
            appform.setActionUrl(form.getSubmitUrl());
            JSONObject data = null;
            for (GenFormPanel panel : panellist) {
                if (panel.getPanelType().equals(BuildType.PANEL_FORM) || panel.getPanelType().equals(BuildType.PANEL_TAB_FORM)) {
                    List<GenPanelGroup> grouplist = this.genpanelgroupService.findByPanelId(panel.getPanelId());
                    ArrayList<BuildGroup> glist = new ArrayList<BuildGroup>();
                    if (grouplist.isEmpty()) {
                        BuildGroup g = new BuildGroup();
                        g.setGroupId("panel" + panel.getPanelId());
                        g.setGroupTitle(panel.getPanelTitle());
                        glist.add(g);
                    } else {
                        for (GenPanelGroup group : grouplist) {
                            BuildGroup g = new BuildGroup();
                            g.setGroupId(group.getGroupId());
                            g.setGroupTitle(group.getGroupTitle());
                            glist.add(g);
                        }
                    }
                    appform.setGroups(glist);
                    String loadurl = "";
                    if (!StrKit.notBlank(form.getLoaddataUrl())) continue;
                    String paras = "formcode=" + formcode + "&id=" + id;
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        loadurl = form.getLoaddataUrl().indexOf("?") > 0 ? form.getLoaddataUrl() + "&" + paras : form.getLoaddataUrl() + "?" + paras;
                        Object objectdata = SysUtils.sendHttp(request, response, loadurl);
                        data = (JSONObject)objectdata;
                    } else {
                        data = new JSONObject();
                    }
                    if (StringUtils.isNotBlank((CharSequence)id) && data.getLong("processinstid") != null) {
                        ProcessInstance process = this.flowUtilService.getProcInstService().findProcessById(data.getLong("processinstid").longValue());
                        orgId = this.basEmpAccountService.findById(Long.parseLong(process.getCreator())).getOrgId();
                    }
                    gflow = this.genFormFlowService.findByFormIdAndApplyOrgs(form.getId(), null, orgId.toString());
                    flowCode = form.getFlowCode();
                    if (gflow != null) {
                        flowCode = gflow.getFlowCode();
                    }
                    if (StringUtils.isNotBlank((CharSequence)id) && data.getLong("processinstid") != null) {
                        flowInfo = this.flowUtilService.getFlowInfo(data.getLong("processinstid"));
                    } else if (StringUtils.isNotBlank((CharSequence)flowCode)) {
                        flowInfo.put("actId", this.flowUtilService.getFirstAct(flowCode));
                    } else {
                        flowInfo.put("actId", "Act_1");
                    }
                    HashMap<String, Map> actItemMap = new HashMap<String, Map>();
                    if (flowInfo.get("actId") != null || StringUtils.isNotBlank((CharSequence)flowCode)) {
                        List<Map<String, Object>> actItems = this.genFormFlowService.getFormItem(form.getId(), orgId, null, Objects.toString(flowInfo.get("actId"), StringUtils.isNotBlank((CharSequence)flowCode) ? (data.getLong("processinstid") == null ? this.flowUtilService.getFirstAct(flowCode) : this.flowUtilService.getFirstAct(data.getLong("processinstid"))) : ""), "");
                        for (Map map : actItems) {
                            actItemMap.put(map.get("itemId").toString(), map);
                        }
                    }
                    appform.setFlowInfo(flowInfo);
                    List<GenPanelItem> itemlist = this.genpanelitemDao.findByPanelIdAndIsUseAndAppShowOrderByDisplayNo(panel.getPanelId(), "Y", 1L);
                    for (GenPanelItem genPanelItem : itemlist) {
                        List actlist;
                        GenAppItem item = new GenAppItem();
                        item.setType(genPanelItem.getItemType());
                        item.setLabel(genPanelItem.getItemLabel());
                        if (StringUtils.isNotBlank((CharSequence)genPanelItem.getItemUnit())) {
                            item.setLabel(genPanelItem.getItemLabel() + "(" + genPanelItem.getItemUnit() + ")");
                        }
                        item.setHidden(1L == genPanelItem.getHidden());
                        item.setUnit(genPanelItem.getItemUnit());
                        item.setGroupId(StringUtils.isBlank((CharSequence)genPanelItem.getGroupId()) ? "panel" + panel.getPanelId() : genPanelItem.getGroupId());
                        item.setName(genPanelItem.getItemHtmlname());
                        item.setLength(genPanelItem.getItemLength());
                        item.setDecimal(genPanelItem.getItemDecimal());
                        item.setAppOptions(genPanelItem.getAppoptions());
                        if (BuildType.ITEM_DICBOX.equals(genPanelItem.getItemType())) {
                            item.setUrl("/dic/dic?typeCode=" + genPanelItem.getDicCode());
                        } else {
                            item.setUrl(FreeMarkerUtil.instance().genString(genPanelItem.getComboUrl(), (Map)data));
                        }
                        if (BuildType.ITEM_OTHERRADIOBOX.equals(genPanelItem.getItemType())) {
                            item.setType(BuildType.ITEM_DICRADIOBOX);
                        }
                        if (BuildType.ITEM_OTHERCHECKBOX.equals(genPanelItem.getItemType())) {
                            item.setType(BuildType.ITEM_DICCHECKBOX);
                        }
                        if (BuildType.ITEM_OTHERCOMBOBOX.equals(genPanelItem.getItemType())) {
                            item.setType(BuildType.ITEM_COMBOBOX);
                        }
                        if (BuildType.ITEM_DICRADIOBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_OTHERRADIOBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_OTHERCHECKBOX.equals(genPanelItem.getItemType())) {
                            item.setUrl("/dic/dic?typeCode=" + genPanelItem.getDicCode());
                        }
                        if (StringUtils.isBlank((CharSequence)id)) {
                            item.setValue(FreeMarkerUtil.instance().genString(genPanelItem.getDefaultValue(), freemarkmap));
                            if (StringUtils.isNotBlank((CharSequence)item.getValue())) {
                                data.put(genPanelItem.getItemHtmlname(), (Object)item.getValue());
                            }
                        }
                        if (data != null && data.containsKey((Object)genPanelItem.getItemHtmlname())) {
                            DocFileVersion version;
                            String detailId;
                            JSONArray array;
                            Object combodata;
                            String combourl;
                            item.setHiddenValue(data.getString(genPanelItem.getItemHtmlname()));
                            if (BuildType.ITEM_MONEYBOX.equals(genPanelItem.getItemType())) {
                                item.setValue(data.getString(genPanelItem.getItemHtmlname()));
                            } else {
                                item.setValue(data.getString(genPanelItem.getItemHtmlname()));
                            }
                            if ("6".equals(genPanelItem.getItemType()) || StringUtils.isNotBlank((CharSequence)genPanelItem.getDicCode()) && (BuildType.ITEM_DICRADIOBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(genPanelItem.getItemType())) || BuildType.ITEM_OTHERRADIOBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_OTHERCHECKBOX.equals(genPanelItem.getItemType())) {
                                item.setType("6");
                                String value = this.commonService.getDicText(genPanelItem.getDicCode(), item.getValue());
                                item.setValue(value);
                                if (BuildType.ITEM_OTHERRADIOBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_OTHERCHECKBOX.equals(genPanelItem.getItemType())) {
                                    GenAppItem itemother = new GenAppItem();
                                    itemother.setType(item.getType());
                                    itemother.setLabel(genPanelItem.getItemLabel());
                                    itemother.setName(genPanelItem.getItemHtmlname() + "Other");
                                    itemother.setHidden(true);
                                    itemother.setHiddenValue(data.getString(itemother.getName()));
                                    if ("0".equals(item.getHiddenValue()) || "\u5176\u4ed6".equals(value)) {
                                        item.setValue((value == null ? "" : value) + "-" + itemother.getHiddenValue());
                                        appform.AddItem(itemother);
                                    }
                                }
                            } else if ("2".equals(genPanelItem.getItemType()) || BuildType.ITEM_DICRADIOBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_OTHERCOMBOBOX.equals(genPanelItem.getItemType())) {
                                item.setType("2");
                                combourl = genPanelItem.getComboUrl().indexOf("?") > 0 ? genPanelItem.getComboUrl() + "&" + paras + "&detailId=" + URLUtil.encode((String)item.getValue()) : genPanelItem.getComboUrl() + "?" + paras + "&detailId=" + URLUtil.encode((String)(item.getValue() == null ? "" : item.getValue()));
                                combodata = SysUtils.sendHttp(request, response, FreeMarkerUtil.instance().genString(combourl, (Map)data));
                                array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata));
                                String combtext = "";
                                for (int i = 0; i < array.size(); ++i) {
                                    JSONObject jsonObject = array.getJSONObject(i);
                                    if (!("," + item.getHiddenValue() + ",").contains("," + jsonObject.getString("value") + ",")) continue;
                                    combtext = combtext + (StringUtils.isBlank((CharSequence)combtext) ? "" : ",") + jsonObject.getString("text");
                                }
                                if (StringUtils.isNotBlank((CharSequence)combtext)) {
                                    item.setValue(combtext);
                                }
                                if (BuildType.ITEM_OTHERCOMBOBOX.equals(genPanelItem.getItemType())) {
                                    GenAppItem itemother = new GenAppItem();
                                    itemother.setType(item.getType());
                                    itemother.setLabel(genPanelItem.getItemLabel());
                                    itemother.setName(genPanelItem.getItemHtmlname() + "Other");
                                    itemother.setHidden(true);
                                    itemother.setHiddenValue(data.getString(itemother.getName()));
                                    if ("0".equals(item.getHiddenValue()) || "\u5176\u4ed6".equals(combtext)) {
                                        item.setValue((combtext == null ? "" : combtext) + "-" + itemother.getHiddenValue());
                                        appform.AddItem(itemother);
                                    }
                                }
                            } else if (BuildType.ITEM_COMBOTREE.equals(genPanelItem.getItemType())) {
                                if (StringUtils.isNotBlank((CharSequence)item.getHiddenValue())) {
                                    combourl = genPanelItem.getComboUrl().indexOf("?") > 0 ? genPanelItem.getComboUrl() + "&" + paras : genPanelItem.getComboUrl() + "?" + paras;
                                    combodata = SysUtils.sendHttp(request, response, combourl = combourl + "&detailId=" + URLUtil.encode((String)item.getHiddenValue()));
                                    if (combodata != null && (array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata))).size() > 0) {
                                        for (int i = 0; i < array.size(); ++i) {
                                            if (!item.getHiddenValue().equals(array.getJSONObject(i).getString("id"))) continue;
                                            item.setValue(array.getJSONObject(i).getString("text"));
                                            break;
                                        }
                                    }
                                }
                            } else if (("-" + BuildType.ITEM_EMPCHOOSEBOX).equals(genPanelItem.getItemType()) || BuildType.ITEM_EMPCHOOSEBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_HREMPCHOOSEBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_DEPTCHOOSEBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_PROCHOOSEBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_CONORGCHOOSEBOX.equals(genPanelItem.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(genPanelItem.getItemType()) || BuildType.ITEM_DEPT_TEXTBOX.equals(genPanelItem.getItemType())) {
                                if (StringUtils.isNotBlank((CharSequence)item.getValue())) {
                                    if (BuildType.ITEM_DEPTCHOOSEBOX.equals(genPanelItem.getItemType())) {
                                        item.setValue(this.basDeptService.findByDeptId(Long.parseLong(item.getValue())).getDeptName());
                                    } else if (("-" + BuildType.ITEM_EMPCHOOSEBOX).equals(genPanelItem.getItemType()) || BuildType.ITEM_EMPCHOOSEBOX.equals(genPanelItem.getItemType())) {
                                        String accountName = this.basEmpAccountService.queryEmpAccountByIds(item.getValue());
                                        item.setValue(accountName);
                                    } else if (!BuildType.ITEM_PROCHOOSEBOX.equals(genPanelItem.getItemType())) {
                                        if (BuildType.ITEM_CONORGCHOOSEBOX.equals(genPanelItem.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(genPanelItem.getItemType())) {
                                            String contactOrgName = this.pubContactOrgService.queryContactOrgNameByIds(item.getValue());
                                            if (contactOrgName != null) {
                                                item.setValue(contactOrgName);
                                            }
                                        } else if (BuildType.ITEM_HREMPCHOOSEBOX.equals(genPanelItem.getItemType())) {
                                            item.setValue(this.bSqlHelper.getStringValue("business.workflow.common.getHrEmpName", MapUtil.of((Object)"empId", (Object)Long.parseLong(item.getValue()))));
                                        } else if (BuildType.ITEM_DEPT_TEXTBOX.equals(genPanelItem.getItemType())) {
                                            String deptText = this.basDeptService.findDeptTextById(item.getValue());
                                            item.setValue(deptText);
                                        }
                                    }
                                }
                            } else if (BuildType.ITEM_CHOOSEBOX.equals(genPanelItem.getItemType()) && StringUtils.isNotBlank((CharSequence)Objects.toString(data.get((Object)genPanelItem.getItemHtmlname()), null))) {
                                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genPanelItem.getFormCode(), genPanelItem.getDisplayField()})) {
                                    String dataurl;
                                    Object itemdata;
                                    GenForm itemform = this.findGenFormByCode(genPanelItem.getFormCode());
                                    String detailId2 = item.getHiddenValue();
                                    if (detailId2 != null && (itemdata = SysUtils.sendHttp(request, response, dataurl = itemform.getLoaddataUrl() + "?id=" + detailId2)) != null) {
                                        HashMap<String, Object> map = new HashMap<String, Object>();
                                        map.put("item", itemdata);
                                        item.setValue(FreeMarkerUtil.instance().genString(genPanelItem.getDisplayField(), map));
                                    }
                                } else if (data.containsKey((Object)(genPanelItem.getItemHtmlname() + "_TEXT_"))) {
                                    item.setValue(data.getString(genPanelItem.getItemHtmlname() + "_TEXT_"));
                                }
                            } else if ((BuildType.ITEM_CHOOSEFILEBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_IMAGECHOOSEBOX.equals(genPanelItem.getItemType())) && StringUtils.isNotBlank((CharSequence)(detailId = item.getHiddenValue())) && (version = this.docFileVersionService.findBaseVersionByVersionid(Long.parseLong(detailId))) != null) {
                                item.setValue(version.getOriginalName());
                            }
                        } else {
                            if ("\u521b\u5efa\u4eba".equals(genPanelItem.getItemLabel()) || "createBy".equals(genPanelItem.getItemHtmlname())) {
                                item.setValue(user.getAccountName());
                                item.setHiddenValue(user.getAccountid().toString());
                            }
                            if ("\u521b\u5efa\u65f6\u95f4".equals(genPanelItem.getItemLabel()) || "createTime".equals(genPanelItem.getItemHtmlname())) {
                                item.setValue(DateUtils.getDate());
                                item.setHiddenValue(DateUtils.getDate());
                            }
                        }
                        Map map = (Map)actItemMap.get(genPanelItem.getItemId());
                        List<String> uneditableTypes = Arrays.asList(BuildType.ITEM_GRADEBOX, BuildType.ITEM_SELECTCHOOSEBOX);
                        List<String> noeditableTypes = Arrays.asList(BuildType.ITEM_CHOOSEFILEBOX, BuildType.ITEM_EMPORGCHOOSEBOX, BuildType.ITEM_COMBOTREE, BuildType.ITEM_CHOOSEBOX, BuildType.ITEM_COMBOBOX, BuildType.ITEM_DICBOX, BuildType.ITEM_DATETIMEBOX, BuildType.ITEM_DATEBOX, BuildType.ITEM_YEARBOX, BuildType.ITEM_MONTHBOX, BuildType.ITEM_EMPCHOOSEBOX, "-" + BuildType.ITEM_EMPCHOOSEBOX, BuildType.ITEM_HREMPCHOOSEBOX, BuildType.ITEM_DEPTCHOOSEBOX, BuildType.ITEM_PROCHOOSEBOX, BuildType.ITEM_DICCHECKBOX);
                        if (!(!StringUtils.isBlank((CharSequence)form.getFlowCode()) && (!noeditableTypes.contains(genPanelItem.getItemType()) && genPanelItem.getEditable() != 1L && (map == null || !"Y".equals(map.get("isEditable") + "")) || !StringUtils.isNotBlank((CharSequence)genPanelItem.getEditableAct()) && map == null || !StringUtils.isBlank((CharSequence)id) && isdetail && "Act_1".equals(genPanelItem.getEditableAct()) || uneditableTypes.contains(genPanelItem.getItemType())) || !(actlist = ListUtils.stringToList(genPanelItem.getEditableAct())).contains(flowInfo.get("actId")) && (map == null || !"Y".equals(map.get("editableAct") + "")) || Objects.toString(data.get((Object)"workflowStatus"), "").contains("1") && isdetail)) {
                            if (genPanelItem.getDisable().intValue() == 1) {
                                item.setEditable(false);
                            } else {
                                item.setEditable(true);
                            }
                            item.setRequired(genPanelItem.getRequired().intValue() == 1);
                            if (map != null) {
                                if (map.get("itemLabel") != null) {
                                    item.setLabel(map.get("itemLabel").toString());
                                }
                                item.setHidden("N".equals(map.get("isShow") + ""));
                                item.setEditable("Y".equals(map.get("editableAct") + ""));
                                if (map.get("disable") != null && "1".equals(map.get("disable").toString())) {
                                    item.setEditable(false);
                                }
                                item.setRequired("Y".equals(map.get("isRequired") + ""));
                            }
                            if (BuildType.ITEM_DICBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(genPanelItem.getItemType()) || BuildType.ITEM_DICRADIOBOX.equals(genPanelItem.getItemType())) {
                                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genPanelItem.getDicCode()})) {
                                    item.setUrl("/dic/dic?typeCode=" + genPanelItem.getDicCode());
                                } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genPanelItem.getComboUrl()})) {
                                    item.setUrl(genPanelItem.getComboUrl());
                                }
                            } else {
                                item.setUrl(genPanelItem.getComboUrl());
                            }
                        }
                        if (ListUtils.stringToList(genPanelItem.getHiddenAct()).contains(flowInfo.get("actId"))) {
                            item.setHidden(true);
                        }
                        appform.AddItem(item);
                    }
                    List<GenPanelItem> hideItems = this.genpanelitemDao.findByPanelIdAndIsUseAndAppShowOrderByDisplayNo(panel.getPanelId(), "Y", 0L);
                    for (GenPanelItem panelitem3 : hideItems) {
                        if ("-1".equals(panelitem3.getItemType())) continue;
                        GenAppItem item = new GenAppItem();
                        item.setType(panelitem3.getItemType());
                        item.setLabel(panelitem3.getItemLabel());
                        item.setName(panelitem3.getItemHtmlname());
                        item.setHidden(true);
                        if (StringUtils.isBlank((CharSequence)id)) {
                            item.setValue(FreeMarkerUtil.instance().genString(panelitem3.getDefaultValue(), freemarkmap));
                            if ("\u521b\u5efa\u4eba".equals(panelitem3.getItemLabel()) || "createBy".equals(panelitem3.getItemHtmlname())) {
                                item.setValue(user.getAccountid().toString());
                            }
                            if ("\u521b\u5efa\u65f6\u95f4".equals(panelitem3.getItemLabel()) || "createTime".equals(panelitem3.getItemHtmlname())) {
                                item.setValue(DateUtils.getDate());
                            }
                        } else {
                            item.setValue(data.getString(panelitem3.getItemHtmlname()));
                        }
                        item.setHiddenValue(item.getValue());
                        appform.AddItem(item);
                    }
                    continue;
                }
                if (panel.getPanelType().equals(BuildType.PANEL_FILE) || panel.getPanelType().equals(BuildType.PANEL_TAB_FILE) || panel.getPanelType().equals(BuildType.PANEL_TAB_BILL) || panel.getPanelType().equals(BuildType.PANEL_BILL)) {
                    List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                    ArrayList<GenAppFileType> genAppFileTypes = new ArrayList<GenAppFileType>();
                    if (!filelist.isEmpty()) {
                        for (GenPanelFile file : filelist) {
                            List dealActIds;
                            GenAppFileType genAppFileType = new GenAppFileType();
                            genAppFileType.setFileTypeId(file.getFileTypeId());
                            genAppFileType.setFileTypeName(file.getFileTypeName());
                            genAppFileType.setIsUse("Y");
                            genAppFileType.setDisplayNo(file.getDisplayNo());
                            genAppFileType.setEditableAct(file.getEditableAct());
                            if (flowInfo == null || flowInfo.get("actId") == null || StringUtil.isEmpty(genAppFileType.getEditableAct()) || !genAppFileType.getEditableAct().contains(flowInfo.get("actId").toString())) {
                                genAppFileType.setEditable(0L);
                            } else {
                                genAppFileType.setEditable(1L);
                            }
                            genAppFileType.setRequired(genAppFileType.getEditable() == 0L || file.getRequired() == null ? 0L : file.getRequired());
                            if (flowInfo.get("actId") != null) {
                                if (gflow != null) {
                                    Map<String, Object> map = this.genFormFlowService.getFormFile(form.getId(), orgId, file.getFileTypeId(), Objects.toString(flowInfo.get("actId"), ""));
                                    if (map != null) {
                                        if (map.get("isShow") == null || !"Y".equals(map.get("isShow").toString())) continue;
                                        genAppFileType.setEditable("Y".equals(map.get("isEditable").toString()) ? 1L : 0L);
                                        genAppFileType.setRequired("Y".equals(map.get("isRequired").toString()) && genAppFileType.getEditable() == 1L ? 1L : 0L);
                                        genAppFileType.setShowLocal("Y".equals(map.get("showLocal").toString()) ? 1L : 0L);
                                        genAppFileType.setShowVisual("Y".equals(map.get("showVisual").toString()) ? 1L : 0L);
                                        genAppFileType.setShowScan("Y".equals(map.get("showScan").toString()) ? 1L : 0L);
                                    } else {
                                        genAppFileType.setEditable(0L);
                                    }
                                } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode())) {
                                    if (StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && ("," + file.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                                    if (StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && flowInfo.get("dealActIds") != null) {
                                        boolean hide = true;
                                        dealActIds = (List)flowInfo.get("dealActIds");
                                        for (String dealActId : dealActIds) {
                                            if (("," + file.getHiddenAct() + ",").contains("," + dealActId + ",")) continue;
                                            hide = false;
                                            break;
                                        }
                                        if (hide) continue;
                                    }
                                    if (StringUtils.isNotBlank((CharSequence)file.getEditableAct())) {
                                        String[] acts = file.getEditableAct().split(",");
                                        List<String> actlist = Arrays.asList(acts);
                                        if (actlist.contains(flowInfo.get("actId"))) {
                                            genAppFileType.setEditable(1L);
                                        } else {
                                            genAppFileType.setEditable(0L);
                                        }
                                    } else {
                                        genAppFileType.setEditable(0L);
                                    }
                                    genAppFileType.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1 && genAppFileType.getEditable() == 1L ? 1L : 0L);
                                    genAppFileType.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()) ? 0L : 1L);
                                    genAppFileType.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()) ? 0L : 1L);
                                    genAppFileType.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()) ? 0L : 1L);
                                }
                            } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode()) && StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && flowInfo.get("dealActIds") != null) {
                                boolean hide = true;
                                dealActIds = (List)flowInfo.get("dealActIds");
                                for (String dealActId : dealActIds) {
                                    if (("," + file.getHiddenAct() + ",").contains("," + dealActId + ",")) continue;
                                    hide = false;
                                    break;
                                }
                                if (hide) continue;
                            }
                            genAppFileTypes.add(genAppFileType);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)id)) {
                        for (GenAppFileType genAppFileType : genAppFileTypes) {
                            List<DocFormFile> files = this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), genAppFileType.getFileTypeId(), id);
                            for (DocFormFile file : files) {
                                void var26_41;
                                String string = file.getFileName();
                                if (StringUtil.isEmpty(string)) {
                                    String string2 = this.docFileVersionService.findBaseVersionByVersionid(file.getFileVersionId()).getOriginalName();
                                }
                                genAppFileType.addFiles(new GenAppFile(file.getFileVersionId(), (String)var26_41, file.getMemo(), file.getFormFileId()));
                                appform.AddFiles(new GenAppFile(file.getFileVersionId(), (String)var26_41, file.getMemo(), file.getFormFileId()));
                            }
                        }
                    }
                    if (genAppFileTypes.size() == 0) continue;
                    if (appform.getGenAppFileTypes() == null) {
                        appform.setGenAppFileTypes(genAppFileTypes);
                    } else {
                        appform.getGenAppFileTypes().addAll(genAppFileTypes);
                    }
                    appform.setFileTypeId(((GenAppFileType)genAppFileTypes.get(0)).getFileTypeId());
                    continue;
                }
                GenFormPanel clonepanel = (GenFormPanel)BeanUtils.cloneBean((Object)panel);
                clonepanel.setPanelUrl(FreeMarkerUtil.instance().genString(panel.getPanelUrl(), (Map)data));
                appform.AddPanels(clonepanel);
            }
        }
        return appform;
    }

    @Transactional(readOnly=true, rollbackFor={GEPSBisException.class})
    public BuildForm buildForm(GenForm form, String pkid, HttpServletRequest request, HttpServletResponse response, Object formdata, boolean editFile, String pageType, String isPishiForm, Long todoMsgId) throws Exception {
        HttpSession session = request.getSession(false);
        LoginUser user = (LoginUser)session.getAttribute("LOGIN_USER");
        HashMap<String, LoginUser> freemarkmap = new HashMap<String, LoginUser>();
        freemarkmap.put("loginuser", user);
        BuildForm buildform = new BuildForm();
        buildform.setPK(pkid);
        buildform.setIsdetail(form.getIsdetail());
        buildform.setFormid(form.getId());
        buildform.setFormcode(form.getFormCode());
        buildform.setFormname(form.getFormName());
        buildform.setFormtype(form.getFormType());
        buildform.setThemeId(form.getThemeId());
        buildform.setQueryString(form.getQueryString());
        buildform.setExcludeitems(form.getExcludeitems());
        buildform.setExcludepanels(form.getExcludepanels());
        buildform.setExtraJsUrl(form.getExtraJsUrl());
        Map<Long, GenPanleItemType> itemTypes = this.genpanleitemTypeService.findMapAll();
        if (form.getShowLogo() != null) {
            buildform.setShowLogo(form.getShowLogo() == 1L);
            buildform.setShowTitle(form.getShowTitle() == 1L);
            buildform.setShowCode(form.getShowCode() == 1L);
        } else {
            buildform.setShowLogo(false);
            buildform.setShowTitle(false);
            buildform.setShowCode(false);
        }
        buildform.setBizCode(form.getBizCode());
        if (StrKit.notBlank(buildform.getQueryString()) && buildform.getThemeId() != null) {
            buildform.setQueryString(buildform.getQueryString() + "&themeId=" + buildform.getThemeId());
        }
        buildform.setLoadformid(form.getLoadformid());
        buildform.setSubmiturl(form.getSubmitUrl());
        List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
        Map<Object, Object> flowInfo = new HashMap<String, String>();
        JSONObject json = (JSONObject)formdata;
        if (StrKit.notNull(buildform.getBizCode())) {
            buildform.setBizCodeText(json.getString(buildform.getBizCode()));
        }
        Long orgId = SysUtils.getLoginUser().getOrgid();
        if (pkid != null && json.getLong("processinstid") != null) {
            ProcessInstance process = this.flowUtilService.getProcInstService().findProcessById(json.getLong("processinstid").longValue());
            orgId = this.basEmpAccountService.findById(Long.parseLong(process.getCreator())).getOrgId();
        }
        GenFormFlow gflow = this.genFormFlowService.findByFormIdAndApplyOrgs(form.getId(), null, orgId.toString());
        String flowCode = form.getFlowCode();
        if (gflow != null) {
            flowCode = gflow.getFlowCode();
        }
        if (pkid != null && json.getLong("processinstid") != null) {
            flowInfo = this.flowUtilService.getFlowInfo(json.getLong("processinstid"));
        } else if (StringUtils.isNotBlank((CharSequence)flowCode)) {
            try {
                flowInfo.put("actId", this.flowUtilService.getFirstAct(flowCode));
            }
            catch (EmptyResultDataAccessException e) {
                throw new GEPSBisException("\u6ca1\u6709\u627e\u5230\u53d1\u5e03\u7684\u6d41\u7a0b\u4fe1\u606f,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u68c0\u67e5\u6d41\u7a0b\u72b6\u6001", e);
            }
        } else {
            flowInfo.put("actId", "Act_1");
        }
        String adminEdit = request.getParameter("adminEdit");
        if (!StringUtils.isEmpty((CharSequence)adminEdit) && "Y".equals(adminEdit)) {
            flowInfo.put("actId", this.flowUtilService.getFirstAct(flowCode));
        }
        HashMap<String, Map> actItemMap = new HashMap<String, Map>();
        if (flowInfo.get("actId") != null || StringUtils.isNotBlank((CharSequence)flowCode)) {
            List<Map<String, Object>> actItems = this.genFormFlowService.getFormItem(form.getId(), orgId, null, Objects.toString(flowInfo.get("actId"), StringUtils.isNotBlank((CharSequence)flowCode) ? (json.getLong("processinstid") == null ? this.flowUtilService.getFirstAct(flowCode) : this.flowUtilService.getFirstAct(json.getLong("processinstid"))) : ""), isPishiForm);
            for (Map map : actItems) {
                actItemMap.put(map.get("itemId").toString(), map);
            }
        }
        HashMap<String, BuildItem> itemReferPanel = new HashMap<String, BuildItem>();
        for (GenFormPanel genFormPanel : panellist) {
            DocFileType filetype;
            List<GenPanelFile> filelist;
            if (StrKit.notBlank(buildform.getExcludepanels()) && StrKit.notBlank(genFormPanel.getPanelHtmlid()) && ListUtils.stringToList(buildform.getExcludepanels()).contains(genFormPanel.getPanelHtmlid())) continue;
            if (Arrays.asList(BuildType.PANEL_TAB_FILE, BuildType.PANEL_TAB_FORM, BuildType.PANEL_TAB_CUSTOM, BuildType.PANEL_TAB_BILL, BuildType.PANEL_TAB_STAGE_FILE).contains(genFormPanel.getPanelType()) && !buildform.getGroupIds().containsKey(genFormPanel.getPanelGorupid())) {
                buildform.getGroupIds().put(genFormPanel.getPanelGorupid(), genFormPanel.getPanelGoruptitle());
            }
            BuildPanel buildpanel = new BuildPanel();
            buildpanel.setIsdetail(form.getIsdetail());
            buildpanel.setHideWhenEdit(genFormPanel.getHideWhenEdit() == null ? false : genFormPanel.getHideWhenEdit() == 1L);
            buildpanel.setPenelId(genFormPanel.getPanelId());
            buildpanel.setPaneltitle(genFormPanel.getPanelTitle());
            buildpanel.setPanelhtmlid(genFormPanel.getPanelHtmlid());
            buildpanel.setPanelgorupid(genFormPanel.getPanelGorupid());
            buildpanel.setPaneltype(genFormPanel.getPanelType());
            buildpanel.setColsize(genFormPanel.getFormColnum());
            buildpanel.setOrgItem(genFormPanel.getOrgItem());
            buildpanel.setLabelAlign(genFormPanel.getLabelAlign());
            if (StrKit.notBlank(genFormPanel.getPanelUrl())) {
                String panelurl = genFormPanel.getPanelUrl().indexOf("?") > 0 ? genFormPanel.getPanelUrl() + "&" + buildform.getQueryString() : genFormPanel.getPanelUrl() + "?" + buildform.getQueryString();
                buildpanel.setPanelurl(panelurl);
            }
            if (genFormPanel.getPanelType().equals(BuildType.PANEL_FORM) || genFormPanel.getPanelType().equals(BuildType.PANEL_FORM_PS) || genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_FORM)) {
                List<GenPanelGroup> grouplist = this.genpanelgroupService.findByPanelId(genFormPanel.getPanelId());
                ArrayList<BuildGroup> glist = new ArrayList<BuildGroup>();
                if (grouplist.isEmpty()) {
                    BuildGroup g = new BuildGroup();
                    g.setGroupId("panel" + genFormPanel.getPanelId());
                    g.setGroupTitle(genFormPanel.getPanelTitle());
                    glist.add(g);
                } else {
                    for (GenPanelGroup genPanelGroup : grouplist) {
                        BuildGroup g = new BuildGroup();
                        g.setGroupId(genPanelGroup.getGroupId());
                        g.setGroupTitle(genPanelGroup.getGroupTitle());
                        glist.add(g);
                    }
                }
                List<GenPanelItem> itemlist = "track".equals(pageType) ? this.genpanelitemDao.findByPanelIdAndIsUseOrderByDisplayNo(genFormPanel.getPanelId(), "Y") : (gflow != null ? this.genpanelitemService.findByPanelId(genFormPanel.getPanelId(), gflow != null ? gflow.getId() : "-9900999", Objects.toString(flowInfo.get("actId"), ""), isPishiForm) : this.genpanelitemDao.findByPanelIdAndIsUseOrderByDisplayNo(genFormPanel.getPanelId(), "Y"));
                for (GenPanelItem item : itemlist) {
                    Object data;
                    String combourl;
                    List<ComboxNode> list;
                    ComboxNode node;
                    Map dicMap;
                    Object detailId;
                    Object map;
                    if (StrKit.notBlank(buildform.getExcludeitems()) && StrKit.notBlank(item.getItemHtmlid()) && ListUtils.stringToList(buildform.getExcludeitems()).contains(item.getItemHtmlid())) continue;
                    GenPanleItemType type = itemTypes.get(Long.parseLong(item.getItemType()));
                    BuildItem builditem = new BuildItem();
                    builditem.setFtlname(type.getFtlName());
                    builditem.setButtonClickFun(type.getButtonClickFun());
                    builditem.setIsdetail(form.getIsdetail());
                    builditem.setId(item.getItemHtmlid());
                    builditem.setName(item.getItemHtmlname());
                    builditem.setFormCode(item.getFormCode());
                    builditem.setLabel(item.getItemLabel());
                    builditem.setItemtype(item.getItemType());
                    builditem.setLength(item.getItemLength());
                    builditem.setDecimal(item.getItemDecimal());
                    builditem.setDicCode(item.getDicCode());
                    builditem.setComboUrl(FreeMarkerUtil.instance().genString(item.getComboUrl(), (Map)json));
                    builditem.setHidden(item.getHidden() == 1L);
                    builditem.setSinglerow(item.getSinglerow() == 1L);
                    builditem.setRequired(item.getRequired() == 1L);
                    builditem.setEditable(item.getEditable() == 1L);
                    builditem.setDisable(1L == item.getDisable());
                    builditem.setUnit(item.getItemUnit());
                    builditem.setDataoptions(item.getDataoptions());
                    builditem.setHtmlattr(item.getHtmlAttr());
                    builditem.setPrompt(item.getPrompt());
                    builditem.setDetailAsHref(1L == item.getDetailAsHref());
                    builditem.setClickFunc(item.getClickFunc());
                    builditem.setItemcol(item.getItemCol());
                    if (form.getIsdetail() && !form.getIsappro()) {
                        builditem.setIsdetail(true);
                        if (gflow != null) {
                            map = (Map)actItemMap.get(item.getItemId());
                            if (map != null) {
                                if (map.get("itemLabel") != null) {
                                    builditem.setLabel(map.get("itemLabel").toString());
                                }
                                builditem.setHidden("N".equals(map.get("isShow") + ""));
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode()) && !ListUtils.stringToList(item.getEditableAct()).contains(flowInfo.get("actId")) && ListUtils.stringToList(item.getHiddenAct()).contains(flowInfo.get("actId"))) {
                            builditem.setHidden(true);
                        }
                    } else if (gflow != null) {
                        map = (Map)actItemMap.get(item.getItemId());
                        if (map != null) {
                            if (map.get("itemLabel") != null) {
                                builditem.setLabel(map.get("itemLabel").toString());
                            }
                            builditem.setHidden("N".equals(map.get("isShow") + ""));
                            builditem.setEditable("Y".equals(map.get("isEditable") + ""));
                            builditem.setIsdetail(!"Y".equals(map.get("editableAct") + ""));
                            if (map.get("disable") != null && !"".equals(map.get("disable").toString())) {
                                builditem.setDisable("1".equals(map.get("disable").toString()));
                            }
                            if (map.get("singlerow") != null && !"".equals(map.get("singlerow").toString())) {
                                builditem.setSinglerow("1".equals(map.get("singlerow").toString()));
                            }
                            builditem.setRequired("Y".equals(map.get("isRequired") + ""));
                        } else {
                            builditem.setIsdetail(true);
                            builditem.setEditable(false);
                            builditem.setRequired(false);
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode())) {
                        if (ListUtils.stringToList(item.getEditableAct()).contains(flowInfo.get("actId"))) {
                            builditem.setIsdetail(false);
                        } else {
                            if (ListUtils.stringToList(item.getHiddenAct()).contains(flowInfo.get("actId"))) {
                                builditem.setHidden(true);
                            }
                            builditem.setIsdetail(true);
                        }
                    }
                    builditem.setGroupId(item.getGroupId());
                    builditem.setGroupName("\u5206\u7ec4\u6807\u9898");
                    if (StringUtils.isEmpty((CharSequence)builditem.getGroupId())) {
                        builditem.setGroupId("panel" + genFormPanel.getPanelId());
                    }
                    for (BuildGroup g : glist) {
                        if (!g.getGroupId().equals(builditem.getGroupId())) continue;
                        g.addItem(builditem);
                    }
                    if (item.getReferPanel() != null && StringUtils.isNotBlank((CharSequence)item.getReferPanel())) {
                        itemReferPanel.put(item.getReferPanel(), builditem);
                        buildpanel.addItem(builditem);
                        continue;
                    }
                    if (StrKit.notNull(item.getDefaultValue())) {
                        builditem.setDefaultvalue(FreeMarkerUtil.instance().genString(item.getDefaultValue(), freemarkmap));
                    }
                    if (builditem.isIsdetail()) {
                        if (item.getItemType().equals(BuildType.ITEM_DICBOX)) {
                            if (builditem.isIsdetail()) {
                                detailId = json.getString(item.getItemHtmlname());
                                if (StringUtils.isNotBlank((CharSequence)detailId)) {
                                    dicMap = this.commonService.getDicMap(item.getDicCode());
                                    dicMap = MapUtil.filter(dicMap, (Object[])((String)detailId).split(","));
                                    ArrayList<ComboxNode> list2 = new ArrayList<ComboxNode>();
                                    for (Map.Entry key : dicMap.entrySet()) {
                                        node = new ComboxNode();
                                        node.setText((String)key.getValue());
                                        node.setValue((String)key.getKey());
                                        list2.add(node);
                                    }
                                    builditem.setItemdata(list2);
                                } else {
                                    builditem.setItemdata(Collections.emptyList());
                                }
                            } else {
                                list = this.commonService.getDicCombo(item.getDicCode());
                                builditem.setItemdata(list);
                            }
                        } else if (item.getItemType().equals(BuildType.ITEM_COMBOBOX) || item.getItemType().equals(BuildType.ITEM_COMBOTREE) || item.getItemType().equals(BuildType.ITEM_CASCADECOMBOBOX)) {
                            detailId = json.getString(item.getItemHtmlname());
                            if (detailId == null) {
                                detailId = "";
                            }
                            combourl = item.getComboUrl().indexOf("?") > 0 ? item.getComboUrl() + "&" + buildform.getQueryString() + "&detailId=" + URLUtil.encode((String)detailId) : item.getComboUrl() + "?" + buildform.getQueryString() + "&detailId=" + URLUtil.encode((String)detailId);
                            data = SysUtils.sendHttp(request, response, FreeMarkerUtil.instance().genString(combourl, (Map)json));
                            builditem.setItemdata(data);
                            builditem.setValue((String)detailId);
                        }
                    }
                    if (item.getItemType().equals(BuildType.ITEM_DICRADIOBOX) || item.getItemType().equals(BuildType.ITEM_DICCHECKBOX) || BuildType.ITEM_OTHERRADIOBOX.equals(item.getItemType()) || BuildType.ITEM_OTHERCHECKBOX.equals(item.getItemType()) || BuildType.ITEM_OTHERCOMBOBOX.equals(item.getItemType())) {
                        if (StringUtils.isNotBlank((CharSequence)item.getDicCode())) {
                            if (builditem.isIsdetail()) {
                                detailId = json.getString(item.getItemHtmlname());
                                if (StringUtils.isNotBlank((CharSequence)detailId)) {
                                    dicMap = this.commonService.getDicMap(item.getDicCode());
                                    dicMap = MapUtil.filter((Map)dicMap, (Object[])((String)detailId).split(","));
                                    ArrayList<ComboxNode> list2 = new ArrayList<ComboxNode>();
                                    for (Map.Entry key : dicMap.entrySet()) {
                                        node = new ComboxNode();
                                        node.setText((String)key.getValue());
                                        node.setValue((String)key.getKey());
                                        list2.add(node);
                                    }
                                    builditem.setItemdata(list2);
                                } else {
                                    builditem.setItemdata(Collections.emptyList());
                                }
                            } else {
                                list = this.commonService.getDicComboWithDefault(item.getDicCode());
                                builditem.setItemdata(list);
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)item.getComboUrl())) {
                            detailId = json.getString(item.getItemHtmlname());
                            if (detailId == null) {
                                detailId = "";
                            }
                            combourl = item.getComboUrl().indexOf("?") > 0 ? item.getComboUrl() + "&" + buildform.getQueryString() + "&detailId=" + URLUtil.encode((String)detailId) : item.getComboUrl() + "?" + buildform.getQueryString() + "&detailId=" + URLUtil.encode((String)detailId);
                            data = SysUtils.sendHttp(request, response, FreeMarkerUtil.instance().genString(combourl, (Map)json));
                            builditem.setItemdata(data);
                        }
                    } else if ((item.getItemType().equals(BuildType.ITEM_CHOOSEFILEBOX) || item.getItemType().equals(BuildType.ITEM_IMAGECHOOSEBOX)) && (detailId = json.getLong(item.getItemHtmlname())) != null) {
                        DocFileVersion version = this.docFileVersionService.findDocFileVersion((Long)detailId);
                        json.put(builditem.getName() + "fileName", (Object)version.getOriginalName());
                    }
                    if ((pkid == null || pkid != null && form.getLoadformid() != null) && StringUtils.isNotBlank((CharSequence)item.getGencode()) && item.getItemType().equals(BuildType.ITEM_TEXTBOX)) {
                        String gencode = this.basSysCodeService.genCode(item.getGencode(), form.getQueryString());
                        builditem.setDefaultvalue(gencode);
                    }
                    if ("empchoosebox".equals(type.getItemCode()) || BuildType.ITEM_EMPCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_HREMPCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_DEPTCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_PROCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_CONORGCHOOSEBOX.equals(item.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(item.getItemType()) || BuildType.ITEM_DEPT_TEXTBOX.equals(item.getItemType())) {
                        if ("\u521b\u5efa\u4eba".equals(item.getItemLabel()) || "createBy".equals(item.getItemHtmlname())) {
                            builditem.setDataoptions("buttonText:''");
                        }
                        if (pkid != null || StringUtils.isNotBlank((CharSequence)builditem.getDefaultvalue())) {
                            String id = json.getString(item.getItemHtmlname());
                            if (pkid == null) {
                                id = builditem.getDefaultvalue();
                            }
                            if (StringUtils.isNotBlank((CharSequence)id)) {
                                if (BuildType.ITEM_DEPTCHOOSEBOX.equals(item.getItemType())) {
                                    BasDept pdept;
                                    String deptName = "";
                                    String[] dept = this.basDeptService.findByDeptId(Long.parseLong(id));
                                    deptName = dept.getPdeptId() != null && dept.getPdeptId().intValue() != 0 ? ((pdept = this.basDeptService.findByDeptId(dept.getPdeptId())) != null ? pdept.getDeptName() + "-" + dept.getDeptName() : dept.getDeptName()) : dept.getDeptName();
                                    json.put(item.getItemHtmlname() + "_TEXT_", (Object)deptName);
                                } else if ("empchoosebox".equals(type.getItemCode()) || BuildType.ITEM_EMPCHOOSEBOX.equals(item.getItemType())) {
                                    String accountName = this.basEmpAccountService.queryEmpAccountByIds(id);
                                    json.put(item.getItemHtmlname() + "_TEXT_", (Object)accountName);
                                } else if (BuildType.ITEM_HREMPCHOOSEBOX.equals(item.getItemType())) {
                                    json.put(item.getItemHtmlname() + "_TEXT_", (Object)this.bSqlHelper.getStringValue("business.workflow.common.getHrEmpName", MapUtil.of((Object)"empId", (Object)Long.parseLong(id))));
                                } else if (!BuildType.ITEM_PROCHOOSEBOX.equals(item.getItemType())) {
                                    if (BuildType.ITEM_CONORGCHOOSEBOX.equals(item.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(item.getItemType())) {
                                        String contactOrgName = this.pubContactOrgService.queryContactOrgNameByIds(id);
                                        json.put(item.getItemHtmlname() + "_TEXT_", (Object)contactOrgName);
                                        if (StringUtils.isBlank((CharSequence)item.getClickFunc())) {
                                            for (String i : id.split(",")) {
                                                builditem.setClickFunc("formDetail(\"PubContactOrg_dw\"," + Long.valueOf(i) + ",\"\u3010" + this.pubContactOrgService.queryContactOrgNameByIds(i) + "\u3011\u8be6\u7ec6\u4fe1\u606f\")");
                                                builditem.setDetailAsHref(true);
                                            }
                                        }
                                    } else if (BuildType.ITEM_DEPT_TEXTBOX.equals(item.getItemType())) {
                                        String deptText = this.basDeptService.findDeptTextById(id);
                                        json.put(item.getItemHtmlname() + "_TEXT_", (Object)deptText);
                                    }
                                }
                            }
                        } else if ("\u521b\u5efa\u4eba".equals(item.getItemLabel()) || "createBy".equals(item.getItemHtmlname())) {
                            json.put(item.getItemHtmlname() + "_TEXT_", (Object)user.getAccountName());
                            json.put(item.getItemHtmlname(), (Object)user.getAccountid());
                        }
                    } else if (BuildType.ITEM_FLOWOPINIONBOX.equals(item.getItemType())) {
                        if (pkid != null) {
                            GenFormAdvices ad;
                            BasMessage msg;
                            String editableacts = item.getEditableAct();
                            String actIds = "";
                            if (StringUtils.isNotBlank((CharSequence)editableacts)) {
                                for (String actId : editableacts.split(",")) {
                                    if (!StringUtils.isNotBlank((CharSequence)actId)) continue;
                                    List<Map<String, Object>> editactitems = this.genFormFlowService.getFormItem(form.getId(), orgId, item.getItemId(), actId, isPishiForm);
                                    if (!editactitems.isEmpty()) {
                                        if ("N".equals(String.valueOf(editactitems.get(0).get("isEditable"))) || "N".equals(String.valueOf(editactitems.get(0).get("isShow")))) continue;
                                        actIds = actIds + actId + ",";
                                        continue;
                                    }
                                    actIds = actIds + actId + ",";
                                }
                            }
                            if (actIds.length() > 0) {
                                actIds.substring(0, actIds.length() - 1);
                            }
                            if (gflow != null) {
                                String otheract;
                                String sql = "select group_concat(a.act_id)\n  from  gen_panel_item i,  gen_act_item a\n where a.item_id = i.item_id\n   AND i.is_use = 'Y'\n   and i.item_type = '0'\n   and a.is_editable = 'Y'\n   AND a.is_show = 'Y'\n   AND A.IS_USE = 'Y'\n   and a.setting_id = '" + gflow.getId() + "'\n   and i.item_id = '" + item.getItemId() + "'\n   and (a.panel_type = '0' or a.panel_type is null) ";
                                if ("Y".equals(isPishiForm)) {
                                    sql = "select group_concat(a.act_id)\n  from  gen_panel_item i,  gen_act_item a\n where a.item_id = i.item_id\n   AND i.is_use = 'Y'\n   and i.item_type = '0'\n   and a.is_editable = 'Y'\n   AND a.is_show = 'Y'\n   AND A.IS_USE = 'Y'\n   and a.setting_id = '" + gflow.getId() + "'\n   and i.item_id = '" + item.getItemId() + "'\n   and a.panel_type = '10' ";
                                }
                                if ((otheract = Objects.toString(this.sqlHelper.getSingal(sql), "")).length() > 0) {
                                    actIds = actIds + actIds + "," + otheract;
                                }
                            }
                            builditem.setAllowFile(Boolean.parseBoolean(Objects.toString(flowInfo.get("allowFile"), "false")));
                            builditem.setActDesc(Objects.toString(flowInfo.get("actDesc"), ""));
                            builditem.setOpinions(this.flowUtilService.queryFinishWorkItemByDefid(json.getLong("processinstid"), actIds));
                            if (builditem.isEditable() && todoMsgId != null && (msg = this.basMessageService.findBasMessage(todoMsgId)) != null && (ad = this.genFormAdvicesService.findByWorkitemidAndIsUse(msg.getWorkitemid(), SysUtils.getLoginAccountId())) != null) {
                                builditem.setValue(ad.getWorkmemory());
                                json.put(item.getItemHtmlname(), (Object)builditem.getValue());
                            }
                        }
                    } else if (BuildType.ITEM_CHOOSEBOX.equals(item.getItemType()) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getFormCode(), item.getDisplayField()})) {
                        String dataurl;
                        Object data2;
                        GenForm itemform = this.findGenFormByCode(item.getFormCode());
                        String detailId2 = json.getString(item.getItemHtmlname());
                        if (pkid == null) {
                            detailId2 = builditem.getDefaultvalue();
                        }
                        if (StringUtils.isNotBlank((CharSequence)detailId2) && (data2 = SysUtils.sendHttp(request, response, dataurl = itemform.getLoaddataUrl() + "?id=" + detailId2)) != null) {
                            HashMap<String, Object> map2 = new HashMap<String, Object>();
                            map2.put("item", data2);
                            json.put(item.getItemHtmlname() + "_TEXT_", (Object)FreeMarkerUtil.instance().genString(item.getDisplayField(), map2));
                            if (StringUtils.isBlank((CharSequence)item.getClickFunc())) {
                                builditem.setClickFunc("formDetail(\"" + item.getFormCode() + "\"," + detailId2 + ",\"\u3010" + json.getString(item.getItemHtmlname() + "_TEXT_") + "\u3011\u8be6\u7ec6\u4fe1\u606f\")");
                            }
                        }
                    }
                    if (pkid == null && ("\u521b\u5efa\u65f6\u95f4".equals(item.getItemLabel()) || "createTime".equals(item.getItemHtmlname()))) {
                        json.put(item.getItemHtmlname(), (Object)DateUtils.getDate());
                    }
                    if (StringUtils.isNotBlank((CharSequence)buildpanel.getOrgItem()) && builditem.getId().equals(buildpanel.getOrgItem())) {
                        String combourl2 = genFormPanel.getOrgCombourl();
                        Object combodata = SysUtils.sendHttp(request, response, FreeMarkerUtil.instance().genString(combourl2, (Map)json));
                        JSONArray array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata));
                        for (int i = 0; i < array.size(); ++i) {
                            JSONObject jsonObject = array.getJSONObject(i);
                            if (!jsonObject.getString("value").equals(builditem.getValue())) continue;
                            buildpanel.setOrgText(jsonObject.getString("text"));
                            break;
                        }
                    }
                    buildpanel.addItem(builditem);
                }
                buildpanel.setGroups(glist);
            } else if (genFormPanel.getPanelType().equals(BuildType.PANEL_FILE) || genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_FILE)) {
                if (form.getIsappro() || editFile) {
                    buildpanel.setIsdetail(false);
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genFormPanel.getHiddenAct()}) && ("," + genFormPanel.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(genFormPanel.getPanelId(), "Y");
                for (GenPanelFile file : filelist) {
                    List dealActIds;
                    BuildFile buildFile = new BuildFile();
                    filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                    buildFile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                    buildFile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                    buildFile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                    buildFile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                    if (editFile) {
                        buildFile.setEditable(true);
                    } else if (flowInfo.get("actId") != null) {
                        if (gflow != null) {
                            Map<String, Object> map = this.genFormFlowService.getFormFile(form.getId(), orgId, file.getFileTypeId(), Objects.toString(flowInfo.get("actId"), ""));
                            if (map != null) {
                                if (map.get("isShow") == null || !"Y".equals(map.get("isShow").toString())) continue;
                                buildFile.setEditable("Y".equals(map.get("isEditable").toString() + ""));
                                buildFile.setRequired("Y".equals(map.get("isRequired").toString() + ""));
                                buildFile.setShowLocal("Y".equals(map.get("showLocal").toString() + ""));
                                buildFile.setShowVisual("Y".equals(map.get("showVisual").toString() + ""));
                                buildFile.setShowScan("Y".equals(map.get("showScan").toString() + ""));
                            } else {
                                buildFile.setEditable(false);
                            }
                        } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode())) {
                            if (StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && ("," + file.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                            if (StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && flowInfo.get("dealActIds") != null) {
                                boolean hide = true;
                                dealActIds = (List)flowInfo.get("dealActIds");
                                for (String dealActId : dealActIds) {
                                    if (("," + file.getHiddenAct() + ",").contains("," + dealActId + ",")) continue;
                                    hide = false;
                                    break;
                                }
                                if (hide) continue;
                            }
                            if (StringUtils.isNotBlank((CharSequence)file.getEditableAct())) {
                                String[] acts = file.getEditableAct().split(",");
                                List<String> actlist = Arrays.asList(acts);
                                if (actlist.contains(flowInfo.get("actId"))) {
                                    buildFile.setEditable(true);
                                } else {
                                    buildFile.setEditable(false);
                                }
                            } else {
                                buildFile.setEditable(false);
                            }
                            buildFile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                            buildFile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                            buildFile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                            buildFile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                        }
                    } else if (StringUtils.isNotBlank((CharSequence)form.getFlowCode()) && StringUtils.isNotBlank((CharSequence)file.getHiddenAct()) && flowInfo.get("dealActIds") != null) {
                        boolean hide = true;
                        dealActIds = (List)flowInfo.get("dealActIds");
                        for (String dealActId : dealActIds) {
                            if (("," + file.getHiddenAct() + ",").contains("," + dealActId + ",")) continue;
                            hide = false;
                            break;
                        }
                        if (hide) continue;
                    }
                    buildFile.setFileNature(filetype.getFileNature());
                    buildFile.setFilterFunction(file.getFilterFunction());
                    buildFile.setFileTypeId(file.getFileTypeId());
                    buildFile.setFileTypeName(file.getFileTypeName());
                    buildFile.setCatalogid(file.getCatalogId());
                    if (pkid != null) {
                        buildFile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), pkid));
                    }
                    buildpanel.addFile(buildFile);
                }
            } else if (genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_BILL) || genFormPanel.getPanelType().equals(BuildType.PANEL_BILL)) {
                if (form.getIsappro() || editFile) {
                    buildpanel.setIsdetail(false);
                }
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genFormPanel.getHiddenAct()}) && ("," + genFormPanel.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(genFormPanel.getPanelId(), "Y");
                for (GenPanelFile file : filelist) {
                    BuildFile buildFile = new BuildFile();
                    filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                    buildFile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                    buildFile.setFileNature(filetype.getFileNature());
                    buildFile.setFilterFunction(file.getFilterFunction());
                    buildFile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                    buildFile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                    buildFile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                    buildFile.setFileTypeId(file.getFileTypeId());
                    buildFile.setFileTypeName(file.getFileTypeName());
                    buildFile.setCatalogid(file.getCatalogId());
                    if (pkid != null) {
                        buildFile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), pkid));
                    }
                    buildpanel.addFile(buildFile);
                }
            } else if (genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_CUSTOM) || genFormPanel.getPanelType().equals(BuildType.PANEL_CUSTOM)) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genFormPanel.getHiddenAct()}) && ("," + genFormPanel.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                String content = SysUtils.GetHttpContent(request, FreeMarkerUtil.instance().genString(buildpanel.getPanelurl(), (Map)json));
                buildpanel.setContent(content);
            } else if (genFormPanel.getPanelType().equals(BuildType.PANEL_STAGE_FILE) || genFormPanel.getPanelType().equals(BuildType.PANEL_TAB_STAGE_FILE)) {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{genFormPanel.getHiddenAct()}) && ("," + genFormPanel.getHiddenAct() + ",").contains("," + flowInfo.get("actId") + ",")) continue;
                if (form.getIsappro() || editFile) {
                    buildpanel.setIsdetail(false);
                }
            }
            if (itemReferPanel.containsKey(genFormPanel.getPanelId())) {
                ((BuildItem)itemReferPanel.get(genFormPanel.getPanelId())).setPanel(buildpanel);
                continue;
            }
            buildform.getPanels().add(buildpanel);
        }
        for (String string : itemReferPanel.keySet()) {
            if (((BuildItem)itemReferPanel.get(string)).getPanel() != null) continue;
            for (BuildPanel panel : buildform.getPanels()) {
                for (BuildGroup group : panel.getGroups()) {
                    if (!group.getShowitems().contains(itemReferPanel.get(string))) continue;
                    group.getShowitems().remove(itemReferPanel.get(string));
                }
                if (!panel.getShowitems().contains(itemReferPanel.get(string))) continue;
                panel.getShowitems().remove(itemReferPanel.get(string));
            }
        }
        block19: for (BuildPanel buildPanel : buildform.getPanels()) {
            for (BuildItem item : buildPanel.getItems()) {
                if (item.isIsdetail() || item.isHidden()) continue;
                buildform.setHasEdit(true);
                break;
            }
            for (BuildFile file : buildPanel.getFiles()) {
                if (!file.isEditable()) continue;
                buildform.setHasEdit(true);
                continue block19;
            }
        }
        return buildform;
    }

    public BuildForm buildFilePanel(GenForm form, String panelHtmlID, String pkid, String filepkids, Object formdata, Boolean editFile) throws Exception {
        BuildForm buildform = new BuildForm();
        buildform.setPK(pkid);
        buildform.setFormid(form.getId());
        buildform.setFormcode(form.getFormCode());
        buildform.setFormname(form.getFormName());
        buildform.setFormtype(form.getFormType());
        buildform.setQueryString(form.getQueryString());
        buildform.setLoadformid(form.getLoadformid());
        buildform.setExcludeitems(form.getExcludeitems());
        buildform.setExcludepanels(form.getExcludepanels());
        List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
        Map<String, Object> flowInfo = new HashMap<String, String>();
        JSONObject json = (JSONObject)formdata;
        if (pkid != null && json != null) {
            flowInfo = this.flowUtilService.getFlowInfo(json.getLong("processinstid"));
        }
        if (flowInfo.isEmpty()) {
            flowInfo.put("actId", "Act_1");
        }
        for (GenFormPanel panel : panellist) {
            DocFileType filetype;
            BuildFile buildfile;
            List<GenPanelFile> filelist;
            if (!panel.getPanelType().equals(BuildType.PANEL_STAGE_FILE) && !panel.getPanelType().equals(BuildType.PANEL_TAB_STAGE_FILE) && (!StrKit.notBlank(panel.getPanelHtmlid()) || !panel.getPanelHtmlid().equals(panelHtmlID))) continue;
            BuildPanel buildpanel = new BuildPanel();
            buildpanel.setPaneltitle(panel.getPanelTitle());
            buildpanel.setPenelId(panel.getPanelId());
            buildpanel.setPanelhtmlid(panel.getPanelHtmlid());
            buildpanel.setPanelgorupid(panel.getPanelGorupid());
            buildpanel.setPaneltype(panel.getPanelType());
            buildpanel.setPanelurl(panel.getPanelUrl());
            if (StrKit.notBlank(panel.getPanelUrl())) {
                String panelurl = panel.getPanelUrl().indexOf("?") > 0 ? panel.getPanelUrl() + "&" + buildform.getQueryString() : panel.getPanelUrl() + "?" + buildform.getQueryString();
                buildpanel.setPanelurl(panelurl);
            }
            buildpanel.setColsize(panel.getFormColnum());
            buildpanel.setOrgItem(panel.getOrgItem());
            buildpanel.setLabelAlign(panel.getLabelAlign());
            if (panel.getPanelType().equals(BuildType.PANEL_FILE) || panel.getPanelType().equals(BuildType.PANEL_TAB_FILE)) {
                filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                for (GenPanelFile file : filelist) {
                    buildfile = new BuildFile();
                    buildfile.setFileTypeId(file.getFileTypeId());
                    filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                    buildfile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                    buildfile.setFileNature(filetype.getFileNature());
                    buildfile.setFilterFunction(file.getFilterFunction());
                    buildfile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                    buildfile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                    buildfile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                    buildfile.setFileTypeName(file.getFileTypeName());
                    buildfile.setCatalogid(file.getCatalogId());
                    buildfile.setEditable(editFile);
                    if (StrKit.notBlank(filepkids)) {
                        buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), ListUtils.stringToList(filepkids)));
                    } else if (pkid != null) {
                        buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), pkid));
                    }
                    buildpanel.addFile(buildfile);
                }
            }
            if (panel.getPanelType().equals(BuildType.PANEL_TAB_BILL)) {
                filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                for (GenPanelFile file : filelist) {
                    buildfile = new BuildFile();
                    buildfile.setFileTypeId(file.getFileTypeId());
                    filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                    buildfile.setRequired(file.getRequired() != null && file.getRequired().intValue() == 1);
                    buildfile.setFileNature(filetype.getFileNature());
                    buildfile.setFilterFunction(file.getFilterFunction());
                    buildfile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                    buildfile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                    buildfile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                    buildfile.setFileTypeName(file.getFileTypeName());
                    buildfile.setCatalogid(file.getCatalogId());
                    if (StrKit.notBlank(filepkids)) {
                        buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), ListUtils.stringToList(filepkids)));
                    } else if (pkid != null) {
                        buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), pkid));
                    }
                    buildpanel.addFile(buildfile);
                }
            } else if ((panel.getPanelType().equals(BuildType.PANEL_STAGE_FILE) || panel.getPanelType().equals(BuildType.PANEL_TAB_STAGE_FILE)) && (form.getIsappro() || editFile.booleanValue())) {
                buildpanel.setIsdetail(false);
            }
            buildform.getPanels().add(buildpanel);
            break;
        }
        buildform.getPanels().forEach(a -> a.getGroups().forEach(b -> {}));
        return buildform;
    }

    public BuildForm buildBizEditFilePanel(GenForm form, String pkid, Boolean isArchive) throws Exception {
        BuildForm buildform = new BuildForm();
        buildform.setPK(pkid);
        buildform.setFormid(form.getId());
        buildform.setFormcode(form.getFormCode());
        buildform.setFormname(form.getFormName());
        buildform.setFormtype(form.getFormType());
        buildform.setQueryString(form.getQueryString());
        buildform.setLoadformid(form.getLoadformid());
        buildform.setExcludeitems(form.getExcludeitems());
        buildform.setExcludepanels(form.getExcludepanels());
        List<GenFormPanel> panellist = this.formPanelService.findByFormID(form.getId());
        for (GenFormPanel panel : panellist) {
            if (!panel.getPanelType().equals(BuildType.PANEL_FILE) && !panel.getPanelType().equals(BuildType.PANEL_TAB_FILE)) continue;
            BuildPanel buildpanel = new BuildPanel();
            buildpanel.setPaneltitle(panel.getPanelTitle());
            buildpanel.setPenelId(panel.getPanelId());
            buildpanel.setPanelhtmlid(panel.getPanelHtmlid());
            buildpanel.setPanelgorupid(panel.getPanelGorupid());
            buildpanel.setPaneltype(BuildType.PANEL_FILE);
            buildpanel.setPanelurl(panel.getPanelUrl());
            List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
            for (GenPanelFile file : filelist) {
                BuildFile buildfile = new BuildFile();
                DocFileType filetype = (DocFileType)this.docfiletypeDao.findById(file.getFileTypeId()).get();
                buildfile.setFileNature(filetype.getFileNature());
                buildfile.setFilterFunction(file.getFilterFunction());
                buildfile.setShowLocal(!SysContent.SWITCH_N.equals(file.getShowLocal()));
                buildfile.setShowVisual(!SysContent.SWITCH_N.equals(file.getShowVisual()));
                buildfile.setShowScan(!SysContent.SWITCH_N.equals(file.getShowScan()));
                buildfile.setFileTypeId(file.getFileTypeId());
                buildfile.setFileTypeName(file.getFileTypeName());
                buildfile.setCatalogid(file.getCatalogId());
                if (pkid != null) {
                    buildfile.setFormfilelist(this.docFormFileService.listFormFileByPK(form.getLoadformid() == null ? form.getId() : form.getLoadformid(), file.getFileTypeId(), Arrays.asList(pkid), isArchive));
                }
                buildpanel.addFile(buildfile);
            }
            buildform.getPanels().add(buildpanel);
        }
        return buildform;
    }

    public boolean isFileChange(String aformcode, String apkid, String formcode, String pkid) {
        List<DocFormFile> afileList = this.docFormFileService.findByFormCodeAndPrimaryKey(aformcode, apkid);
        return this.isFileChange(afileList, formcode, pkid);
    }

    public boolean isFileChange(List<DocFormFile> afileList, String formcode, String pkid) {
        List<DocFormFile> fileList = this.docFormFileService.findByFormCodeAndPrimaryKey(formcode, pkid);
        if (afileList == null || afileList.isEmpty()) {
            return !fileList.isEmpty();
        }
        if (afileList.size() != fileList.size()) {
            return true;
        }
        String[] fileCompareField = new String[]{"fileNo", "fileName"};
        for (DocFormFile afile : afileList) {
            DocFormFile file = this.docFormFileService.findByFormIdAndPrimaryKeyAndFileVersionId(formcode, pkid, afile.getFileVersionId());
            if (file == null) {
                return true;
            }
            if (!BeanCompareUtils.isFieldChange(fileCompareField, (Object)afile, (Object)file)) continue;
            return true;
        }
        return false;
    }

    public List<ComboxNode> flowActComb(String panelId) {
        ArrayList<ComboxNode> comlist = new ArrayList<ComboxNode>();
        GenForm form = this.formPanelService.findGenFormByPanelId(panelId);
        if (form == null || form.getFlowCode() == null) {
            return comlist;
        }
        List<Map<String, Object>> list = this.flowUtilService.getFlowActList(form.getFlowCode());
        for (Map<String, Object> map : list) {
            ComboxNode node = new ComboxNode();
            node.setValue(Objects.toString(map.get("ACTIVITYDEFID"), ""));
            node.setText(Objects.toString(map.get("ACTNAME"), "") + "(" + Objects.toString(map.get("ACTIVITYDEFID"), "") + ")");
            comlist.add(node);
        }
        return comlist;
    }

    public List<ComboxNode> queryFlowActComb(String formId) {
        ArrayList<ComboxNode> comlist = new ArrayList<ComboxNode>();
        GenForm form = this.genFormService.findGenForm(formId);
        if (form == null || form.getFlowCode() == null) {
            return comlist;
        }
        List<Map<String, Object>> list = this.flowUtilService.getFlowActList(form.getFlowCode());
        for (Map<String, Object> map : list) {
            ComboxNode node = new ComboxNode();
            node.setValue(Objects.toString(map.get("ACTIVITYDEFID"), ""));
            node.setText(Objects.toString(map.get("ACTNAME"), "") + "(" + Objects.toString(map.get("ACTIVITYDEFID"), "") + ")");
            comlist.add(node);
        }
        return comlist;
    }

    public String getActOpinionTexts(String formCode, String actId) {
        String sql;
        GenForm form = this.findGenFormByCode(formCode);
        GenFormFlow gflow = this.genFormFlowService.findByFormIdAndApplyOrgs(form.getId(), null, SysUtils.getLoginUser().getOrgid().toString());
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (gflow != null) {
            sql = "select group_concat(i.ITEM_HTMLID)\n  from gen_form_panel p, gen_panel_item i, gen_form t, gen_act_item a\n where i.panel_id = p.panel_id\n   and a.item_id = i.item_id\n   and p.is_use = 'Y'\n   AND i.is_use = 'Y'\n   and i.item_type = '0'\n   and a.act_id = :actId\n   and a.is_editable = 'Y'\n   AND a.is_show = 'Y'\n   AND A.IS_USE = 'Y'\n   and a.setting_id = :id\n   and p.form_id = t.id\n   and t.form_code = :formCode";
            params.put("id", gflow.getId());
        } else {
            sql = " select group_concat(i.ITEM_HTMLID)\n          from gen_form_panel p, gen_panel_item i,gen_form t\n         where i.panel_id = p.panel_id\n           and p.is_use = 'Y'\n           AND i.is_use = 'Y'\n           and i.item_type = '0'\n           and instr(','||nvl(i.editable_act,'Act_1')||',',','||:actId||',')>0\n           and p.form_id = t.id\t\tand  t.form_code =:formCode\n";
        }
        params.put("formCode", formCode);
        params.put("actId", actId);
        Object object = this.sqlHelper.getSingal(sql, params);
        return Objects.toString(object, null);
    }

    public List<ComboxNode> getFormList(String query) {
        String sql = "select g.id ,g.form_Code value,g.form_Name text from gen_form g where g.is_use='Y' ";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            sql = sql + " and (upper(g.form_Name) like upper(#query#) or upper(g.form_code) like upper(#query#)) ";
            paras.put("query", "%" + query + "%");
        }
        sql = sql + " order by g.id";
        return this.bSqlHelper.serachBySql(sql, paras, ComboxNode.class);
    }

    public List<ComboxNode> getPanelItem(String formCode, String query) {
        String sql = "select t.item_id id ,concat('$','{item.',t.item_htmlname,'}') value,t.item_label text from GEN_PANEL_ITEM t where exists (select 1 from gen_form_panel p,gen_form f where f.form_code=#formCode# and p.form_id=f.id and f.is_use='Y' and p.panel_id=t.PANEL_ID )and t.hidden='0' and t.is_use='Y'";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            sql = sql + " and (upper(t.item_htmlname) like upper(#query#) or upper(t.item_label) like upper(#query#))";
            paras.put("query", "%" + query + "%");
        }
        paras.put("formCode", formCode);
        sql = sql + " order by t.DISPLAY_NO,ITEM_ID";
        return this.bSqlHelper.serachBySql(sql, paras, ComboxNode.class);
    }

    public LayuiPageObject<Map<String, Object>> queryMyFlowDrafts(int page, int limit, String createDate, String flowname, String isApp) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((CharSequence)createDate)) {
            paras.put("createDate", createDate);
        }
        if (!StringUtils.isEmpty((CharSequence)flowname)) {
            paras.put("flowname", "%" + flowname.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((CharSequence)isApp)) {
            paras.put("isApp", isApp);
        }
        return this.bSqlHelper.serachLayuiPage("business.workflow.common.getMyFlowDrafts", paras, PageRequest.of((int)page, (int)limit));
    }

    public String getFlowTitle(String formCode, String mainId) {
        JSONObject objectdata;
        if (StringUtils.isBlank((CharSequence)formCode) || mainId == null) {
            return null;
        }
        String sql = "select i.*\n  from GEN_FORM f, GEN_FORM_PANEL P, GEN_PANEL_ITEM I\n where P.FORM_ID = F.ID\n   AND I.PANEL_ID = P.PANEL_ID\n   AND P.IS_USE = 'Y'\n   AND I.IS_USE = 'Y'\n   AND f.form_code = #formCode#\n   and f.is_use = 'Y'\n   AND I.IS_TITLE = 'Y'\n\torder by i.display_no \n";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("formCode", formCode);
        List<GenPanelItem> list = this.bSqlHelper.serachBySql(sql, paras, GenPanelItem.class);
        GenForm form = this.findGenFormByCode(formCode);
        if (list.isEmpty()) {
            return null;
        }
        String loadurl = form.getLoaddataUrl().indexOf("?") > 0 ? form.getLoaddataUrl() + "&id=" + mainId : form.getLoaddataUrl() + "?id=" + mainId;
        try {
            objectdata = (JSONObject)SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), loadurl);
        }
        catch (Exception e) {
            return null;
        }
        StringBuffer title = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            GenPanelItem item = list.get(i);
            String t = Objects.toString(objectdata.get((Object)item.getItemHtmlname()), null);
            if (StringUtils.isNotBlank((CharSequence)t)) {
                JSONObject jsonObject;
                int j;
                JSONArray array;
                Object combodata;
                String combourl;
                String cbpara;
                if (BuildType.ITEM_DEPTCHOOSEBOX.equals(item.getItemType())) {
                    t = this.basDeptService.findByDeptId(Long.parseLong(t)).getDeptName();
                } else if (BuildType.ITEM_MONEYBOX.equals(item.getItemType())) {
                    if (t != null) {
                        BigDecimal money = new BigDecimal(t);
                        t = money.setScale(item.getItemDecimal().intValue(), RoundingMode.HALF_UP).toString();
                    }
                } else if (("-" + BuildType.ITEM_EMPCHOOSEBOX).equals(item.getItemType()) || BuildType.ITEM_EMPCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_EMPCHOOSEBOX.equals(item.getItemType())) {
                    t = this.basEmpAccountService.queryEmpAccountByIds(t);
                } else if (BuildType.ITEM_DICBOX.equals(item.getItemType()) || BuildType.ITEM_DICRADIOBOX.equals(item.getItemType()) || BuildType.ITEM_DICCHECKBOX.equals(item.getItemType()) || BuildType.ITEM_OTHERRADIOBOX.equals(item.getItemType()) || BuildType.ITEM_OTHERCHECKBOX.equals(item.getItemType())) {
                    if (StringUtils.isNotBlank((CharSequence)item.getDicCode())) {
                        t = this.commonService.getDicText(item.getDicCode(), t);
                    } else if (StringUtils.isNotBlank((CharSequence)item.getComboUrl())) {
                        cbpara = "formcode=" + formCode + "&id=" + mainId;
                        combourl = item.getComboUrl().indexOf("?") > 0 ? item.getComboUrl() + "&" + cbpara : item.getComboUrl() + "?" + cbpara;
                        try {
                            combodata = SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), combourl);
                        }
                        catch (Exception e) {
                            return null;
                        }
                        array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata));
                        for (j = 0; j < array.size(); ++j) {
                            jsonObject = array.getJSONObject(j);
                            if (!jsonObject.getString("value").equals(t)) continue;
                            t = jsonObject.getString("text");
                            break;
                        }
                    }
                } else if (BuildType.ITEM_COMBOBOX.equals(item.getItemType())) {
                    cbpara = "formcode=" + formCode + "&id=" + mainId;
                    combourl = item.getComboUrl().indexOf("?") > 0 ? item.getComboUrl() + "&" + cbpara : item.getComboUrl() + "?" + cbpara;
                    try {
                        combodata = SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), combourl);
                    }
                    catch (Exception e) {
                        return null;
                    }
                    array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata));
                    for (j = 0; j < array.size(); ++j) {
                        jsonObject = array.getJSONObject(j);
                        if (!jsonObject.getString("value").equals(t)) continue;
                        t = jsonObject.getString("text");
                        break;
                    }
                } else if (BuildType.ITEM_CHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_PROCHOOSEBOX.equals(item.getItemType()) || BuildType.ITEM_CONORGCHOOSEBOX.equals(item.getItemType()) || ("-" + BuildType.ITEM_CONORGCHOOSEBOX).equals(item.getItemType())) {
                    if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getFormCode(), item.getDisplayField()})) {
                        JSONObject cbdata;
                        GenForm filedform = this.findGenFormByCode(item.getFormCode());
                        String filedloadurl = filedform.getLoaddataUrl().indexOf("?") > 0 ? filedform.getLoaddataUrl() + "&id=" + t : filedform.getLoaddataUrl() + "?id=" + t;
                        try {
                            cbdata = (JSONObject)SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), filedloadurl);
                        }
                        catch (Exception e) {
                            return null;
                        }
                        t = Objects.toString(cbdata.get((Object)item.getDisplayField().replace("${item.", "").replace("}", "")), null);
                    }
                } else if (BuildType.ITEM_COMBOTREE.equals(item.getItemType())) {
                    cbpara = "formcode=" + formCode + "&id=" + mainId;
                    combourl = item.getComboUrl().indexOf("?") > 0 ? item.getComboUrl() + "&" + cbpara : item.getComboUrl() + "?" + cbpara;
                    combourl = combourl + "&detailId=" + URLUtil.encode((String)t);
                    try {
                        combodata = SysUtils.sendHttp(((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse(), combourl);
                    }
                    catch (Exception e) {
                        return null;
                    }
                    array = JSONArray.parseArray((String)JSON.toJSONString((Object)combodata));
                    for (j = 0; j < array.size(); ++j) {
                        jsonObject = array.getJSONObject(j);
                        if (!jsonObject.getString("id").equals(t)) continue;
                        t = jsonObject.getString("text");
                        break;
                    }
                }
            }
            if (i > 0) {
                title.append("-");
            }
            if (!StrKit.notNull(t)) continue;
            title.append(t);
        }
        return title.toString().replaceAll("\t|\r|\n", "");
    }

    public GenForm copyGenForm(String id) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        GenForm entity = (GenForm)this.genformDao.findById(id).get();
        GenForm clonebean = (GenForm)BeanUtils.cloneBean((Object)entity);
        clonebean.setId(null);
        clonebean.setFormCode(clonebean.getFormCode() + "_clone");
        this.saveGenForm(clonebean);
        List<GenFormPanel> panellist = this.formPanelService.findByFormID(id);
        for (GenFormPanel panel : panellist) {
            GenFormPanel clonepanel = (GenFormPanel)BeanUtils.cloneBean((Object)panel);
            clonepanel.setPanelId(null);
            clonepanel.setFormId(clonebean.getId());
            this.formPanelService.saveGenFormPanel(clonepanel);
            if (panel.getPanelType().equals(BuildType.PANEL_FORM) || panel.getPanelType().equals(BuildType.PANEL_TAB_FORM)) {
                List<GenPanelItem> itemlist = this.panelItemDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                ArrayList<GenPanelItem> cloneitemlist = new ArrayList<GenPanelItem>(itemlist.size());
                for (GenPanelItem item : itemlist) {
                    GenPanelItem cloneitem = (GenPanelItem)BeanUtils.cloneBean((Object)item);
                    cloneitem.setItemId(null);
                    cloneitem.setPanelId(clonepanel.getPanelId());
                    cloneitem.setGroupId(null);
                    cloneitem.setReferPanel(null);
                    cloneitemlist.add(cloneitem);
                }
                this.panelItemDao.saveAll(cloneitemlist);
                continue;
            }
            if (!panel.getPanelType().equals(BuildType.PANEL_FILE) && !panel.getPanelType().equals(BuildType.PANEL_TAB_FILE)) continue;
            List<GenPanelFile> filelist = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
            ArrayList<GenPanelFile> clonefilelist = new ArrayList<GenPanelFile>(filelist.size());
            for (GenPanelFile file : filelist) {
                GenPanelFile clonefile = (GenPanelFile)BeanUtils.cloneBean((Object)file);
                clonefile.setPanelFileId(null);
                clonefile.setPanelId(clonepanel.getPanelId());
                clonefilelist.add(clonefile);
            }
            this.genpanelfileDao.saveAll(clonefilelist);
        }
        return clonebean;
    }

    public String getFlowCodeByFormCode(String formCode) {
        GenForm form = this.findGenFormByCode(formCode);
        GenFormFlow flow = this.genFormFlowService.findByFormIdAndApplyOrgs(form.getId(), null, SysUtils.getLoginUser().getOrgid().toString());
        String flowCode = form.getFlowCode();
        if (flow != null) {
            flowCode = flow.getFlowCode();
        }
        return flowCode;
    }

    public void genFormByTable(DBTable table, boolean proccess) {
        String formName = StringUtils.isNotBlank((CharSequence)table.getDescription()) ? table.getDescription() : table.getTablename();
        if (formName.length() > 25) {
            formName.substring(0, 24);
        }
        GenForm form = new GenForm();
        form.setFormCode(table.getEntityName());
        form.setFormName(formName);
        form.setBusiTable(table.getTablename());
        form.setFormType("1");
        form.setIsApp("N");
        String pageName = table.getEntityName();
        pageName = pageName.substring(0, 1).toLowerCase() + pageName.substring(1);
        form.setSubmitUrl("/" + pageName + "/save" + table.getEntityName());
        form.setLoaddataUrl("/" + pageName + "/find" + table.getEntityName());
        form.setExcludeitems("/js/" + table.getViewpath() + "/" + pageName + "Extra.js");
        form.setIsUse("Y");
        this.saveGenForm(form);
        GenFormPanel panel = new GenFormPanel();
        panel.setPanelTitle("\u57fa\u7840\u4fe1\u606f");
        panel.setFormColnum(2L);
        panel.setPanelType("0");
        panel.setIsUse("Y");
        panel.setDisplayNo(1L);
        panel.setFormId(form.getId());
        this.formPanelService.saveGenFormPanel(panel);
        this.genpanelitemService.genPanelItemByTable(table, panel.getPanelId());
    }

    public List<DocFormFile> findBillFileList(String formCode, String pkId, String fileNature) {
        return this.findBillFileList(formCode, pkId, fileNature, null);
    }

    public List<DocFormFile> findBillFileList(String formCode, String pkId, String fileNature, String panelFileIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((CharSequence)formCode)) {
            return null;
        }
        params.put("formCode", formCode);
        if (StringUtils.isEmpty((CharSequence)pkId)) {
            return null;
        }
        params.put("pkId", pkId);
        if (!StringUtils.isEmpty((CharSequence)fileNature) && !"null".equals(fileNature)) {
            params.put("fileNature", ListUtils.stringToListWithLong(fileNature));
        }
        if (!StringUtils.isEmpty((CharSequence)panelFileIds) && !"null".equals(panelFileIds)) {
            params.put("panelFileIds", ListUtils.stringToListWithLong(panelFileIds));
        }
        GenForm form = new GenForm();
        List<GenForm> forms = this.genformDao.findByFormCodeAndIsUse(formCode, "Y");
        if (form != null && forms.size() > 0) {
            form = forms.get(0);
        }
        List<GenPanelFile> GenPanelFiles = this.bSqlHelper.getList("gen.GenForm.findBillPanelByFormCode", params, GenPanelFile.class);
        ArrayList<DocFormFile> list = new ArrayList<DocFormFile>();
        for (GenPanelFile file : GenPanelFiles) {
            List<DocFormFile> listFormFileByPK = this.docFormFileService.listFormFileByPK(form.getId(), file.getFileTypeId(), pkId);
            if (listFormFileByPK == null || listFormFileByPK.size() <= 0) continue;
            list.addAll(listFormFileByPK);
        }
        return list;
    }

    public List<ComboxNode> getPanelItemCom(String formCode, String query) {
        String sql = "select t.item_id id ,t.item_id value,t.item_label text from GEN_PANEL_ITEM t where exists (select 1 from gen_form_panel p,gen_form f where f.form_code=#formCode# and p.form_id=f.id and f.is_use='Y' and p.panel_id=t.PANEL_ID ) and t.is_use='Y'";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)query)) {
            sql = sql + " and (upper(t.item_htmlname) like upper(#query#) or upper(t.item_label) like upper(#query#))";
            paras.put("query", "%" + query + "%");
        }
        paras.put("formCode", formCode);
        sql = sql + " order by t.DISPLAY_NO,ITEM_ID";
        return this.bSqlHelper.serachBySql(sql, paras, ComboxNode.class);
    }

    public String getFormBorder() {
        return this.formBorder;
    }

    public void setFormBorder(String formBorder) {
        this.formBorder = formBorder;
    }

    public Object getFields(String fromCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formCode", fromCode);
        return this.bSqlHelper.getMapList("business.fm.FmApplyForm.getFields1", params);
    }

    public String getTitle(String fromCode) {
        String sql = "select i.*\n  from GEN_FORM f, GEN_FORM_PANEL P, GEN_PANEL_ITEM I\n where P.FORM_ID = F.ID\n   AND I.PANEL_ID = P.PANEL_ID\n   AND P.IS_USE = 'Y'\n   AND I.IS_USE = 'Y'\n   AND f.form_code = #formCode#\n   and f.is_use = 'Y'\n   AND I.IS_TITLE = 'Y'\n";
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("formCode", fromCode);
        List<GenPanelItem> list = this.bSqlHelper.serachBySql(sql, paras, GenPanelItem.class);
        if (list.isEmpty()) {
            return "";
        }
        return list.get(0).getItemHtmlname();
    }

    public JsonMsg importGenForm(String jsonStr) {
        JsonMsg msg = new JsonMsg();
        List list = JSONObject.parseArray((String)jsonStr, GenForm.class);
        int falseNum = 0;
        ArrayList<String> namelist = new ArrayList<String>();
        for (GenForm importForm : list) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{importForm.getId(), importForm.getFormCode()})) {
                ++falseNum;
                namelist.add(importForm.getFormName());
                continue;
            }
            try {
                GenForm form = this.genFormService.findGenFormByCode(importForm.getFormCode());
                if (form != null) {
                    this.genFormService.delGenForm(form.getId());
                    List<GenFormPanel> panels = this.formPanelService.findByFormID(form.getId());
                    for (GenFormPanel panel : panels) {
                        List<GenPanelItem> items = this.genpanelitemService.findByPanelId(panel.getPanelId(), null, null, null);
                        this.genpanelitemService.delGenPanelItemAll(items);
                        List<GenPanelFile> files = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
                        this.genpanelfileDao.deleteAll(files);
                        List<GenPanelGroup> groups = this.genpanelgroupService.findByPanelId(panel.getPanelId());
                        this.genpanelgroupService.delGenPanelGroupAll(groups);
                        this.formPanelService.delGenFormPanel(panel.getPanelId());
                    }
                }
                importForm.setId(null);
                this.genFormService.saveGenForm(importForm);
                HashMap<String, String> panelIds = new HashMap<String, String>(importForm.getPanels().size() * 2);
                HashMap<String, String> groupIds = new HashMap<String, String>(importForm.getPanels().size() * 2);
                for (GenFormPanel panel : importForm.getPanels()) {
                    panel.setFormId(importForm.getId());
                    String panelId = panel.getPanelId();
                    panel.setPanelId(null);
                    this.formPanelService.saveGenFormPanel(panel);
                    panelIds.put(panelId, panel.getPanelId());
                }
                for (GenFormPanel panel : importForm.getPanels()) {
                    for (GenPanelGroup group : panel.getGroups()) {
                        String groupId = group.getGroupId();
                        group.setPanelId(panel.getPanelId());
                        group.setGroupId(null);
                        this.genpanelgroupService.saveGenPanelGroup(group);
                        groupIds.put(groupId, group.getGroupId());
                    }
                    for (GenPanelItem item : panel.getItems()) {
                        BasDicType type;
                        item.setPanelId(panel.getPanelId());
                        if (StringUtils.isNotBlank((CharSequence)item.getReferPanel())) {
                            item.setReferPanel((String)panelIds.get(item.getReferPanel()));
                        }
                        if (StringUtils.isNotBlank((CharSequence)item.getGroupId())) {
                            item.setGroupId((String)groupIds.get(item.getGroupId()));
                        }
                        item.setItemId(null);
                        this.genpanelitemService.saveGenPanelItem(item);
                        if (item.getDicType() == null || (type = this.basdictypeService.findByDicCode(item.getDicCode())) != null) continue;
                        item.getDicType().setId(null);
                        this.basdictypeService.saveBasDicType(item.getDicType());
                        for (ValueText dic : item.getDicType().getDics()) {
                            BasDic basdic = new BasDic();
                            basdic.setDicCode(item.getDicType().getDicCode());
                            basdic.setDicName(item.getDicType().getDicName());
                            basdic.setDicText(dic.getText());
                            basdic.setDicValue(dic.getValue());
                            basdic.setTypeId(item.getDicType().getId());
                            basdic.setIsEnable("1");
                            this.basdiceService.saveDic(basdic);
                        }
                    }
                }
            }
            catch (Exception e) {
                ++falseNum;
                namelist.add(importForm.getFormName());
            }
        }
        if (falseNum == 0) {
            int successNum = list.size();
            msg.setMsg(successNum + "\u4e2a\u8868\u5355\u5bfc\u5165\u6210\u529f");
        } else {
            msg.setSuccess(false);
            int successNum = list.size() - falseNum;
            String name = StringUtils.join(namelist, (String)",");
            msg.setMsg(successNum + "\u4e2a\u8868\u5355\u5bfc\u5165\u6210\u529f\uff0c" + falseNum + "\u4e2a\u8868\u5355\u5bfc\u5165\u5931\u8d25\uff0c" + name + "\u5bfc\u5165\u5931\u8d25");
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportGenFormXml(String formIds, HttpServletResponse response) {
        ArrayList<GenForm> list = new ArrayList<GenForm>();
        String title = "";
        String[] formIdList = formIds.split(";");
        int num = formIdList.length;
        String str = "\u8868\u5355";
        if (num > 3) {
            num = 3;
            str = "\u7b49\u8868\u5355";
        }
        for (int i = 0; i < formIdList.length; ++i) {
            GenForm form = this.getGenFormAllInfo(formIdList[i]);
            list.add(form);
            if (i < num - 1) {
                title = title + form.getFormName() + "\u3001";
            }
            if (i != num - 1) continue;
            title = title + form.getFormName() + str;
        }
        cn.hutool.json.JSONArray json = JSONUtil.parseArray(list);
        ServletOutputStream out = null;
        try {
            response.setContentType("text/plain");
            response.setHeader("Content-Disposition", "attachment;filename=" + new String((title + ".json").getBytes("utf-8"), "iso-8859-1"));
            out = response.getOutputStream();
            out.write(json.toJSONString(1).getBytes());
        }
        catch (Exception e) {
            String msg = e.getCause().getMessage();
            if (msg != null && msg.contains("\u8f6f\u4ef6\u4e2d\u6b62")) {
            } else {
                logger.error((Object)("\u8868\u5355ID\uff1a" + formIds + "   \u5bfc\u51fa\u5931\u8d25\uff01"));
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
    }

    public GenForm getGenFormAllInfo(String formId) {
        GenForm form = this.findGenForm(formId);
        List<GenFormPanel> panels = this.formPanelService.findByFormID(form.getId());
        for (GenFormPanel panel : panels) {
            List<GenPanelItem> items = this.genpanelitemService.findByPanelId(panel.getPanelId(), null, null, null);
            for (GenPanelItem genPanelItem : items) {
                if (!StringUtils.isNotBlank((CharSequence)genPanelItem.getDicCode())) continue;
                BasDicType type = this.basdictypeService.findByDicCode(genPanelItem.getDicCode());
                if (type != null) {
                    List<ValueText> dics = MemCache.dicMap.get(genPanelItem.getDicCode());
                    type.setDics(dics);
                    genPanelItem.setDicType(type);
                    continue;
                }
                logger.warn((Object)(genPanelItem.getItemLabel() + "\u5173\u8054\u7684\u5b57\u5178" + genPanelItem.getDicCode() + "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u8bb0\u5f55"));
            }
            panel.setItems(items);
            List<GenPanelFile> files = this.genpanelfileDao.findByPanelIdAndIsUseOrderByDisplayNo(panel.getPanelId(), "Y");
            for (GenPanelFile file : files) {
                file.setFileType(this.docfiletypeService.findDocFileType(file.getFileTypeId()));
            }
            panel.setFiles(files);
            List<GenPanelGroup> list = this.genpanelgroupService.findByPanelId(panel.getPanelId());
            panel.setGroups(list);
        }
        form.setPanels(panels);
        return form;
    }

    public void updateWfStatus(String formcode, Long id, Long status) {
        GenForm genForm;
        if (StringUtils.isNotEmpty((CharSequence)formcode) && id != null && status != null && (genForm = this.findGenFormByCode(formcode)) != null) {
            String tableName = genForm.getBusiTable();
            String pkColNum = this.generatorService.getPK(tableName);
            String sql = "update " + tableName + " t\r\n   set t.workflow_status =" + status + "\r\n where " + pkColNum + " = " + id;
            this.sqlHelper.exeNativeSQL(sql);
        }
    }

    public PageObject getMiniList(String fuzzy, int page, int rows) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(fuzzy)) {
            params.put("fuzzy", StringUtil.getLikeStr(fuzzy));
        }
        return this.bSqlHelper.searchPage("gen.GenForm.getMiniList", params, PageRequest.of((int)page, (int)rows));
    }

    public String getFormName(String formCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formCode", formCode);
        return this.bSqlHelper.getStringValue("gen.GenForm.getFormName", params);
    }

    public boolean isPersonDealProcess(Long userId, Long processinstId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("processinstId", processinstId);
        return this.bSqlHelper.getIntValue("gen.GenForm.isPersonDealProcess", params) > 0;
    }
}

