/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.gen.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.gen.dao.GenFormPrintDao;
import com.guochuang.imp.gen.dao.GenFormPrintItemDao;
import com.guochuang.imp.gen.entity.GenFormPrint;
import com.guochuang.imp.gen.entity.GenFormPrintItem;
import com.guochuang.imp.gen.service.GenFormPrintItemService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenFormPrintService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GenFormPrintDao genFormPrintDao;
    @Autowired
    private GenFormPrintItemService genFormPrintItemService;
    @Autowired
    private GenFormPrintItemDao genFormPrintItemDao;

    public GenFormPrint findGenFormPrint(Long id) {
        GenFormPrint entity = (GenFormPrint)this.genFormPrintDao.findById(id).get();
        return entity;
    }

    public List<List<GenFormPrintItem>> buildFormPrint(String entityStr, GenFormPrint genFormPrint) {
        JSONObject mapFromJsonStr = new HashMap();
        ArrayList<List<GenFormPrintItem>> dataList = new ArrayList<List<GenFormPrintItem>>();
        ArrayList<GenFormPrintItem> tempList = new ArrayList<GenFormPrintItem>();
        GenFormPrintItem genFormPrintItem = null;
        int surplus = genFormPrint.getPrintColumnNumbers().intValue();
        List<GenFormPrintItem> genFormPrintItemList = null;
        mapFromJsonStr = JSON.parseObject((String)entityStr);
        genFormPrintItemList = this.genFormPrintItemDao.findByPrintIdAndIsUse(genFormPrint.getPrintId(), "Y");
        for (int i = 0; i < genFormPrintItemList.size(); ++i) {
            genFormPrintItem.setPrintItemContent(mapFromJsonStr.get((genFormPrintItem = genFormPrintItemList.get(i)).getPrintItemContent()) == null ? "" : mapFromJsonStr.get(genFormPrintItem.getPrintItemContent()).toString());
            if (surplus <= 0) {
                surplus = genFormPrint.getPrintColumnNumbers().intValue();
                dataList.add(tempList);
                tempList = new ArrayList();
            }
            if (surplus - genFormPrintItem.getItemColumnNumbers().intValue() - genFormPrintItem.getItemLabelNumbers().intValue() >= 0) {
                tempList.add(genFormPrintItem);
            } else {
                surplus = genFormPrint.getPrintColumnNumbers().intValue();
                dataList.add(tempList);
                tempList = new ArrayList();
                tempList.add(genFormPrintItem);
            }
            surplus = surplus - genFormPrintItem.getItemColumnNumbers().intValue() - genFormPrintItem.getItemLabelNumbers().intValue();
        }
        dataList.add(tempList);
        return dataList;
    }

    public void saveGenFormPrint(GenFormPrint entity) {
        this.genFormPrintDao.save(entity);
        if (entity.getGenFormPrintItemdataList() != null) {
            for (GenFormPrintItem detail : entity.getGenFormPrintItemdataList()) {
                detail.setPrintId(entity.getPrintId());
                if (StrKit.isBlank(detail.getIsUse())) {
                    detail.setIsUse("Y");
                    detail.setCreateAccount(entity.getModifyAccount());
                    detail.setCreateTime(new Date());
                }
                detail.setModifyAccount(entity.getModifyAccount());
                detail.setModifyTime(new Date());
                this.genFormPrintItemService.saveGenFormPrintItem(detail);
            }
        }
    }

    public void delGenFormPrint(Long id) {
        GenFormPrint entity = (GenFormPrint)this.genFormPrintDao.findById(id).get();
        entity.setIsUse("N");
        this.genFormPrintDao.save(entity);
    }

    public PageObject PageAll(String search, String startDate, String endDate, String applyPerson, String applyDept, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        return this.bSqlHelper.serachPage("gen.GenFormPrint.select", params, PageRequest.of((int)page, (int)rows));
    }
}

