/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.common.persist;

import com.guochuang.imp.doc.common.persist.FileInfo;
import com.guochuang.imp.doc.common.persist.PersistInterface;
import com.guochuang.imp.doc.common.util.FileHelper;
import com.guochuang.imp.doc.common.util.FileStoreException;
import com.guochuang.imp.doc.common.util.WaterMarkEnum;
import com.guochuang.imp.doc.common.util.WaterMarkUtil;
import com.guochuang.imp.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.multipart.MultipartFile;

public class PersistLocalFile
implements PersistInterface {
    private String localpath = "";
    private String localvisualpath = "";
    FileHelper filehelper = new FileHelper();
    private static PersistLocalFile instance;

    public PersistLocalFile(String lp, String lvp) {
        this.localpath = lp;
        this.localvisualpath = lvp;
    }

    public static synchronized PersistLocalFile getInstance(String lp, String lvp) {
        if (instance == null) {
            instance = new PersistLocalFile(lp, lvp);
        }
        return instance;
    }

    @Override
    public String uploadFile(MultipartFile file, FileInfo fileinfo) throws FileStoreException {
        String visualfilepath;
        String fileID;
        block34: {
            String filename = this.filehelper.replaceBlank(file.getOriginalFilename());
            fileinfo.setFilename(filename);
            fileID = "";
            String catapath = "/" + fileinfo.getProjectid() + "/" + fileinfo.getCatalogid() + "/";
            String pathString = this.localpath + "/" + catapath;
            String visualpathString = this.localvisualpath + catapath;
            File diskpath = new File(pathString);
            if (!diskpath.exists()) {
                diskpath.mkdirs();
            }
            String diskfilepath = diskpath.getAbsolutePath() + "/" + filename;
            File diskfile = this.filehelper.generFile(diskfilepath);
            visualfilepath = visualpathString + diskfile.getName();
            try {
                String waterMarkType = fileinfo.getWaterMarkType();
                String markContent = fileinfo.getMarkContent();
                String fileExt = FilenameUtils.getExtension((String)filename);
                if (StringUtil.isNotEmpty(waterMarkType) && StringUtil.isNotEmpty(markContent) && ("pdf".equals(fileExt) || "doc".equals(fileExt) || "docx".equals(fileExt))) {
                    if (WaterMarkEnum.IMG_MARK.getType().equals(waterMarkType)) {
                        FileInfo imgFile = new FileInfo();
                        imgFile.setUUID(fileinfo.getMarkContent());
                        imgFile = this.downloadFile(imgFile);
                        WaterMarkUtil.addImageWaterMark(file.getInputStream(), filename, diskfile.getAbsolutePath(), imgFile.getIs());
                    } else if (WaterMarkEnum.TEXT_MARK.getType().equals(waterMarkType)) {
                        WaterMarkUtil.addTextWaterMark(file.getInputStream(), filename, diskfile.getAbsolutePath(), fileinfo.getMarkContent());
                    }
                    try (FileInputStream is = new FileInputStream(diskfile.getAbsolutePath());){
                        String md5 = DigestUtils.md5Hex((InputStream)is);
                        fileinfo.setMd5(md5);
                    }
                    is = new FileInputStream(diskfile.getAbsolutePath());
                    var16_19 = null;
                    try {
                        String sha1 = DigestUtils.sha1Hex((InputStream)is);
                        fileinfo.setSha1(sha1);
                        break block34;
                    }
                    catch (Throwable throwable) {
                        var16_19 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (var16_19 != null) {
                                try {
                                    ((InputStream)is).close();
                                }
                                catch (Throwable throwable) {
                                    var16_19.addSuppressed(throwable);
                                }
                            } else {
                                ((InputStream)is).close();
                            }
                        }
                    }
                }
                file.transferTo(diskfile);
            }
            catch (IllegalStateException e) {
                throw new FileStoreException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!", e);
            }
            catch (IOException e) {
                throw new FileStoreException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!", e);
            }
            catch (Exception e) {
                throw new FileStoreException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25!", e);
            }
        }
        fileID = visualfilepath;
        return fileID;
    }

    @Override
    public FileInfo downloadFile(FileInfo fileinfo) throws FileStoreException {
        String pathString = "D:/TOMCAT-TAIMP/webapps/defaultroot/";
        String visualpathString = "/defaultroot/";
        String filepath = fileinfo.getUUID().replaceFirst(this.localvisualpath, this.localpath);
        File file = new File(filepath);
        if (this.filehelper.hasPermissions()) {
            try {
                fileinfo.setIs(new FileInputStream(file));
                fileinfo.setFilesize(file.length());
                return fileinfo;
            }
            catch (FileNotFoundException e) {
                throw new FileStoreException("\u6587\u4ef6:" + fileinfo.getUUID() + " \u672a\u627e\u5230!", e);
            }
        }
        return null;
    }

    public File downloadhelpFile(String filename) throws FileStoreException {
        String pathString = this.localpath;
        String visualpathString = this.localvisualpath;
        String filepath = filename.replaceFirst(visualpathString, pathString);
        File file = new File(filepath);
        return file;
    }

    @Override
    public FileInfo viewFile(FileInfo fileinfo) throws FileStoreException {
        return null;
    }

    @Override
    public boolean deleteFile(FileInfo fileinfo) throws FileStoreException {
        return false;
    }

    @Override
    public void replaceFile(MultipartFile file, FileInfo fileinfo) throws FileStoreException {
    }

    @Override
    public List<String> searchFile(FileInfo fileinfo) throws FileStoreException {
        return null;
    }

    @Override
    public boolean exist(FileInfo fileinfo) throws FileStoreException {
        String pathString = "D:/TOMCAT-TAIMP/webapps/defaultroot/";
        String visualpathString = "/defaultroot/";
        String filepath = fileinfo.getUUID().replaceFirst(this.localvisualpath, this.localpath);
        File file = new File(filepath);
        return file != null && file.exists();
    }

    @Override
    public Map<String, String> searchFileWithExcerpt(FileInfo fileinfo) throws FileStoreException {
        return null;
    }
}

