/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.doc.common.convert;

import com.guochuang.imp.doc.common.convert.WPSOfficeConverter;
import com.guochuang.imp.doc.common.persist.FileInfo;
import com.guochuang.imp.doc.entity.DocFileVersion;
import com.guochuang.imp.doc.service.DocFileVersionService;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class OfficeConvertCallable
implements Callable<Object> {
    public static Logger loger = Logger.getLogger(OfficeConvertCallable.class);
    private DocFileVersionService docfileversionService;
    private FileInfo fileinfo;

    public OfficeConvertCallable(DocFileVersionService docfileversionService, FileInfo fileinfo) {
        this.docfileversionService = docfileversionService;
        this.fileinfo = fileinfo;
    }

    @Override
    public Object call() {
        DocFileVersion version = this.fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(this.fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(this.fileinfo.getVersionid());
        int result = WPSOfficeConverter.officeToPdf(this.fileinfo.getTemppath(), this.fileinfo.getViewpath());
        loger.info((Object)("\u6587\u6863\u8f6c\u6362\u6210\u529f:" + version.getOriginalName()));
        if (result == -1) {
            version.setConvertStatus(-1L);
            loger.error((Object)("\u6587\u6863\u672a\u627e\u5230:" + version.getOriginalName() + " versionid:" + version.getVersionId() + " path:" + this.fileinfo.getTemppath()));
        } else if (result == 1) {
            version.setConvertStatus(1L);
            loger.info((Object)("\u6587\u6863\u8f6c\u6362\u6210\u529f:" + version.getOriginalName() + "versionid:" + version.getVersionId()));
            File dir = new File(this.fileinfo.getTemppath()).getParentFile();
            try {
                FileUtils.cleanDirectory((File)dir);
            }
            catch (IOException e) {
                loger.error((Object)"\u6587\u6863\u8f6c\u6362\u5931\u8d25:FileUtils.cleanDirectory(dir)");
            }
        } else if (result == 0) {
            version.setConvertStatus(0L);
            loger.error((Object)("\u6587\u6863\u8f6c\u6362\u5931\u8d25:" + version.getOriginalName() + "versionid:" + version.getVersionId()));
        }
        version.setPreviewPath(this.fileinfo.getViewpath());
        this.docfileversionService.saveDocFileVersion(version);
        return "OK";
    }
}

