/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.config.support;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class ContextCopyingDecorator
implements TaskDecorator {
    public Runnable decorate(Runnable runnable) {
        try {
            RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
            Map previous = MDC.getCopyOfContextMap();
            return () -> {
                try {
                    if (previous == null) {
                        MDC.clear();
                    } else {
                        MDC.setContextMap((Map)previous);
                    }
                    RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes);
                    runnable.run();
                }
                finally {
                    MDC.clear();
                    RequestContextHolder.resetRequestAttributes();
                }
            };
        }
        catch (IllegalStateException e) {
            return runnable;
        }
    }
}

