/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.GmInfoPraiseDao;
import com.guochuang.imp.base.entity.GmInfoPraise;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmInfoPraiseService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GmInfoPraiseDao gminfopraiseDao;

    public GmInfoPraise findGmInfoPraise(Long id) {
        GmInfoPraise entity = (GmInfoPraise)this.gminfopraiseDao.findById(id).get();
        return entity;
    }

    public void saveGmInfoPraise(GmInfoPraise entity) {
        this.gminfopraiseDao.save(entity);
    }

    public void delGmInfoPraise(Long id) {
        GmInfoPraise entity = (GmInfoPraise)this.gminfopraiseDao.findById(id).get();
        entity.setIsUse("N");
        this.gminfopraiseDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.GmInfoPraise.select", params, PageRequest.of((int)page, (int)rows));
    }

    public GmInfoPraise findPraiseDataByInfoId(Long accountid, Long id, String praiseType) {
        GmInfoPraise infoPraise = this.gminfopraiseDao.findByInfoIdAndAccountIdAndPraiseTypeAndIsUse(id, accountid, praiseType, "Y");
        if (infoPraise == null) {
            infoPraise = this.createPraiseDataByInfoId(id, praiseType);
        }
        return infoPraise;
    }

    private GmInfoPraise createPraiseDataByInfoId(Long id, String praiseType) {
        LoginUser user = SysUtils.getLoginUser();
        GmInfoPraise infoPraise = new GmInfoPraise();
        infoPraise.setAccountId(user.getAccountid());
        infoPraise.setInfoId(id);
        infoPraise.setOrgId(user.getOrgid());
        infoPraise.setDeptId(user.getDeptid());
        infoPraise.setIsPraise("N");
        infoPraise.setIsUse("Y");
        infoPraise.setPraiseType(praiseType);
        this.saveGmInfoPraise(infoPraise);
        return infoPraise;
    }

    public int findPraiseCountByInfoId(Long id) {
        List<GmInfoPraise> praiseList = this.gminfopraiseDao.findByInfoIdAndPraiseTypeAndIsPraiseAndIsUse(id, "1", "Y", "Y");
        int count = praiseList.size();
        return count;
    }
}

