/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.ComboxUtils;
import com.guochuang.imp.base.common.util.DateUtils;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasSysCodeDao;
import com.guochuang.imp.base.dao.BasSysCodeSeqDao;
import com.guochuang.imp.base.entity.BasSysCode;
import com.guochuang.imp.base.entity.BasSysCodeSeq;
import com.guochuang.imp.base.service.CommonService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasSysCodeService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasSysCodeDao bassyscodeDao;
    @Autowired
    private BasSysCodeSeqDao bassyscodeseqDao;

    public BasSysCode findBasSysCode(String id) {
        BasSysCode entity = (BasSysCode)this.bassyscodeDao.findById(id).get();
        return entity;
    }

    public void saveBasSysCode(BasSysCode entity) {
        this.bassyscodeDao.save(entity);
    }

    public void delBasSysCode(String id) {
        this.bassyscodeDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,concat(t.GENCODE_PREFIX,date_format(x.gencode_date,case when t.gencode_rule='6' then '%Y-%m' when t.gencode_rule='5' then '%Y-%m-%d' end ),lpad(x.gencode_no,case when t.gencode_rule='2' then 2 when t.gencode_rule='4' then 4  when t.gencode_rule='7' then 6 else 3 end ,'0'),t.GENCODE_SUFFIX) cur_no from BAS_SYS_CODE t,");
        sql.append("(select s.*,row_number() over(partition by s.sys_code_id order by s.gencode_date desc)rn  from BAS_SYS_CODE_SEQ s)x");
        sql.append(" where x.SYS_CODE_ID=t.SYS_CODE_ID and  x.rn=1");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.GENCODE) like :search ");
            sql.append(" or upper(t.GENCODE_PREFIX) like :search ");
            sql.append(" or upper(t.GENCODE_SUFFIX) like :search ");
            sql.append(" or upper(t.MEMO) like :search ");
            sql.append(" or upper(t.SYS_CODE_ID) like :search ");
            sql.append(" or upper(t.GENCODE_RULE) like :search ");
            sql.append(" or upper(t.GENCODE_DATE) like :search ");
            sql.append(" or upper(t.GENCODE_NO) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.GENCODE_DATE desc,t.SYS_CODE_ID ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("GENCODE_RULE", "SYS_CODE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public BasSysCodeSeq findByCode(BasSysCode code, String params) {
        List<BasSysCodeSeq> list = this.bassyscodeseqDao.findBySysCodeIdOrderByGencodeDate(code.getSysCodeId());
        if (SysContent.SWITCH_Y.equals(code.getYearclear()) || SysContent.SWITCH_Y.equals(code.getMonthclear())) {
            String dateFmt = "%Y";
            String gendate = SysUtils.getParamars(params, "gendate");
            String tempSql = "";
            if (SysContent.SWITCH_Y.equals(code.getMonthclear())) {
                dateFmt = "%Y-%m";
            }
            if (StrKit.isBlank(gendate)) {
                gendate = DateUtils.parse(new Date(), dateFmt);
                params = StrKit.notBlank(params) ? SysUtils.addParamars(params, "gendate", gendate) : "gendate=" + gendate;
            }
            tempSql = " and DATE_FORMAT(t.gencode_date, '" + dateFmt + "') = DATE_FORMAT(STR_TO_DATE('" + gendate + "', '" + dateFmt + "'), '" + dateFmt + "')";
            String sql = "select t.id  from BAS_SYS_CODE_SEQ t where t.sys_code_id = ?1 " + tempSql;
            Object o = this.sqlHelper.getSingal(sql, new Object[]{code.getSysCodeId()});
            if (o == null) {
                return this.createNewGencode(code, params);
            }
            return (BasSysCodeSeq)this.bassyscodeseqDao.findById(Long.parseLong(o.toString())).get();
        }
        if (list.isEmpty()) {
            BasSysCodeSeq newcode = new BasSysCodeSeq();
            newcode.setSysCodeId(code.getSysCodeId());
            newcode.setGencodeNo(0L);
            newcode.setGencodeDate(new Date());
            return (BasSysCodeSeq)this.bassyscodeseqDao.save(newcode);
        }
        return list.get(0);
    }

    public BasSysCodeSeq createNewGencode(BasSysCode code, String params) {
        String gendate = SysUtils.getParamars(params, "gendate");
        BasSysCodeSeq newcode = new BasSysCodeSeq();
        newcode.setSysCodeId(code.getSysCodeId());
        newcode.setGencodeNo(0L);
        try {
            if (!StrKit.isBlank(gendate) && (DateUtils.isValidMonth(gendate) || DateUtils.isValidYear(gendate))) {
                if (SysContent.SWITCH_Y.equals(code.getMonthclear())) {
                    newcode.setGencodeDate(DateUtils.strToMonthDate(gendate));
                } else if (SysContent.SWITCH_Y.equals(code.getYearclear())) {
                    newcode.setGencodeDate(DateUtils.strToYearDate(gendate));
                }
            }
        }
        catch (ParseException e) {
            newcode.setGencodeDate(new Date());
        }
        this.bassyscodeseqDao.save(newcode);
        return newcode;
    }

    public List<ComboxNode> allcode() {
        List<Object> list = new ArrayList();
        String sql = "select distinct t.gencode as value,\n                t.gencode ||'-' ||a.dic_text  as text,\n               '('||t.gencode_prefix ||'[' ||a.dic_text ||']'||\n                t.gencode_suffix ||')-'|| T.MEMO as description\n  from BAS_SYS_CODE t\n  left join bas_dic a\n    on a.dic_value = t.gencode_rule\n   and a.dic_code = 'SYS_CODE'";
        List resultlist = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        list = ComboxUtils.buildComboxNodes(resultlist);
        ComboxNode node = new ComboxNode();
        node.setText("---\u65e0---");
        list.add(0, node);
        return list;
    }

    public String genCode(String gencode, String params) {
        BasSysCode code;
        String codestr = "";
        List<BasSysCode> codes = this.bassyscodeDao.findByGencode(gencode);
        codestr = codes != null && !codes.isEmpty() ? ((code = codes.get(0)).getGencodeRule() == SysContent.SYSCODE_CUSTOM ? this.genCustomCode(code, gencode, params) : this.genRuleCode(code, params)) : this.genCustomCode(null, gencode, params);
        return codestr;
    }

    public String genRuleCode(BasSysCode code, String params) {
        String codestr = "";
        if (code.getGencodeRule() == 2L) {
            codestr = (code.getGencodePrefix() == null ? "" : code.getGencodePrefix()) + this.getSeqNo(code, 2L, params) + (code.getGencodeSuffix() == null ? "" : code.getGencodeSuffix());
        } else if (code.getGencodeRule() == 3L) {
            codestr = (code.getGencodePrefix() == null ? "" : code.getGencodePrefix()) + this.getSeqNo(code, 3L, params) + (code.getGencodeSuffix() == null ? "" : code.getGencodeSuffix());
        } else if (code.getGencodeRule() == 4L) {
            codestr = (code.getGencodePrefix() == null ? "" : code.getGencodePrefix()) + this.getSeqNo(code, 4L, params) + (code.getGencodeSuffix() == null ? "" : code.getGencodeSuffix());
        } else if (code.getGencodeRule() == 7L) {
            codestr = (code.getGencodePrefix() == null ? "" : code.getGencodePrefix()) + this.getSeqNo(code, 6L, params) + (code.getGencodeSuffix() == null ? "" : code.getGencodeSuffix());
        } else if (code.getGencodeRule() == 5L) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMMdd");
            String datestr = sdf.format(new Date());
            codestr = (code.getGencodePrefix() == null ? "" : code.getGencodePrefix()) + datestr + this.getSeqNo(code, 3L, params) + (code.getGencodeSuffix() == null ? "" : code.getGencodeSuffix());
        } else if (code.getGencodeRule() == 6L) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyMM");
            String datestr = sdf.format(new Date());
            codestr = (code.getGencodePrefix() == null ? "" : code.getGencodePrefix()) + datestr + this.getSeqNo(code, 3L, params) + (code.getGencodeSuffix() == null ? "" : code.getGencodeSuffix());
        }
        return codestr;
    }

    public String genCustomCode(BasSysCode code, String gencode, String params) {
        String codestr = "";
        if ("ARCHIVES_NO".equals(gencode)) {
            codestr = codestr + "0000";
            codestr = codestr + "-";
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + "-";
            codestr = codestr + SysUtils.getParamars(params, "saveterm");
            codestr = codestr + "-";
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + "-";
            codestr = codestr + this.getArchivesNo(Long.parseLong(SysUtils.getParamars(params, "archivestype")), 4L);
        } else if ("PROJECT_CODE".equals(gencode)) {
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 4L, params);
        } else if ("ZJBF".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("DFZJ".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("HBFX".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("CWSK".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("LOAN_NO".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("PMPMCON_CODE".equals(gencode)) {
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 4L, params);
        } else if ("FYBX".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("DXSJ".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("FWWX".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("CWJS".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("FWXC".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("FWZG".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("JJQD".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("ZJSQ".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("ZCQD".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("SQBH".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("ZCJD".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("ZCPD".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        } else if ("CGSQ".equals(gencode)) {
            codestr = codestr + code.getGencodePrefix();
            codestr = codestr + SysUtils.getParamars(params, "firstcode");
            codestr = codestr + SysUtils.getParamars(params, "secondcode");
            codestr = codestr + this.getSeqNo(code, 3L, params);
        }
        return codestr;
    }

    public String getSeqNo(BasSysCode code, Long length, String params) {
        BasSysCodeSeq seq = this.findByCode(code, params);
        String selectsql = "select lpad((t.gencode_no + 1), ?1, '0') as gencode\n  from bas_sys_code_seq t\n where t.id = ?2";
        Object result = this.sqlHelper.getSingal(selectsql, new Object[]{length, seq.getId()});
        String updatesql = "update bas_sys_code_seq t set t.gencode_no=t.gencode_no+1 where t.id=?1";
        this.sqlHelper.exeNativeSQL(updatesql, new Object[]{seq.getId()});
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    public String getArchivesNo(Long typeid, Long lenght) {
        String selectsql = "select lpad((count(*) + 1), ?1, '0') as no from DOC_FILE_VERSION t where t.archives_type=?2 and t.is_use='Y' and t.archives_no is not null ";
        Object result = this.sqlHelper.getSingal(selectsql, new Object[]{lenght, typeid});
        if (result != null) {
            return result.toString();
        }
        return "";
    }
}

