/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasQuerySettingdDao;
import com.guochuang.imp.base.entity.BasQuerySettingd;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasQuerySettingdService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasQuerySettingdDao basQuerySettingdDao;
    private static final String DATA_PERM_GROUP = "group";
    private static final String DATA_PERM_COMPANY = "company";
    private static final String DATA_PERM_DEPT = "dept";

    public PageObject pageAll(int page, int rows, String sort, String order, String typeId, String dataPerm) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        if (!StringUtil.isEmpty(typeId)) {
            params.put("typeId", typeId);
        }
        if (!StringUtil.isEmpty(dataPerm)) {
            params.put("dataPerm", dataPerm);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasQuerySettingd.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasQuerySettingd(BasQuerySettingd entity) {
        this.basQuerySettingdDao.save(entity);
    }

    public BasQuerySettingd findBasQuerySettingd(Long id) {
        BasQuerySettingd entity = (BasQuerySettingd)this.basQuerySettingdDao.findById(id).get();
        return entity;
    }

    public void delBasQuerySettingd(Long id) {
        BasQuerySettingd entity = (BasQuerySettingd)this.basQuerySettingdDao.findById(id).get();
        entity.setIsUse("N");
        this.basQuerySettingdDao.save(entity);
    }

    public List<Map<String, Object>> listDataPerm(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        return this.bSqlHelper.getMapList("base.BasQuerySetting.listDataPerm", params);
    }

    public List<ComBoxTreeNode> getOrgByDataperm(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        params.put("orgSql", this.getOrgSqlByCode(code));
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasQuerySetting.getOrgByDataperm", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> getDeptByDataperm(String code, Long orgId) {
        if (StringUtils.isBlank((CharSequence)code) || orgId == null) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        params.put("orgId", orgId);
        params.put("deptSql", this.getDeptSqlByCode(code));
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasQuerySetting.getDeptByDataperm", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public String getDeptSqlByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        LoginUser user = SysUtils.getLoginUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        List<BasQuerySettingd> dataPerms = this.bSqlHelper.getList("base.BasQuerySettingd.getSettingdByCode", params, BasQuerySettingd.class);
        for (BasQuerySettingd perms : dataPerms) {
            if (!DATA_PERM_GROUP.equals(perms.getDataPerm())) continue;
            return " select t.dept_id from bas_dept t where t.is_use='Y' ";
        }
        StringBuilder sql = new StringBuilder("select -1 dept_id ");
        for (BasQuerySettingd perms : dataPerms) {
            if (DATA_PERM_COMPANY.equals(perms.getDataPerm())) {
                sql.append("union all SELECT d.dept_id  FROM bas_roles_account a, bas_roles r,bas_dept d \nWHERE a.ACCOUNT_ID = " + user.getAccountid() + "  AND a.ROLE_ID = r.ROLE_ID and d.org_id = a.org_id\n\tAND ( CASE WHEN r.ROLE_TYPE = 'org' THEN  concat( a.ORG_ID, '>', a.ROLE_ID ) \n\t\t    \tWHEN r.ROLE_TYPE = 'dept' THEN concat( a.ORG_ID, '>', a.DEPT_ID, '>', a.ROLE_ID ) END) LIKE '" + perms.getParticipantId() + "'");
            }
            if (!DATA_PERM_DEPT.equals(perms.getDataPerm())) continue;
            sql.append("union all SELECT a.dept_id  FROM bas_roles_account a, bas_roles r \nWHERE a.ACCOUNT_ID = " + user.getAccountid() + "  AND a.ROLE_ID = r.ROLE_ID \n\tAND ( CASE WHEN r.ROLE_TYPE = 'org' THEN  concat( a.ORG_ID, '>', a.ROLE_ID ) \n\t\t    \tWHEN r.ROLE_TYPE = 'dept' THEN concat( a.ORG_ID, '>', a.DEPT_ID, '>', a.ROLE_ID ) END) LIKE '" + perms.getParticipantId() + "'");
        }
        return sql.toString();
    }

    public String getOrgSqlByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        LoginUser user = SysUtils.getLoginUser();
        List<BasQuerySettingd> dataPerms = this.bSqlHelper.getList("base.BasQuerySettingd.getSettingdByCode", params, BasQuerySettingd.class);
        for (BasQuerySettingd perms : dataPerms) {
            if (!DATA_PERM_GROUP.equals(perms.getDataPerm())) continue;
            return " select t.org_id from bas_org t where t.is_use='Y' ";
        }
        StringBuilder sql = new StringBuilder("select -1 org_id ");
        for (BasQuerySettingd perms : dataPerms) {
            if (DATA_PERM_COMPANY.equals(perms.getDataPerm())) {
                sql.append("union all SELECT a.ORG_ID  FROM bas_roles_account a, bas_roles r  \nWHERE a.ACCOUNT_ID = " + user.getAccountid() + "  AND a.ROLE_ID = r.ROLE_ID \n\tAND ( CASE WHEN r.ROLE_TYPE = 'org' THEN  concat( a.ORG_ID, '>', a.ROLE_ID ) \n\t\t    \tWHEN r.ROLE_TYPE = 'dept' THEN concat( a.ORG_ID, '>', a.DEPT_ID, '>', a.ROLE_ID ) END) LIKE '" + perms.getParticipantId() + "'");
            }
            if (!DATA_PERM_DEPT.equals(perms.getDataPerm())) continue;
            sql.append("union all SELECT a.ORG_ID  FROM bas_roles_account a, bas_roles r \nWHERE a.ACCOUNT_ID = " + user.getAccountid() + "  AND a.ROLE_ID = r.ROLE_ID \n\tAND ( CASE WHEN r.ROLE_TYPE = 'org' THEN  concat( a.ORG_ID, '>', a.ROLE_ID ) \n\t\t    \tWHEN r.ROLE_TYPE = 'dept' THEN concat( a.ORG_ID, '>', a.DEPT_ID, '>', a.ROLE_ID ) END) LIKE '" + perms.getParticipantId() + "'");
        }
        return sql.toString();
    }

    public String getFullOrgSqlByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("code", code);
        LoginUser user = SysUtils.getLoginUser();
        List<BasQuerySettingd> dataPerms = this.bSqlHelper.getList("base.BasQuerySettingd.getSettingdByCode", params, BasQuerySettingd.class);
        for (BasQuerySettingd perms : dataPerms) {
            if (!DATA_PERM_GROUP.equals(perms.getDataPerm())) continue;
            return " select t.org_id from bas_org t where t.is_use='Y' ";
        }
        StringBuilder sql = new StringBuilder("select -1 org_id ");
        for (BasQuerySettingd perms : dataPerms) {
            if (!DATA_PERM_COMPANY.equals(perms.getDataPerm())) continue;
            sql.append("union all SELECT a.ORG_ID  FROM bas_roles_account a, bas_roles r  \nWHERE a.ACCOUNT_ID = " + user.getAccountid() + "  AND a.ROLE_ID = r.ROLE_ID \n\tAND ( CASE WHEN r.ROLE_TYPE = 'org' THEN  concat( a.ORG_ID, '>', a.ROLE_ID ) \n\t\t    \tWHEN r.ROLE_TYPE = 'dept' THEN concat( a.ORG_ID, '>', a.DEPT_ID, '>', a.ROLE_ID ) END) LIKE '" + perms.getParticipantId() + "'");
        }
        return sql.toString();
    }

    public boolean findBasQuerySettingdByEntity(BasQuerySettingd basQuerySettingd) {
        if (basQuerySettingd == null) {
            return false;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("participantType", basQuerySettingd.getParticipantType());
        params.put("participantId", basQuerySettingd.getParticipantId());
        params.put("typeId", basQuerySettingd.getTypeId());
        params.put("dataParm", basQuerySettingd.getDataPerm());
        Integer count = this.bSqlHelper.getIntValue("base.BasQuerySetting.findBasQuerySettingdByEntity", params);
        return count != null && count > 0;
    }
}

