/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.spring.SpringContextHolder;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasProcessForwardingDao;
import com.guochuang.imp.base.dao.BasProcessForwardingdDao;
import com.guochuang.imp.base.entity.BasProcessForwarding;
import com.guochuang.imp.base.entity.BasProcessForwardingd;
import com.guochuang.imp.base.extend.IBasMessageAdditional;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasProcessForwardingService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasProcessForwardingDao basProcessForwardingDao;
    @Autowired
    private BasProcessForwardingdDao basProcessForwardingdDao;

    public PageObject<Map<String, Object>> pageAll(int page, int rows, String sort, String order, String title, String senderName, Date startDate, Date endDate, String isReadValue) {
        LoginUser loginUser = SysUtils.getLoginUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("accountId", loginUser.getAccountid().toString());
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        if (!StringUtil.isEmpty(title)) {
            params.put("title", "%" + title + "%");
        }
        if (!StringUtil.isEmpty(senderName)) {
            params.put("senderName", "%" + senderName + "%");
        }
        if (!StringUtil.isEmpty(startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtil.isEmpty(endDate)) {
            params.put("endDate", endDate);
        }
        if (!"All".equals(isReadValue)) {
            params.put("isReadValue", isReadValue);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasProcessForwarding.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasProcessForwarding(BasProcessForwarding entity) {
        this.basProcessForwardingDao.save(entity);
        for (String id : entity.getReceiveIds().split(",")) {
            BasProcessForwardingd detail = new BasProcessForwardingd();
            detail.setForwardingId(entity.getId());
            detail.setIsRead("N");
            detail.setReceiveId(Long.parseLong(id));
            detail.setMsgId(entity.getMsgId());
            detail.setProcessinstid(entity.getProcessinstid());
            detail.setIsUse("Y");
            this.basProcessForwardingdDao.save(detail);
        }
        Map<String, IBasMessageAdditional> map = SpringContextHolder.getBeansOfType(IBasMessageAdditional.class);
        for (String key : map.keySet()) {
            IBasMessageAdditional bma = map.get(key);
            bma.onProcessForwarding(entity);
        }
    }

    public BasProcessForwarding findBasProcessForwarding(Long id) {
        BasProcessForwarding entity = (BasProcessForwarding)this.basProcessForwardingDao.findById(id).get();
        return entity;
    }

    public void delBasProcessForwarding(Long id) {
        BasProcessForwarding entity = (BasProcessForwarding)this.basProcessForwardingDao.findById(id).get();
        entity.setIsUse("N");
        this.basProcessForwardingDao.save(entity);
    }

    public List<Map<String, Object>> listForwarding(String formCode, Long busiMainId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formCode", formCode);
        params.put("busiMainId", busiMainId);
        return this.bSqlHelper.getMapList("base.BasProcessForwarding.listForwarding", params);
    }

    public List<Map<String, Object>> listLoginForwarding(Boolean read) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (read != null) {
            if (read.booleanValue()) {
                params.put("isRead", "Y");
            } else {
                params.put("isRead", "Y");
            }
        }
        return this.bSqlHelper.getMapList("base.BasProcessForwarding.listLoginForwarding", params);
    }

    public List<Map<String, Object>> findAllReceive() {
        return this.bSqlHelper.getMapList("base.BasProcessForwarding.findAllReceive", null);
    }
}

