/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.bean.BeanUtil;
import com.guochuang.imp.base.common.spring.SystemServiceLog;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.ComboxCheckNode;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.ComboxUtils;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysContent;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasEmpAccountDao;
import com.guochuang.imp.base.dao.BasOrgDao;
import com.guochuang.imp.base.entity.BasOrg;
import com.guochuang.imp.base.req.GetBasOrgCombotreeReq;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.base.service.MemCacheService;
import com.guochuang.imp.util.StringUtil;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasOrgService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasOrgDao basOrgDao;
    @Autowired
    private BasEmpAccountDao basAccountDao;
    @Autowired
    private CommonService commonService;
    @Autowired
    private MemCacheService memCacheService;

    public List<ComBoxTreeNode> getOrgDeptTree(boolean fullName, boolean showDept, Integer level, boolean withLogin, boolean withOut, boolean withSelf, Long pid, boolean showCancel) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fullName", fullName);
        params.put("showDept", showDept);
        params.put("level", level);
        if (withLogin) {
            pid = SysUtils.getLoginUser().getOrgid();
        }
        if (pid == null) {
            pid = 0L;
        }
        params.put("pid", pid);
        params.put("withOut", withOut);
        params.put("withSelf", withSelf);
        params.put("showCancel", showCancel);
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getOrgDeptTree", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComboxNode> getOrgDeptComb(boolean fullName, boolean showDept, Integer level, boolean withLogin, boolean withOut, boolean withEmpty, boolean withSelf, Long pid, boolean showCancel) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fullName", fullName);
        params.put("showDept", showDept);
        params.put("level", level);
        if (withLogin) {
            pid = SysUtils.getLoginUser().getOrgid();
        }
        if (pid == null) {
            pid = 0L;
        }
        params.put("pid", pid);
        params.put("withOut", withOut);
        params.put("withSelf", withSelf);
        params.put("showCancel", showCancel);
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getOrgDeptTree", params);
        ComboxUtils.DefineNode dn = new ComboxUtils.DefineNode();
        dn.id = "id";
        dn.text = "text";
        dn.value = "id";
        if (withEmpty) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", "");
            map.put("text", "\u5168\u90e8");
            list.add(0, map);
        }
        return ComboxUtils.buildComboxNodes(list, dn);
    }

    public List<ComBoxTreeNode> getOrgMenu(long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT \tt.ORG_ID id,\n     t.abbr text, \n     t.org_name , \n     t.retrieve_Code , \n      t.org_code as orgCode,\n\t\tcase when (\tSELECT COUNT(*) \n\t\t\t\t\t\tFROM BAS_ORG \n\t\t\t\t\t\tWHERE PORG_ID = T.ORG_ID AND IS_USE='Y'\n\t\t\t\t\t)=0 then 'open' else 'closed' end AS state \nFROM \tBAS_ORG t  WHERE\tt.IS_USE='Y' \nAND\t\tt.PORG_ID = ?1 \norder by t.sort\n");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.listToNodeList(list);
    }

    public List<ComBoxTreeNode> getOrgTree(Boolean isContainOutside) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from BAS_ORG m \n\t where   m.PORG_ID = 0  and m.is_use='Y' \n\t union all\n\t select m.* from BAS_ORG m,org  where  m.PORG_ID=org.ORG_ID and m.is_use='Y'\n\t )\n select \n\t\t\tt.ORG_ID id, \n\t\t\tT.PORG_ID PID, \n\t\t\tt.abbr text, \n\t\t\t'open' as state\n from org t\n");
        if (!isContainOutside.booleanValue()) {
            sql.append("where t.type = 0");
        }
        sql.append(" ORDER BY t.sort");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> findOrgTree(Long obsId) {
        StringBuilder sql = new StringBuilder();
        sql.append("select \tT .ORG_ID id,\n       T .PORG_ID pid, \n       T .abbr text \n from \tBAS_ORG T \n where T .IS_USE = 'Y' \n start with \t\tT .PORG_ID = ?1 \nCONNECT BY PRIOR \tT .ORG_ID = T .PORG_ID \n ORDER BY \t\t\tT .sort ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{obsId}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public String getOrgName(String ids) {
        String sql = "select GETORGNAME('" + ids + "') from dual";
        return Objects.toString(this.sqlHelper.getSingal(sql), "");
    }

    public String getOrgDeptName(String ids) {
        String sql = "select GETDEPTNAME('" + ids + "') ";
        return Objects.toString(this.sqlHelper.getSingal(sql), "");
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeWb(String id, String orgId) {
        StringBuilder sql = new StringBuilder();
        if (StringUtils.isNotBlank((String)orgId)) {
            id = orgId;
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept_wb m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept_wb m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept_wb a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        } else {
            if (StringUtils.isBlank((String)id)) {
                id = "0";
            }
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept_wb m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept_wb m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept_wb a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        }
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTree(String id, String orgId, String type, String showCancel) {
        StringBuilder sql = new StringBuilder();
        if (StringUtils.isNotBlank((String)orgId)) {
            id = orgId;
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' " + ("1".equals(type) ? "" : " and ifnull(m.type,'0')='0' ") + ("Y".equalsIgnoreCase(showCancel) ? "" : " and m.status <> '0' ") + "\n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id " + ("1".equals(type) ? "" : " and ifnull(m.type,'0')='0' ") + ("Y".equalsIgnoreCase(showCancel) ? "" : " and m.status <> '0' ") + "\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id " + ("1".equals(type) ? "" : " and ifnull(a.type,'0')='0' ") + ("Y".equalsIgnoreCase(showCancel) ? "" : " and a.status <> '0' ") + ")=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        } else {
            if (StringUtils.isBlank((String)id)) {
                id = "0";
            }
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' " + ("1".equals(type) ? "" : " and ifnull(m.type,'0')='0' ") + ("Y".equalsIgnoreCase(showCancel) ? "" : " and m.status <> '0' ") + "\n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id " + ("1".equals(type) ? "" : " and ifnull(m.type,'0')='0' ") + ("Y".equalsIgnoreCase(showCancel) ? "" : " and m.status <> '0' ") + "\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id " + ("1".equals(type) ? "" : " and ifnull(a.type,'0')='0' ") + ("Y".equalsIgnoreCase(showCancel) ? "" : " and a.status <> '0' ") + ")=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        }
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeExcludeExternal(String orgId, String deptId) {
        StringBuilder sql = new StringBuilder();
        if (!StringUtils.isNotBlank((String)orgId)) {
            return null;
        }
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(orgId) ? "m.pid" : "m.id") + "='" + orgId + "' \n    and m.org_name!='\u5916\u90e8\u5355\u4f4d'\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n" + (StringUtils.isNotBlank((String)deptId) ? "where dept_id=" + deptId : "") + " ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeQx(String id, String orgId) {
        StringBuilder sql = new StringBuilder();
        Subject currentUser = SecurityUtils.getSubject();
        if (!currentUser.isPermitted("searchAllHrPost")) {
            id = orgId;
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        } else {
            id = "0";
            sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        }
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public Object queryOrgAndDeptTreeWithoutRoot(String id) {
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  m.pid=" + SysContent.GROUP_ORG + " \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeForContact(String id) {
        String crossOrg = "Y";
        if (StringUtils.isBlank((String)id)) {
            id = "Y".equals(crossOrg) ? "0" : SysUtils.getLoginUser().getOrgid().toString();
        }
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  " + ("0".equals(id) ? "m.pid" : "m.id") + "='" + id + "'\n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<Map<String, Object>> queryEmpOrgTree(Long id, String showCancel, String nameSort) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sql = "with recursive emp as(\nselect e.* from view_bas_org_emp e where e.id=#id# union all\nselect e.* from view_bas_org_emp e,emp m where  e.pid = m.id\n)\nselect b.*,\n       (select count(*) from view_bas_org_emp a where a.pid = b.id) title,\n       case when b.type=0 then 'org' when b.type=1 then 'dept' when b.type=2 then 'post' when b.type=3 then 'emp' else '' end class_Name,\n       b.text name,\n       case when b.type=3 then (select emp_id from bas_emp e where e.hr_emp_id = b.pkid and e.is_use='Y') else '' end user_code\n  from emp b \n" + ("Y".equalsIgnoreCase(showCancel) ? "" : " where (b.type in(0,1) and b.status<>'0') or (b.type = 3 and b.status in('01','02')) \n") + "order by b.type desc,b.display_no";
        params.put("id", id.toString());
        List<Map<String, Object>> maps = this.bSqlHelper.serachBySql(sql, params);
        if ("Y".equalsIgnoreCase(nameSort)) {
            Map<Boolean, List<Map>> part = maps.stream().collect(Collectors.partitioningBy(m -> "3".equals(m.get("type"))));
            List<Map> emps = part.get(Boolean.TRUE);
            Collator collator = Collator.getInstance(Locale.CHINA);
            emps.sort(Comparator.comparing(o -> collator.getCollationKey(o.get("text").toString())));
            List<Map<String, Object>> result = part.get(Boolean.FALSE);
            result.addAll(emps);
            return CommTreeUtils.buildTreeMap(result);
        }
        return CommTreeUtils.buildTreeMap(maps);
    }

    public List<Map<String, Object>> queryOrgTreeMap(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String sql = " WITH RECURSIVE temp AS ( \nSELECT b.*,( SELECT count(*) FROM view_bas_org_dept a WHERE a.pid = b.id ) title,\nnvl2 ( b.dept_id, 'dept', 'org' ) class_Name,\nb.text NAME \nFROM\n\tview_bas_org_dept b WHERE b.id=#id# \n\tUNION ALL\n\tSELECT b.*,( SELECT count(*) FROM view_bas_org_dept a WHERE a.pid = b.id ) title,\nnvl2 ( b.dept_id, 'dept', 'org' ) class_Name,\nb.text NAME \nFROM\n\tview_bas_org_dept b,\n\t\ttemp t \n\tWHERE\n\t\tt.id = b.pid \n\t) SELECT\n\ttemp.*\nFROM\n\ttemp ";
        params.put("id", id.toString());
        return CommTreeUtils.buildTreeMap(this.bSqlHelper.serachBySql(sql, params));
    }

    public List queryOrgAndDeptList(String id) {
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" WITH RECURSIVE temp AS (  SELECT\tb.*  FROM\tview_bas_org_dept b WHERE b.pid = '" + id + "' \tUNION ALL SELECT\tb.*  FROM\tview_bas_org_dept b,\t\ttemp t \tWHERE\t\tt.id = b.pid \t) SELECT\ttemp.* FROM\ttemp ");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeNew(String id) {
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept m \n\t where  m.id='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept m,org  where  m.pid=org.id\n\t )\n select t.*,\n\t(case when (select count(*) from view_bas_org_dept a where a.pid=t.id)=0 then 'open' else 'closed' end )state\n from org t\n ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public Object queryOrgAndDeptTreeNew1(String id, Long orgId) {
        if (StringUtils.isBlank((String)id)) {
            id = "0";
        }
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select m.* from view_bas_org_dept_new m \n\t where  m.pid='" + id + "' \n\t union all\n\t select m.* from view_bas_org_dept_new m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_dept_new a where a.pid=t.id)=0 then 'open' else 'closed' end state,concat(t.id,'_') pids\n from org t\n where t.ORG_ID=" + orgId + " ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public JsonMsg saveOrg(BasOrg basOrg) {
        if (basOrg.getOrgId() == null) {
            basOrg.setIsUse("Y");
        }
        this.basOrgDao.save(basOrg);
        this.memCacheService.setOrgCache();
        return new JsonMsg(true, "\u4fdd\u5b58\u6210\u529f", basOrg);
    }

    @SystemServiceLog(description="\u67e5\u8be2\u7ec4\u7ec7\u673a\u6784\u4fe1\u606fservice")
    public BasOrg findByOrgId(Long orgId) {
        Optional org = this.basOrgDao.findById(orgId);
        if (org.isPresent()) {
            return (BasOrg)this.basOrgDao.findById(orgId).get();
        }
        return null;
    }

    public boolean delOrgs(Long searchId) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tUPDATE \tBAS_ORG m \n\tSET\t\tm.IS_USE='N' \n\tWHERE \tm.ORG_ID in ( with recursive org as(\n\t\t\t\t select a.* from BAS_ORG a where  a.ORG_ID = ?1 and a.IS_USE = 'Y' \n\t\t\t\t union all\n\t\t\t\t select a.* from BAS_ORG a,org where org.ORG_ID=a.PORG_ID and a.IS_USE = 'Y' )\n\t\t\t\t select org.ORG_ID from org) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{searchId});
        return true;
    }

    public List<ComBoxTreeNode> getOutOrgTreeByLv(String lv) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct T.ORG_ID ID, T.ABBR TEXT,T.PORG_ID PID \n  FROM bas_org t\n WHERE t.lv = ?1\n START WITH org_id IN (SELECT org_id\n                         FROM bas_outside_org  where is_use='Y')\nCONNECT BY PRIOR t.porg_id = t.org_id  order by t.ABBR");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{lv}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> buildOrgAndDeptTreeWithOnLineAccount(List<ComBoxTreeNode> orgdepttree, List<Long> accountIdList) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", accountIdList);
        String sql = "select t.*,nvl(d.dept_id,t.dept_id) bizdept,nvl(d.org_id,t.org_id) bizorg,(with recursive org as(\nselect m.* from view_bas_org_dept m where m.id =nvl(d.dept_id,t.dept_id)\nunion all  select m.* from view_bas_org_dept m,org  where  m.id=org.pid\n)select group_concat(org.id) from org\n)pids from bas_emp_account t\nleft join bas_org o on o.org_id = t.org_id\nleft join bas_dept d on d.dept_id= o.belong_dept where t.account_id in( #join(ids)#) and t.emp_id<>0";
        List<Map<String, Object>> accountlist = this.bSqlHelper.serachBySql(sql, params);
        this.buildOnLineAccount(orgdepttree, accountlist);
        return orgdepttree;
    }

    public void buildOnLineAccount(List<ComBoxTreeNode> orgdepttree, List<Map<String, Object>> accountlist) {
        for (ComBoxTreeNode node : orgdepttree) {
            if ("1".equals(node.getAttributes().get("dtype").toString())) {
                String id = node.getId();
                int num = 0;
                for (Map<String, Object> account : accountlist) {
                    if (account.get("bizdept") == null || !("," + account.get("pids") + ",").contains("," + id + ",") && !id.equals(account.get("deptId").toString())) continue;
                    ++num;
                }
                node.setText(num > 0 ? node.getText() + "(" + num + ")" : node.getText());
            } else {
                int num = 0;
                for (Map<String, Object> account : accountlist) {
                    if (!("," + account.get("pids") + ",").contains("," + node.getId() + ",")) continue;
                    ++num;
                }
                node.setText(num > 0 ? node.getText() + "(" + num + ")" : node.getText());
            }
            if (node.getChildren().size() <= 0) continue;
            this.buildOnLineAccount(node.getChildren(), accountlist);
        }
    }

    public List<ComboxNode> allFinanceOrg() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct T.ORG_ID ID, T.ABBR TEXT,T.ORG_ID VALUE,t.sort \n  FROM bas_org t\n WHERE  T.type='0' and t.is_use='Y' order by t.sort ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<BasOrg> allEasOrg() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * \n  FROM bas_org t\n WHERE  T.type='0' and t.is_use='Y' order by t.sort ");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), BasOrg.class, new int[0]);
        return list;
    }

    public List<ComboxNode> getComboOrg(String type) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct T.ORG_ID ID, T.ORG_NAME TEXT,T.ORG_ID VALUE,T.SORT \n  FROM bas_org t\n WHERE t.is_use='Y'" + ("1".equals(type) ? "" : " and ifnull(t.type,'0')='0' ") + " order by t.sort");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public Long queryEmpOrgId(Long accountId) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("  select getorgid(:accountId) from dual ");
        params.put("accountId", accountId);
        Object o = this.sqlHelper.getSingal(sql.toString(), params);
        if (o != null && StrKit.notBlank(o.toString())) {
            return Long.valueOf(o.toString());
        }
        return null;
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*  ");
        sql.append(" from BAS_ORG t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.ABBR) like :search ");
            sql.append(" or upper(t.ADDR) like :search ");
            sql.append(" or upper(t.ANNUL_DATE) like :search ");
            sql.append(" or upper(t.ESTABLISH_DATE) like :search ");
            sql.append(" or upper(t.LEGAL_PERSON) like :search ");
            sql.append(" or upper(t.MAIN_INDUSTRY) like :search ");
            sql.append(" or upper(t.ORG_CODE) like :search ");
            sql.append(" or upper(t.ORG_NAME) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.SORT");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<ComBoxTreeNode> treeBasOrg(Long pid, String type, String showFullName) {
        return this.treeBasOrg(pid, type, showFullName, "N");
    }

    public List<ComBoxTreeNode> treeBasOrg(Long pid, String type, String showFullName, String showCancel) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        params.put("type", type);
        if (StringUtils.isNotBlank((String)showFullName)) {
            params.put("showFullName", showFullName);
        }
        if (StringUtils.isNotBlank((String)showCancel)) {
            params.put("showCancel", showCancel);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.treeBasOrg", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> findBasOrgByOne(Long org_id) {
        List<ComBoxTreeNode> result = null;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("org_id", org_id);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.findBasOrgByOne", params);
        result = CommTreeUtils.buildTreeNode(list);
        for (int i = 0; i < result.size(); ++i) {
            result.get(i).setValue(result.get(i).getId());
            result.get(i).setChecked(false);
        }
        return result;
    }

    public List<Map<String, Object>> constructOrgAndFirstDept() {
        HashMap params = new HashMap();
        StringBuilder sql = new StringBuilder();
        sql.append("select\nt.ID value,\nt.TEXT text\nfrom VIEW_BAS_ORG_DEPT t where t.pid='10000000' order by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[0], new int[0]);
        for (Map map : list) {
            map.put("value", map.get("VALUE"));
            map.put("text", map.get("TEXT"));
        }
        return list;
    }

    public Object getComboDeptForGroup() {
        StringBuilder sql = new StringBuilder();
        sql.append("select\nt.dept_id value,\nt.abbr text\nfrom BAS_DEPT t where t.is_use='Y' and t.org_id=10000000");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public Object getComboDeptForLogin(Long orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getComboDeptForLogin", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComBoxTreeNode> getNextDept(Long deptId) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive cte as(\n    SELECT x.ID id,x.TEXT text,x.PID pid \n    from VIEW_BAS_ORG_DEPT x\n    where x.id =" + deptId + " \n    union all \n    SELECT y.ID id,y.TEXT text,y.PID pid\n    from VIEW_BAS_ORG_DEPT y\n    join cte c on c.id = y.pid and y.id =" + deptId + "\n)SELECT ID,TEXT,PID from cte");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }

    public String findRetrieveCodeById(Long orgId) {
        String firstCode = null;
        if (orgId != null) {
            BasOrg orgEntity = (BasOrg)this.basOrgDao.findById(orgId).get();
            firstCode = orgEntity.getRetrieveCode();
        }
        return firstCode;
    }

    public Object getComboOrgTop(Long orgId) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive tmp as  \n(select A.org_id id, A.org_id value,A.porg_id PID,A.ABBR TEXT,A.SORT from bas_org A where A.org_id =" + orgId + "\n");
        sql.append("UNION ALL  \n");
        sql.append("select B.org_id id,B.org_id value,B.porg_id PID,B.ABBR TEXT,B.SORT from bas_org B,tmp t  where t.PID = B.org_id) \n");
        sql.append("select *  from tmp p ORDER BY SORT \n");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public BasOrg findTaxTypeByOrgId(Long orgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        if (orgId == null) {
            orgId = user.getOrgid();
        }
        params.put("orgId", orgId);
        BasOrg entity = this.bSqlHelper.getEntity("base.BasOrg.findTaxTypeByOrgId", params, BasOrg.class);
        return entity;
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeByOrg(String id, Long orgId) {
        String orgSql = "";
        if (SysContent.GROUP_ORG.compareTo(orgId) == 0) {
            id = "0";
            orgSql = " and m.ORG_id= " + orgId + " ";
        } else {
            id = SysContent.GROUP_ORG.toString();
            orgSql = " and m.dept_id= " + SysUtils.getLoginUser().getBusinessUnitId() + " ";
        }
        String view = "view_bas_org_bizdept";
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive org as\n\t (select * from " + view + " m \n\t where  m.pid='" + id + "' " + orgSql + " \n\t union all\n\t select m.* from " + view + " m,org  where  m.pid=org.id\n\t )\n select t.*,\n\tcase when (select count(*) from view_bas_org_bizdept a where a.pid=t.id)=0 then 'open' else 'closed' end state from org t\n ORDER by t.dtype desc,t.display_no");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<ComboxNode> getComboxListForApplyOrg(Long orgId, String level) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        if (orgId == null) {
            orgId = user.getOrgid();
        }
        params.put("orgId", orgId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getComboxListForApplyOrg", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComBoxTreeNode> querySubUnit(Long id, String excludeids) {
        String sql = "select b.* from view_bas_org_dept b\n  where b.pid='" + (id == null ? SysUtils.getLoginUser().getOrgid() : id) + "' or\nb.pid in (select t.id from view_bas_org_dept t\n  where b.pid='" + (id == null ? SysUtils.getLoginUser().getOrgid() : id) + "'  and t.dept_id is null )\n\torder by dtype desc,b.display_no";
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]));
        return ll;
    }

    public List<ComboxNode> getSubUnitAndSeptByOrg(Long orgId, Boolean isdetail) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        if (orgId != null) {
            params.put("orgId", orgId);
        } else if (!isdetail.booleanValue()) {
            params.put("orgId", user.getOrgid());
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getComboxListForOrgSub", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public String findSubUnitAndSeptNameById(String id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)id)) {
            return "";
        }
        params.put("id", id);
        return this.bSqlHelper.getStringValue("base.BasOrg.findSubUnitAndSeptNameById", params);
    }

    public List<ComboxNode> findAssessmentOrg() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.findAssessmentOrg", params);
        return ComboxUtils.buildComboxNodes(list);
    }

    public BasOrg findByAbbr(String abbr) {
        return this.basOrgDao.findByAbbr(abbr);
    }

    public List<ComboxNode> getComboOrgSimple() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT distinct T.ORG_ID ID, T.ABBR TEXT,T.ORG_ID VALUE,T.SORT  FROM bas_org t WHERE t.is_use='Y' and ifnull(t.type,'0')!='1' order by t.sort");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }

    public List<ComBoxTreeNode> getOrgTreeByDataPerm(String dataPerm) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        List<Map<String, Object>> list = null;
        if ("group".equals(dataPerm)) {
            return this.queryOrgAndDeptTree(null, null, "0", "Y");
        }
        if ("company".equals(dataPerm)) {
            params.put("orgId", user.getOrgid());
            params.put("self", "Y");
            list = this.bSqlHelper.getMapList("base.BasOrg.getComboxListForOrgSub", params);
        } else if ("charge".equals(dataPerm)) {
            list = this.bSqlHelper.getMapList("base.BasOrg.getChargeOrgAndDept", params);
        } else if ("dept".equals(dataPerm)) {
            list = this.bSqlHelper.getMapList("base.BasOrg.getLeaderDept", params);
        }
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<ComBoxTreeNode> queryOrgAndDeptTreeRoot() {
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.queryOrgAndDeptTreeRoot", null);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(list);
        return ll;
    }

    public List<Map<String, Object>> findInsideOrgList() {
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.findInsideOrgList", null);
        if (list != null && !list.isEmpty()) {
            return list;
        }
        return Collections.emptyList();
    }

    public List<ComBoxTreeNode> queryOrgTreeByEscrow(Long pid, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        params.put("type", type);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.queryOrgTreeByEscrow", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<BasOrg> allOrg() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT *\nFROM bas_org t\nWHERE t.is_use = 'Y'\norder by t.sort");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), BasOrg.class, new int[0]);
        return list;
    }

    public BasOrg findByOrgCode(String orgCode) {
        List<BasOrg> list = this.basOrgDao.findByOrgCodeAndIsUse(orgCode, "Y");
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    public BasOrg findByOrgName(String orgName) {
        return this.basOrgDao.findByOrgNameAndIsUse(orgName, "Y");
    }

    public List<ComboxCheckNode> getSubUnitAndSOrg(String checkValue) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)checkValue)) {
            params.put("checkValue", checkValue);
        } else {
            params.put("checkValue", -1);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasOrg.getSubUnitAndSOrg", params);
        return ComboxUtils.buildComboxCheckNodes(list);
    }

    public String getNamesByIds(String ids) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ids", ids);
        return this.bSqlHelper.getStringValue("base.BasOrg.getNamesByIds", params);
    }

    public String getMembershipOrgLogo() {
        LoginUser loginUser = SysUtils.getLoginUser();
        if (loginUser != null) {
            Long orgId = loginUser.getOrgid();
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("orgId", orgId);
            return this.bSqlHelper.getStringValue("base.BasOrg.getMembershipOrgLogo", params);
        }
        return null;
    }

    public boolean hasRepeat(BasOrg org) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgName", org.getOrgName());
        params.put("abbr", org.getAbbr());
        params.put("orgId", org.getOrgId());
        params.put("orgCode", org.getOrgCode());
        params.put("retrieveCode", org.getRetrieveCode());
        return this.bSqlHelper.getIntValue("base.BasOrg.checkRepeatCount", params) > 0;
    }

    public List<ComBoxTreeNode> queryThisUnitAndItsSubsidiaries(String orgId, Boolean isTree) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)orgId)) {
            params.put("orgId", orgId);
        } else {
            params.put("orgId", SysContent.ORG_ID_TFJT);
        }
        if (isTree != null && isTree.booleanValue()) {
            params.put("isTree", isTree);
        }
        List<Map<String, Object>> mapList = this.bSqlHelper.getMapList("base.BasOrg.queryThisUnitAndItsSubsidiaries", params);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(mapList);
        return ll;
    }

    public Long getOrgEmpNums(Long orgId, String showCancel, boolean getAll) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);
        params.put("showCancel", showCancel);
        if (getAll) {
            params.put("getAll", "Y");
        }
        return this.bSqlHelper.getLongValue("base.BasOrg.getOrgEmpNums", params);
    }

    public List<Map<String, Object>> queryEmpOrgTreeForTime(Long pid, String showCancel, String nameSort) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (pid == null) {
            pid = 0L;
        }
        String sql = "with recursive emp as(\nselect e.* from view_bas_org_emp e where e.pid=#pid# union all\nselect e.* from view_bas_org_emp e,emp m where  e.pid = m.id\n)\nselect b.*,\n       (case when b.type = 3 then 1 else 0 end) as title,\n       case when b.type=0 then 'org' when b.type=1 then 'dept' when b.type=2 then 'post' when b.type=3 then 'emp' else '' end class_Name,\n       b.text name,\n       case when b.type=3 then (select emp_id from bas_emp e where e.hr_emp_id = b.pkid and e.is_use='Y') else '' end user_code,\n       case when b.type=3 then (select h.photo_Version_Id from hr_emp h where h.hr_emp_id = b.pkid ) else '' end photo_Version_Id\n  from emp b \n" + ("Y".equalsIgnoreCase(showCancel) ? "" : " where (b.type in(0,1) and b.status<>'0') or (b.type = 3 and b.status in('01','02')) \n") + "order by b.type desc,b.display_no";
        params.put("pid", pid.toString());
        List<Map<String, Object>> maps = this.bSqlHelper.serachBySql(sql, params);
        if ("Y".equalsIgnoreCase(nameSort)) {
            Map<Boolean, List<Map>> part = maps.stream().collect(Collectors.partitioningBy(m -> "3".equals(m.get("type"))));
            List<Map> emps = part.get(Boolean.TRUE);
            Collator collator = Collator.getInstance(Locale.CHINA);
            emps.sort(Comparator.comparing(o -> collator.getCollationKey(o.get("text").toString())));
            List<Map<String, Object>> result = part.get(Boolean.FALSE);
            result.addAll(emps);
            return CommTreeUtils.buildTreeMap(result);
        }
        return this.filterData(CommTreeUtils.buildTreeMap(maps));
    }

    public List<Map<String, Object>> queryEmpOrgTreeForTimeMultiJob(Long pid, String showCancel, String nameSort) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (pid == null) {
            pid = 0L;
        }
        String sql = "with recursive emp as(\nselect e.* from view_bas_org_emp e where e.pid=#pid# union all\nselect e.* from view_bas_org_emp e,emp m where  e.pid = m.id\n)\nselect b.*,\n       (case when b.type = 3 then 1 else 0 end) as title,\n       case when b.type=0 then 'org' when b.type=1 then 'dept' when b.type=2 then 'post' when b.type=3 then 'emp' else '' end class_Name,\n       b.text name,\n       case when b.type=3 then (select emp_id from bas_emp e where e.hr_emp_id = b.pkid and e.is_use='Y') else '' end user_code,\n       case when b.type=3 then (select h.photo_Version_Id from hr_emp h where h.hr_emp_id = b.pkid ) else '' end photo_Version_Id\n  from emp b \n" + ("Y".equalsIgnoreCase(showCancel) ? "" : " where (b.type in(0,1) and b.status<>'0') or (b.type = 3 and b.status in('01','02')) \n") + "order by b.type desc,b.display_no";
        params.put("pid", pid.toString());
        List<Map<String, Object>> maps = this.bSqlHelper.serachBySql(sql, params);
        if ("Y".equalsIgnoreCase(nameSort)) {
            Map<Boolean, List<Map>> part = maps.stream().collect(Collectors.partitioningBy(m -> "3".equals(m.get("type"))));
            List<Map> emps = part.get(Boolean.TRUE);
            Collator collator = Collator.getInstance(Locale.CHINA);
            emps.sort(Comparator.comparing(o -> collator.getCollationKey(o.get("text").toString())));
            List<Map<String, Object>> result = part.get(Boolean.FALSE);
            result.addAll(emps);
            return CommTreeUtils.buildTreeMap(result);
        }
        List<Map<String, Object>> res = CommTreeUtils.buildTreeMap(maps);
        List<Map<String, Object>> res1 = this.filterData(res);
        String sql2 = "SELECT\n\t\tconcat( 'emp', e.HR_EMP_ID ) AS id,\n\t\tconcat( '', sd.dept_sub ) AS pid,\n\t\te.EMP_NAME AS TEXT,\n\t\te.EMP_CODE AS CODE,\n\t\trow_number() OVER ( ORDER BY IF (( sd.ORDER_NUM IS NULL ), 1, 0 ), sd.ORDER_NUM, e.ORDER_NUM ) AS DISPLAY_NO,\n\t\t'4' AS type,\n\t\te.HR_EMP_ID AS pkid,\n\t\te.STATUS AS STATUS ,\n\t\t'1' as tittle,\n\t\t'emp' as class_Name,\n\t\te.EMP_NAME,\n\t\t(select emp_id from bas_emp ee where ee.hr_emp_id = e.HR_EMP_ID and ee.is_use='Y') as user_code,\n\t\te.photo_Version_Id as photo_Version_Id\n\n\tFROM\n\t\t(\n\t\t\tview_has_normal_account_emp e\n\t\t\tJOIN (\n\t\t\tSELECT\n\t\t\t\tt.HR_EMP_ID AS HR_EMP_ID,\n\t\t\t\tmin( p.ORDER_NUM ) AS ORDER_NUM,\n\t\t\t\tp.DEPT_ID AS dept_sub \n\t\t\tFROM\n\t\t\t\t(\n\t\t\t\t\thr_emp t\n\t\t\t\t\tJOIN hr_post p ON ((\n\t\t\t\t\t\t\tfind_in_set( p.POST_ID, t.VICE_STATION ) > 0 \n\t\t\t\t\t\t))) \n\t\t\tWHERE\n\t\t\t\t((\n\t\t\t\t\t\tt.IS_USE = 'Y' \n\t\t\t\t\t\t) \n\t\t\t\tAND ( p.IS_USE = 'Y' )) \n\t\t\tGROUP BY\n\t\t\t\tt.HR_EMP_ID,\n\t\t\t\tp.DEPT_ID \n\t\t\t\t) sd ON ((\n\t\t\t\t\tsd.HR_EMP_ID = e.HR_EMP_ID \n\t\t\t\t))) \n\tWHERE\n\t\t((\n\t\t\t\te.IS_USE = 'Y' \n\t\t\t\t) \n\t\t\tAND ( e.HR_EMP_ID <> 0 ) \n\t\t\tAND ( e.GROUP_STATISTICS = '1' ) \n\t\t\tAND e.ORG_ID IN (\n\t\t\t\tWITH recursive temp AS (\n\t\t\t\tSELECT\n\t\t\t\t\to.ORG_ID AS org_id,\n\t\t\t\t\to.PORG_ID AS PORG_ID \n\t\t\t\tFROM\n\t\t\t\t\tbas_org o \n\t\t\t\tWHERE\n\t\t\t\t\t((\n\t\t\t\t\t\t\to.ORG_ID = 10000000 \n\t\t\t\t\t\t\t) \n\t\t\t\t\tAND ( o.IS_USE = 'Y' )) UNION ALL\n\t\t\t\tSELECT\n\t\t\t\t\to2.ORG_ID AS org_id,\n\t\t\t\t\to2.PORG_ID AS PORG_ID \n\t\t\t\tFROM\n\t\t\t\t\t( bas_org o2 JOIN temp t ) \n\t\t\t\tWHERE\n\t\t\t\t\t((\n\t\t\t\t\t\t\tt.org_id = o2.PORG_ID \n\t\t\t\t\t\t\t) \n\t\t\t\t\tAND ( o2.IS_USE = 'Y' ))) SELECT\n\t\t\t\ttemp.org_id \n\t\t\tFROM\n\t\t\ttemp \n\t))";
        List<Map<String, Object>> otherEmp = this.bSqlHelper.serachBySql(sql2, params);
        Map<String, List<Map<String, Object>>> otherEmpDeptList = otherEmp.stream().collect(Collectors.groupingBy(m -> String.valueOf(m.get("pid"))));
        this.recursiveDept(res1, otherEmpDeptList);
        return res1;
    }

    public void recursiveDept(List<Map<String, Object>> nodes, Map<String, List<Map<String, Object>>> otherEmpDeptList) {
        nodes.forEach(node -> {
            String id;
            if (this.isListMapOfStringObjectAndNotEmpty(node.get("children"))) {
                this.recursiveDept((List)node.get("children"), otherEmpDeptList);
            } else if ("dept".equals(Optional.ofNullable(node.get("className")).orElse("").toString()) && otherEmpDeptList.containsKey(id = Optional.ofNullable(node.get("id")).orElse("0").toString())) {
                Integer existNum = Integer.valueOf(Optional.ofNullable(node.get("title")).orElse("0").toString());
                List otherEmps = (List)otherEmpDeptList.get(id);
                if (node.get("children") != null) {
                    List existChildren = (List)node.get("children");
                    existChildren.addAll(otherEmps);
                    node.put("children", existChildren);
                } else {
                    node.put("children", otherEmps);
                }
                existNum = existNum + otherEmps.size();
                node.put("title", existNum);
            }
        });
    }

    public boolean isListMapOfStringObjectAndNotEmpty(Object obj) {
        Object firstElement;
        List list;
        if (obj != null && obj instanceof List && (list = (List)obj).size() > 0 && (firstElement = list.get(0)) instanceof Map) {
            Map map = (Map)firstElement;
            boolean isStringKeys = map.keySet().stream().allMatch(key -> key instanceof String);
            boolean isObjectValues = map.values().stream().allMatch(value -> value instanceof Object);
            return isStringKeys && isObjectValues;
        }
        return false;
    }

    private List<Map<String, Object>> filterData(List<Map<String, Object>> res) {
        for (int i = 0; i < res.size(); ++i) {
            res.get(i).put("title", this.filterData(res.get(i)));
        }
        return res;
    }

    private int filterData(Map<String, Object> res) {
        Object child;
        int nums = 0;
        int childNums = 0;
        if (!StringUtil.isEmpty(res.get("title"))) {
            nums += Integer.parseInt(res.get("title").toString());
        }
        if (!StringUtil.isEmpty(child = res.get("children"))) {
            List resChildList = (List)child;
            for (int j = 0; j < resChildList.size(); ++j) {
                childNums += this.filterData((Map)resChildList.get(j));
            }
        }
        res.put("title", childNums);
        return nums += childNums;
    }

    public List<ComBoxTreeNode> getBasOrgCombotree(GetBasOrgCombotreeReq req) {
        if (null != req.getIsOwnOrg() && req.getIsOwnOrg().booleanValue()) {
            req.setOrgId(SysUtils.getLoginUser().getOrgid());
        }
        Map params = BeanUtil.beanToMap((Object)req, (boolean)false, (boolean)true);
        List<Map<String, Object>> mapList = this.bSqlHelper.getMapList("base.BasOrg.getBasOrgCombotree", params);
        List<ComBoxTreeNode> ll = CommTreeUtils.buildTreeNode(mapList);
        return ll;
    }
}

