/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasOpRecordDao;
import com.guochuang.imp.base.entity.BasOpRecord;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.DateUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasOpRecordService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasOpRecordDao basOpRecordDao;

    public PageObject pageAll(Long busiId, String busiFormCode, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        if (busiId != null) {
            params.put("busiId", busiId);
        }
        if (!StringUtil.isEmpty(busiFormCode)) {
            params.put("busiFormCode", busiFormCode);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasOpRecord.pageAll", params, PageRequest.of((int)page, (int)rows));
        for (Map<String, Object> map : pageObject.getRows()) {
            map.put("createrName", MemCache.getEmpAccountName(StringUtil.strToLong(map.get("createAccount"))));
            map.put("createTime", DateUtil.formatDateTime(map.get("createTime")));
        }
        return pageObject;
    }

    @Transactional
    public void saveBasOpRecord(BasOpRecord entity) {
        this.basOpRecordDao.save(entity);
    }

    public BasOpRecord findBasOpRecord(Long id) {
        BasOpRecord entity = (BasOpRecord)this.basOpRecordDao.findById(id).get();
        return entity;
    }

    public void delBasOpRecord(Long id) {
        BasOpRecord entity = (BasOpRecord)this.basOpRecordDao.findById(id).get();
        entity.setIsUse("N");
        this.basOpRecordDao.save(entity);
    }
}

