/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.ComboxUtils;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasMeasureUnitDao;
import com.guochuang.imp.base.entity.BasMeasureUnit;
import com.guochuang.imp.base.service.CommonService;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasMeasureUnitService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasMeasureUnitDao basmeasureunitDao;

    public BasMeasureUnit findBasMeasureUnit(Long id) {
        BasMeasureUnit entity = (BasMeasureUnit)this.basmeasureunitDao.findById(id).get();
        return entity;
    }

    public void saveBasMeasureUnit(BasMeasureUnit entity) {
        this.basmeasureunitDao.save(entity);
    }

    public void delBasMeasureUnit(Long id) {
        this.basmeasureunitDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select * from BAS_MEASURE_UNIT t ");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(t.MEASURE_UNIT_ID) like :search ");
            sql.append(" or upper(t.MEASURE_UNIT_NAME) like :search ");
            sql.append(" or upper(t.MEASURE_UNIT_ALIAS) like :search ");
            sql.append(" or upper(t.DISPLAY_NO) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.MEASURE_UNIT_ID");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<ComboxNode> getComboxList() {
        String sql = "select distinct t.MEASURE_UNIT_ID value,\n\tt.MEASURE_UNIT_NAME text\n\t from BAS_MEASURE_UNIT t \n  order by t.display_No,t.MEASURE_UNIT_ID";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        return ComboxUtils.buildComboxNodes(list, new ComboxUtils.DefineNode());
    }
}

