/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasGroupAccountRelateDao;
import com.guochuang.imp.base.entity.BasGroup;
import com.guochuang.imp.base.entity.BasGroupAccountRelate;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasGroupAccountRelateService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasGroupAccountRelateDao basgroupaccountrelateDao;

    public BasGroupAccountRelate findBasGroupAccountRelate(Long id) {
        BasGroupAccountRelate entity = (BasGroupAccountRelate)this.basgroupaccountrelateDao.findById(id).get();
        return entity;
    }

    public List<BasGroupAccountRelate> findBasGroupAccountRelateByGroupId(Long id) {
        return this.basgroupaccountrelateDao.findByGroupIdAndIsUse(id, "Y");
    }

    public List<BasGroupAccountRelate> findBasGroupAccountRelateByUserType(String typeId) {
        return this.basgroupaccountrelateDao.findByUserTypeAndIsUse(typeId, "Y");
    }

    public List<BasGroupAccountRelate> findBasGroupAccountRelateByGroupEntityList(List<BasGroup> groups) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        String groupIds = "";
        if (groups != null && groups.size() > 0) {
            for (int i = 0; i < groups.size(); ++i) {
                groupIds = groupIds + groups.get(i).getGroupId() + ",";
            }
        } else {
            return new ArrayList<BasGroupAccountRelate>();
        }
        params.put("groupIds", "," + groupIds);
        return this.bSqlHelper.getList("base.BasGroupAccountRelate.getListByGroupId", params, BasGroupAccountRelate.class);
    }

    public void saveBasGroupAccountRelate(BasGroupAccountRelate entity) {
        this.basgroupaccountrelateDao.save(entity);
    }

    public void delBasGroupAccountRelate(Long id) {
        BasGroupAccountRelate entity = (BasGroupAccountRelate)this.basgroupaccountrelateDao.findById(id).get();
        entity.setIsUse("N");
        this.basgroupaccountrelateDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.BasGroupAccountRelate.select", params, PageRequest.of((int)page, (int)rows));
    }

    public void deleteByGroupId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("groupId", id);
        List<BasGroupAccountRelate> list = this.bSqlHelper.getList("base.BasGroupAccountRelate.getListByGroupId", params, BasGroupAccountRelate.class);
        for (BasGroupAccountRelate e : list) {
            e.setIsUse("N");
            this.basgroupaccountrelateDao.save(e);
        }
    }
}

