/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasFlowPrintDetailDao;
import com.guochuang.imp.base.entity.BasFlowPrintDetail;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasFlowPrintDetailService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasFlowPrintDetailDao basFlowPrintDetailDao;

    public List<Map<String, Object>> pageAll(String search, Long mainId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (mainId == null) {
            return new ArrayList<Map<String, Object>>();
        }
        params.put("mainId", mainId);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasFlowPrintDetail.pageAll", params);
        return list;
    }

    @Transactional
    public void saveBasFlowPrintDetail(List<BasFlowPrintDetail> list, Long mainId) {
        for (BasFlowPrintDetail entiy : list) {
            if (entiy.getDetailId() == null) {
                entiy.setCreateTime(new Date());
                entiy.setCreateAccount(SysUtils.getLoginAccountId());
            } else {
                entiy.setModifyTime(new Date());
                entiy.setModifyAccount(SysUtils.getLoginAccountId());
            }
            entiy.setPrintId(mainId);
        }
        this.basFlowPrintDetailDao.saveAll(list);
    }

    public BasFlowPrintDetail findBasFlowPrintDetail(Long id) {
        BasFlowPrintDetail entity = (BasFlowPrintDetail)this.basFlowPrintDetailDao.findById(id).get();
        return entity;
    }

    public void delBasFlowPrintDetail(Long id) {
        BasFlowPrintDetail entity = (BasFlowPrintDetail)this.basFlowPrintDetailDao.findById(id).get();
        entity.setIsUse("N");
        this.basFlowPrintDetailDao.save(entity);
    }

    public List<Map<String, Object>> findByForeignId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("mainId", id);
        return this.bSqlHelper.getMapList("base.BasFlowPrintDetail.pageAll", params);
    }

    public List<BasFlowPrintDetail> findListById(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("mainId", id);
        return this.bSqlHelper.getList("base.BasFlowPrintDetail.pageAll", params, BasFlowPrintDetail.class);
    }
}

