/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.map.MapUtil;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasFlowActPrintDao;
import com.guochuang.imp.base.entity.BasFlowActPrint;
import com.guochuang.imp.base.service.BasFlowActPrintDetailService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasFlowActPrintService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasFlowActPrintDao basFlowActPrintDao;
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BasFlowActPrintDetailService basFlowActPrintDetailService;

    public PageObject pageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.trim().toUpperCase() + "%");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasFlowActPrint.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasFlowActPrint(BasFlowActPrint entity, String detailList) {
        this.basFlowActPrintDao.save(entity);
        if (!StringUtil.isEmpty(detailList)) {
            this.basFlowActPrintDetailService.saveBasFlowActPrintDetail(detailList, entity.getPrintId());
        }
    }

    public BasFlowActPrint findBasFlowActPrint(Long id) {
        BasFlowActPrint entity = (BasFlowActPrint)this.basFlowActPrintDao.findById(id).get();
        return entity;
    }

    public void delBasFlowActPrint(Long id) {
        BasFlowActPrint entity = (BasFlowActPrint)this.basFlowActPrintDao.findById(id).get();
        entity.setIsUse("N");
        this.basFlowActPrintDao.save(entity);
    }

    public boolean findByProcessdefidAndIsUse(Long processdefid) {
        return this.basFlowActPrintDao.findByProcessdefidAndIsUse(processdefid, "Y") != null;
    }

    public List<Map<String, Object>> findActListByFlowName(String processdefid) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        if (StringUtil.isEmpty(processdefid)) {
            return new ArrayList<Map<String, Object>>();
        }
        String sql = "SELECT x.* FROM (\nWITH flow_act AS (\n\tSELECT\n\t\tExtractValue ( t.PROCESSDEFCONTENT, '/ProcessDefine/Activitys/Activity/@id' ) acts_id,\n\t\tREGEXP_REPLACE(ExtractValue ( t.PROCESSDEFCONTENT, '/ProcessDefine/Activitys/Activity/@name' ),'\\\\s+',' ') NAMES   \n\tFROM\n\t\twf_processdefine t \n\tWHERE\n\t\tt.PROCESSDEFID =?1\n\t\t) SELECT\n\tSUBSTRING_INDEX( SUBSTRING_INDEX( a.acts_id, ' ', b.ID + 1 ), ' ',- 1 ) AS activitydefid,\n\tSUBSTRING_INDEX( SUBSTRING_INDEX( a.NAMES, ' ', b.ID + 1 ), ' ',- 1 ) AS actname \nFROM\n\tflow_act A\n\tJOIN sys_ROW b ON b.ID < ( length( a.acts_id ) - length( REPLACE ( a.acts_id, ' ', '' ) ) + 1 )\n) X where  x.activitydefid <>'act_start' and x.activitydefid <>'act_finish' \norder by cast(substr(x.activitydefid,5)  as   SIGNED   INTEGER)";
        List flowActList = this.sqlHelper.queryByNativeSQL(sql, new Object[]{processdefid}, new int[0]);
        Iterator iterator = flowActList.iterator();
        while (iterator.hasNext()) {
            HashMap<String, String> map = new HashMap<String, String>();
            Map next = (Map)iterator.next();
            map.put("text", next.get("ACTNAME").toString() + "(" + next.get("ACTIVITYDEFID").toString() + ")");
            map.put("value", (String)next.get("ACTIVITYDEFID"));
            list.add(map);
        }
        return list;
    }

    public Map<String, Object> loadFlowInfo(Long processinstid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Long processdefid = this.bSqlHelper.getLongValue("base.BasFlowActPrint.findProcessdefid", MapUtil.of((Object)"processinstid", (Object)processinstid));
        BasFlowActPrint main = this.basFlowActPrintDao.findByProcessdefidAndIsUse(processdefid, "Y");
        if (main != null) {
            map.put("title", StringUtil.null2String(main.getPrintTitle()));
            List<Map<String, Object>> list = this.basFlowActPrintDetailService.findByForeignId(main.getPrintId());
            for (Map<String, Object> detail : list) {
                Map<String, Object> advice = this.findAdviceByActs(StringUtil.null2String(detail.get("actId")), processinstid);
                if (advice == null) continue;
                advice.put("adviceTimeFormat", this.formatDateObj(advice.get("adviceTime")));
                advice.put("adviceTime", this.formatTimeObj(advice.get("adviceTime")));
                if (!StringUtil.isEmpty(detail.get("itemName"))) {
                    advice.put("itemName", detail.get("itemName"));
                }
                if ("N".equals(main.getIsShowEmptyAdvice())) {
                    String adviceStr = StringUtil.null2String(advice.get("advice"));
                    if (StringUtil.isEmpty(adviceStr)) continue;
                    map.put(StringUtil.null2String(detail.get("actCode")), advice);
                    continue;
                }
                map.put(StringUtil.null2String(detail.get("actCode")), advice);
            }
        }
        LinkedHashMap collect = map.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        return collect;
    }

    public String formatDateObj(Object ojb) {
        return ojb != null ? String.valueOf(ojb).substring(0, 7) : "";
    }

    public String formatTimeObj(Object ojb) {
        return ojb != null ? String.valueOf(ojb).substring(0, 16) : "";
    }

    public Map<String, Object> findAdviceByActs(String acts, Long processinstid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtil.isEmpty(acts) || processinstid == null) {
            return new HashMap<String, Object>();
        }
        params.put("processinstid", processinstid);
        params.put("acts", acts);
        Map<String, Object> map = this.bSqlHelper.getMap("base.BasFlowActPrint.getFlowAdvice", params);
        if (map != null && !map.isEmpty()) {
            return map;
        }
        return new HashMap<String, Object>();
    }
}

