/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasEmpLoginStatisticsDao;
import com.guochuang.imp.base.entity.BasEmpLoginStatistics;
import com.guochuang.imp.base.entity.BasOrg;
import com.guochuang.imp.base.entity.OrgProportion;
import com.guochuang.imp.base.entity.Top10;
import com.guochuang.imp.base.service.BasOrgService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasEmpLoginStatisticsService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasEmpLoginStatisticsDao basEmpLoginStatisticsDao;
    @Autowired
    private BasOrgService orgService;

    public PageObject pageAll(int page, int rows, String startDate, String endDate, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((CharSequence)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((CharSequence)endDate)) {
            params.put("endDate", endDate);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasEmpLoginStatistics.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasEmpLoginStatistics(BasEmpLoginStatistics entity) {
        this.basEmpLoginStatisticsDao.save(entity);
    }

    public PageObject findBasEmpLoginStatistics(int page, int rows, Long id, String keyword, String deptId) {
        BasEmpLoginStatistics entity = (BasEmpLoginStatistics)this.basEmpLoginStatisticsDao.findById(id).get();
        String loginInfo = entity.getLoginInfo();
        List originalList = JSONUtil.parseArray((String)loginInfo).toList(Map.class);
        List filterList = originalList.stream().filter(map -> {
            String empbame;
            if (StrUtil.isBlank((CharSequence)keyword)) {
                return true;
            }
            String string = empbame = ObjectUtil.isNull(map.get("empbame")) ? "" : map.get("empbame").toString();
            return StrUtil.equals((CharSequence)keyword, (CharSequence)empbame);
        }).filter(map -> {
            String deptid;
            if (StrUtil.isBlank((CharSequence)deptId)) {
                return true;
            }
            String string = deptid = ObjectUtil.isNull(map.get("deptid")) ? "" : map.get("deptid").toString();
            return StrUtil.equals((CharSequence)deptId, (CharSequence)deptid);
        }).collect(Collectors.toList());
        int totalCount = filterList.size();
        int fromIndex = (page - 1) * rows;
        int toIndex = page * rows;
        if (fromIndex > totalCount) {
            return new PageObject(ListUtil.empty(), 0L);
        }
        if (toIndex > totalCount) {
            toIndex = totalCount;
        }
        List subList = filterList.subList(fromIndex, toIndex);
        return new PageObject(subList, Long.valueOf(totalCount));
    }

    public void delBasEmpLoginStatistics(Long id) {
        BasEmpLoginStatistics entity = (BasEmpLoginStatistics)this.basEmpLoginStatisticsDao.findById(id).get();
        entity.setIsUse("N");
        this.basEmpLoginStatisticsDao.save(entity);
    }

    public void runTask() {
        LocalDate currentDay = LocalDate.now();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("startDate", currentDay);
        params.put("endDate", currentDay.plusDays(1L));
        Integer loginNum = this.bSqlHelper.getIntValue("base.BasEmpLoginStatistics.getLoginNum", params);
        Integer totalEmpNum = this.bSqlHelper.getIntValue("base.BasEmpLoginStatistics.getTotalEmpNum", null);
        Integer notLoginNum = totalEmpNum - loginNum;
        List<Map> list = this.bSqlHelper.getList("base.BasEmpLoginStatistics.getLoginInfo", params, Map.class);
        BasEmpLoginStatistics entity = new BasEmpLoginStatistics();
        entity.setStatisticsDay(Date.from(currentDay.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()));
        entity.setLoginNum(loginNum);
        entity.setNotLoginNum(notLoginNum);
        entity.setLoginInfo(JSONUtil.toJsonStr(list));
        entity.setIsUse("Y");
        this.saveBasEmpLoginStatistics(entity);
    }

    public Map<String, Object> getMonthlyStatistics() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map<String, Object> params = BasEmpLoginStatisticsService.getParams();
        map.put("month", DateUtil.date().month());
        Integer totalEmpNum = this.bSqlHelper.getIntValue("base.BasEmpLoginStatistics.getTotalEmpNum", null);
        map.put("totalEmpNum", totalEmpNum);
        Integer loginNum = this.bSqlHelper.getIntValue("base.BasEmpLoginStatistics.getLoginNum", params);
        map.put("loginNum", loginNum);
        String proportion = totalEmpNum > 0 ? NumberUtil.decimalFormat((String)"#.##%", (Object)NumberUtil.div((Number)loginNum, (Number)totalEmpNum)) : "0%";
        map.put("proportion", proportion);
        return map;
    }

    public List<Top10> getTop10() {
        Map<String, Object> params = BasEmpLoginStatisticsService.getParams();
        return this.bSqlHelper.getList("base.BasEmpLoginStatistics.getTopTen", params, Top10.class);
    }

    public Object getOrgProportion() {
        ArrayList list = new ArrayList();
        Map<String, Object> params = BasEmpLoginStatisticsService.getParams();
        List<BasOrg> orgs = this.orgService.allOrg();
        orgs.forEach(basOrg -> {
            OrgProportion item = new OrgProportion();
            params.put("orgId", basOrg.getOrgId());
            Integer totalOrgEmpNum = this.bSqlHelper.getIntValue("base.BasEmpLoginStatistics.getOrgTotalEmpNum", params);
            Integer orgLoginNum = this.bSqlHelper.getIntValue("base.BasEmpLoginStatistics.getOrgLoginNum", params);
            BigDecimal orgProportionSort = totalOrgEmpNum > 0 ? NumberUtil.div((Number)orgLoginNum, (Number)totalOrgEmpNum) : new BigDecimal(0);
            String orgProportion = NumberUtil.decimalFormat((String)"#.##%", (Object)orgProportionSort);
            item.setOrgName(basOrg.getOrgName());
            item.setOrgProportion(orgProportion);
            item.setOrgProportionSort(orgProportionSort);
            list.add(item);
        });
        return list.stream().sorted(Comparator.comparing(OrgProportion::getOrgProportionSort, Comparator.reverseOrder())).collect(Collectors.toList());
    }

    private static Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        DateTime startDate = DateUtil.beginOfMonth((Date)DateUtil.date());
        DateTime endDate = DateUtil.endOfMonth((Date)DateUtil.date());
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        return params;
    }
}

