/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import cn.hutool.core.util.StrUtil;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.dao.BasEarlyWarningSettingDao;
import com.guochuang.imp.base.entity.BasEarlyWarningLevel;
import com.guochuang.imp.base.entity.BasEarlyWarningSetting;
import com.guochuang.imp.base.entity.BasEarlyWarningSettingFilter;
import com.guochuang.imp.base.entity.BasEarlyWarningSettingMsg;
import com.guochuang.imp.base.entity.BasEarlyWarningUse;
import com.guochuang.imp.base.entity.BasModelManage;
import com.guochuang.imp.base.extend.BasExecuteSqlColumnModel;
import com.guochuang.imp.base.extend.BasExecuteSqlModel;
import com.guochuang.imp.base.service.BasEarlyWarningLevelService;
import com.guochuang.imp.base.service.BasEarlyWarningSettingFilterService;
import com.guochuang.imp.base.service.BasEarlyWarningSettingMsgService;
import com.guochuang.imp.base.service.BasEarlyWarningUseService;
import com.guochuang.imp.base.service.BasModelManageService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.gen.util.FreeMarkerUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasEarlyWarningSettingService {
    private Logger logger = LoggerFactory.getLogger(BasEarlyWarningSettingService.class);
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasEarlyWarningSettingDao basEarlyWarningSettingDao;
    @Autowired
    private BasEarlyWarningUseService basEarlyWarningUseService;
    @Autowired
    private BasEarlyWarningSettingFilterService basEarlyWarningSettingFilterService;
    @Autowired
    private BasEarlyWarningSettingMsgService basEarlyWarningSettingMsgService;
    @Autowired
    private BasModelManageService basModelManageService;
    @Autowired
    private BasEarlyWarningLevelService basEarlyWarningLevelService;

    public PageObject<Map<String, Object>> pageAll(String search, Long warningType, int page, int rows, String sort, String order) {
        PageObject<Map<String, Object>> obj;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (search != null && !"".equals(search)) {
            params.put("search", "%" + search + "%");
        }
        if (warningType != null) {
            params.put("warningType", warningType);
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        if ((obj = this.bSqlHelper.serachPage("base.BasEarlyWarningSetting.pageAll", params, PageRequest.of((int)page, (int)rows))) != null && obj.getRows() != null) {
            obj.getRows().stream().forEach(row -> {
                if (row.get("isEnable") != null) {
                    row.put("isEnableText", MemCache.getDicText("IS_ENABLE", row.get("isEnable").toString()));
                }
            });
        }
        return obj;
    }

    @Transactional
    public void saveBasEarlyWarningSetting(BasEarlyWarningSetting entity, List<BasEarlyWarningUse> list) {
        Object model;
        if (entity.getWarningType() != null && (model = this.basModelManageService.findBasModelManage(entity.getWarningType())) != null) {
            entity.setBusinessCode(((BasModelManage)model).getModelCode());
        }
        this.basEarlyWarningSettingDao.save(entity);
        if (list != null && !list.isEmpty()) {
            for (BasEarlyWarningUse basEarlyWarningUse : list) {
                if (basEarlyWarningUse.getWarningReceiveId() == null) {
                    basEarlyWarningUse.setCreateAccount(SysUtils.getLoginAccountId());
                    basEarlyWarningUse.setCreateTime(new Date());
                } else {
                    BasEarlyWarningUse model2 = this.basEarlyWarningUseService.findBasEarlyWarningUse(basEarlyWarningUse.getWarningReceiveId());
                    basEarlyWarningUse.setCreateAccount(model2.getCreateAccount());
                    basEarlyWarningUse.setCreateTime(model2.getCreateTime());
                }
                basEarlyWarningUse.setIsUse("Y");
                basEarlyWarningUse.setModifyAccount(SysUtils.getLoginAccountId());
                basEarlyWarningUse.setModifyTime(new Date());
                basEarlyWarningUse.setWarningSettingId(entity.getWarningSettingId());
                this.basEarlyWarningUseService.saveBasEarlyWarningUse(basEarlyWarningUse);
            }
        }
        if (entity.getDataList() != null && !entity.getDataList().isEmpty()) {
            int j = 1;
            for (BasEarlyWarningSettingFilter detail : entity.getDataList()) {
                if (detail.getSettingFilterId() == null) {
                    detail.setCreateAccount(SysUtils.getLoginAccountId());
                    detail.setCreateTime(new Date());
                }
                detail.setWarningSettingId(entity.getWarningSettingId());
                detail.setModifyAccount(SysUtils.getLoginAccountId());
                detail.setModifyTime(new Date());
                detail.setOrderNum(j++);
                this.basEarlyWarningSettingFilterService.saveBasEarlyWarningSettingFilter(detail);
            }
        }
        if (entity.getMsgData() != null && !entity.getMsgData().isEmpty()) {
            for (BasEarlyWarningSettingMsg basEarlyWarningSettingMsg : entity.getMsgData()) {
                if (basEarlyWarningSettingMsg.getSettingMsgId() == null) {
                    basEarlyWarningSettingMsg.setCreateAccount(SysUtils.getLoginAccountId());
                    basEarlyWarningSettingMsg.setCreateTime(new Date());
                }
                basEarlyWarningSettingMsg.setWarningSettingId(entity.getWarningSettingId());
                basEarlyWarningSettingMsg.setModifyAccount(SysUtils.getLoginAccountId());
                basEarlyWarningSettingMsg.setModifyTime(new Date());
                this.basEarlyWarningSettingMsgService.saveBasEarlyWarningSettingMsg(basEarlyWarningSettingMsg);
            }
        }
    }

    public BasEarlyWarningSetting findBasEarlyWarningSetting(Long id) {
        BasEarlyWarningSetting entity = (BasEarlyWarningSetting)this.basEarlyWarningSettingDao.findById(id).get();
        return entity;
    }

    @Transactional
    public void delBasEarlyWarningSetting(Long id) {
        BasEarlyWarningSetting entity = (BasEarlyWarningSetting)this.basEarlyWarningSettingDao.findById(id).get();
        entity.setIsUse("N");
        this.basEarlyWarningSettingDao.save(entity);
        this.basEarlyWarningUseService.delBasEarlyWarningUseByMainId(id);
        this.basEarlyWarningSettingFilterService.delBasEarlyWarningSettingFilterBySettingId(id);
        this.basEarlyWarningSettingMsgService.delBasEarlyWarningSettingMsgBySettingId(id);
    }

    public Map<String, List<Map<String, Object>>> findEarlyWarningListSum(Long workspaceId, Long themeId, String themeCode, String search, LoginUser loginUser) {
        List<Map<String, Object>> list = this.findEarlyWarningList(workspaceId, themeId, themeCode, search, loginUser);
        Map groups = list.stream().collect(Collectors.groupingBy(map -> Objects.toString(map.get("workspaceName")), LinkedHashMap::new, Collectors.toList()));
        return groups;
    }

    public List<Map<String, Object>> findEarlyWarningList(Long workspaceId, Long themeId, String themeCode, LoginUser loginUser) {
        return this.findEarlyWarningList(workspaceId, themeId, themeCode, null, loginUser);
    }

    public List<Map<String, Object>> findEarlyWarningList(Long workspaceId, Long themeId, String themeCode, String search, LoginUser loginUser) {
        long startTime = System.currentTimeMillis();
        List<Map<String, Object>> themeList = this.getEmpThemeList(workspaceId, themeId, themeCode, loginUser.getEmpid());
        if (themeList != null && !themeList.isEmpty()) {
            StringBuffer warningSettingIds = new StringBuffer("");
            StringBuffer themeIds = new StringBuffer("");
            themeList.stream().forEach(themeInfo -> {
                warningSettingIds.append("," + themeInfo.get("warningSettingId").toString());
                themeIds.append("," + themeInfo.get("themeId").toString());
            });
            warningSettingIds.append(",");
            themeIds.append(",");
            Map<String, String> filterSqls = this.getWarningSettingFilterInfo(warningSettingIds.toString());
            Map<String, String> msgFormats = this.getWarningSettingMsgFormatInfo(warningSettingIds.toString());
            List<BasExecuteSqlModel> basExecuteSqlModels = this.basModelManageService.findThemeSqlInfoList(themeIds.toString());
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (Map<String, Object> themeInfo2 : themeList) {
                List<Map<String, Object>> tmpList;
                String themeIdStr = themeInfo2.get("themeId").toString();
                String warningSettingIdStr = themeInfo2.get("warningSettingId").toString();
                BasExecuteSqlModel basSql = basExecuteSqlModels.stream().filter(tt -> themeIdStr.equals(tt.getThemeId().toString())).findAny().orElse(null);
                if (basSql == null) continue;
                StringBuffer finalSql = new StringBuffer(basSql.getFinalSql());
                if (filterSqls.get(warningSettingIdStr) != null) {
                    finalSql.append(" AND ");
                    finalSql.append(filterSqls.get(warningSettingIdStr));
                }
                if ((tmpList = this.bSqlHelper.serachBySql(finalSql.toString(), themeInfo2)) == null || tmpList.isEmpty()) continue;
                String orgIds = StringUtil.null2String(themeInfo2.get("orgIds"));
                String deptIds = StringUtil.null2String(themeInfo2.get("deptIds"));
                String empIds = StringUtil.null2String(themeInfo2.get("empIds"));
                String orgDataKey = "";
                String deptDataKey = "";
                String empDataKey = "";
                List<BasExecuteSqlColumnModel> columnModels = basSql.getColumnList();
                if (columnModels != null) {
                    for (BasExecuteSqlColumnModel colInfo : columnModels) {
                        if ("02".equals(colInfo.getColumnCat())) {
                            orgDataKey = colInfo.getColumnFieldName();
                            continue;
                        }
                        if ("03".equals(colInfo.getColumnCat())) {
                            deptDataKey = colInfo.getColumnFieldName();
                            continue;
                        }
                        if (!"04".equals(colInfo.getColumnCat())) continue;
                        empDataKey = colInfo.getColumnFieldName();
                    }
                }
                List<Map<String, Object>> list = this.getFilterDataList(tmpList, orgIds, deptIds, empIds, orgDataKey, deptDataKey, empDataKey);
                list.forEach(map -> {
                    HashMap nmap = new HashMap();
                    map.entrySet().forEach(key -> {
                        nmap.put(key.getKey(), key.getValue());
                        nmap.put(((String)key.getKey()).toUpperCase(), key.getValue());
                    });
                    if (msgFormats.get(warningSettingIdStr) != null) {
                        map.put("msg", FreeMarkerUtil.instance().genString((String)msgFormats.get(warningSettingIdStr), nmap));
                    } else {
                        map.put("msg", "");
                    }
                    map.put("warningSettingId", themeInfo2.get("warningSettingId"));
                    map.put("workspaceId", themeInfo2.get("workspaceId"));
                    map.put("workspaceName", themeInfo2.get("workspaceName"));
                    map.put("themeId", themeInfo2.get("themeId"));
                    map.put("themeName", themeInfo2.get("themeName"));
                    map.put("menuId", themeInfo2.get("menuId"));
                    map.put("isDealInForm", themeInfo2.get("isDealInForm"));
                    map.put("formCode", themeInfo2.get("formCode"));
                    map.put("levelText", themeInfo2.get("levelText"));
                    map.put("levelColor", themeInfo2.get("levelColor"));
                    map.put("settingName", themeInfo2.get("settingName"));
                    map.put("warningUrl", themeInfo2.get("warningUrl"));
                    map.put("dealScript", themeInfo2.get("dealScript"));
                    map.put("orderNum", themeInfo2.get("orderNum"));
                });
                if (StringUtils.isNotBlank((CharSequence)search)) {
                    list = list.stream().filter(map -> Objects.toString(map.get("msg")).contains(search)).collect(Collectors.toList());
                }
                result.addAll(list);
            }
            long endTime = System.currentTimeMillis();
            this.logger.info("\u83b7\u53d6\u9884\u8b66\u6d88\u606f\u6570\u636e\u8017\u65f6\uff1a" + (endTime - startTime) / 1000L + "\u79d2");
            return result;
        }
        return Collections.emptyList();
    }

    private List<Map<String, Object>> getEmpThemeList(Long workspaceId, Long themeId, String themeCode, Long empId) {
        List<Map<String, Object>> theme2;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("empId", empId);
        if (workspaceId != null) {
            params.put("workspaceId", workspaceId);
        }
        if (themeId != null) {
            params.put("themeId", themeId);
        }
        if (StringUtils.isNotBlank((CharSequence)themeCode)) {
            params.put("themeCode", themeCode);
        }
        ArrayList themeList = new ArrayList();
        List<Map<String, Object>> theme1 = this.bSqlHelper.getMapList("base.BasEarlyWarningSetting.findEarlyWarningThemeList", params);
        if (theme1 != null && !theme1.isEmpty()) {
            for (int i = 0; i < theme1.size(); ++i) {
                BasEarlyWarningLevel level;
                String themeIdStr = theme1.get(i).get("themeId").toString();
                HashMap<String, Object> themeInfo = themeList.stream().filter(theme -> theme.get("themeId").toString().equals(themeIdStr)).findAny().orElse(null);
                if (themeInfo != null) continue;
                themeInfo = new HashMap<String, Object>();
                themeInfo.put("warningSettingId", theme1.get(i).get("warningSettingId").toString());
                themeInfo.put("workspaceId", theme1.get(i).get("workspaceId").toString());
                themeInfo.put("dealScript", theme1.get(i).get("dealScript"));
                themeInfo.put("orderNum", theme1.get(i).get("orderNum"));
                themeInfo.put("themeId", theme1.get(i).get("themeId").toString());
                themeInfo.put("workspaceName", StringUtil.null2String(theme1.get(i).get("workspaceName")));
                themeInfo.put("themeName", StringUtil.null2String(theme1.get(i).get("themeName")));
                themeInfo.put("msgFormatValue", StringUtil.null2String(theme1.get(i).get("msgFormatValue")));
                themeInfo.put("menuId", StringUtil.null2String(theme1.get(i).get("menuId")));
                themeInfo.put("isDealInForm", StringUtil.null2String(theme1.get(i).get("isDealInForm")));
                themeInfo.put("formCode", StringUtil.null2String(theme1.get(i).get("formCode")));
                themeInfo.put("orgIds", "");
                themeInfo.put("deptIds", "");
                themeInfo.put("empIds", "");
                BasEarlyWarningSetting set = this.findBasEarlyWarningSetting(Long.parseLong(StringUtil.null2String(theme1.get(i).get("warningSettingId"))));
                if (set != null && StringUtils.isNotBlank((CharSequence)set.getWarningLevel()) && (level = this.basEarlyWarningLevelService.findBasEarlyWarningLevel(Long.parseLong(StringUtil.null2String(set.getWarningLevel())))) != null) {
                    themeInfo.put("levelText", level.getLevelText());
                    themeInfo.put("levelColor", level.getLevelColor());
                }
                themeInfo.put("settingName", set.getSettingName());
                themeInfo.put("warningUrl", set.getWarningUrl());
                themeList.add(themeInfo);
            }
        }
        if ((theme2 = this.bSqlHelper.getMapList("base.BasEarlyWarningSetting.findEarlyWarningThemeListForData", params)) != null && !theme2.isEmpty()) {
            for (int i = 0; i < theme2.size(); ++i) {
                BasEarlyWarningLevel level;
                String themeIdStr = theme2.get(i).get("themeId").toString();
                HashMap<String, Object> themeInfo = themeList.stream().filter(theme -> theme.get("themeId").toString().equals(themeIdStr)).findAny().orElse(null);
                if (themeInfo != null) continue;
                themeInfo = new HashMap<String, Object>();
                themeInfo.put("warningSettingId", theme2.get(i).get("warningSettingId").toString());
                themeInfo.put("workspaceId", theme2.get(i).get("workspaceId").toString());
                themeInfo.put("dealScript", theme2.get(i).get("dealScript"));
                themeInfo.put("orderNum", theme2.get(i).get("orderNum"));
                themeInfo.put("themeId", theme2.get(i).get("themeId").toString());
                themeInfo.put("workspaceName", StringUtil.null2String(theme2.get(i).get("workspaceName")));
                themeInfo.put("themeName", StringUtil.null2String(theme2.get(i).get("themeName")));
                themeInfo.put("menuId", StringUtil.null2String(theme2.get(i).get("menuId")));
                themeInfo.put("isDealInForm", StringUtil.null2String(theme2.get(i).get("isDealInForm")));
                themeInfo.put("formCode", StringUtil.null2String(theme2.get(i).get("formCode")));
                themeInfo.put("msgFormatValue", StringUtil.null2String(theme2.get(i).get("msgFormatValue")));
                themeInfo.put("orgIds", StringUtil.null2String(theme2.get(i).get("orgIds")));
                themeInfo.put("deptIds", StringUtil.null2String(theme2.get(i).get("deptIds")));
                themeInfo.put("empIds", StringUtil.null2String(theme2.get(i).get("empIds")));
                BasEarlyWarningSetting set = this.findBasEarlyWarningSetting(Long.parseLong(StringUtil.null2String(theme2.get(i).get("warningSettingId"))));
                if (set != null && StringUtils.isNotBlank((CharSequence)set.getWarningLevel()) && (level = this.basEarlyWarningLevelService.findBasEarlyWarningLevel(Long.parseLong(StringUtil.null2String(set.getWarningLevel())))) != null) {
                    themeInfo.put("levelText", level.getLevelText());
                    themeInfo.put("levelColor", level.getLevelColor());
                }
                themeInfo.put("settingName", set.getSettingName());
                themeInfo.put("warningUrl", set.getWarningUrl());
                themeList.add(themeInfo);
            }
        }
        return themeList.stream().sorted(Comparator.comparingLong(e -> Long.parseLong(Objects.toString(e.get("orderNum"), "999999999")))).collect(Collectors.toList());
    }

    private Map<String, String> getWarningSettingFilterInfo(String warningSettingIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("warningSettingIds", warningSettingIds);
        List<Map<String, Object>> filterList = this.bSqlHelper.getMapList("base.BasEarlyWarningSettingFilter.getFilterData", params);
        HashMap<String, String> result = new HashMap<String, String>();
        if (filterList != null && !filterList.isEmpty()) {
            for (Map<String, Object> entity : filterList) {
                String warningSettingId = entity.get("warningSettingId").toString();
                if (result.containsKey(warningSettingId)) {
                    String tmp = (String)result.get(warningSettingId) + " " + entity.get("exp").toString();
                    result.put(warningSettingId, tmp);
                    continue;
                }
                result.put(warningSettingId, entity.get("exp").toString());
            }
        }
        return result;
    }

    private Map<String, String> getWarningSettingMsgFormatInfo(String warningSettingIds) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("warningSettingIds", warningSettingIds);
        List<Map<String, Object>> msgList = this.bSqlHelper.getMapList("base.BasEarlyWarningSettingMsg.findEarlyWarningSettingMsgList", params);
        HashMap<String, String> result = new HashMap<String, String>();
        if (msgList != null && !msgList.isEmpty()) {
            for (Map<String, Object> entity : msgList) {
                String tmp;
                String warningSettingId = entity.get("warningSettingId").toString();
                if (result.containsKey(warningSettingId)) {
                    tmp = (String)result.get(warningSettingId);
                    tmp = "2".equals(entity.get("opType").toString()) ? tmp + "${" + StrUtil.toCamelCase((CharSequence)entity.get("opValue").toString()) + "!}" : tmp + entity.get("opValue").toString();
                    result.put(warningSettingId, tmp);
                    continue;
                }
                tmp = "";
                tmp = "2".equals(entity.get("opType").toString()) ? "${" + StrUtil.toCamelCase((CharSequence)entity.get("opValue").toString()) + "!}" : entity.get("opValue").toString();
                result.put(warningSettingId, tmp);
            }
        }
        return result;
    }

    private List<Map<String, Object>> getFilterDataList(List<Map<String, Object>> dataList, String orgIds, String deptIds, String empIds, String orgDataKey, String deptDataKey, String empDataKey) {
        if (orgIds != null && !"".equals(orgIds) || deptIds != null && !"".equals(deptIds) || empIds != null && !"".equals(empIds)) {
            List<Map<String, Object>> ttList = dataList.stream().filter(tmp -> orgIds != null && orgDataKey != null && !"".equals(orgIds) && !"".equals(orgDataKey) && tmp.get(orgDataKey) != null && ("," + orgIds + ",").lastIndexOf("," + tmp.get(orgDataKey).toString() + ",") >= 0 || deptIds != null && deptDataKey != null && !"".equals(deptIds) && !"".equals(deptDataKey) && tmp.get(deptDataKey) != null && ("," + deptIds + ",").lastIndexOf("," + tmp.get(deptDataKey).toString() + ",") >= 0 || empIds != null && empDataKey != null && !"".equals(empIds) && !"".equals(empDataKey) && tmp.get(empDataKey) != null && ("," + empIds + ",").lastIndexOf("," + tmp.get(empDataKey).toString() + ",") >= 0).collect(Collectors.toList());
            return ttList;
        }
        return dataList;
    }

    public List<Map<String, Object>> getWarnList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> slist = this.bSqlHelper.getMapList("base.BasEarlyWarningSetting.getAllSettings", params);
        for (Map<String, Object> setting : slist) {
            StringBuffer select = new StringBuffer(" select ");
            StringBuffer from = new StringBuffer(" from  ");
            StringBuffer where = new StringBuffer(" where  1=1  ");
            params.put("id", setting.get("earlyWarningSettingId"));
            List<Map<String, Object>> filterlist1 = this.bSqlHelper.getMapList("base.BasEarlyWarningSetting.getFilterData", params);
            List<Map<String, Object>> filterlist2 = this.bSqlHelper.getMapList("base.BasEarlyWarningSetting.getFilterData2", params);
            String filterSql1 = filterlist1.stream().map(map -> map.get("exp").toString()).collect(Collectors.joining(" "));
            String filterSql2 = filterlist2.stream().map(map -> map.get("exp").toString()).collect(Collectors.joining(" "));
            if (StringUtils.isNotBlank((CharSequence)filterSql1)) {
                where.append(" and " + filterSql1);
            }
            if (StringUtils.isNotBlank((CharSequence)filterSql2)) {
                where.append(" and " + filterSql2);
            }
            params.put("id", setting.get("businessType"));
            List<Map<String, Object>> models = this.bSqlHelper.getMapList("base.BasEarlyWarningSetting.getModelBySetting", params);
            for (int i = 0; i < models.size(); ++i) {
                Map<String, Object> map2 = models.get(i);
                from.append(map2.get("modelCode").toString());
                if (i != models.size() - 1) {
                    from.append(",");
                }
                params.put("id", map2.get("modelId"));
                List<Map<String, Object>> list2 = this.bSqlHelper.getMapList("base.BasEarlyWarningSetting.getModelByPid", params);
                list2.forEach(field -> select.append(Objects.toString(field.get("express"), "") + " " + field.get("modelCode").toString() + ","));
            }
            select.append(" '' endtag");
            params.put("id", setting.get("businessType"));
            List<Map<String, Object>> references = this.bSqlHelper.getMapList("base.BasEarlyWarningSetting.selectReference", params);
            for (Map map2 : references) {
                where.append(" and " + map2.get("rTable1") + "." + map2.get("rColumn1") + " = " + map2.get("rTable2") + "." + map2.get("rColumn2") + " ");
            }
            String sql = select.append(from).append(where).toString();
            List<Map<String, Object>> list3 = this.bSqlHelper.serachBySql(sql, params);
            list3.forEach(map -> {
                HashMap nmap = new HashMap();
                map.entrySet().forEach(key -> {
                    nmap.put(key.getKey(), key.getValue());
                    nmap.put(StrUtil.toUnderlineCase((CharSequence)((CharSequence)key.getKey())), key.getValue());
                    nmap.put(StrUtil.toUnderlineCase((CharSequence)((CharSequence)key.getKey())).toUpperCase(), key.getValue());
                });
                map.put("msg", FreeMarkerUtil.instance().genString(setting.get("msgContent").toString(), nmap));
                map.put("settingName", setting.get("settingName"));
            });
            list.addAll(list3);
        }
        return list;
    }
}

