/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasDemandApplyDao;
import com.guochuang.imp.base.entity.BasDemandApply;
import com.guochuang.imp.base.service.BasMessageService;
import com.guochuang.imp.doc.entity.FormFileBean;
import com.guochuang.imp.doc.service.DocFormFileService;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.pub.service.PubFlowRelateService;
import com.guochuang.imp.util.StringUtil;
import com.guochuang.imp.workflow.service.FlowUtilService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasDemandApplyService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasDemandApplyDao basDemandApplyDao;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private PubFlowRelateService pubFlowRelateService;

    public PageObject pageAll(String search, Long flowDone, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (flowDone != null) {
            params.put("flowsql", " and t.processinstid in (" + this.flowUtilService.queryDealedProcess("BasDemandApply", flowDone) + ") \n");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasDemandApply.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    public void saveBasDemandApply(BasDemandApply entity, FormFileBean formfile) {
        this.basDemandApplyDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
        this.pubFlowRelateService.savePubFlowRelateList(entity.getPfrList(), entity.getId(), "BasDemandApply");
    }

    @Transactional
    public void saveBasDemandApply(BasDemandApply entity) {
        this.basDemandApplyDao.save(entity);
    }

    public BasDemandApply findBasDemandApply(Long id) {
        BasDemandApply entity = (BasDemandApply)this.basDemandApplyDao.findById(id).get();
        return entity;
    }

    public void delBasDemandApply(Long id) {
        BasDemandApply entity = (BasDemandApply)this.basDemandApplyDao.findById(id).get();
        entity.setIsUse("N");
        this.basDemandApplyDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public List<Map<String, Object>> findAllAdvice(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        return this.bSqlHelper.getMapList("base.BasDemandApply.findAllAdvice", params);
    }
}

