/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasBankMaintainDao;
import com.guochuang.imp.base.entity.BasBankMaintain;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import com.guochuang.imp.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class BasBankMaintainService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasBankMaintainDao basBankMaintainDao;

    public PageObject pageAll(String fuzzy, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtil.isEmpty(fuzzy)) {
            params.put("fuzzy", "%" + fuzzy + "%");
        }
        if (!StringUtil.isEmpty(sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtil.isEmpty(order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.serachPage("base.BasBankMaintain.pageAll", params, PageRequest.of((int)page, (int)rows));
        return pageObject;
    }

    @Transactional
    public void saveBasBankMaintain(BasBankMaintain entity) {
        this.basBankMaintainDao.save(entity);
    }

    public BasBankMaintain findBasBankMaintain(Long id) {
        BasBankMaintain entity = (BasBankMaintain)this.basBankMaintainDao.findById(id).get();
        return entity;
    }

    public void delBasBankMaintain(Long id) {
        BasBankMaintain entity = (BasBankMaintain)this.basBankMaintainDao.findById(id).get();
        entity.setIsUse("N");
        this.basBankMaintainDao.save(entity);
    }

    public boolean exsit(String bankType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bankType", bankType);
        int count = this.bSqlHelper.getIntValue("base.BasBankMaintain.countBankType", params);
        return count != 0;
    }

    public BasBankMaintain findByBankType(String bankType) {
        return this.basBankMaintainDao.findByBankTypeAndIsUse(bankType, "Y");
    }

    public List<Map<String, Object>> list() {
        return this.bSqlHelper.getMapList("base.BasBankMaintain.list", null);
    }
}

