/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.service;

import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.CommTreeUtils;
import com.guochuang.imp.base.common.util.NativeSqlHelper;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.dao.BasAppMenuDao;
import com.guochuang.imp.base.entity.BasAppMenu;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasAppMenuService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BasAppMenuDao basappmenuDao;

    public BasAppMenu findBasAppMenu(Long id) {
        BasAppMenu entity = (BasAppMenu)this.basappmenuDao.findById(id).get();
        return entity;
    }

    public void saveBasAppMenu(BasAppMenu entity) {
        this.basappmenuDao.save(entity);
    }

    public void delBasAppMenu(Long id) {
        this.basappmenuDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        String sql = "select * from BAS_APP_MENU t  order by t.MENU_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from BAS_APP_MENU t where   upper(t.MENU_ID) like ?1  or upper(t.PMENU_ID) like ?1  or upper(t.MENU_NAME) like ?1  or upper(t.MENU_ADDR) like ?1  or upper(t.MENU_ICO) like ?1  or upper(t.PERMISSION_CONTROL) like ?1  or upper(t.MENU_TYPE) like ?1  or upper(t.ENABLE) like ?1  or upper(t.DISPLAY_NO) like ?1  or upper(t.CREATE_BY) like ?1  or upper(t.CREATE_TIME) like ?1  or upper(t.MODIFY_ACCOUNT) like ?1  or upper(t.MODIFY_TIME) like ?1  or upper(t.REMARKS) like ?1  or upper(t.IS_USE) like ?1  order by t.MENU_ID";
            return this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        }
        return this.sqlHelper.pagerNativeSQL(sql, page, rows);
    }

    public void delBasAppMenuAndChild(Long id) {
        StringBuilder sql = new StringBuilder();
        sql.append("\tUPDATE \tBAS_APP_MENU T \n\tSET\t\tT.IS_USE='N' \n\tWHERE \tT.MENU_ID in ( with recursive menu as(\n\t\t\t\t select a.* from BAS_APP_MENU a where  a.menu_id = ?1 and a.IS_USE = 'Y' \n\t\t\t\t union all\n\t\t\t\t select a.* from BAS_APP_MENU a,menu where menu.menu_id=a.pmenu_id and a.IS_USE = 'Y' )\n\t\t\t\t select menu.menu_id from menu) \n");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{id});
    }

    public List<ComBoxTreeNode> treeBasAppMenu(Long pid) {
        StringBuilder sql = new StringBuilder();
        sql.append("with recursive menu as\n\t (select m.* from BAS_APP_MENU m \n\t where   m.pmenu_id = ?1  and m.is_use='Y' \n\t union all\n\t select m.* from BAS_APP_MENU m,menu  where  m.pmenu_id=menu.menu_id and m.is_use='Y'\n\t )\n select \n\t\t\tt.MENU_ID id, \n\t\t\tT.PMENU_ID PID, \n\t\t\tt.MENU_NAME text, \n\t\t\tt.background_Color,\n\t\t\tt.menu_type, \n\t\t\tt.enable \n from menu t\n ORDER BY t.DISPLAY_NO");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new Object[]{pid}, new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }
}

