/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.spring.SystemControllerLog;
import com.guochuang.imp.base.common.support.SysConfigEnum;
import com.guochuang.imp.base.common.util.AesUtil;
import com.guochuang.imp.base.common.util.DateUtils;
import com.guochuang.imp.base.common.util.GenerateRandomKeyUtil;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.Md5Utils;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.StrKit;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasEmp;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.service.BasEmpAccountService;
import com.guochuang.imp.base.service.BasEmpDeviceService;
import com.guochuang.imp.base.service.BasEmpService;
import com.guochuang.imp.base.service.BasMessageService;
import com.guochuang.imp.base.service.BasOrgService;
import com.guochuang.imp.base.service.CommonService;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/login"})
public class LoginController
extends BaseController {
    private static Logger loger = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private BasEmpService basEmpService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private BasOrgService basOrgService;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasMessageService basmessageService;
    @Autowired
    private BasEmpDeviceService basEmpDeviceService;
    public static Map<String, Date> tokes = new HashMap<String, Date>();
    public static Map<String, Long> users = new HashMap<String, Long>();

    @RequestMapping(value={"/getLoginKey"})
    @ResponseBody
    @SystemControllerLog(description="\u7528\u6237\u767b\u5f55")
    public JsonMsg getLoginKey(HttpServletRequest request) {
        String key = Objects.toString(request.getSession().getAttribute("sessionSalt"), null);
        if (StringUtils.isBlank((CharSequence)key)) {
            key = GenerateRandomKeyUtil.getRandomKey(16);
            request.getSession().setAttribute("sessionSalt", (Object)key);
        }
        return new JsonMsg(true, "", key);
    }

    @RequestMapping(value={"/admintemp"})
    public String adminlogin(HttpSession session, HttpServletRequest request, String empCode, Model model, String tempKey) {
        JsonMsg msg = new JsonMsg();
        BasEmp emp = this.basEmpService.findByloginNameOrEmpCode(empCode);
        ArrayList<String> keys = new ArrayList<String>(6);
        for (int i = -2; i < 3; ++i) {
            keys.add(SysUtils.MD5("IMP" + (CommonService.getOnlineUserAccount().size() + i) + DateUtil.thisDayOfMonth() + DateUtil.thisDayOfWeek()).toLowerCase());
        }
        if (!keys.contains(tempKey.toLowerCase())) {
            return "/";
        }
        Long accountid = null;
        List<BasEmpAccount> accountlist = this.basEmpAccountService.findByEmpId(emp.getEmpId());
        request.getSession().setAttribute("adminlogin", (Object)"Y");
        if (accountlist != null && accountlist.size() > 0) {
            accountid = accountlist.get(0).getAccountId();
        }
        try {
            msg = this.login("N", session, request, accountid, emp.getLoginPassword(), null, null, true, null, null, null, null, null);
        }
        catch (Exception e) {
            msg.setSuccess(false);
            msg.setMsg("\u9519\u8bef\u7684\u51ed\u8bc1");
        }
        return "redirect:" + Objects.toString(msg.getO(), "");
    }

    private void login(HttpServletRequest request, Long accountid) {
        BasEmpAccount account = this.basEmpAccountService.findById(accountid);
        BasEmp emp = this.basEmpService.findEmpByempId(account.getEmpId());
        this.login("N", request.getSession(), request, accountid, emp.getLoginPassword(), null, null, true, null, null, null, null, null);
    }

    @RequestMapping(value={"/loginStart"})
    @ResponseBody
    @SystemControllerLog(description="\u7528\u6237\u767b\u5f55")
    public JsonMsg login(String isApp, HttpSession session, HttpServletRequest request, Long loginAccountid, String passWord, String caId, String dingId, boolean adminlogin, String loginParams, String IMEI, String bindDevice, String deviceMode, String casLogin) {
        String md5passWord;
        String userName = request.getParameter("userName");
        if (StringUtils.isNotBlank((CharSequence)userName) || StringUtils.isNotBlank((CharSequence)loginParams)) {
            JsonMsg jsonMsg = this.checklogin(session, request, userName, passWord, "N", loginParams);
            if (!jsonMsg.isSuccess()) {
                return jsonMsg;
            }
            String sessionSalt = request.getParameter("sessionSalt");
            if (StringUtils.isNotBlank((CharSequence)sessionSalt)) {
                if (StringUtils.isNotBlank((CharSequence)loginParams)) {
                    try {
                        loginParams = AesUtil.aesDecrypt(loginParams, sessionSalt);
                        JSONObject json = JSONObject.parseObject((String)loginParams);
                        userName = json.getString("userName");
                        passWord = json.getString("passWord");
                        if (json.containsKey((Object)"loginAccountid")) {
                            loginAccountid = json.getLong("loginAccountid");
                        }
                    }
                    catch (Exception e) {
                        loger.error("\u7528\u6237\u540d\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff0cuserName\uff1a" + userName + ",passWord:" + passWord + ",sessionSalt:" + sessionSalt);
                        e.printStackTrace();
                    }
                } else {
                    try {
                        userName = AesUtil.aesDecrypt(userName, sessionSalt);
                        passWord = AesUtil.aesDecrypt(passWord, sessionSalt);
                    }
                    catch (Exception e) {
                        loger.error("\u7528\u6237\u540d\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff0cuserName\uff1a" + userName + ",passWord:" + passWord + ",sessionSalt:" + sessionSalt);
                        e.printStackTrace();
                    }
                }
            }
        }
        JsonMsg msg = new JsonMsg();
        LoginUser loginUser = new LoginUser();
        if (!StringUtils.isEmpty((CharSequence)caId)) {
            BasEmp emp = this.basEmpService.findByCaId(caId);
            md5passWord = emp.getLoginPassword();
            session.setAttribute("IS_VALID_PSW", (Object)(!md5passWord.equals(SysUtils.md5two("123")) ? 1 : 0));
        } else if (adminlogin) {
            md5passWord = passWord;
        } else {
            md5passWord = SysUtils.md5two(passWord);
            session.setAttribute("IS_VALID_PSW", (Object)this.commonService.isPasswordValid(passWord));
        }
        UsernamePasswordToken token = new UsernamePasswordToken(loginAccountid.toString(), md5passWord);
        Subject currentUser = SecurityUtils.getSubject();
        try {
            currentUser.login((AuthenticationToken)token);
            if ("1".equals(bindDevice)) {
                BasEmp emp = this.basEmpService.findByloginNameOrEmpCode(userName);
                if (StringUtils.isBlank((CharSequence)emp.getImei())) {
                    emp.setImei(IMEI);
                    emp.setDeviceMode(deviceMode);
                    this.basEmpService.saveEmp(emp);
                } else if (!emp.getImei().equals(IMEI) && !"***".equals(emp.getImei())) {
                    msg.setSuccess(false);
                    msg.setMsg("\u8d26\u53f7\u5df2\u88ab\u5176\u4ed6\u7528\u6237\u7ed1\u5b9a\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u89e3\u7ed1");
                    return msg;
                }
            }
            msg.setSuccess(true);
        }
        catch (UnknownAccountException uae) {
            msg.setSuccess(false);
            msg.setMsg("\u672a\u77e5\u8d26\u6237");
        }
        catch (IncorrectCredentialsException ice) {
            msg.setSuccess(false);
            msg.setMsg("\u9519\u8bef\u7684\u51ed\u8bc1");
        }
        catch (LockedAccountException lae) {
            msg.setSuccess(false);
            msg.setMsg("\u8d26\u6237\u5df2\u9501\u5b9a");
        }
        catch (ExcessiveAttemptsException eae) {
            msg.setSuccess(false);
            msg.setMsg("\u9519\u8bef\u6b21\u6570\u8fc7\u591a");
        }
        catch (AuthenticationException ae) {
            msg.setSuccess(false);
            msg.setMsg("\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u6b63\u786e");
        }
        if (currentUser.isAuthenticated()) {
            LoginUser oldloginUser;
            if ("Y".equals(casLogin)) {
                session.setAttribute("casLogin", (Object)"Y");
                if (session.getAttribute("archiveLogin") != null) {
                    if ("Y".equals(session.getAttribute("archiveLogin"))) {
                        session.setAttribute("Archivelogin", (Object)"Y");
                    } else {
                        session.removeAttribute("Archivelogin");
                    }
                }
            }
            if ((oldloginUser = (LoginUser)session.getAttribute("LOGIN_USER")) != null) {
                session.removeAttribute("LOGIN_USER");
                CommonService.delOnlineUser(oldloginUser);
                this.commonService.setLogOutLog(session.getId(), oldloginUser.getAccountid());
            }
            BasEmpAccount account = this.basEmpAccountService.findEmpAccountById(loginAccountid);
            BasEmp emp = this.basEmpService.findEmpByempId(account.getEmpId());
            emp.setLockCount(0L);
            emp.setLockTime(null);
            Long time = System.currentTimeMillis();
            this.basEmpService.saveEmp(emp);
            Long time2 = System.currentTimeMillis();
            loger.info("\u4fdd\u5b58\u7528\u6237\u4fe1\u606f\u8017\u65f6\uff1a" + (time2 - time));
            String ip = SysUtils.getIpAddr(request);
            loginUser = this.commonService.setSessionAndLogInLog(session, emp, loginAccountid, ip);
            CommonService.addOnlineUser(loginUser);
        } else {
            token.clear();
        }
        if ("Y".equals(isApp)) {
            Subject subject = SecurityUtils.getSubject();
            Serializable tokenId = subject.getSession().getId();
            if (tokenId != null) {
                loginUser.setAuthToken(tokenId.toString());
            }
            msg.setO(loginUser);
        } else {
            msg.setO("/");
        }
        return msg;
    }

    @RequestMapping(value={"/applogin"})
    @ResponseBody
    @SystemControllerLog(description="app\u7528\u6237\u767b\u5f55")
    public JsonMsg applogin(HttpSession session, HttpServletRequest request, String userName, String passWord, String loginParams, String IMEI, String bindDevice, String deviceMode, String appVersion) {
        JsonMsg jsonMsg = this.checklogin(session, request, userName, passWord, "Y", loginParams);
        if (!jsonMsg.isSuccess()) {
            return jsonMsg;
        }
        List accountlist = (List)jsonMsg.getO();
        session.setAttribute("mobile", (Object)"1");
        jsonMsg = this.login("Y", session, request, Long.parseLong(((Map)accountlist.get(0)).get("ACCOUNT_ID").toString()), passWord, null, null, false, loginParams, IMEI, bindDevice, deviceMode, null);
        if (jsonMsg.isSuccess()) {
            session.setMaxInactiveInterval(604800);
            this.basEmpDeviceService.saveBasEmpDeviceSync(IMEI, deviceMode, appVersion, Long.parseLong(((Map)accountlist.get(0)).get("ACCOUNT_ID").toString()));
        }
        return jsonMsg;
    }

    @RequestMapping(value={"/checkUserAndPassWord"})
    @ResponseBody
    public Object checkUserAndPassWord(HttpSession session, HttpServletRequest request, String userName, String passWord) {
        BasEmp emp = this.basEmpService.findByloginNameOrEmpCode(userName);
        if (emp != null && emp.getLoginPassword().equals(SysUtils.md5two(passWord))) {
            if (this.basEmpAccountService.findAccountByEmpId(emp.getEmpId()) == null) {
                return "0";
            }
            return "1";
        }
        return "0";
    }

    @RequestMapping(value={"/checklogin"}, method={RequestMethod.POST})
    @ResponseBody
    public JsonMsg checklogin(HttpSession session, HttpServletRequest request, String userName, String passWord, String isApp, String loginParams) {
        String msgstr = "";
        String sessionSalt = request.getParameter("sessionSalt");
        Long d1 = System.currentTimeMillis();
        if (StringUtils.isNotBlank((CharSequence)sessionSalt)) {
            if (StringUtils.isNotBlank((CharSequence)loginParams)) {
                try {
                    loginParams = AesUtil.aesDecrypt(loginParams, sessionSalt);
                    JSONObject json = JSONObject.parseObject((String)loginParams);
                    userName = json.getString("userName");
                    passWord = json.getString("passWord");
                    String archiveLogin = json.getString("archiveLogin");
                    if ("true".equals(archiveLogin)) {
                        session.setAttribute("Archivelogin", (Object)"Y");
                    }
                }
                catch (Exception e) {
                    loger.error("\u7528\u6237\u540d\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff0cuserName\uff1a" + userName + ",passWord:" + passWord + ",sessionSalt:" + sessionSalt);
                    e.printStackTrace();
                }
            } else {
                try {
                    passWord = AesUtil.aesDecrypt(passWord, sessionSalt);
                }
                catch (Exception e) {
                    loger.error("\u7528\u6237\u540d\u5bc6\u7801\u89e3\u5bc6\u5931\u8d25\uff0cuserName\uff1a" + userName + ",passWord:" + passWord + ",sessionSalt:" + sessionSalt);
                    e.printStackTrace();
                }
            }
        }
        Long d2 = System.currentTimeMillis();
        loger.info("\u89e3\u5bc6\u8017\u65f6" + (d2 - d1));
        boolean success = true;
        List accountlist1 = null;
        BasEmp emp = this.basEmpService.findByloginNameOrEmpCode(userName);
        Long d3 = System.currentTimeMillis();
        loger.info("\u67e5\u627e\u7528\u6237\u8017\u65f6" + (d3 - d2));
        if (emp == null || emp.getEmpId() == null) {
            msgstr = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef";
            return new JsonMsg(false, msgstr, accountlist1);
        }
        if (!("02".equals(emp.getStatus()) || "01".equals(emp.getStatus()) || "1".equals(emp.getStatus()))) {
            return new JsonMsg(false, "\u7528\u6237\u4e0d\u5b58\u5728");
        }
        Date nowDate = new Date();
        if ("Y".equals(isApp) && (StrKit.isBlank(emp.getIsApp()) || "N".equals(emp.getIsApp()))) {
            success = false;
            msgstr = "\u8be5\u7528\u6237\u672a\u5f00\u901a\u624b\u673a\u7aef\u6743\u9650,\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458";
            return new JsonMsg(success, msgstr, accountlist1);
        }
        if (emp != null && emp.getLockTime() != null && nowDate.after(emp.getLockTime())) {
            emp.setLockCount(0L);
            emp.setLockTime(null);
            this.basEmpService.saveEmp(emp);
        }
        if (emp != null && Md5Utils.verify(passWord, emp.getLoginPassword()) && emp.getLockTime() == null) {
            accountlist1 = this.basEmpAccountService.findAccountByEmpId(emp.getEmpId());
            Long d4 = System.currentTimeMillis();
            loger.info("\u67e5\u627e\u8d26\u5957\u8017\u65f6" + (d4 - d3));
            if (accountlist1 == null) {
                msgstr = "\u7528\u6237\u5e10\u5957\u4fe1\u606f\u51fa\u9519\uff0c\u8bf7\u6838\u5bf9";
                success = false;
            } else {
                success = true;
            }
        } else {
            msgstr = "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef";
            if (emp != null) {
                if (emp.getLockTime() != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("HH:mm");
                    String time = sdf.format(emp.getLockTime());
                    msgstr = "\u7528\u6237\u5df2\u88ab\u9501\u5b9a,\u8bf7" + time + "\u4e4b\u540e\u518d\u8bd5";
                } else {
                    Long count = emp.getLockCount() == null ? 0L : emp.getLockCount();
                    if ((count = Long.valueOf(count + 1L)) >= 3L) {
                        msgstr = "\u7528\u6237\u540d\u5bc6\u7801\u51fa\u9519,<br>\u9519\u8bef5\u6b21\u540e\u5c06\u6682\u65f6\u9501\u5b9a\u7528\u6237,<br>\u8fd8\u6709" + (5L - count) + "\u6b21\u673a\u4f1a";
                    }
                    if (count >= 5L) {
                        msgstr = "\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a,<br>\u5c06\u6682\u65f6\u9501\u5b9a\u7528\u62372\u5c0f\u65f6";
                        Date date = new Date();
                        Calendar ca = Calendar.getInstance();
                        ca.setTime(date);
                        ca.add(11, 2);
                        emp.setLockTime(ca.getTime());
                        emp.setLockIp(SysUtils.getIpAddr(request));
                        loger.warn("{}\u7528\u6237\u540d\u5bc6\u7801\u9519\u8bef\u6b21\u6570\u8fc7\u591a,\u5c06\u6682\u65f6\u9501\u5b9a\u7528\u62372\u5c0f\u65f6,\u767b\u5f55IP:{}", (Object)emp.getEmpName(), (Object)SysUtils.getIpAddr(request));
                    }
                    emp.setLockCount(count);
                    this.basEmpService.saveEmp(emp);
                }
            }
            success = false;
        }
        if (accountlist1 != null && accountlist1.size() > 1) {
            accountlist1.forEach(obj -> {
                Map account = (Map)obj;
                Long accountId = Long.parseLong(account.get("ACCOUNT_ID").toString());
                account.put("todo", this.basmessageService.getAccountUndoMsgCount(accountId));
            });
        }
        return new JsonMsg(success, msgstr, accountlist1);
    }

    @RequestMapping(value={"/exit"}, method={RequestMethod.POST})
    @ResponseBody
    @SystemControllerLog(description="\u7528\u6237\u9000\u51fa")
    public Object exit(HttpSession session, HttpServletRequest request) {
        LoginUser loginUser;
        JsonMsg msg = new JsonMsg();
        if (session != null && session.getId() != null && (loginUser = this.getLoginUser(request)) != null) {
            Subject currentUser = SecurityUtils.getSubject();
            CommonService.delOnlineUser(loginUser);
            this.commonService.setLogOutLog(session.getId(), loginUser.getAccountid());
            currentUser.logout();
            CommonService.DelSession(session);
            msg.setSuccess(true);
            msg.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        return msg;
    }

    @RequestMapping(value={"/getOnlineNum"}, method={RequestMethod.POST})
    @ResponseBody
    public long getOnlineNum(HttpServletRequest request, Long orgid) {
        long onlineNum = 0L;
        LoginUser loginUser = this.getLoginUser(request);
        if (loginUser != null) {
            CommonService.updateOnlineUser(loginUser);
            List<Long> accountIdList = CommonService.getOnlineUserAccount();
            if (!accountIdList.isEmpty()) {
                List list = this.basEmpAccountService.getOnlineUserList(accountIdList, orgid, null);
                onlineNum = list.size();
            }
        }
        return onlineNum;
    }

    @RequestMapping(value={"/orgOnLineAccountTree"}, method={RequestMethod.POST})
    @ResponseBody
    public Object onlineUserObsTree(HttpServletRequest request, @RequestParam(value="id", required=false, defaultValue="0") String id) {
        LoginUser loginUser = this.getLoginUser(request);
        List<Object> orgOnLineAccountTree = new ArrayList();
        if (loginUser != null) {
            CommonService.updateOnlineUser(loginUser);
            List<Long> accountIdList = CommonService.getOnlineUserAccount();
            if (!accountIdList.isEmpty() && accountIdList.size() > 0) {
                orgOnLineAccountTree = this.basOrgService.queryOrgAndDeptTree(id, null, "1", "Y");
                orgOnLineAccountTree = this.basOrgService.buildOrgAndDeptTreeWithOnLineAccount(orgOnLineAccountTree, accountIdList);
            }
        }
        return orgOnLineAccountTree;
    }

    @RequestMapping(value={"/getOnlineUserList"}, method={RequestMethod.POST})
    @ResponseBody
    public Object getOnlineUserList(@RequestParam(value="orgid", required=false, defaultValue="0") Long orgid, Long deptid) {
        PageObject pj = new PageObject();
        List<Long> accountIdList = CommonService.getOnlineUserAccount();
        if (!accountIdList.isEmpty()) {
            List list = this.basEmpAccountService.getOnlineUserList(accountIdList, orgid, deptid);
            pj.setRows(list);
            pj.setTotal(list.size());
        }
        return pj;
    }

    @RequestMapping(value={"/switchChecklogin"}, method={RequestMethod.POST})
    @ResponseBody
    public Object switchChecklogin(HttpSession session, HttpServletRequest request) {
        JsonMsg msg = new JsonMsg();
        LoginUser loginUser = this.getLoginUser(request);
        if (loginUser != null) {
            List accountlist1 = this.basEmpAccountService.findAccountByEmpId(loginUser.getEmpid());
            if (accountlist1 == null) {
                msg.setSuccess(false);
                msg.setMsg("\u7528\u6237\u5e10\u5957\u4fe1\u606f\u51fa\u9519\uff0c\u8bf7\u6838\u5bf9");
                msg.setO("/index.action");
            } else {
                msg.setSuccess(true);
                Long accountId = loginUser.getAccountid();
                ArrayList<Map> listMaps = new ArrayList<Map>();
                for (Object o : accountlist1) {
                    Map row = (Map)o;
                    if (accountId == Long.parseLong(row.get("ACCOUNT_ID").toString())) {
                        row.put("ISCURRENT", "1");
                    } else {
                        row.put("ISCURRENT", "0");
                    }
                    row.put("todo", this.basmessageService.getAccountUndoMsgCount(Long.parseLong(row.get("ACCOUNT_ID").toString())));
                    listMaps.add(row);
                }
                msg.setO(listMaps);
            }
        } else {
            msg.setSuccess(false);
            msg.setMsg("\u9875\u9762session\u5931\u6548,\u8bf7\u91cd\u65b0\u767b\u5f55");
            msg.setO("/index.action");
        }
        return msg;
    }

    @RequestMapping(value={"/switchLogin"}, method={RequestMethod.POST})
    @ResponseBody
    public Object switchLogin(String isApp, HttpSession session, HttpServletRequest request, String loginAccountid) {
        JsonMsg msg = new JsonMsg();
        if (session != null && session.getId() != null) {
            Subject subject;
            Serializable tokenId;
            LoginUser loginUser = this.getLoginUser(request);
            BasEmp emp = loginUser.getEmp();
            String ip = SysUtils.getIpAddr(request);
            this.commonService.setLogOutLog(session.getId(), loginUser.getAccountid());
            session.removeAttribute("LOGIN_USER");
            request.getSession().setAttribute("adminlogin", (Object)"Y");
            msg = this.login("N", session, request, Long.parseLong(loginAccountid), emp.getLoginPassword(), null, null, true, null, null, null, null, null);
            if ("Y".equals(isApp) && (tokenId = (subject = SecurityUtils.getSubject()).getSession().getId()) != null) {
                loginUser = this.getLoginUser(request);
                loginUser.setAuthToken(tokenId.toString());
            }
            msg.setO(this.getLoginUser(request));
            msg.setSuccess(true);
            msg.setMsg("\u64cd\u4f5c\u6210\u529f");
        }
        return msg;
    }

    @ResponseBody
    @RequestMapping(value={"/generationQRCode"})
    public Object generationToken(HttpServletResponse response) {
        String uid = UUID.randomUUID().toString();
        tokes.put(uid, new Date());
        JSONObject object = new JSONObject();
        object.put("token", (Object)uid);
        object.put("platform", (Object)"pc");
        object.put("type", (Object)"login");
        return new JsonMsg(true, "", Base64.encodeBase64String((byte[])object.toJSONString().getBytes()));
    }

    @ResponseBody
    @RequestMapping(value={"/determine"})
    public JsonMsg determine(HttpServletRequest request, String token, String platform) {
        token = new String(Base64.decodeBase64((String)token));
        try {
            JSONObject object = JSON.parseObject((String)token);
            if (tokes.containsKey(object.get((Object)"token"))) {
                users.put(object.get((Object)"token").toString(), SysUtils.getLoginAccountId());
                return new JsonMsg(true, "\u6b63\u5728\u767b\u5f55\u8bf7\u7a0d\u540e...");
            }
            return new JsonMsg("\u8bf7\u6c42\u65e0\u6548");
        }
        catch (Exception e) {
            return new JsonMsg("\u8bf7\u6c42\u65e0\u6548");
        }
    }

    @ResponseBody
    @RequestMapping(value={"/scanLogin"})
    public Object scanLogin(HttpServletRequest request, String token) {
        if (StringUtils.isBlank((CharSequence)token)) {
            return new JsonMsg("\u8bf7\u6c42\u65e0\u6548");
        }
        JSONObject object = JSON.parseObject((String)(token = new String(Base64.decodeBase64((String)token))));
        Long accountId = users.get(object.get((Object)"token"));
        if (accountId == null) {
            return new JsonMsg("\u672a\u626b\u7801");
        }
        this.login(request, accountId);
        users.remove(token);
        tokes.remove(token);
        LoginUser user = this.getLoginUser(request);
        user.setAuthToken(request.getSession().getId());
        return new JsonMsg(true, "\u767b\u5f55\u6210\u529f", user);
    }

    @RequestMapping(value={"/singleLogin"})
    public ModelAndView singleLogin(HttpSession session, HttpServletRequest request, String params, Long timestamp) {
        ModelAndView view = new ModelAndView();
        request.getSession().setAttribute("sessionSalt", (Object)GenerateRandomKeyUtil.getRandomKey(16));
        view.setViewName("index");
        String now = DateUtils.parse(new Date(), "yyyyMMdd");
        String key = "IMPLOGIN" + now;
        Date requestdate = new Date(timestamp + 30000L);
        if (requestdate.before(new Date())) {
            return view;
        }
        try {
            params = AesUtil.aesDecrypt(params, key);
            List<BasEmpAccount> accountlist = this.basEmpAccountService.getAccountByPhone(params);
            if (accountlist != null && accountlist.size() > 0) {
                LoginUser loginUser = new LoginUser();
                BasEmpAccount account = accountlist.get(0);
                Long loginAccountid = null;
                if (account != null) {
                    loginAccountid = account.getAccountId();
                }
                BasEmp emp = this.basEmpService.findEmpByempId(account.getEmpId());
                UsernamePasswordToken token = new UsernamePasswordToken(loginAccountid.toString(), emp.getLoginPassword());
                Subject currentUser = SecurityUtils.getSubject();
                currentUser.login((AuthenticationToken)token);
                if (currentUser.isAuthenticated()) {
                    LoginUser oldloginUser = (LoginUser)session.getAttribute("LOGIN_USER");
                    if (oldloginUser != null) {
                        session.removeAttribute("LOGIN_USER");
                        CommonService.delOnlineUser(oldloginUser);
                        this.commonService.setLogOutLog(session.getId(), oldloginUser.getAccountid());
                    }
                    emp.setLockCount(0L);
                    emp.setLockTime(null);
                    this.basEmpService.saveEmp(emp);
                    String ip = SysUtils.getIpAddr(request);
                    loginUser = this.commonService.setSessionAndLogInLog(session, emp, loginAccountid, ip);
                    CommonService.addOnlineUser(loginUser);
                } else {
                    token.clear();
                }
                view.setViewName("redirect:/");
            }
        }
        catch (Exception e) {
            loger.error("\u53c2\u6570\u89e3\u5bc6\u5931\u8d25\uff0cparams\uff1a" + params);
            e.printStackTrace();
        }
        return view;
    }

    @RequestMapping(value={"/checkConfirm"})
    public Object checkConfirm(HttpSession session, HttpServletRequest request, String confirm, String preurl) {
        JsonMsg msg = this.checklogin(session, request, this.basEmpService.findEmpByempId(SysUtils.getLoginUser().getEmpid()).getLoginName(), confirm, null, null);
        if (msg.isSuccess()) {
            HashMap<String, Long> map;
            Object ob = session.getAttribute("menuConfirmMap");
            if (ob == null) {
                map = new HashMap<String, Long>();
                session.setAttribute("menuConfirmMap", map);
            } else {
                map = (HashMap<String, Long>)ob;
            }
            map.put(preurl.split("\\?")[0], System.currentTimeMillis());
            return "redirect:" + preurl;
        }
        request.setAttribute("validatemsg", (Object)"\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        request.setAttribute("preurl", (Object)preurl);
        return "/confirm";
    }

    @RequestMapping(value={"/checkPasswordTwiceConfirm"})
    public Object checkPasswordTwiceConfirm(HttpSession session, HttpServletRequest request, ServletResponse response, String twicePassword, String preurl) throws IOException, ServletException {
        JsonMsg msg = new JsonMsg();
        LoginUser user = this.getLoginUser(request);
        BasEmp basEmp = this.basEmpService.findEmpByempId(user.getEmpid());
        if (basEmp.getLoginPasswordTwice().equals(SysUtils.md5two(twicePassword))) {
            msg.setSuccess(true);
            msg.setMsg("\u4e8c\u6b21\u5bc6\u7801\u6821\u9a8c\u6210\u529f");
        } else {
            msg.setSuccess(false);
            msg.setMsg("\u4e8c\u6b21\u5bc6\u7801\u6821\u9a8c\u5931\u8d25");
        }
        if (msg.isSuccess()) {
            HashMap<String, Long> map;
            Object ob = session.getAttribute("menuConfirmMap");
            if (ob == null) {
                map = new HashMap<String, Long>();
                session.setAttribute("menuConfirmMap", map);
            } else {
                map = (HashMap<String, Long>)ob;
            }
            map.put(preurl.split("\\?")[0], System.currentTimeMillis());
            session.setAttribute("LAST_QUERY_VERIFY_TIME", (Object)System.currentTimeMillis());
            return "redirect:" + preurl;
        }
        String password = user.getEmp().getLoginPasswordTwice();
        String erpServer = user.getErpServer();
        String empName = user.getEmp().getEmpName();
        request.setAttribute("preurl", (Object)preurl);
        request.setAttribute("password", (Object)password);
        request.setAttribute("erpServer", (Object)erpServer);
        request.setAttribute("empName", (Object)empName);
        request.setAttribute("validatemsg", (Object)"\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        String queryPassSpecify = MemCache.SysConfigMap.get(SysConfigEnum.QUERY_PASS_SPECIFY.getCode());
        request.setAttribute("queryPassSpecify", (Object)queryPassSpecify);
        request.getRequestDispatcher("/view/setTwicePassword").forward((ServletRequest)request, response);
        return "";
    }
}

