/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.GmInfoComment;
import com.guochuang.imp.base.service.GmInfoCommentService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/GmInfoComment"})
public class GmInfoCommentController
extends BaseController {
    @Autowired
    private GmInfoCommentService gminfocommentService;

    @RequestMapping(value={"/pageGmInfoComment"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageGmInfoComment(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.gminfocommentService.PageAll(search, page, rows, sort, order);
    }

    @RequestMapping(value={"/findGmInfoComment"})
    @ResponseBody
    public Object findGmInfoComment(Long id) {
        GmInfoComment entity = this.gminfocommentService.findGmInfoComment(id);
        return entity;
    }

    @RequestMapping(value={"/saveGmInfoComment"})
    @ResponseBody
    public Object saveGmInfoComment(HttpServletRequest request, GmInfoComment entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getCommentId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.gminfocommentService.saveGmInfoComment(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delGmInfoComment"})
    @ResponseBody
    public Object delGmInfoComment(Long id) {
        this.gminfocommentService.delGmInfoComment(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/createCommentData"})
    @ResponseBody
    public Object createCommentData(HttpServletRequest request, Long infoId, String content, Long commentId) {
        JsonMsg msg = new JsonMsg();
        GmInfoComment comment = new GmInfoComment();
        if (commentId != null) {
            comment = this.gminfocommentService.findGmInfoComment(commentId);
            comment.setContent(content);
            comment.setCommentDate(new Date());
        } else {
            comment.setCommentBy(this.getLoginUser(request).getAccountid());
            comment.setCommentDate(new Date());
            comment.setContent(content);
            comment.setInfoId(infoId);
            comment.setIsUse("Y");
        }
        this.gminfocommentService.saveGmInfoComment(comment);
        return msg;
    }

    @RequestMapping(value={"/findCommentDataByInfoId"})
    @ResponseBody
    public Object findCommentDataByInfoId(HttpServletRequest request, Long infoId) {
        JsonMsg msg = new JsonMsg();
        List<Map<String, Object>> comments = this.gminfocommentService.findCommentDataByInfoId(infoId);
        msg.setO(comments);
        return msg;
    }
}

