/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.spring.SpringContextHolder;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasDic;
import com.guochuang.imp.base.entity.BasSystemConfig;
import com.guochuang.imp.base.service.BasSystemConfigService;
import com.guochuang.imp.base.service.MemCacheService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basSystemConfig"})
public class BasSystemConfigController
extends BaseController {
    @Autowired
    private BasSystemConfigService basSystemConfigService;

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public PageObject pageAll(int page, int rows, String sort, String order) {
        return this.basSystemConfigService.pageAll(page, rows, sort, order);
    }

    @PostMapping(value={"/getAllData"})
    @ResponseBody
    public Object getAllData() {
        return this.basSystemConfigService.getAllData();
    }

    @PostMapping(value={"/saveBasSystemConfig"})
    @ResponseBody
    public JsonMsg saveBasSystemConfig(HttpServletRequest request, BasSystemConfig entity) {
        JsonMsg msg = new JsonMsg();
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getId() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.basSystemConfigService.saveBasSystemConfig(entity);
        return msg;
    }

    @PostMapping(value={"/saveBasSystemConfigByJsonStr"})
    @ResponseBody
    public JsonMsg saveBasSystemConfigByJsonStr(HttpServletRequest request, String configs) {
        JsonMsg msg = new JsonMsg();
        LoginUser loginUser = this.getLoginUser(request);
        msg.setO(this.basSystemConfigService.saveBasSystemConfigByJsonStr(configs, loginUser));
        return msg;
    }

    @PostMapping(value={"/saveQueryVerifyDataByJsonStr"})
    @ResponseBody
    public JsonMsg saveQueryVerifyDataByJsonStr(HttpServletRequest request, String configs) {
        JsonMsg msg = new JsonMsg();
        LoginUser loginUser = this.getLoginUser(request);
        msg.setO(this.basSystemConfigService.saveQueryVerifyDataByJsonStr(configs, loginUser));
        return msg;
    }

    @PostMapping(value={"/findBasSystemConfig"})
    @ResponseBody
    public BasSystemConfig findBasSystemConfig(Long id) {
        BasSystemConfig entity = this.basSystemConfigService.findBasSystemConfig(id);
        return entity;
    }

    @PostMapping(value={"/delBasSystemConfig"})
    @ResponseBody
    public JsonMsg delBasSystemConfig(Long id) {
        this.basSystemConfigService.delBasSystemConfig(id);
        return new JsonMsg();
    }

    @PostMapping(value={"/findBasSystemConfigFlow"})
    @ResponseBody
    public JsonMsg findBasSystemConfigFlow(HttpServletRequest request) {
        return this.basSystemConfigService.findBasSystemConfigFlow();
    }

    @PostMapping(value={"/saveBasSystemConfigFlow"})
    @ResponseBody
    public JsonMsg saveBasSystemConfigFlow(HttpServletRequest request, String enableSet, String userSet) {
        JsonMsg msg = new JsonMsg();
        this.basSystemConfigService.saveBasSystemConfigFlow(enableSet, userSet);
        SpringContextHolder.getBean(MemCacheService.class).setSysConfigCache();
        return msg;
    }

    @PostMapping(value={"/getDicInfo"})
    @ResponseBody
    public JsonMsg getDicInfo(HttpServletRequest request, String dicCode) {
        JsonMsg msg = new JsonMsg();
        List<BasDic> dicList = this.basSystemConfigService.getDicInfo(dicCode);
        msg.setMsg(dicList);
        return msg;
    }

    @PostMapping(value={"/getBasSysConfigByCode"})
    @ResponseBody
    public BasSystemConfig getBasSysConfigByCode(HttpServletRequest request, String code) {
        return this.basSystemConfigService.getBasSysConfigByCode(code);
    }
}

