/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.exception.GEPSBisException;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasSpaceComponentAssociated;
import com.guochuang.imp.base.entity.BasSpaceComponentCustom;
import com.guochuang.imp.base.entity.BasSpaceComponentDefinition;
import com.guochuang.imp.base.entity.GmInfoType;
import com.guochuang.imp.base.service.BasSpaceComponentAssociatedService;
import com.guochuang.imp.base.service.BasSpaceComponentCustomService;
import com.guochuang.imp.base.service.BasSpaceComponentDefinitionService;
import com.guochuang.imp.base.service.CommonService;
import com.guochuang.imp.base.service.GmInfoTypeManagersService;
import com.guochuang.imp.base.service.GmInfoTypeService;
import com.guochuang.imp.report.entity.ReportBase;
import com.guochuang.imp.report.service.ReportBaseService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasSpaceComponentAssociated"})
public class BasSpaceComponentAssociatedController
extends BaseController {
    @Autowired
    private BasSpaceComponentAssociatedService basspacecomponentassociatedService;
    @Autowired
    private CommonService comService;
    @Autowired
    private BasSpaceComponentDefinitionService basSpaceComponentDefinitionService;
    @Autowired
    private GmInfoTypeService gmInfoTypeService;
    @Autowired
    private GmInfoTypeManagersService gmInfoTypeManagersService;
    @Autowired
    private BasSpaceComponentCustomService basSpaceComponentCustomService;
    @Autowired
    private ReportBaseService reportBaseService;

    @RequestMapping(value={"/findBasSpaceComponentAssociated"})
    @ResponseBody
    public Object findBasSpaceComponentAssociated(Long id) {
        JsonMsg msg = new JsonMsg();
        BasSpaceComponentAssociated entity = this.basspacecomponentassociatedService.findBasSpaceComponentAssociated(id);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasSpaceComponentAssociated"})
    @ResponseBody
    public Object delBasSpaceComponentAssociated(Long id) {
        this.basspacecomponentassociatedService.delBasSpaceComponentAssociated(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/saveBasSpaceComponentAssociated"})
    @ResponseBody
    public Object saveBasSpaceComponentAssociated(HttpServletRequest request, String dataStr, Long spaceId) throws GEPSBisException {
        JsonMsg msg = new JsonMsg();
        BasSpaceComponentAssociated entity = new BasSpaceComponentAssociated();
        JSONObject jsonObject = JSONObject.parseObject((String)dataStr);
        entity.setAssociated(Long.parseLong((String)jsonObject.get((Object)"associated")));
        entity.setSpaceId(spaceId);
        entity.setComponentType((String)jsonObject.get((Object)"componentType"));
        entity.setComponentId((String)jsonObject.get((Object)"componentId"));
        entity.setSquence(Long.parseLong((String)jsonObject.get((Object)"squence")));
        entity.setDisplayName((String)jsonObject.get((Object)"displayName"));
        entity.setComponentWidth((String)jsonObject.get((Object)"componentWidth"));
        entity.setComponentHeight(Long.parseLong((String)jsonObject.get((Object)"componentHeight")));
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getAssociated() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.basspacecomponentassociatedService.saveBasSpaceComponentAssociated(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/toBasSpaceComponentAssociatedPage"})
    public String toBasSpaceComponentAssociatedPage(Long id, Model model, String isdetail) {
        if (id != null) {
            List<Map<String, Object>> basSpaceComponentList = this.basspacecomponentassociatedService.findBySpaceId(id);
            model.addAttribute("dataList", basSpaceComponentList);
        } else {
            model.addAttribute("dataList", new ArrayList());
        }
        model.addAttribute("isdetail", (Object)isdetail);
        return "base/BasSpaceComponentAssociated";
    }

    @RequestMapping(value={"/saveSpaceComponentSquence"})
    @ResponseBody
    public Object saveSpaceComponentSquence(String dataStr) {
        JsonMsg msg = new JsonMsg();
        JSONArray jsonArray = JSONArray.parseArray((String)dataStr);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Long associated = Long.parseLong(Objects.toString(jsonObject.get((Object)"associated")));
            BasSpaceComponentAssociated basSpaceComponentAssociated = this.basspacecomponentassociatedService.findBasSpaceComponentAssociated(associated);
            Integer squence = (Integer)jsonObject.get((Object)"squence");
            basSpaceComponentAssociated.setSquence(squence.longValue());
            this.basspacecomponentassociatedService.saveBasSpaceComponentAssociated(basSpaceComponentAssociated);
        }
        return msg;
    }

    @RequestMapping(value={"/allocateBasSpaceComponent"})
    public String allocateBasSpaceComponent(Long spaceId, String componentType, Model model) {
        List<ComboxNode> componentTypes = this.comService.getDicComboWithDefault("COMPONENT_TYPE");
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        model.addAttribute("componentTypes", componentTypes);
        return "base/BasSpaceComponentWin";
    }

    @RequestMapping(value={"/showInfoTypeSelectWin"})
    public String showInfoTypeSelectWin(Long spaceId, String componentType, Long associated, Model model) {
        String componentType2;
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        BasSpaceComponentAssociated basSpaceComponentAssociated = null;
        ArrayList<GmInfoType> list = new ArrayList<GmInfoType>();
        if (associated != null && (componentType2 = (basSpaceComponentAssociated = this.basspacecomponentassociatedService.findBasSpaceComponentAssociated(associated)).getComponentType()) == "1") {
            String componentId = basSpaceComponentAssociated.getComponentId();
            for (String id : componentId.split(",")) {
                GmInfoType gmInfoType = this.gmInfoTypeService.findGmInfoType(Long.parseLong(id));
                list.add(gmInfoType);
            }
        }
        model.addAttribute("gmInfoTypeList", list);
        return "base/infoTypeSelectWin";
    }

    @RequestMapping(value={"/showComponentSelectWin"})
    public String showComponentSelectWin(Long spaceId, String componentType, Model model) {
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        return "base/componentSelectWin";
    }

    @RequestMapping(value={"/addComponentAssociated"})
    @ResponseBody
    public Object addComponentAssociated(HttpServletRequest request, Long spaceId, String dataStr, Long maxSquence) throws UnsupportedEncodingException {
        JsonMsg msg = new JsonMsg();
        JSONArray jsonArray = JSONArray.parseArray((String)dataStr);
        ArrayList<BasSpaceComponentAssociated> list = new ArrayList<BasSpaceComponentAssociated>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            String componentContent;
            String linkAddress;
            BasSpaceComponentAssociated entity = new BasSpaceComponentAssociated();
            Long l = maxSquence;
            Long l2 = maxSquence = Long.valueOf(maxSquence + 1L);
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            entity.setSpaceId(spaceId);
            String componentType = (String)jsonObject.get((Object)"componentType");
            String componentId = jsonObject.getString("componentId");
            entity.setComponentType(componentType);
            entity.setComponentId(componentId);
            if ("1".equals(componentType)) {
                linkAddress = "/GmInfoContent/viewContentListByIds?typeIds=" + componentId;
                String infoContent = SysUtils.GetHttpContent(request, linkAddress);
                entity.setComponentContent(infoContent);
            } else if ("2".equals(componentType)) {
                BasSpaceComponentDefinition spaceComponentDefinition = this.basSpaceComponentDefinitionService.findBasSpaceComponentDefinition(Long.parseLong(componentId));
                linkAddress = "/BasSpaceComponentDefinition/viewContentListByIds?componentIds=" + spaceComponentDefinition.getComponentId();
                componentContent = SysUtils.GetHttpContent(request, linkAddress);
                entity.setComponentContent(componentContent);
            } else {
                ReportBase report = this.reportBaseService.findReportBase(Long.parseLong(componentId));
                linkAddress = "/ReportBase/genReport?space=Y&showTitle=false&reportCode=" + report.getReportCode();
                componentContent = SysUtils.GetHttpContent(request, linkAddress);
                entity.setComponentContent(componentContent);
            }
            entity.setSquence(maxSquence);
            entity.setComponentWidth("33.30%");
            entity.setComponentHeight(380L);
            entity.setModifyAccount(this.getLoginUser(request).getAccountid());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            if (entity.getAssociated() == null) {
                entity.setCreateAccount(this.getLoginUser(request).getAccountid());
                entity.setCreateTime(new Date());
            }
            this.basspacecomponentassociatedService.saveBasSpaceComponentAssociated(entity);
            list.add(entity);
        }
        msg.setO(list);
        return msg;
    }

    @RequestMapping(value={"/addComponentAssociatedInCard"})
    @ResponseBody
    public Object addComponentAssociatedInCard(HttpServletRequest request, String dataStr, Long associated) throws UnsupportedEncodingException {
        JsonMsg msg = new JsonMsg();
        BasSpaceComponentAssociated basSpaceComponentAssociated = this.basspacecomponentassociatedService.findBasSpaceComponentAssociated(associated);
        String componentId = basSpaceComponentAssociated.getComponentId();
        JSONArray jsonArray = JSONArray.parseArray((String)dataStr);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String singlecComponentId = (String)jsonObject.get((Object)"componentId");
            componentId = componentId + "," + singlecComponentId;
        }
        basSpaceComponentAssociated.setComponentId(componentId);
        basSpaceComponentAssociated.setModifyAccount(this.getLoginUser(request).getAccountid());
        basSpaceComponentAssociated.setModifyTime(new Date());
        this.basspacecomponentassociatedService.saveBasSpaceComponentAssociated(basSpaceComponentAssociated);
        String componentType = basSpaceComponentAssociated.getComponentType();
        String linkAddress = "1".equals(componentType) ? "/GmInfoContent/viewContentListByIds?typeIds=" + basSpaceComponentAssociated.getComponentId() : "/BasSpaceComponentDefinition/viewContentListByIds?componentIds=" + basSpaceComponentAssociated.getComponentId();
        String content = SysUtils.GetHttpContent(request, linkAddress);
        basSpaceComponentAssociated.setComponentContent(content);
        msg.setO(basSpaceComponentAssociated);
        return msg;
    }

    @RequestMapping(value={"/countInfoTypeIsOrNotUse"})
    @ResponseBody
    public Object countInfoTypeIsOrNotUse(Long id) {
        JsonMsg msg = new JsonMsg();
        Integer countInfoTypeIsOrNotUse = this.basspacecomponentassociatedService.countInfoTypeIsOrNotUse(id);
        if (countInfoTypeIsOrNotUse == 1) {
            msg.setMsg("\u8be5\u680f\u76ee\u88ab\u7a7a\u95f4\u6240\u5f15\u7528,\u4e0d\u80fd\u5220\u9664");
        } else {
            this.gmInfoTypeManagersService.deleteByTypeId(id);
        }
        return msg;
    }

    @RequestMapping(value={"/findPublishScopeByTypeId"})
    @ResponseBody
    public Object findPublishScopeByTypeId(Long typeId) {
        JsonMsg msg = new JsonMsg();
        Map<String, Object> data = this.basspacecomponentassociatedService.findPublishScopeByTypeId(typeId);
        msg.setO(data);
        return msg;
    }

    @RequestMapping(value={"/showInfoTypeSelectWinFilter"})
    public String showInfoTypeSelectWinFilter(Long spaceId, String componentType, Long associated, Model model) {
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        model.addAttribute("associated", (Object)associated);
        BasSpaceComponentCustom custom = null;
        ArrayList<GmInfoType> list = new ArrayList<GmInfoType>();
        Long height = 380L;
        String width = "33.30%";
        if (associated != null) {
            custom = this.basSpaceComponentCustomService.findBasSpaceComponentCustom(associated);
            String componentType1 = "";
            String componentId = "";
            if (custom == null) {
                BasSpaceComponentAssociated gmSpaceComponentAssociated = this.basspacecomponentassociatedService.findBasSpaceComponentAssociated(associated);
                if (gmSpaceComponentAssociated != null) {
                    height = gmSpaceComponentAssociated.getComponentHeight();
                    width = gmSpaceComponentAssociated.getComponentWidth();
                    componentType1 = gmSpaceComponentAssociated.getComponentType();
                    componentId = gmSpaceComponentAssociated.getComponentId();
                }
            } else {
                height = custom.getComponentHeight();
                width = custom.getComponentWidth();
                componentType1 = custom.getComponentType();
                componentId = custom.getComponentId();
            }
            if ("1".equals(componentType1)) {
                for (String id : componentId.split(",")) {
                    GmInfoType gmInfoType = this.gmInfoTypeService.findGmInfoType(Long.parseLong(id));
                    list.add(gmInfoType);
                }
            }
        }
        model.addAttribute("height", (Object)height);
        model.addAttribute("width", (Object)width);
        model.addAttribute("gmInfoTypeList", (Object)JSON.toJSONString(list));
        return "base/infoTypeSelectWinFilter";
    }

    @RequestMapping(value={"/showComponentSelectWinFilter"})
    public String showComponentSelectWinFilter(Long spaceId, String componentType, Long associated, Model model) {
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        model.addAttribute("associated", (Object)associated);
        ArrayList<BasSpaceComponentDefinition> list = new ArrayList<BasSpaceComponentDefinition>();
        Long height = 380L;
        String width = "33.30%";
        if (associated != null) {
            BasSpaceComponentCustom custom = this.basSpaceComponentCustomService.findBasSpaceComponentCustom(associated);
            String componentType1 = "";
            String componentId = "";
            if (custom == null) {
                BasSpaceComponentAssociated gmSpaceComponentAssociated = this.basspacecomponentassociatedService.findBasSpaceComponentAssociated(associated);
                if (gmSpaceComponentAssociated != null) {
                    height = gmSpaceComponentAssociated.getComponentHeight();
                    width = gmSpaceComponentAssociated.getComponentWidth();
                    componentType1 = gmSpaceComponentAssociated.getComponentType();
                    componentId = gmSpaceComponentAssociated.getComponentId();
                }
            } else {
                height = custom.getComponentHeight();
                width = custom.getComponentWidth();
                componentType1 = custom.getComponentType();
                componentId = custom.getComponentId();
            }
            if ("2".equals(componentType1)) {
                for (String id : componentId.split(",")) {
                    BasSpaceComponentDefinition definition = this.basSpaceComponentDefinitionService.findBasSpaceComponentDefinition(Long.parseLong(id));
                    list.add(definition);
                }
            }
        }
        model.addAttribute("height", (Object)height);
        model.addAttribute("width", (Object)width);
        model.addAttribute("definitionList", (Object)JSON.toJSONString(list));
        return "base/componentSelectWinFilter";
    }

    @RequestMapping(value={"/saveSpaceComponentSquenceCustom"})
    @ResponseBody
    public Object saveSpaceComponentSquenceCustom(HttpServletRequest request, String dataStr, Long spaceId) {
        JsonMsg msg = new JsonMsg();
        JSONArray jsonArray = JSONArray.parseArray((String)dataStr);
        this.basSpaceComponentCustomService.deleteByUserAndSpace(this.getLoginUser(request).getAccountid(), spaceId);
        for (int i = 0; i < jsonArray.size(); ++i) {
            BasSpaceComponentCustom entity = new BasSpaceComponentCustom();
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            entity.setComponentType(jsonObject.get((Object)"componentType").toString());
            entity.setComponentId(jsonObject.get((Object)"componentId").toString());
            entity.setSquence(Long.parseLong(jsonObject.get((Object)"squence").toString()));
            Integer squence = (Integer)jsonObject.get((Object)"squence");
            entity.setSquence(squence.longValue());
            entity.setSpaceId(spaceId);
            entity.setDisplayName(null);
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
            entity.setModifyAccount(this.getLoginUser(request).getAccountid());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            entity.setComponentHeight(jsonObject.get((Object)"componentHeight") != null ? jsonObject.getLong("componentHeight") : 338L);
            entity.setComponentWidth(jsonObject.get((Object)"componentWidth") != null ? jsonObject.getString("componentWidth") : "33.30%");
            this.basSpaceComponentCustomService.saveBasSpaceComponentCustom(entity);
        }
        return msg;
    }

    @RequestMapping(value={"/resetSpaceComponentSquenceCustom"})
    @ResponseBody
    public Object resetSpaceComponentSquenceCustom(HttpServletRequest request, Long spaceId) {
        JsonMsg msg = new JsonMsg();
        this.basSpaceComponentCustomService.deleteByUserAndSpace(this.getLoginUser(request).getAccountid(), spaceId);
        return msg;
    }
}

