/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasProcessForwarding;
import com.guochuang.imp.base.service.BasProcessForwardingService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/basProcessForwarding"})
public class BasProcessForwardingController
extends BaseController {
    @Autowired
    private BasProcessForwardingService basProcessForwardingService;

    @GetMapping(value={"/dialog"})
    public ModelAndView toProcessForwarding() {
        ModelAndView view = new ModelAndView();
        view.setViewName("/base/basProcessForwardingDailog");
        return view;
    }

    @RequestMapping(value={"/getReceivePerson"})
    @ResponseBody
    public List<Map<String, Object>> getReceivePerson(HttpServletRequest request) {
        return this.basProcessForwardingService.findAllReceive();
    }

    @PostMapping(value={"/pageAll"})
    @ResponseBody
    public PageObject pageAll(int page, int rows, String sort, String order, String subject, String createName, Date startDate, Date endDate, String isReadValue) {
        return this.basProcessForwardingService.pageAll(page, rows, sort, order, subject, createName, startDate, endDate, isReadValue);
    }

    @PostMapping(value={"/saveBasProcessForwarding"})
    @ResponseBody
    public JsonMsg saveBasProcessForwarding(HttpServletRequest request, BasProcessForwarding entity) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        entity.setSendtime(new Date());
        entity.setSender(SysUtils.getLoginAccountId());
        this.basProcessForwardingService.saveBasProcessForwarding(entity);
        return msg;
    }

    @PostMapping(value={"/findBasProcessForwarding"})
    @ResponseBody
    public BasProcessForwarding findBasProcessForwarding(Long id) {
        BasProcessForwarding entity = this.basProcessForwardingService.findBasProcessForwarding(id);
        return entity;
    }

    @PostMapping(value={"/delBasProcessForwarding"})
    @ResponseBody
    public JsonMsg delBasProcessForwarding(Long id) {
        this.basProcessForwardingService.delBasProcessForwarding(id);
        return new JsonMsg();
    }

    @PostMapping(value={"/listForwarding"})
    @ResponseBody
    public Object listForwarding(String formCode, Long busiMainId) {
        return this.basProcessForwardingService.listForwarding(formCode, busiMainId);
    }

    @RequestMapping(value={"/toList"})
    public Object listForwarding(String formCode, Long busiMainId, Model model) {
        model.addAttribute("list", this.basProcessForwardingService.listForwarding(formCode, busiMainId));
        return "/base/basForwarding";
    }

    @PostMapping(value={"/listLoginForwarding"})
    @ResponseBody
    public Object listLoginForwarding(Boolean read) {
        return this.basProcessForwardingService.listLoginForwarding(read);
    }
}

