/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasModelManage;
import com.guochuang.imp.base.extend.BasExecuteSqlModel;
import com.guochuang.imp.base.service.BasModelManageService;
import com.guochuang.imp.base.service.BasRolesService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basModelManage"})
public class BasModelManageController
extends BaseController {
    @Autowired
    private BasModelManageService basModelManageService;
    @Autowired
    private BasRolesService basRolesService;

    @RequestMapping(value={"/treeBasModelManageWithRoot"})
    @ResponseBody
    public Object treeBasModelManageWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid) {
        List<ComBoxTreeNode> treelist = this.basModelManageService.treeBasModelManageWithRoot(pid, null);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        root.setIconCls("iconfont icon-datasource");
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @PostMapping(value={"/saveBasModelManage"})
    @ResponseBody
    public JsonMsg saveBasModelManage(HttpServletRequest request, BasModelManage entity) {
        JsonMsg msg = new JsonMsg();
        entity.setIsUse("Y");
        this.basModelManageService.saveBasModelManage(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/findBasModelManage"})
    @ResponseBody
    public BasModelManage findBasModelManage(Long id) {
        BasModelManage entity = this.basModelManageService.findBasModelManage(id);
        return entity;
    }

    @PostMapping(value={"/delBasModelManage"})
    @ResponseBody
    public JsonMsg delBasModelManage(Long id) {
        this.basModelManageService.delBasModelManage(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/getDataColumns"})
    @ResponseBody
    public Object getDataColumns(Long modelPid, String search) {
        return this.basModelManageService.getDataColumns(search, modelPid);
    }

    @RequestMapping(value={"/treeBasModelManageWithNameSpace"})
    @ResponseBody
    public Object treeBasModelManageWithNameSpace(@RequestParam(value="pid", defaultValue="0") Long pid, Long detailId, String showRoot, String themeCode) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        if (detailId != null) {
            BasModelManage modelManage = this.basModelManageService.findBasModelManage(detailId);
            ComBoxTreeNode node = new ComBoxTreeNode();
            node.setId(modelManage.getModelId().toString());
            node.setText(modelManage.getModelName());
            node.setId(modelManage.getModelId().toString());
            list.add(node);
            return list;
        }
        if (StringUtils.isNotBlank((CharSequence)themeCode)) {
            BasModelManage model = this.basModelManageService.getModelByCode(themeCode);
            pid = model.getModelId();
            List<ComBoxTreeNode> treelist = this.basModelManageService.treeBasModelManageWithRoot(pid, "workspace");
            ComBoxTreeNode root = new ComBoxTreeNode();
            root.setId(model.getModelId().toString());
            root.setText(model.getModelName());
            root.setChecked(false);
            root.setChildren(treelist);
            root.setIconCls("iconfont icon-datasource");
            list.add(root);
            return list;
        }
        List<ComBoxTreeNode> treelist = this.basModelManageService.treeBasModelManageWithRoot(pid, "workspace");
        if ("Y".equals(showRoot)) {
            ComBoxTreeNode root = new ComBoxTreeNode();
            root.setId("0");
            root.setText("\u6839\u8282\u70b9");
            root.setChecked(false);
            root.setChildren(treelist);
            root.setIconCls("iconfont icon-datasource");
            list.add(root);
            return list;
        }
        return treelist;
    }

    @RequestMapping(value={"/findThemeListByWorkspace"})
    @ResponseBody
    public Object findThemeListByWorkspace(Long modelId) {
        return this.basModelManageService.findThemeListByWorkspace(modelId);
    }

    @RequestMapping(value={"/findThemeListByWorkspaceNew"})
    @ResponseBody
    public Object findThemeListByWorkspaceNew(Long modelId) {
        return this.basModelManageService.findThemeListByWorkspaceNew(modelId);
    }

    @RequestMapping(value={"/findModelManageSqlInfo"})
    @ResponseBody
    public Object findModelManageSqlInfo(Long themeId) {
        List<BasExecuteSqlModel> list;
        if (themeId != null && (list = this.basModelManageService.findThemeSqlInfoList(themeId.toString())) != null) {
            return new JsonMsg(true, "", list.get(0));
        }
        return new JsonMsg(false, "\u672a\u83b7\u53d6\u5230\u4e1a\u52a1\u4e3b\u9898\u4e3b\u952eID");
    }

    @RequestMapping(value={"/findDataCatListByThemeId"})
    @ResponseBody
    public Object findDataCatListByThemeId(Long themeId) {
        if (themeId != null) {
            return this.basModelManageService.findDataCatListByThemeId(themeId);
        }
        return Collections.emptyList();
    }

    @RequestMapping(value={"/pageBasRoles"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasRoles(@RequestParam(value="roleType", defaultValue="") String roleType, @RequestParam(value="orgid", defaultValue="0") Long orgid, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        if ("person".equals(roleType)) {
            ArrayList list = new ArrayList();
            HashMap<String, String> entity = new HashMap<String, String>();
            entity.put("ROLE_ID", "");
            entity.put("ROLE_NAME", "\u6570\u636e\u5bf9\u5e94\u4eba\u5458");
            list.add(entity);
            return new PageObject(list, 1L);
        }
        return this.basRolesService.PageAll(roleType, orgid, search, page, rows);
    }
}

