/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasEmpAccount;
import com.guochuang.imp.base.service.BasEmpAccountService;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basEmpAccount"})
public class BasEmpAccountController
extends BaseController {
    @Autowired
    private BasEmpAccountService basEmpAccountService;

    @RequestMapping(value={"/findAllEmpAccount"})
    @ResponseBody
    public Object findAllEmpAccount() {
        return this.basEmpAccountService.findAllEmpAccountList();
    }

    @RequestMapping(value={"/findEmpAccountByEmpId"})
    @ResponseBody
    public Object findEmpAccountByEmpId(Long empId) {
        if (empId == null) {
            return new ArrayList();
        }
        return this.basEmpAccountService.findEmpAccountByEmpId(empId);
    }

    @RequestMapping(value={"/saveEmpAccount"})
    @ResponseBody
    public Object saveEmpAccount(HttpServletRequest request, BasEmpAccount basEmpAccount) throws RemoteException {
        basEmpAccount.setIsUse("Y");
        basEmpAccount = this.basEmpAccountService.saveBasEmpAccount(basEmpAccount);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f", basEmpAccount);
    }

    @RequestMapping(value={"/saveEmpAccountInt"})
    @ResponseBody
    public Object saveEmpAccountInt(BasEmpAccount basEmpAccount) throws RemoteException {
        BasEmpAccount account = this.basEmpAccountService.findById(basEmpAccount.getAccountId());
        account = this.basEmpAccountService.saveBasEmpAccount(account);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f", basEmpAccount);
    }

    @RequestMapping(value={"/delEmpAccount"})
    @ResponseBody
    public Object delEmpAccount(String empAccountId) {
        BasEmpAccount basEmpAccount = this.basEmpAccountService.findEmpAccountById(Long.parseLong(empAccountId));
        basEmpAccount.setIsUse("N");
        this.basEmpAccountService.saveBasEmpAccount(basEmpAccount);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f", basEmpAccount);
    }

    @RequestMapping(value={"/setEmpAccountDefault"})
    @ResponseBody
    public Object setEmpAccountDefault(Long empAccountId) {
        this.basEmpAccountService.setEmpAccountDefault(empAccountId);
        return new JsonMsg(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"/queryEmpAccountById"})
    @ResponseBody
    public Object queryEmpAccountById(Long accountId) {
        BasEmpAccount account = this.basEmpAccountService.findEmpAccountById(accountId);
        return account;
    }

    @RequestMapping(value={"/queryAccountNameById"})
    @ResponseBody
    public Object queryEmpAccountById(String accountId) {
        String[] ids = accountId.split(",");
        String accountName = "";
        for (String id : ids) {
            BasEmpAccount account = this.basEmpAccountService.findEmpAccountById(Long.parseLong(id));
            if (account == null) continue;
            accountName = accountName + "," + account.getAccountName();
        }
        if (StringUtils.isNotBlank((CharSequence)accountName)) {
            accountName = accountName.substring(1);
        }
        return accountName;
    }

    @RequestMapping(value={"/pageall"})
    @ResponseBody
    public Object quertAllEmp(HttpServletRequest request, String filterDeptIds, Long orgidNew, Long orgid, Long deptid, Long processinstid, String toActId, String isCopy, String formCode, String isSort, String search, int page, int rows, @RequestParam(value="isViceStation", defaultValue="") String isViceStation, String showVisual, String roleId, String isHaveOrgAndRole, String selectPerson, String accountId, String notInAccountId) {
        return (PageObject)this.basEmpAccountService.pageall(filterDeptIds, orgidNew, orgid, deptid, processinstid, toActId, isCopy, formCode, search, page, rows, isViceStation, roleId, isHaveOrgAndRole, showVisual, accountId, isSort, selectPerson, notInAccountId);
    }

    @RequestMapping(value={"/getEmpStatisticsMap"})
    @ResponseBody
    public Map<String, Object> getEmpStatisticsMap() {
        return this.basEmpAccountService.getEmpStatisticsMap();
    }

    @RequestMapping(value={"/findByOrgOrBizId"})
    @ResponseBody
    public List findByOrgOrBizId(Long id, String search) {
        return this.basEmpAccountService.findByOrgOrBizIdnew(id, search);
    }

    @RequestMapping(value={"/findEmpAccountByAccountIds"})
    @ResponseBody
    public Object findEmpAccountByAccountIds(String accountIds) {
        JsonMsg msg = new JsonMsg();
        List<Map<String, Object>> data = this.basEmpAccountService.findEmpAccountByAccountIds(accountIds);
        msg.setO(data);
        return msg;
    }

    @RequestMapping(value={"/findEmpByAccountIds"})
    @ResponseBody
    public List<Map<String, Object>> findEmpByAccountIds(String accountIds) {
        return this.basEmpAccountService.findEmpByAccountIds(accountIds);
    }

    @RequestMapping(value={"/accountOrgTree"})
    @ResponseBody
    public Object accountOrgTree(Long processinstid, String toActId, String isCopy, String formCode, String particType, String treetype, Long orgId, String type, String showCancel) {
        return this.basEmpAccountService.accountOrgTree(processinstid, toActId, isCopy, formCode, particType, treetype, orgId, type, showCancel);
    }
}

