/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasDicType;
import com.guochuang.imp.base.service.BasDicService;
import com.guochuang.imp.base.service.BasDicTypeService;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/BasDicType"})
public class BasDicTypeController
extends BaseController {
    @Autowired
    private BasDicTypeService basdictypeService;
    @Autowired
    private BasDicService dicService;

    @RequestMapping(value={"/pageBasDicType"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasDicType(HttpServletRequest request, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order, Long businessTypeId) {
        return this.basdictypeService.PageAll(search, businessTypeId, page, rows, sort, order);
    }

    @RequestMapping(value={"/findBasDicType"})
    @ResponseBody
    public Object findBasDicType(Long id) {
        BasDicType entity = this.basdictypeService.findBasDicType(id);
        return entity;
    }

    @RequestMapping(value={"/saveBasDicType"})
    @ResponseBody
    public Object saveBasDicType(HttpServletRequest request, BasDicType entity) {
        JsonMsg msg = this.basdictypeService.checkRepeat(entity);
        if (msg.isSuccess()) {
            if (entity.getId() != null) {
                String disCode = entity.getDicCode();
                String disName = entity.getDicName();
                this.dicService.updateData(entity.getId(), disCode, disName);
            }
            entity.setModifyBy(this.getLoginUser(request).getAccountid().toString());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            this.basdictypeService.saveBasDicType(entity);
        }
        return msg;
    }

    @RequestMapping(value={"/delBasDicType"})
    @ResponseBody
    public Object delBasDicType(Long id) {
        this.basdictypeService.delBasDicType(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/pageDicType"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageDicType(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, boolean isContainUrl, boolean isContainColum) {
        return this.basdictypeService.pageDicType(search, page, rows);
    }

    @RequestMapping(value={"/exportDicTypeXml"})
    public void exportGenFormXml(String ids, HttpServletResponse response) {
        this.basdictypeService.exportDicTypeXml(ids, response);
    }

    @RequestMapping(value={"/importDicType"})
    @ResponseBody
    public Object importGenFormXml(MultipartHttpServletRequest multiRequest) {
        Iterator iter = multiRequest.getFileNames();
        JsonMsg msg = new JsonMsg();
        while (iter.hasNext()) {
            MultipartFile file = multiRequest.getFile((String)iter.next());
            try {
                InputStream inputStream = file.getInputStream();
                Throwable var6 = null;
                try {
                    InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
                    int ch = 0;
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((ch = ((Reader)reader).read()) != -1) {
                        stringBuffer.append((char)ch);
                    }
                    ((Reader)reader).close();
                    String jsonString = stringBuffer.toString();
                    msg = this.basdictypeService.importDicType(jsonString);
                }
                catch (Throwable var19) {
                    var6 = var19;
                    throw var19;
                }
                finally {
                    if (inputStream == null) continue;
                    if (var6 != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable var18) {
                            var6.addSuppressed(var18);
                        }
                        continue;
                    }
                    inputStream.close();
                }
            }
            catch (Exception var21) {
                msg = new JsonMsg(false, "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25");
            }
        }
        return msg;
    }
}

