/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.guochuang.imp.base.common.util.ComBoxTreeNode;
import com.guochuang.imp.base.common.util.JsonMsg;
import com.guochuang.imp.base.controller.BaseController;
import com.guochuang.imp.base.entity.BasBank;
import com.guochuang.imp.base.service.BasBankService;
import com.guochuang.imp.webservice.IQianZhanOrgService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasBank"})
public class BasBankController
extends BaseController {
    @Autowired
    private BasBankService basBankService;
    @Autowired(required=false)
    private IQianZhanOrgService qianZhanOrgService;

    @RequestMapping(value={"/pageBasBank"})
    @ResponseBody
    public Object pageBasBank(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sort, String order) {
        return this.basBankService.PageAll(search, page, rows, sort, order);
    }

    @RequestMapping(value={"/findBasBank"})
    @ResponseBody
    public Object findBasBank(Long id) {
        return this.basBankService.findBasBank(id);
    }

    @RequestMapping(value={"/saveBasBank"})
    @ResponseBody
    public Object saveBasBank(HttpServletRequest request, BasBank entity) {
        entity.setIsUse("Y");
        JsonMsg msg = this.basBankService.checkRepeat(entity);
        if (msg.isSuccess()) {
            this.basBankService.saveBasBank(entity);
            msg.setO(entity);
        }
        return msg;
    }

    @RequestMapping(value={"/delBasBank"})
    @ResponseBody
    public Object delBasBank(Long id) {
        BasBank entity = this.basBankService.findBasBank(id);
        entity.setIsUse("N");
        this.basBankService.saveBasBank(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeBasBankWithRoot"})
    @ResponseBody
    public Object treeBasBankWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid, String detailId, String bankType) {
        List<ComBoxTreeNode> treelist = this.basBankService.treeBasBank(pid, bankType, null);
        ComBoxTreeNode root = new ComBoxTreeNode();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
            root.setId(detailId.toString());
            BasBank entity = this.basBankService.findBasBank(Long.parseLong(detailId));
            root.setText(entity.getBankName());
            root.setChecked(true);
            list.add(root);
            return list;
        }
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasBank"})
    @ResponseBody
    public Object treeBasBank(@RequestParam(value="pid", defaultValue="0") Long pid, String bankType, String detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            ComBoxTreeNode root = new ComBoxTreeNode();
            BasBank b = this.basBankService.findBasBank(Long.parseLong(detailId));
            root.setId(b.getBankId() + "");
            root.setText(b.getBankName());
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basBankService.treeBasBank(pid, bankType, null);
    }

    @RequestMapping(value={"/treeBasBankWithDataType"})
    @ResponseBody
    public Object treeBasBankWithDataType(@RequestParam(value="pid", defaultValue="0") Long pid, String dataType, String detailId) {
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        if (StringUtils.isNotEmpty((String)detailId) && !detailId.equals("null")) {
            ComBoxTreeNode root = new ComBoxTreeNode();
            BasBank b = this.basBankService.findBasBank(Long.parseLong(detailId));
            root.setId(b.getBankId() + "");
            root.setText(b.getBankName());
            root.setChecked(true);
            list.add(root);
            return list;
        }
        return this.basBankService.treeBasBank(pid, null, dataType);
    }

    @RequestMapping(value={"/delBasBankAndChild"})
    @ResponseBody
    public Object delBasBankAndChild(Long id) {
        this.basBankService.delBasBankAndChild(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/getOrgInfoByName"})
    @ResponseBody
    public Object getOrgInfoByName(HttpServletRequest request, String name) {
        String msg = this.qianZhanOrgService.listOrgInfoByName(name);
        JSONObject obj = JSON.parseObject((String)msg);
        if (obj == null) {
            return new JsonMsg(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", null);
        }
        return new JsonMsg(true, "\u6570\u636e\u67e5\u8be2\u6210\u529f", obj.getJSONArray("result"));
    }
}

