/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util.exceltools;

import com.guochuang.imp.base.common.util.exceltools.TableColumn;
import com.guochuang.imp.base.common.util.exceltools.TableDataCell;
import com.guochuang.imp.base.common.util.exceltools.TableDataRow;
import com.guochuang.imp.base.common.util.exceltools.TableHeaderMetaData;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.List;

public class TableData {
    private static DecimalFormat format = new DecimalFormat("0.##");
    public static final int STYLE_TYPE_STRING = 0;
    public static final int STYLE_TYPE_FLOAT_2 = 1;
    public static final int STYLE_TYPE_FLOAT_3 = 2;
    public static final int STYLE_TYPE_INTEGER = 3;
    public static final int STYLE_TYPE_RED_BG = 10;
    public static final int STYLE_TYPE_YELLOW_BG = 11;
    public static final int STYLE_TYPE_GREEN_BG = 12;
    private String sheetTitle;
    private TableHeaderMetaData header;
    private LinkedList<TableDataRow> rows;
    private int totalRows;

    public TableData() {
    }

    public TableData(TableHeaderMetaData header) {
        this.header = header;
        this.rows = new LinkedList();
    }

    public void compute() {
        for (int i = 0; i < this.header.getColumnCount(); ++i) {
            TableColumn tc = this.header.getColumnAt(i);
            if (!tc.isVisible() || !tc.isGrouped() || !tc.isDisplaySummary()) continue;
            this.buildSummary(i);
        }
    }

    private TableDataRow buildNewRow(String key, int index) {
        int i;
        TableDataRow nrow = new TableDataRow(this);
        for (i = 0; i < index; ++i) {
            nrow.addCell("");
        }
        nrow.addCell("(" + key + ")\u5c0f\u8ba1");
        for (i = index + 1; i < this.header.getColumnCount(); ++i) {
            TableColumn thc = this.header.getColumnAt(i);
            if (thc.getAggregateRule() != null) {
                nrow.addCell(0);
                continue;
            }
            nrow.addCell("");
        }
        return nrow;
    }

    private void buildSummary(int index) {
        int i;
        LinkedList<SummaryData> lst = new LinkedList<SummaryData>();
        String okey = null;
        SummaryData sd = null;
        for (int j = 0; j < this.rows.size(); ++j) {
            Object value;
            TableColumn thc;
            int i2;
            TableDataRow row = this.rows.get(j);
            String key = row.getCellAt(index).getValue();
            if (okey == null) {
                okey = key;
                sd = new SummaryData();
                sd.key = key;
                sd.count = 0;
                sd.row = this.buildNewRow(key, index);
            }
            if (okey != null && !okey.equals(key)) {
                for (i2 = index; i2 < this.header.getColumnCount(); ++i2) {
                    thc = this.header.getColumnAt(i2);
                    if (thc.getAggregateRule() == null) continue;
                    value = sd.row.getCellAt(i2).getValue();
                    if ("avg".equalsIgnoreCase(thc.getAggregateRule())) {
                        if (sd.count > 0) {
                            sd.row.getCellAt(i2).setValue("\u5e73\u5747\uff1a" + format.format(Double.parseDouble((String)value) / (double)sd.count));
                            continue;
                        }
                        sd.row.getCellAt(i2).setValue("\u5e73\u5747\uff1a0");
                        continue;
                    }
                    if ("max".equalsIgnoreCase(thc.getAggregateRule())) {
                        sd.row.getCellAt(i2).setValue("\u6700\u5927\u503c\uff1a" + (String)value);
                        continue;
                    }
                    if ("min".equalsIgnoreCase(thc.getAggregateRule())) {
                        sd.row.getCellAt(i2).setValue("\u6700\u5c0f\u503c\uff1a" + (String)value);
                        continue;
                    }
                    if ("sum".equalsIgnoreCase(thc.getAggregateRule())) {
                        sd.row.getCellAt(i2).setValue("\u6c42\u548c\uff1a" + (String)value);
                        continue;
                    }
                    if (!"count".equalsIgnoreCase(thc.getAggregateRule())) continue;
                    sd.row.getCellAt(i2).setValue("\u5171" + (String)value + "\u884c");
                }
                sd.index = j;
                lst.add(sd);
                okey = key;
                sd = new SummaryData();
                sd.key = key;
                sd.count = 0;
                sd.row = this.buildNewRow(key, index);
            }
            ++sd.count;
            for (i2 = index + 1; i2 < this.header.getColumnCount(); ++i2) {
                thc = this.header.getColumnAt(i2);
                if (thc.getColumnType() == 4 || thc.getAggregateRule() == null) continue;
                value = Double.parseDouble(sd.row.getCellAt(i2).getValue());
                Double cellValue = null;
                try {
                    cellValue = Double.valueOf(row.getCellAt(i2).getValue());
                }
                catch (NumberFormatException e) {
                    cellValue = null;
                }
                if (cellValue == null) continue;
                if ("max".equalsIgnoreCase(thc.getAggregateRule())) {
                    if ((Double)value < cellValue) {
                        value = cellValue;
                    }
                } else if ("min".equalsIgnoreCase(thc.getAggregateRule())) {
                    if ((Double)value > cellValue) {
                        value = cellValue;
                    }
                } else if ("count".equalsIgnoreCase(thc.getAggregateRule())) {
                    Object object = value;
                    value = (Double)value + 1.0;
                    Double d = value;
                } else if ("sum".equalsIgnoreCase(thc.getAggregateRule())) {
                    value = (Double)value + cellValue;
                } else if ("avg".equalsIgnoreCase(thc.getAggregateRule())) {
                    value = (Double)value + cellValue;
                }
                sd.row.getCellAt(i2).setValue(format.format(value));
            }
        }
        if (sd != null) {
            for (i = index; i < this.header.getColumnCount(); ++i) {
                TableColumn thc = this.header.getColumnAt(i);
                if (thc.getAggregateRule() == null) continue;
                String value = sd.row.getCellAt(i).getValue();
                if ("avg".equalsIgnoreCase(thc.getAggregateRule())) {
                    if (sd.count > 0) {
                        sd.row.getCellAt(i).setValue("\u5e73\u5747\uff1a" + format.format(Double.parseDouble(value) / (double)sd.count));
                        continue;
                    }
                    sd.row.getCellAt(i).setValue("\u5e73\u5747\uff1a0");
                    continue;
                }
                if ("max".equalsIgnoreCase(thc.getAggregateRule())) {
                    sd.row.getCellAt(i).setValue("\u6700\u5927\u503c\uff1a" + value);
                    continue;
                }
                if ("min".equalsIgnoreCase(thc.getAggregateRule())) {
                    sd.row.getCellAt(i).setValue("\u6700\u5c0f\u503c\uff1a" + value);
                    continue;
                }
                if ("sum".equalsIgnoreCase(thc.getAggregateRule())) {
                    sd.row.getCellAt(i).setValue("\u6c42\u548c\uff1a" + value);
                    continue;
                }
                if (!"count".equalsIgnoreCase(thc.getAggregateRule())) continue;
                sd.row.getCellAt(i).setValue("\u5171" + value + "\u884c");
            }
            lst.add(sd);
            sd.index = this.rows.size();
        }
        for (i = 0; i < lst.size(); ++i) {
            SummaryData sda = (SummaryData)lst.get(i);
            this.rows.add(sda.index + i, sda.row);
        }
    }

    public TableHeaderMetaData getTableHeader() {
        return this.header;
    }

    public void addRow(TableDataRow row) {
        this.rows.add(row);
    }

    public List<TableDataRow> getRows() {
        return this.rows;
    }

    public TableDataRow getRowAt(int index) {
        return this.rows.get(index);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public void setHeader(TableHeaderMetaData header) {
        this.header = header;
    }

    public void setRows(LinkedList<TableDataRow> rows) {
        this.rows = rows;
    }

    public String getSheetTitle() {
        return this.sheetTitle;
    }

    public void setSheetTitle(String sheetTitle) {
        this.sheetTitle = sheetTitle;
    }

    class SummaryData {
        String key;
        int index;
        int count;
        TableDataRow row;

        SummaryData() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.key).append("\t").append(this.index).append("\t").append(this.count).append("\t");
            for (TableDataCell cell : this.row.getCells()) {
                sb.append(cell.getValue()).append("\t");
            }
            return sb.toString();
        }
    }
}

