/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util.excel;

import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.common.util.excel.ExcelExportBean;
import com.guochuang.imp.base.common.util.excel.ExcelExportCol;
import com.guochuang.imp.base.common.util.excel.ExcelExportMutlCol;
import com.guochuang.imp.util.DateUtil;
import com.guochuang.imp.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.ObjectUtils;

public class ExcelExportUtil {
    private static final int DEFAULT_TITLE_HEIGHT = 30;
    private static final int DEFAULT_HEIGHT = 16;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void export(List<Map<String, Object>> dataList, List<ExcelExportCol> cols, ExcelExportBean excelBean, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int defaultHeight = excelBean.getDefaultHeight() == 0 ? 16 : excelBean.getDefaultHeight();
        int defaultWidth = excelBean.getDefaultWith() == 0 ? 12 : excelBean.getDefaultWith();
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        XSSFSheet sheet = xssfWorkbook.createSheet(excelBean.getSheetName());
        for (int i = 0; i < cols.size(); ++i) {
            if (cols.get(i).getColWidth() == 0) continue;
            int width = cols.get(i).getColWidth() == 0 ? defaultWidth : cols.get(i).getColWidth();
            sheet.setColumnWidth(i, 256 * width);
        }
        if (!StringUtil.isEmpty(excelBean.getTitle())) {
            ExcelExportUtil.addTitle(xssfWorkbook, sheet, excelBean.getTitle(), cols.size());
        }
        XSSFCellStyle headStyle = xssfWorkbook.createCellStyle();
        XSSFFont headFont = xssfWorkbook.createFont();
        headFont.setBold(true);
        headFont.setFontName("\u5b8b\u4f53");
        headFont.setFontHeightInPoints((short)12);
        headStyle.setFont((Font)headFont);
        headStyle.setAlignment(HorizontalAlignment.CENTER);
        headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headStyle.setBorderBottom(BorderStyle.THIN);
        headStyle.setBorderLeft(BorderStyle.THIN);
        headStyle.setBorderTop(BorderStyle.THIN);
        headStyle.setBorderRight(BorderStyle.THIN);
        List<ExcelExportMutlCol> mulCols = excelBean.getMutlCols();
        if (!ObjectUtils.isEmpty(mulCols)) {
            ExcelExportUtil.mutlHeader(mulCols, sheet, headStyle, sheet.getLastRowNum() + 1, defaultHeight);
        }
        XSSFRow headerRow = sheet.createRow(sheet.getLastRowNum() + 1);
        for (int i = 0; i < cols.size(); ++i) {
            XSSFCell cell = headerRow.createCell(i);
            cell.setCellValue(cols.get(i).getColTitle());
            cell.setCellStyle((CellStyle)headStyle);
        }
        headerRow.setHeight((short)(20 * defaultHeight));
        int bodyStartRow = sheet.getLastRowNum() + 1;
        XSSFCellStyle bodyStyle = xssfWorkbook.createCellStyle();
        XSSFFont bodyFont = xssfWorkbook.createFont();
        bodyFont.setFontName("\u5b8b\u4f53");
        bodyStyle.setWrapText(true);
        bodyStyle.setFont((Font)bodyFont);
        bodyStyle.setBorderBottom(BorderStyle.THIN);
        bodyStyle.setBorderLeft(BorderStyle.THIN);
        bodyStyle.setBorderTop(BorderStyle.THIN);
        bodyStyle.setBorderRight(BorderStyle.THIN);
        if (!ObjectUtils.isEmpty(dataList)) {
            for (Map<String, Object> data : dataList) {
                XSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
                for (int i = 0; i < cols.size(); ++i) {
                    XSSFCell cell = row.createCell(i);
                    Object cellVal = data.get(cols.get(i).getColName());
                    int dataType = cols.get(i).getDataType();
                    if (dataType == 1 || StringUtil.null2String(cellVal).startsWith("=")) {
                        String cellValue = StringUtil.null2String(cellVal);
                        cell.setCellValue(cellValue.replace("&nbsp;", " "));
                    } else if (dataType == 2) {
                        cell.setCellValue(StringUtil.str2Double(cellVal));
                    } else if (dataType == 3) {
                        cell.setCellValue(DateUtil.formatDate(cellVal));
                    } else if (dataType == 4) {
                        cell.setCellValue(DateUtil.formatDateTime(cellVal));
                    }
                    cell.setCellStyle((CellStyle)bodyStyle);
                }
                row.setHeight((short)(20 * defaultHeight));
            }
        }
        if (!ObjectUtils.isEmpty((Object)excelBean.getMergeCols())) {
            if ("2".equals(excelBean.getMergeType())) {
                ExcelExportUtil.mergeRowMutli(dataList, cols, excelBean.getMergeCols(), sheet, bodyStartRow);
            } else {
                ExcelExportUtil.mergeRow(dataList, cols, excelBean.getMergeCols(), sheet, bodyStartRow);
            }
        }
        ExcelExportUtil.freeze(excelBean, sheet, cols, bodyStartRow);
        ServletOutputStream output = null;
        try {
            output = response.getOutputStream();
            response.reset();
            String fileName = SysUtils.getUrlFileName(request, excelBean.getFileName() + ".xlsx");
            response.setHeader("Content-disposition", "attachment; filename=" + fileName);
            response.setContentType("application/msexcel");
            xssfWorkbook.write((OutputStream)output);
        }
        finally {
            if (xssfWorkbook != null) {
                xssfWorkbook.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportManySheet(List<ExcelExportBean> excelBeanList, HttpServletRequest request, HttpServletResponse response, String fileName, Boolean isNeedZero) throws IOException {
        XSSFWorkbook xssfWorkbook = new XSSFWorkbook();
        excelBeanList.forEach(excelBean -> {
            int defaultHeight = excelBean.getDefaultHeight() == 0 ? 16 : excelBean.getDefaultHeight();
            int defaultWidth = excelBean.getDefaultWith() == 0 ? 12 : excelBean.getDefaultWith();
            List<Map<String, Object>> dataList = excelBean.getDataList();
            List<ExcelExportCol> cols = excelBean.getCols();
            XSSFSheet sheet = xssfWorkbook.createSheet(excelBean.getSheetName());
            for (int i = 0; i < cols.size(); ++i) {
                if (cols.get(i).getColWidth() == 0) continue;
                int width = cols.get(i).getColWidth() == 0 ? defaultWidth : cols.get(i).getColWidth();
                sheet.setColumnWidth(i, 256 * width);
            }
            if (!StringUtil.isEmpty(excelBean.getTitle())) {
                ExcelExportUtil.addTitleAndSubsidiaryName(xssfWorkbook, sheet, excelBean.getTitle(), excelBean.getSubsidiaryName(), cols.size());
            }
            if (!StringUtil.isEmpty(excelBean.getLeftTitle()) && !StringUtil.isEmpty(excelBean.getRightTitle())) {
                ExcelExportUtil.addTitleInfo(xssfWorkbook, sheet, excelBean.getLeftTitle(), excelBean.getRightTitle(), cols.size());
            }
            XSSFCellStyle headStyle = xssfWorkbook.createCellStyle();
            XSSFFont headFont = xssfWorkbook.createFont();
            headFont.setBold(true);
            headFont.setFontName("\u5b8b\u4f53");
            headFont.setFontHeightInPoints((short)12);
            headStyle.setFont((Font)headFont);
            headStyle.setAlignment(HorizontalAlignment.CENTER);
            headStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            headStyle.setBorderBottom(BorderStyle.THIN);
            headStyle.setBorderLeft(BorderStyle.THIN);
            headStyle.setBorderTop(BorderStyle.THIN);
            headStyle.setBorderRight(BorderStyle.THIN);
            XSSFDataFormat dataFormat = xssfWorkbook.createDataFormat();
            short percentFormat = dataFormat.getFormat("0.00%");
            List<ExcelExportMutlCol> mulCols = excelBean.getMutlCols();
            if (!ObjectUtils.isEmpty(mulCols)) {
                ExcelExportUtil.mutlHeader(mulCols, sheet, headStyle, sheet.getLastRowNum() + 1, defaultHeight);
            }
            XSSFRow headerRow = sheet.createRow(sheet.getLastRowNum() + 1);
            for (int i = 0; i < cols.size(); ++i) {
                XSSFCell cell = headerRow.createCell(i);
                cell.setCellValue(cols.get(i).getColTitle());
                cell.setCellStyle((CellStyle)headStyle);
            }
            headerRow.setHeight((short)(20 * defaultHeight));
            int bodyStartRow = sheet.getLastRowNum() + 1;
            XSSFCellStyle bodyStyle = xssfWorkbook.createCellStyle();
            XSSFFont bodyFont = xssfWorkbook.createFont();
            bodyFont.setFontName("\u5b8b\u4f53");
            bodyStyle.setWrapText(true);
            bodyStyle.setFont((Font)bodyFont);
            bodyStyle.setBorderBottom(BorderStyle.THIN);
            bodyStyle.setBorderLeft(BorderStyle.THIN);
            bodyStyle.setBorderTop(BorderStyle.THIN);
            bodyStyle.setBorderRight(BorderStyle.THIN);
            XSSFCellStyle decimalStyle = xssfWorkbook.createCellStyle();
            decimalStyle.setWrapText(true);
            decimalStyle.setFont((Font)bodyFont);
            decimalStyle.setBorderBottom(BorderStyle.THIN);
            decimalStyle.setBorderLeft(BorderStyle.THIN);
            decimalStyle.setBorderTop(BorderStyle.THIN);
            decimalStyle.setBorderRight(BorderStyle.THIN);
            decimalStyle.setDataFormat(xssfWorkbook.createDataFormat().getFormat("0.00"));
            if (!ObjectUtils.isEmpty(dataList)) {
                for (Map<String, Object> data : dataList) {
                    XSSFRow row = sheet.createRow(sheet.getLastRowNum() + 1);
                    for (int i = 0; i < cols.size(); ++i) {
                        XSSFCell cell = row.createCell(i);
                        Object cellVal = data.get(cols.get(i).getColName());
                        int dataType = cols.get(i).getDataType();
                        cell.setCellStyle((CellStyle)bodyStyle);
                        if (StringUtil.null2String(cellVal).startsWith("=")) {
                            String cellFormula = cellVal.toString().substring(1);
                            XSSFFormulaEvaluator formulaEvaluator = xssfWorkbook.getCreationHelper().createFormulaEvaluator();
                            cell.setCellFormula(cellFormula);
                            CellValue formulaValue = formulaEvaluator.evaluate((Cell)cell);
                            cell.setCellFormula(null);
                            cell.setCellValue(formulaValue.getNumberValue());
                        } else if (dataType == 1 || StringUtil.null2String(cellVal).startsWith("=")) {
                            String cellValue = StringUtil.null2String(cellVal);
                            cellValue = cellValue.trim();
                            cell.setCellValue(cellValue.replace("&nbsp;", " "));
                        } else if (dataType == 2 || dataType == 22) {
                            if (StringUtil.str2Double(cellVal) == 0.0 && !isNeedZero.booleanValue()) {
                                cell.setCellValue("");
                            } else {
                                cell.setCellValue(StringUtil.str2Double(cellVal));
                            }
                        } else if (dataType == 3) {
                            cell.setCellValue(DateUtil.formatDate(cellVal));
                        } else if (dataType == 4) {
                            cell.setCellValue(DateUtil.formatDateTime(cellVal));
                        } else if (dataType == 5) {
                            cell.setCellStyle((CellStyle)decimalStyle);
                            cell.setCellValue(StringUtil.str2Double(cellVal));
                        }
                        ExcelExportCol exportCol = cols.get(i);
                        if (exportCol.getDataType() != 22) continue;
                        XSSFCellStyle percentStyle = xssfWorkbook.createCellStyle();
                        percentStyle.cloneStyleFrom((CellStyle)bodyStyle);
                        percentStyle.setDataFormat(percentFormat);
                        try {
                            double value = cell.getNumericCellValue();
                            cell.setCellValue(value / 100.0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        cell.setCellStyle((CellStyle)percentStyle);
                    }
                    row.setHeight((short)(20 * defaultHeight));
                }
            }
            if (!ObjectUtils.isEmpty((Object)excelBean.getMergeCols())) {
                if ("2".equals(excelBean.getMergeType())) {
                    ExcelExportUtil.mergeRowMutli(dataList, cols, excelBean.getMergeCols(), sheet, bodyStartRow);
                } else {
                    ExcelExportUtil.mergeRow(dataList, cols, excelBean.getMergeCols(), sheet, bodyStartRow);
                }
            }
            ExcelExportUtil.freeze(excelBean, sheet, cols, bodyStartRow);
            sheet.setForceFormulaRecalculation(true);
        });
        ServletOutputStream output = null;
        try {
            output = response.getOutputStream();
            response.reset();
            String name = SysUtils.getUrlFileName(request, fileName + ".xlsx");
            response.setHeader("Content-disposition", "attachment; filename=" + name);
            response.setContentType("application/msexcel");
            xssfWorkbook.write((OutputStream)output);
        }
        finally {
            if (xssfWorkbook != null) {
                xssfWorkbook.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    private static void addTitle(XSSFWorkbook xssfWorkbook, XSSFSheet sheet, String title, int colLen) {
        XSSFCellStyle titleStyle = xssfWorkbook.createCellStyle();
        XSSFFont titleFont = xssfWorkbook.createFont();
        titleFont.setFontName("\u5b8b\u4f53");
        titleFont.setBold(true);
        titleFont.setFontHeightInPoints((short)14);
        titleStyle.setFont((Font)titleFont);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFRow titleRow = sheet.createRow(0);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(title);
        titleCell.setCellStyle((CellStyle)titleStyle);
        CellRangeAddress titleRegion = new CellRangeAddress(0, 0, 0, colLen - 1);
        sheet.addMergedRegion(titleRegion);
        titleRow.setHeight((short)600);
    }

    private static void addTitleAndSubsidiaryName(XSSFWorkbook xssfWorkbook, XSSFSheet sheet, String title, String subsidiaryName, int colLen) {
        XSSFCellStyle titleStyle1 = xssfWorkbook.createCellStyle();
        XSSFFont titleFont1 = xssfWorkbook.createFont();
        titleFont1.setFontName("\u5b8b\u4f53");
        titleFont1.setFontHeightInPoints((short)12);
        titleStyle1.setFont((Font)titleFont1);
        titleStyle1.setAlignment(HorizontalAlignment.LEFT);
        XSSFRow titleRow1 = sheet.createRow(0);
        XSSFCell titleCell1 = titleRow1.createCell(0);
        titleCell1.setCellValue(StringUtil.isNotEmpty(subsidiaryName) ? subsidiaryName : "");
        titleCell1.setCellStyle((CellStyle)titleStyle1);
        titleRow1.setHeight((short)300);
        XSSFCellStyle titleStyle = xssfWorkbook.createCellStyle();
        XSSFFont titleFont = xssfWorkbook.createFont();
        titleFont.setFontName("\u5b8b\u4f53");
        titleFont.setBold(true);
        titleFont.setFontHeightInPoints((short)14);
        titleStyle.setFont((Font)titleFont);
        titleStyle.setAlignment(HorizontalAlignment.CENTER);
        titleStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        XSSFRow titleRow = sheet.createRow(1);
        XSSFCell titleCell = titleRow.createCell(0);
        titleCell.setCellValue(title);
        titleCell.setCellStyle((CellStyle)titleStyle);
        CellRangeAddress titleRegion = new CellRangeAddress(1, 1, 0, colLen - 1);
        sheet.addMergedRegion(titleRegion);
        titleRow.setHeight((short)600);
    }

    private static void addTitleInfo(XSSFWorkbook xssfWorkbook, XSSFSheet sheet, String leftTitle, String rightTitle, int colLen) {
        XSSFCellStyle titleStyle1 = xssfWorkbook.createCellStyle();
        int centerLen = colLen / 2;
        XSSFFont titleFont = xssfWorkbook.createFont();
        titleFont.setFontName("\u5b8b\u4f53");
        titleFont.setFontHeightInPoints((short)12);
        titleStyle1.setFont((Font)titleFont);
        titleStyle1.setAlignment(HorizontalAlignment.LEFT);
        XSSFCellStyle titleStyle2 = xssfWorkbook.createCellStyle();
        titleStyle2.setFont((Font)titleFont);
        titleStyle2.setAlignment(HorizontalAlignment.RIGHT);
        XSSFRow titleRow = sheet.createRow(2);
        XSSFCell cell1 = titleRow.createCell(0);
        cell1.setCellValue(leftTitle);
        cell1.setCellStyle((CellStyle)titleStyle1);
        if (centerLen - 1 > 1) {
            sheet.addMergedRegion(new CellRangeAddress(2, 2, 0, centerLen - 1));
        }
        XSSFCell cell2 = titleRow.createCell(centerLen);
        cell2.setCellValue(rightTitle);
        cell2.setCellStyle((CellStyle)titleStyle2);
        titleRow.setHeight((short)450);
        sheet.addMergedRegion(new CellRangeAddress(2, 2, centerLen, colLen - 1));
    }

    private static void mutlHeader(List<ExcelExportMutlCol> mulCols, XSSFSheet sheet, XSSFCellStyle headStyle, int startRow, int defaultHeight) {
        XSSFRow row = sheet.createRow(startRow);
        row.setHeight((short)(20 * defaultHeight));
        int firstCol = 0;
        int lastCol = -1;
        for (int i = 0; i < mulCols.size(); ++i) {
            ExcelExportMutlCol col = mulCols.get(i);
            firstCol = lastCol + 1;
            lastCol = firstCol + col.getColSpan() - 1;
            for (int j = firstCol; j <= lastCol; ++j) {
                XSSFCell cell = row.createCell(j);
                cell.setCellValue(col.getColTitle());
                cell.setCellStyle((CellStyle)headStyle);
            }
            if (startRow == startRow + col.getRowSpan() - 1 && firstCol == lastCol) continue;
            CellRangeAddress mutlheaderRegion = new CellRangeAddress(startRow, startRow + col.getRowSpan() - 1, firstCol, lastCol);
            sheet.addMergedRegion(mutlheaderRegion);
        }
    }

    private static int getColIndex(List<ExcelExportCol> cols, String colName) {
        for (int j = 0; j < cols.size(); ++j) {
            if (!colName.equals(cols.get(j).getColName())) continue;
            return j;
        }
        return 0;
    }

    private static void mergeRow(List<Map<String, Object>> dataList, List<ExcelExportCol> cols, String mergeCol, XSSFSheet sheet, int bodyStartRow) {
        String[] mergeCols = mergeCol.split(",");
        int[] mergeColIndexs = new int[mergeCols.length];
        for (int i = 0; i < mergeColIndexs.length; ++i) {
            mergeColIndexs[i] = ExcelExportUtil.getColIndex(cols, mergeCols[i]);
        }
        String groupCol = mergeCols[0];
        if (StringUtil.isNotEmpty(dataList.get(0).get(groupCol))) {
            String groupVal = dataList.get(0).get(groupCol).toString();
            int startRow = bodyStartRow;
            int endRow = 0;
            int index = 0;
            for (Map<String, Object> map : dataList) {
                if (StringUtil.isEmpty(map.get(groupCol))) {
                    endRow = startRow + index - 1;
                    if (index > 1) {
                        for (int mergeColIndex : mergeColIndexs) {
                            CellRangeAddress mutlheaderRegion = new CellRangeAddress(startRow, endRow, mergeColIndex, mergeColIndex);
                            sheet.addMergedRegion(mutlheaderRegion);
                        }
                    }
                    startRow = endRow + 1;
                    index = 0;
                    groupVal = "";
                } else {
                    String tmpVal = map.get(groupCol).toString();
                    if (!groupVal.equals(tmpVal)) {
                        endRow = startRow + index - 1;
                        if (index > 1) {
                            for (int mergeColIndex : mergeColIndexs) {
                                CellRangeAddress mutlheaderRegion = new CellRangeAddress(startRow, endRow, mergeColIndex, mergeColIndex);
                                sheet.addMergedRegion(mutlheaderRegion);
                            }
                        }
                        startRow = endRow + 1;
                        index = 0;
                        groupVal = tmpVal;
                    }
                }
                ++index;
            }
            endRow = startRow + index - 1;
            if (index > 1) {
                for (Object mergeColIndex : (Object)mergeColIndexs) {
                    CellRangeAddress mutlheaderRegion = new CellRangeAddress(startRow, endRow, (int)mergeColIndex, (int)mergeColIndex);
                    sheet.addMergedRegion(mutlheaderRegion);
                }
            }
        }
    }

    private static void mergeRowMutli(List<Map<String, Object>> dataList, List<ExcelExportCol> cols, String mergeCol, XSSFSheet sheet, int bodyStartRow) {
        String[] mergeCols = mergeCol.split(",");
        for (int i = 0; i < mergeCols.length; ++i) {
            int mergeColIndex = ExcelExportUtil.getColIndex(cols, mergeCols[i]);
            String groupCol = mergeCols[i];
            if (!StringUtil.isNotEmpty(dataList.get(0).get(groupCol))) continue;
            String groupVal = dataList.get(0).get(groupCol).toString();
            int startRow = bodyStartRow;
            int endRow = 0;
            int index = 0;
            for (Map<String, Object> map : dataList) {
                if (StringUtil.isEmpty(map.get(groupCol))) {
                    endRow = startRow + index - 1;
                    if (index > 1) {
                        CellRangeAddress mutlheaderRegion = new CellRangeAddress(startRow, endRow, mergeColIndex, mergeColIndex);
                        sheet.addMergedRegion(mutlheaderRegion);
                    }
                    startRow = endRow + 1;
                    index = 0;
                    groupVal = "";
                } else {
                    String tmpVal = map.get(groupCol).toString();
                    if (!groupVal.equals(tmpVal)) {
                        endRow = startRow + index - 1;
                        if (index > 1) {
                            CellRangeAddress mutlheaderRegion = new CellRangeAddress(startRow, endRow, mergeColIndex, mergeColIndex);
                            sheet.addMergedRegion(mutlheaderRegion);
                        }
                        startRow = endRow + 1;
                        index = 0;
                        groupVal = tmpVal;
                    }
                }
                ++index;
            }
            endRow = startRow + index - 1;
            if (index <= 1) continue;
            CellRangeAddress mutlheaderRegion = new CellRangeAddress(startRow, endRow, mergeColIndex, mergeColIndex);
            sheet.addMergedRegion(mutlheaderRegion);
        }
    }

    private static void freeze(ExcelExportBean excelBean, XSSFSheet sheet, List<ExcelExportCol> cols, int bodyStartRow) {
        int colCount = 0;
        int startCol = 1;
        if (!ObjectUtils.isEmpty((Object)excelBean.getFreezeCols())) {
            String[] freezeCols = excelBean.getFreezeCols().split(",");
            colCount = freezeCols.length;
            startCol = ExcelExportUtil.getColIndex(cols, freezeCols[0]) + 1;
        }
        int rowCount = 0;
        int startRow = 1;
        if (excelBean.isFreezeColHeader()) {
            rowCount = bodyStartRow;
        }
        if (colCount > 0 || rowCount > 0) {
            sheet.createFreezePane(colCount, rowCount, startCol, startRow);
        }
    }

    public static void main(String[] args) {
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", "\u9f99\u751f");
        map.put("code1", "\u9f991");
        map.put("code2", "\u9f992");
        map.put("memo", "\u5907\u6ce8");
        map.put("code3", "\u9f993");
        map.put("code4", "\u9f994");
        dataList.add(map);
        ArrayList<ExcelExportCol> cols = new ArrayList<ExcelExportCol>();
        cols.add(new ExcelExportCol("userName", "\u59d3\u540d"));
        cols.add(new ExcelExportCol("code1", "\u7f16\u78011"));
        cols.add(new ExcelExportCol("code2", "\u7f16\u78012"));
        cols.add(new ExcelExportCol("memo", "\u5907\u6ce8"));
        cols.add(new ExcelExportCol("code3", "\u7f16\u78013"));
        cols.add(new ExcelExportCol("code4", "\u7f16\u78014"));
        ExcelExportBean excelBean = new ExcelExportBean();
        excelBean.setTitle("\u6d4b\u8bd5");
        ArrayList<ExcelExportMutlCol> mutlCols = new ArrayList<ExcelExportMutlCol>();
        mutlCols.add(new ExcelExportMutlCol("\u59d3\u540d", 1, 2));
        mutlCols.add(new ExcelExportMutlCol("\u7f16\u780112", 2, 1));
        mutlCols.add(new ExcelExportMutlCol("\u5907\u6ce8", 1, 2));
        mutlCols.add(new ExcelExportMutlCol("\u7f16\u780134", 2, 1));
        excelBean.setMutlCols(mutlCols);
        try {
            ExcelExportUtil.export(dataList, cols, excelBean, null, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

