/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import com.guochuang.imp.base.common.util.ValueText;
import com.guochuang.imp.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;

public class MemCache {
    public static Map<String, List<ValueText>> dicMap;
    public static Map<Long, String> orgMap;
    public static Map<Long, String> orgAbbrMap;
    public static Map<Long, String> deptMap;
    public static Map<Long, String> deptAbbrMap;
    public static Map<Long, String> empAccountMap;
    public static Map<Long, String> hrEmpMap;
    public static Map<String, String> SysConfigMap;

    public static String getDicText(String dicCode, String dicValue) {
        if (StringUtil.isEmpty(dicValue)) {
            return "";
        }
        List<ValueText> list = dicMap.get(dicCode);
        if (ObjectUtils.isEmpty(list)) {
            return "";
        }
        String dicText = "";
        if (dicValue.contains(",")) {
            String[] dicValues = dicValue.split(",");
            ArrayList<String> dicTexts = new ArrayList<String>();
            block0: for (ValueText valText : list) {
                for (String dicVal : dicValues) {
                    if (!valText.getValue().equals(dicVal)) continue;
                    dicTexts.add(valText.getText());
                    continue block0;
                }
            }
            dicText = StringUtils.join(dicTexts, (String)",");
        } else {
            for (ValueText valText : list) {
                if (!valText.getValue().equals(dicValue)) continue;
                dicText = valText.getText();
                break;
            }
        }
        return dicText;
    }

    public static String getOrgName(Long orgId) {
        if (orgId == null) {
            return "";
        }
        return orgMap.get(orgId);
    }

    public static String getOrgAbbr(Long orgId) {
        if (orgId == null) {
            return "";
        }
        return orgAbbrMap.get(orgId);
    }

    public static String getOrgAbbr(String orgIds) {
        if (StringUtil.isEmpty(orgIds)) {
            return "";
        }
        String[] orgIdArr = orgIds.split(",");
        ArrayList<String> orgNames = new ArrayList<String>();
        for (String orgId : orgIdArr) {
            orgNames.add(orgAbbrMap.get(Long.parseLong(orgId)));
        }
        return StringUtils.join(orgNames, (String)",");
    }

    public static String getConfigValue(String code) {
        if (code == null) {
            return "";
        }
        return SysConfigMap.get(code);
    }

    public static Set<String> getDicStrSet(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        List<ValueText> list = dicMap.get(code);
        if (ObjectUtils.isEmpty(list)) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        list.stream().map(ValueText::getValue).forEach(set::add);
        return set;
    }

    public static String getOrgName(String orgIds) {
        if (StringUtil.isEmpty(orgIds)) {
            return "";
        }
        String[] orgIdArr = orgIds.split(",");
        ArrayList<String> orgNames = new ArrayList<String>();
        for (String orgId : orgIdArr) {
            orgNames.add(orgMap.get(Long.parseLong(orgId)));
        }
        return StringUtils.join(orgNames, (String)",");
    }

    public static String getDeptName(Long deptId) {
        if (deptId == null) {
            return "";
        }
        return deptMap.get(deptId);
    }

    public static String getDeptName(String deptIds) {
        if (StringUtil.isEmpty(deptIds)) {
            return "";
        }
        String[] deptIdArr = deptIds.split(",");
        ArrayList<String> deptNames = new ArrayList<String>();
        for (String deptId : deptIdArr) {
            deptNames.add(deptMap.get(Long.parseLong(deptId)));
        }
        return StringUtils.join(deptNames, (String)",");
    }

    public static String getDeptAbbr(Long deptId) {
        if (deptId == null) {
            return "";
        }
        return deptAbbrMap.get(deptId);
    }

    public static String getDeptAbbr(String deptIds) {
        if (StringUtil.isEmpty(deptIds)) {
            return "";
        }
        String[] deptIdArr = deptIds.split(",");
        ArrayList<String> deptNames = new ArrayList<String>();
        for (String deptId : deptIdArr) {
            deptNames.add(deptAbbrMap.get(Long.parseLong(deptId)));
        }
        return StringUtils.join(deptNames, (String)",");
    }

    public static String getEmpAccountName(Long accountId) {
        if (accountId == null) {
            return "";
        }
        return empAccountMap.get(accountId);
    }

    public static String getEmpAccountName(String accountIds) {
        if (StringUtil.isEmpty(accountIds)) {
            return "";
        }
        String[] accountIdArr = accountIds.split(",");
        ArrayList<String> accountNames = new ArrayList<String>();
        for (String accountId : accountIdArr) {
            accountNames.add(empAccountMap.get(Long.parseLong(accountId)));
        }
        return StringUtils.join(accountNames, (String)",");
    }

    public static String getEmpName(Long hrEmpId) {
        if (hrEmpId == null) {
            return "";
        }
        return hrEmpMap.get(hrEmpId);
    }

    public static String getEmpName(String hrEmpIds) {
        if (StringUtil.isEmpty(hrEmpIds)) {
            return "";
        }
        String[] hrEmpIdArr = hrEmpIds.split(",");
        ArrayList<String> hrEmpNames = new ArrayList<String>();
        for (String hrEmpId : hrEmpIdArr) {
            hrEmpNames.add(hrEmpMap.get(Long.parseLong(hrEmpId)));
        }
        return StringUtils.join(hrEmpNames, (String)",");
    }
}

