/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import com.guochuang.imp.base.common.util.ComboxCheckNode;
import com.guochuang.imp.base.common.util.ComboxNode;
import com.guochuang.imp.base.entity.BasDic;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ComboxUtils {
    public static List<ComboxNode> dictoCombo(List<BasDic> list) {
        ArrayList<ComboxNode> nodelist = new ArrayList<ComboxNode>();
        for (BasDic dic : list) {
            ComboxNode node = new ComboxNode();
            node.setId(dic.getDicId().toString());
            node.setText(dic.getDicText());
            node.setValue(dic.getDicValue());
            node.setDesc(dic.getMemo());
            nodelist.add(node);
        }
        return nodelist;
    }

    public static List<ComboxNode> dictoComboWithDefault(List<BasDic> list) {
        ArrayList<ComboxNode> nodelist = new ArrayList<ComboxNode>();
        for (BasDic dic : list) {
            ComboxNode node = new ComboxNode();
            node.setId(dic.getDicId().toString());
            node.setText(dic.getDicText());
            node.setValue(dic.getDicValue());
            node.setDesc(dic.getMemo());
            if (dic.getIsDefault() != null && dic.getIsDefault() == 1L) {
                node.setSelected(true);
            }
            nodelist.add(node);
        }
        return nodelist;
    }

    public static List<ComboxCheckNode> buildComboxCheckNodes(List list) {
        ArrayList<ComboxCheckNode> nodelist = new ArrayList<ComboxCheckNode>();
        for (Object o : list) {
            Map row = (Map)o;
            ComboxCheckNode comboxCheckNode = new ComboxCheckNode();
            ComboxUtils.fillNodeProperty(comboxCheckNode, row);
            nodelist.add(comboxCheckNode);
        }
        return nodelist;
    }

    public static List<ComboxNode> buildComboxNodes(List list) {
        DefineNode defineNode = new DefineNode();
        ArrayList<ComboxNode> nodelist = new ArrayList<ComboxNode>();
        for (Object o : list) {
            Map row = (Map)o;
            ComboxNode node = new ComboxNode();
            ComboxUtils.fillNodeProperty(node, row, defineNode);
            nodelist.add(node);
        }
        return nodelist;
    }

    public static List<ComboxNode> buildComboxNodes(List list, DefineNode defineNode) {
        ArrayList<ComboxNode> nodelist = new ArrayList<ComboxNode>();
        for (Object o : list) {
            Map row = (Map)o;
            ComboxNode node = new ComboxNode();
            ComboxUtils.fillNodeProperty(node, row, defineNode);
            nodelist.add(node);
        }
        return nodelist;
    }

    public static ComboxNode fillNodeProperty(ComboxNode node, Map row, DefineNode defineNode) {
        node.setId(row.get(defineNode.id) == null ? "" : row.get(defineNode.id).toString());
        node.setText(row.get(defineNode.text) == null ? "" : row.get(defineNode.text).toString());
        node.setValue(row.get(defineNode.value) == null ? "" : row.get(defineNode.value).toString());
        node.setGroup(row.get(defineNode.group) == null ? "" : row.get(defineNode.group).toString());
        node.setDesc(row.get(defineNode.desc) == null ? "" : row.get(defineNode.desc).toString());
        node.setSelected(row.get(defineNode.selected) == null ? false : Boolean.valueOf(row.get(defineNode.selected).toString()));
        for (Map.Entry entry : row.entrySet()) {
            String keystr = entry.getKey().toString().toLowerCase();
            node.addAttributes(keystr, row.get(entry.getKey()));
        }
        return node;
    }

    public static ComboxCheckNode fillNodeProperty(ComboxCheckNode node, Map row) {
        node.setId(row.get("id") == null ? "" : row.get("id").toString());
        node.setText(row.get("text") == null ? "" : row.get("text").toString());
        node.setValue(row.get("value") == null ? "" : row.get("value").toString());
        node.setChecked(row.get("checked") == null ? false : Boolean.valueOf(row.get("checked").toString()));
        for (Map.Entry entry : row.entrySet()) {
            String keystr = entry.getKey().toString().toLowerCase();
            node.addAttributes(keystr, row.get(entry.getKey()));
        }
        return node;
    }

    public static class DefineNode {
        public String id = "ID";
        public String text = "TEXT";
        public String value = "VALUE";
        public String group = "GROUP";
        public String desc = "DESCRIPTION";
        public String selected = "SELECTED";
    }
}

