/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import com.guochuang.imp.base.common.util.LayuiPageObject;
import com.guochuang.imp.base.common.util.PageObject;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.gen.util.DBPropertyUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.engine.PageQuery;
import org.hibernate.engine.spi.SessionImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

@Repository(value="BeetlSQLHelper")
public class BeetlSQLHelper {
    @Autowired
    SQLManager sqlManager;
    private static final String userkey = "loginuser";
    @PersistenceContext
    @Resource
    private EntityManager entityManager;
    private static Logger logger = LoggerFactory.getLogger(BeetlSQLHelper.class);

    private void appendUserToParams(Map<String, Object> params) {
        if (params != null && !params.containsKey(userkey)) {
            params.put(userkey, SysUtils.getLoginUser());
        }
        if (params != null && params.get("search") != null) {
            params.put("search", params.get("search").toString().replace("_", "/_"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getMetaInfoList(String sql, Object[] params) {
        Statement pst = null;
        ResultSet rs = null;
        try {
            ResultSetMetaData data;
            SessionImplementor session = (SessionImplementor)this.entityManager.unwrap(SessionImplementor.class);
            Connection con = session.connection();
            pst = con.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    pst.setObject(i + 1, params[i]);
                }
            }
            if ((data = (rs = pst.executeQuery()).getMetaData()) != null) {
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
                for (int i = 1; i <= data.getColumnCount(); ++i) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("colNum", data.getColumnName(i));
                    map.put("colType", data.getColumnTypeName(i));
                    map.put("colField", DBPropertyUtil.columnToProperty2(data.getColumnName(i).toLowerCase()));
                    result.add(map);
                }
                ArrayList<Map<String, Object>> arrayList = result;
                return arrayList;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u5e93\u76f8\u5e94\u5217\u540d\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("ResultSet failed\uff01", (Throwable)e);
                }
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    logger.error("PreparedStatement failed\uff01", (Throwable)e);
                }
            }
        }
        return null;
    }

    public PageObject<Map<String, Object>> serachPage(String sqlId, Map<String, Object> params, PageRequest pageRequest) {
        this.appendUserToParams(params);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), params, -1L, (long)pageRequest.getPageSize());
        Class<Map> clazz = Map.class;
        this.sqlManager.pageQuery(sqlId, clazz, query);
        return new PageObject<Map<String, Object>>(query);
    }

    public LayuiPageObject<Map<String, Object>> serachLayuiPage(String sqlId, Map<String, Object> params, PageRequest pageRequest) {
        this.appendUserToParams(params);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), params, -1L, (long)pageRequest.getPageSize());
        Class<Map> clazz = Map.class;
        this.sqlManager.pageQuery(sqlId, clazz, query);
        return new LayuiPageObject<Map<String, Object>>(query);
    }

    public PageObject<Map<String, Object>> serachPage(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        Class<Map> clazz = Map.class;
        List<Map> list = this.getList(sqlId, params, clazz);
        PageObject<Map<String, Object>> pageObject = new PageObject<Map<String, Object>>();
        pageObject.setRows(list);
        pageObject.setTotal(Long.parseLong(String.valueOf(list.size())));
        return pageObject;
    }

    public <T> PageObject<T> serachPage(String sqlId, Map<String, Object> params, Class<T> cls, PageRequest pageRequest) {
        this.appendUserToParams(params);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), params, -1L, (long)pageRequest.getPageSize());
        this.sqlManager.pageQuery(sqlId, cls, query);
        return new PageObject(query);
    }

    public <T> PageObject<T> serachPage(String sqlId, Map<String, Object> params, Class<T> cls) {
        this.appendUserToParams(params);
        List<T> list = this.getList(sqlId, params, cls);
        PageObject<T> pageObject = new PageObject<T>();
        pageObject.setRows(list);
        pageObject.setTotal(Long.parseLong(String.valueOf(list.size())));
        return pageObject;
    }

    public <T> List<T> getList(String sqlId, Map<String, Object> params, Class<T> cls) {
        this.appendUserToParams(params);
        List list = this.sqlManager.select(sqlId, cls, params);
        return list;
    }

    public List<Map<String, Object>> getMapList(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        Class<Map> clazz = Map.class;
        List list = this.sqlManager.select(sqlId, clazz, params);
        return list;
    }

    public <T> T getEntity(String sqlId, Map<String, Object> params, Class<T> cls) {
        this.appendUserToParams(params);
        Object t = this.sqlManager.selectSingle(sqlId, params, cls);
        return (T)t;
    }

    public Map<String, Object> getMap(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        Class<Map> clazz = Map.class;
        Map retrunMap = (Map)this.sqlManager.selectSingle(sqlId, params, clazz);
        return retrunMap;
    }

    public Long getLongValue(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        return this.sqlManager.longValue(sqlId, params);
    }

    public Integer getIntValue(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        return this.sqlManager.intValue(sqlId, params);
    }

    public BigDecimal getBigDecimalValue(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        return this.sqlManager.bigDecimalValue(sqlId, params);
    }

    public String getStringValue(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        return (String)this.sqlManager.selectSingle(sqlId, params, String.class);
    }

    public int updateOrDelete(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        return this.sqlManager.update(sqlId, params);
    }

    public int updateBysql(String sql, Map<String, Object> params) {
        this.appendUserToParams(params);
        return this.sqlManager.executeUpdate(sql, params);
    }

    public PageObject<Map<String, Object>> serachPageBySql(String sql, Map<String, Object> params, PageRequest pageRequest) {
        this.appendUserToParams(params);
        Class<Map> clazz = Map.class;
        List list = this.sqlManager.execute(sql, clazz, params, (long)((pageRequest.getPageNumber() - 1) * pageRequest.getPageSize() + 1), (long)pageRequest.getPageSize());
        PageObject<Map<String, Object>> pageObject = new PageObject<Map<String, Object>>();
        pageObject.setRows(list);
        List count = this.sqlManager.execute("select count(*) from (" + sql + ") t", Long.class, params);
        pageObject.setTotal((Long)count.get(0));
        return pageObject;
    }

    public List<Map<String, Object>> serachBySql(String sql, Map<String, Object> params) {
        this.appendUserToParams(params);
        Class<Map> clazz = Map.class;
        List list = this.sqlManager.execute(sql, clazz, params);
        return list;
    }

    public <T> List<T> serachBySql(String sql, Map<String, Object> params, Class<T> cls) {
        this.appendUserToParams(params);
        List list = this.sqlManager.execute(sql, cls, params);
        return list;
    }

    public PageObject<Map<String, Object>> searchPage(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        Class<Map> clazz = Map.class;
        List<Map> list = this.getList(sqlId, params, clazz);
        PageObject<Map<String, Object>> pageObject = new PageObject<Map<String, Object>>();
        pageObject.setRows(list);
        pageObject.setTotal(Long.parseLong(String.valueOf(list.size())));
        return pageObject;
    }

    public <T> PageObject<T> searchPage(String sqlId, Map<String, Object> params, Class<T> cls, PageRequest pageRequest) {
        this.appendUserToParams(params);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), params, -1L, (long)pageRequest.getPageSize());
        this.sqlManager.pageQuery(sqlId, cls, query);
        return new PageObject(query);
    }

    public PageObject<Map<String, Object>> searchPage(String sqlId, Map<String, Object> params, PageRequest pageRequest) {
        this.appendUserToParams(params);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), params, -1L, (long)pageRequest.getPageSize());
        Class<Map> clazz = Map.class;
        this.sqlManager.pageQuery(sqlId, clazz, query);
        return new PageObject<Map<String, Object>>(query);
    }
}

