/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.util;

import com.guochuang.imp.base.common.util.GenerateRandomKeyUtil;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class AesUtil {
    private static final String ALGORITHMSTR = "AES/ECB/PKCS5Padding";

    public static String base64Encode(byte[] bytes) {
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static byte[] base64Decode(String base64Code) throws Exception {
        return StringUtils.isEmpty((CharSequence)base64Code) ? null : Base64.decodeBase64((String)base64Code);
    }

    public static byte[] aesEncryptToBytes(String content, String encryptKey) throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(encryptKey.getBytes());
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128, secureRandom);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(1, new SecretKeySpec(encryptKey.getBytes(), "AES"));
        return cipher.doFinal(content.getBytes("utf-8"));
    }

    public static String aesEncrypt(String content, String encryptKey) throws Exception {
        return AesUtil.base64Encode(AesUtil.aesEncryptToBytes(content, encryptKey));
    }

    public static String aesDecryptByBytes(byte[] encryptBytes, String decryptKey) throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        secureRandom.setSeed(decryptKey.getBytes());
        KeyGenerator kgen = KeyGenerator.getInstance("AES");
        kgen.init(128, secureRandom);
        Cipher cipher = Cipher.getInstance(ALGORITHMSTR);
        cipher.init(2, new SecretKeySpec(decryptKey.getBytes(), "AES"));
        byte[] decryptBytes = cipher.doFinal(encryptBytes);
        return new String(decryptBytes);
    }

    public static String aesDecrypt(String encryptStr, String decryptKey) throws Exception {
        return StringUtils.isEmpty((CharSequence)encryptStr) ? null : AesUtil.aesDecryptByBytes(AesUtil.base64Decode(encryptStr), decryptKey);
    }

    public static void main(String[] args) throws Exception {
        String sessionSalt = GenerateRandomKeyUtil.getRandomKey(16);
        String content = "admin";
        System.out.println("\u52a0\u5bc6\u524d\uff1a" + content);
        System.out.println("\u52a0\u5bc6\u5bc6\u94a5\u548c\u89e3\u5bc6\u5bc6\u94a5\uff1a" + sessionSalt);
        String encrypt = AesUtil.aesEncrypt(content, sessionSalt);
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + encrypt);
        String decrypt = AesUtil.aesDecrypt(encrypt, sessionSalt);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + decrypt);
    }
}

