/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.support;

import com.guochuang.imp.base.common.support.LockByKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class SimultaneousEntriesLockByKey<T>
implements LockByKey<T> {
    private final Map<T, Semaphore> semaphores = new ConcurrentHashMap<T, Semaphore>();
    private int allowed_threads;

    public SimultaneousEntriesLockByKey(int allowed_threads) {
        this.allowed_threads = allowed_threads;
    }

    @Override
    public synchronized void lock(T key) {
        Semaphore semaphore = this.semaphores.compute(key, (k, v) -> v == null ? new Semaphore(this.allowed_threads) : v);
        semaphore.acquireUninterruptibly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(T key) {
        if (key == null) {
            throw new IllegalArgumentException("key \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Semaphore semaphore = this.semaphores.get(key);
        if (semaphore == null) {
            return;
        }
        semaphore.release();
        Map<T, Semaphore> map = this.semaphores;
        synchronized (map) {
            if (semaphore.availablePermits() >= this.allowed_threads) {
                this.semaphores.remove(key, semaphore);
            }
        }
    }
}

