/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.spring;

import com.alibaba.fastjson.JSON;
import com.guochuang.imp.base.common.spring.OpRecord;
import com.guochuang.imp.base.common.util.SysUtils;
import com.guochuang.imp.base.common.util.ThreadPoolUtil;
import com.guochuang.imp.base.entity.BasOpRecord;
import com.guochuang.imp.base.service.BasOpRecordService;
import com.guochuang.imp.util.StringUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class OpRecordAspect {
    private static Logger logger = LoggerFactory.getLogger(OpRecordAspect.class);
    @Autowired
    private BasOpRecordService basOpRecordService;

    @Pointcut(value="@annotation(com.guochuang.imp.base.common.spring.OpRecord)")
    private void pointcut() {
    }

    @Around(value="pointcut()")
    public Object doAround(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature methodSignature = (MethodSignature)pjp.getSignature();
        Method method = methodSignature.getMethod();
        OpRecord annotation = method.getAnnotation(OpRecord.class);
        String entityName = annotation.value();
        String busiId = annotation.busiId();
        String busiFormCode = annotation.busiFormCode();
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext((Object)pjp);
        standardEvaluationContext = this.setContextVariables(standardEvaluationContext, (JoinPoint)pjp);
        String busiIdBefore = this.getElValue("#" + entityName + "." + busiId, standardEvaluationContext);
        Object re = pjp.proceed();
        String busiIdVal = this.getElValue("#" + entityName + "." + busiId, standardEvaluationContext);
        String opType = StringUtil.isEmpty(busiIdBefore) ? "0" : "1";
        Long curAccountId = SysUtils.getLoginAccountId();
        ThreadPoolUtil.commPools.submit(() -> {
            String[] argNames = ((MethodSignature)pjp.getSignature()).getParameterNames();
            Object[] args = pjp.getArgs();
            for (int i = 0; i < argNames.length; ++i) {
                if (!argNames[i].equals(entityName)) continue;
                BasOpRecord basOpRecord = new BasOpRecord();
                basOpRecord.setBusiId(Long.parseLong(busiIdVal));
                basOpRecord.setBusiFormCode(busiFormCode);
                basOpRecord.setContent(JSON.toJSONString((Object)args[i]));
                basOpRecord.setOpType(opType);
                basOpRecord.setIsUse("Y");
                basOpRecord.setCreater(curAccountId);
                this.basOpRecordService.saveBasOpRecord(basOpRecord);
            }
        });
        return re;
    }

    private void execuAfter(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        OpRecord annotation = method.getAnnotation(OpRecord.class);
        String entityName = annotation.value();
        String busiFormCode = annotation.busiFormCode();
        String busiId = annotation.busiId();
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext((Object)joinPoint);
        standardEvaluationContext = this.setContextVariables(standardEvaluationContext, joinPoint);
        Long busiIdVal = Long.parseLong(this.getElValue("#" + entityName + "." + busiId, standardEvaluationContext));
        String[] argNames = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
        Object[] args = joinPoint.getArgs();
        for (int i = 0; i < argNames.length; ++i) {
            if (!argNames[i].equals(entityName)) continue;
            BasOpRecord basOpRecord = new BasOpRecord();
            basOpRecord.setBusiId(busiIdVal);
            basOpRecord.setBusiFormCode(busiFormCode);
            basOpRecord.setContent(JSON.toJSONString((Object)args[i]));
            basOpRecord.setOpType("1");
            this.basOpRecordService.saveBasOpRecord(basOpRecord);
        }
    }

    private StandardEvaluationContext setContextVariables(StandardEvaluationContext standardEvaluationContext, JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method targetMethod = methodSignature.getMethod();
        LocalVariableTableParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
        String[] parametersName = parameterNameDiscoverer.getParameterNames(targetMethod);
        if (args == null || args.length <= 0) {
            return standardEvaluationContext;
        }
        for (int i = 0; i < args.length; ++i) {
            standardEvaluationContext.setVariable(parametersName[i], args[i]);
        }
        return standardEvaluationContext;
    }

    private String getElValue(String key, StandardEvaluationContext context) {
        if (StringUtil.isEmpty(key)) {
            return "";
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(key);
        String value = (String)exp.getValue((EvaluationContext)context, String.class);
        return value;
    }
}

