/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.interceptor.repeat;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.guochuang.imp.base.common.interceptor.repeat.HttpHelper;
import com.guochuang.imp.base.common.interceptor.repeat.RepeatSubmit;
import com.guochuang.imp.base.common.interceptor.repeat.RepeatSubmitInterceptor;
import com.guochuang.imp.base.common.interceptor.repeat.RepeatSubmitProperties;
import com.guochuang.imp.base.common.interceptor.repeat.RepeatedlyRequestWrapper;
import com.guochuang.imp.base.common.util.SysUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@EnableConfigurationProperties(value={RepeatSubmitProperties.class})
public class SameUrlDataInterceptor
extends RepeatSubmitInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SameUrlDataInterceptor.class);
    public final String REPEAT_PARAMS = "repeatParams";
    public final String REPEAT_TIME = "repeatTime";
    private static final Cache<String, Object> cache = CacheBuilder.newBuilder().maximumSize(600L).expireAfterWrite(RepeatSubmitProperties.getExpireTime().longValue(), TimeUnit.SECONDS).build();

    @Override
    public boolean isRepeatSubmit(HttpServletRequest request, RepeatSubmit annotation) {
        Map preDataMap;
        Map sessionMap;
        String nowParams = "";
        if (request instanceof RepeatedlyRequestWrapper) {
            RepeatedlyRequestWrapper repeatedlyRequest = (RepeatedlyRequestWrapper)request;
            nowParams = HttpHelper.getBodyString((ServletRequest)repeatedlyRequest);
        }
        if (StringUtils.isEmpty((Object)nowParams)) {
            nowParams = this.toJsonString(request.getParameterMap());
        }
        HashMap<String, Object> nowDataMap = new HashMap<String, Object>();
        nowDataMap.put("repeatParams", SysUtils.MD5(nowParams));
        nowDataMap.put("repeatTime", System.currentTimeMillis());
        String url = request.getRequestURI();
        String cacheRepeatKey = "rs_" + request.getSession().getId() + "_" + url;
        Object sessionObj = cache.getIfPresent((Object)String.valueOf(cacheRepeatKey));
        if (sessionObj != null && (sessionMap = (Map)sessionObj).containsKey(url) && this.compareParams(nowDataMap, preDataMap = (Map)sessionMap.get(url)) && this.compareTime(nowDataMap, preDataMap, annotation.interval())) {
            return true;
        }
        HashMap<String, HashMap<String, Object>> cacheMap = new HashMap<String, HashMap<String, Object>>(1);
        cacheMap.put(url, nowDataMap);
        cache.put((Object)cacheRepeatKey, cacheMap);
        return false;
    }

    private boolean compareParams(Map<String, Object> nowMap, Map<String, Object> preMap) {
        String nowParams = (String)nowMap.get("repeatParams");
        String preParams = (String)preMap.get("repeatParams");
        return nowParams.equals(preParams);
    }

    private boolean compareTime(Map<String, Object> nowMap, Map<String, Object> preMap, int interval) {
        long time2;
        long time1 = (Long)nowMap.get("repeatTime");
        return time1 - (time2 = ((Long)preMap.get("repeatTime")).longValue()) < (long)(interval * 1000);
    }

    private String toJsonString(Object obj) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

