/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.filter;

import com.guochuang.imp.base.common.filter.FormDataXssRequest;
import com.guochuang.imp.base.common.filter.PayloadXssRequest;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class XssFilter
implements Filter {
    public static Logger loger = Logger.getLogger(Filter.class);
    private static String[] REFERERS = new String[]{"http://localhost", "http://127.0.0.1", "http://192.168", "http://10.1.9", "http://36.7.134.1", "http://zgpt.hfbhtz.com", "http://11.11.17.251", "http://11.11", "http://power.kdgcsoft.com:8181", "http://11.11", "http://www.hfbhtz.com", "http://www.fytfjt.com", "http://220.178.228.222", "http://32b4e55f.r3.cpolar.top"};

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String currentURL = req.getRequestURI();
        String head = req.getHeader("Content-Type");
        if (this.checkUri(req)) {
            if (!(!currentURL.contains(".jsp") && !currentURL.contains(".action") && currentURL.contains(".") || currentURL.contains("/import") || currentURL.contains("/ueditor/action") || currentURL.contains("WebOfficeController") || currentURL.contains("file/upload") || currentURL.contains("file/multiupload") || currentURL.contains("loginPage/upload") || currentURL.contains("saveFile") || currentURL.contains("upload"))) {
                if (head != null) {
                    String enctype = req.getContentType();
                    if (StringUtils.isNotBlank((CharSequence)enctype) && enctype.contains("multipart/form-data") && !currentURL.contains("/BasMenu") && !currentURL.contains("/GenPanel") && !currentURL.contains("/BasMenu") && !currentURL.contains("/yozoWebOffice")) {
                        chain.doFilter((ServletRequest)new PayloadXssRequest(req), (ServletResponse)res);
                    } else if (!currentURL.contains("/BasMenu") && !currentURL.contains("/GenPanel")) {
                        chain.doFilter((ServletRequest)new FormDataXssRequest(req), (ServletResponse)res);
                    } else {
                        chain.doFilter((ServletRequest)req, (ServletResponse)res);
                    }
                } else {
                    chain.doFilter((ServletRequest)req, (ServletResponse)res);
                }
            } else {
                chain.doFilter((ServletRequest)req, (ServletResponse)res);
            }
        }
    }

    private boolean checkUri(HttpServletRequest req) {
        String quer = req.getRequestURI() + "?" + req.getQueryString();
        if (!(quer == null || req.getRequestURI().contains("file/") || quer.contains("saveReportBase") || quer.contains("myMenuFunction") || quer.contains("BasUsedFunction") || !this.matchString(quer))) {
            return false;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies != null && cookies.length > 0) {
            for (Cookie cookie : cookies) {
                if (!this.matchString(cookie.getValue())) continue;
                return false;
            }
        }
        String referer = req.getHeader("Referer");
        boolean b = true;
        for (String vReferer : REFERERS) {
            if (referer != null && !referer.trim().startsWith(vReferer)) continue;
            b = true;
            break;
        }
        return b;
    }

    private boolean matchString(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return false;
        }
        try {
            str = URLDecoder.decode(str, "UTF-8");
            str = str.replace('\u0000', ' ').replaceAll("\\s*|\t|\r|\n", "").toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            return true;
        }
        String s = "[\\s\\S]*../[\\s\\S]*?";
        if (str.matches("[\\s\\S]*<script[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*alert[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*href[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*<iframe[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*<image[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*<img[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*<input[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*<a[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*<svg[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*<style[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*<textarea[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*window[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*eval\\([\\s\\S]*\\)[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*function[\\s\\S]*?")) {
            return true;
        }
        if (str.matches("[\\s\\S]*\\.\\./[\\s\\S]*?")) {
            return true;
        }
        return str.matches("[\\s\\S]*\\.\\.\\\\[\\s\\S]*?") && !str.endsWith(".log");
    }

    public void destroy() {
    }
}

