/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.base.common.filter;

import com.guochuang.imp.base.common.spring.SpringContextHolder;
import com.guochuang.imp.base.common.support.SysConfigEnum;
import com.guochuang.imp.base.common.util.BeetlSQLHelper;
import com.guochuang.imp.base.common.util.LoginUser;
import com.guochuang.imp.base.common.util.MemCache;
import com.guochuang.imp.config.SysConfigProperties;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class MenuConfirmFilter
implements Filter {
    public static Logger loger = Logger.getLogger(MenuConfirmFilter.class);
    private static long expiredTime = 180000L;
    private boolean inted = false;
    private static Map<String, Long> menus = new HashMap<String, Long>(){
        {
            this.put("/view/business/hr/HrSalaryJInputMain", null);
            this.put("/view/business/hr/HrSalaryDeptInputQuery", null);
            this.put("/view/business/hr/HrSalaryJInputMainSelf", null);
            this.put("/view/business/fm/FmImport", null);
        }
    };
    private static Map<String, Object> controlMenus = new HashMap<String, Object>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (SysConfigProperties.getMenuControl() && this.checkControlMenu(req)) {
            request.getRequestDispatcher("/errorpage/403").forward(request, response);
            return;
        }
        if ("Y".equals(MemCache.SysConfigMap.get(SysConfigEnum.QUERY_VERIFY.getCode())) && this.checkMenu(req)) {
            LoginUser user = (LoginUser)req.getSession().getAttribute("LOGIN_USER");
            String password = user.getEmp().getLoginPasswordTwice();
            String erpServer = user.getErpServer();
            String empName = user.getEmp().getEmpName();
            request.setAttribute("password", (Object)password);
            request.setAttribute("erpServer", (Object)erpServer);
            request.setAttribute("empName", (Object)empName);
            String queryPassSpecify = MemCache.SysConfigMap.get(SysConfigEnum.QUERY_PASS_SPECIFY.getCode());
            request.setAttribute("queryPassSpecify", (Object)queryPassSpecify);
            String url = req.getRequestURI();
            String queryurl = req.getQueryString();
            if (null != queryurl) {
                url = url + "?" + queryurl;
            }
            request.setAttribute("preurl", (Object)url.replace(req.getContextPath(), ""));
            request.getRequestDispatcher("/view/setTwicePassword").forward(request, response);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean checkMenu(HttpServletRequest req) {
        Object ob;
        String currentURL = req.getRequestURI();
        if (StringUtils.isBlank((CharSequence)currentURL)) {
            return false;
        }
        currentURL = currentURL.replace(req.getContextPath(), "");
        if (!this.inted) {
            Class<MenuConfirmFilter> clazz = MenuConfirmFilter.class;
            // MONITORENTER : com.guochuang.imp.base.common.filter.MenuConfirmFilter.class
            if (!this.inted) {
                MenuConfirmFilter.reloadMenus();
                this.inted = true;
            }
            // MONITOREXIT : clazz
        }
        String host = "http://www.ct.com";
        try {
            URI uri1 = new URI(host + currentURL);
            URI normalizedUri1 = uri1.normalize();
            currentURL = normalizedUri1.toString().replace(host, "");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (!menus.containsKey(currentURL)) {
            return false;
        }
        Long lastTime = null;
        if ("Y".equals(MemCache.SysConfigMap.get(SysConfigEnum.CONTINUOUS_QUERY_VERIFY_GLOBAL.getCode()))) {
            ob = req.getSession().getAttribute("LAST_QUERY_VERIFY_TIME");
            if (ob == null) {
                req.getSession().setAttribute("menuConfirmMap", new HashMap());
                return true;
            }
            lastTime = (Long)ob;
        } else {
            ob = req.getSession().getAttribute("menuConfirmMap");
            if (ob == null) {
                req.getSession().setAttribute("menuConfirmMap", new HashMap());
                return true;
            }
            HashMap map = (HashMap)ob;
            if (map.get(currentURL) == null) {
                return true;
            }
            lastTime = (Long)map.get(currentURL);
        }
        if (MemCache.SysConfigMap.get(SysConfigEnum.CONTINUOUS_QUERY_VERIFY.getCode()) != null) {
            try {
                expiredTime = Long.parseLong(MemCache.SysConfigMap.get(SysConfigEnum.CONTINUOUS_QUERY_VERIFY.getCode()));
            }
            catch (Exception e) {
                loger.warn((Object)("\u9a8c\u8bc1\u5bc6\u7801\u751f\u6548\u65f6\u95f4\u5931\u8d25,\u5931\u8d25\u539f\u56e0" + e.getMessage()));
            }
        }
        if (System.currentTimeMillis() - lastTime <= expiredTime) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean checkControlMenu(HttpServletRequest req) {
        String currentURL = req.getRequestURI();
        if (StringUtils.isBlank((CharSequence)currentURL)) {
            return false;
        }
        currentURL = currentURL.replace(req.getContextPath(), "");
        if (!this.inted) {
            Class<MenuConfirmFilter> clazz = MenuConfirmFilter.class;
            // MONITORENTER : com.guochuang.imp.base.common.filter.MenuConfirmFilter.class
            if (!this.inted) {
                MenuConfirmFilter.reloadMenus();
                this.inted = true;
            }
            // MONITOREXIT : clazz
        }
        String host = "http://www.ct.com";
        try {
            URI uri1 = new URI(host + currentURL);
            URI normalizedUri1 = uri1.normalize();
            currentURL = normalizedUri1.toString().replace(host, "");
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (!controlMenus.containsKey(currentURL)) {
            return false;
        }
        Subject currentUser = SecurityUtils.getSubject();
        if (currentUser.isPermitted(currentURL)) return false;
        return true;
    }

    public static void reloadMenus() {
        BeetlSQLHelper bSqlHelper = SpringContextHolder.getBean(BeetlSQLHelper.class);
        List<Map<String, Object>> menuList = bSqlHelper.serachBySql("SELECT t.MENU_ADDR,t.MENU_ID FROM bas_menu t where t.IS_TWICE_PASSWORD_CONFIRM='Y' and t.is_Use='Y' and (t.MENU_ADDR is not null and t.MENU_ADDR !='') ", null);
        menus = menuList.stream().collect(Collectors.toMap(map -> Objects.toString(map.get("menuAddr")).split("\\?")[0], map -> Long.parseLong(Objects.toString(map.get("menuId")))));
        List<Map<String, Object>> menuControlList = bSqlHelper.getMapList("base.BasMenu.getMenus", null);
        controlMenus = menuControlList.stream().collect(Collectors.toMap(map -> Objects.toString(map.get("menuAddr")).split("\\?")[0], map -> map.get("menuId"), (k, v) -> k + "*******" + v));
    }

    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

