/*
 * Decompiled with CFR 0.152.
 */
package com.guochuang.imp.app.common;

import cn.hutool.core.map.MapUtil;
import com.getui.push.v2.sdk.ApiHelper;
import com.getui.push.v2.sdk.GtApiConfiguration;
import com.getui.push.v2.sdk.api.PushApi;
import com.getui.push.v2.sdk.common.ApiResult;
import com.getui.push.v2.sdk.dto.req.Audience;
import com.getui.push.v2.sdk.dto.req.AudienceDTO;
import com.getui.push.v2.sdk.dto.req.Settings;
import com.getui.push.v2.sdk.dto.req.Strategy;
import com.getui.push.v2.sdk.dto.req.message.PushChannel;
import com.getui.push.v2.sdk.dto.req.message.PushDTO;
import com.getui.push.v2.sdk.dto.req.message.PushMessage;
import com.getui.push.v2.sdk.dto.req.message.android.AndroidDTO;
import com.getui.push.v2.sdk.dto.req.message.android.GTNotification;
import com.getui.push.v2.sdk.dto.req.message.android.ThirdNotification;
import com.getui.push.v2.sdk.dto.req.message.android.Ups;
import com.getui.push.v2.sdk.dto.req.message.ios.Alert;
import com.getui.push.v2.sdk.dto.req.message.ios.Aps;
import com.getui.push.v2.sdk.dto.req.message.ios.IosDTO;
import com.getui.push.v2.sdk.dto.res.TaskIdDTO;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppPush {
    private static Logger logger = Logger.getLogger(AppPush.class);
    @Value(value="${app.appId:-}")
    private String appId;
    @Value(value="${app.appKey:-}")
    private String appKey;
    @Value(value="${app.masterSecret:-}")
    private String masterSecret;
    @Value(value="${app.packName:com.kdgcsoft.zhct}")
    private String packName;
    @Value(value="${app.trustSSL:true}")
    private boolean trustSSL;
    private PushApi pushApi;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PushApi getPushApi() {
        if (this.pushApi != null) return this.pushApi;
        Class<AppPush> clazz = AppPush.class;
        synchronized (AppPush.class) {
            if (this.pushApi != null) return this.pushApi;
            GtApiConfiguration apiConfiguration = new GtApiConfiguration();
            apiConfiguration.setAppId(this.appId);
            apiConfiguration.setAppKey(this.appKey);
            apiConfiguration.setMasterSecret(this.masterSecret);
            apiConfiguration.setDomain("https://restapi.getui.com/v2/");
            apiConfiguration.setTrustSSL(this.trustSSL);
            ApiHelper apiHelper = ApiHelper.build((GtApiConfiguration)apiConfiguration);
            this.pushApi = (PushApi)apiHelper.creatApi(PushApi.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.pushApi;
        }
    }

    public String getPackName() {
        return this.packName;
    }

    public void pushToList(String title, String content, String params, List<String> clientIds) {
        this.pushToList(title, content, params, clientIds, true, 1800000, false);
    }

    public void pushToList(String title, String content, String params, List<String> clientIds, boolean addNum) {
        this.pushToList(title, content, params, clientIds, true, 1800000, addNum);
    }

    public Map<String, Object> pushTransmissionToAll(String content, List<String> clientIds, boolean offline) {
        if ("-".equals(this.appId)) {
            logger.warn((Object)"\u6ca1\u6709\u627e\u5230appId\u53c2\u6570\uff0capp\u63a8\u9001\u5931\u6548");
            return null;
        }
        PushDTO pushDTO = new PushDTO();
        pushDTO.setRequestId(System.currentTimeMillis() + "");
        PushMessage pushMessage = new PushMessage();
        pushDTO.setPushMessage(pushMessage);
        pushMessage.setTransmission(content);
        ApiResult task = this.getPushApi().createMsg(pushDTO);
        Audience audience = new Audience();
        AudienceDTO adto = new AudienceDTO();
        adto.setTaskid(((TaskIdDTO)task.getData()).getTaskId());
        adto.setAudience(audience);
        audience.setCid(clientIds);
        ApiResult apiResult = this.getPushApi().pushListByCid(adto);
        return this.getMapValue((ApiResult<Map<String, Map<String, String>>>)apiResult, clientIds);
    }

    public Map<String, Object> pushToList(String title, String content, String params, List<String> clientIds, boolean offline, int offlineExpireTime, boolean addNum) {
        if ("-".equals(this.appId)) {
            logger.warn((Object)"\u6ca1\u6709\u627e\u5230appId\u53c2\u6570\uff0capp\u63a8\u9001\u5931\u6548");
            return null;
        }
        PushDTO pushDTO = new PushDTO();
        pushDTO.setRequestId(System.currentTimeMillis() + "");
        Strategy strategy = new Strategy();
        strategy.setDef(Integer.valueOf(1));
        Settings settings = new Settings();
        settings.setStrategy(strategy);
        pushDTO.setSettings(settings);
        settings.setTtl(Integer.valueOf(offlineExpireTime));
        PushChannel pushChannel = new PushChannel();
        Alert alert = new Alert();
        alert.setTitle(title);
        alert.setBody(content);
        Aps aps = new Aps();
        aps.setContentAvailable(Integer.valueOf(0));
        aps.setSound("default");
        aps.setAlert(alert);
        IosDTO iosDTO = new IosDTO();
        iosDTO.setAps(aps);
        iosDTO.setType("notify");
        iosDTO.setPayload(params);
        iosDTO.setAutoBadge("+1");
        pushChannel.setIos(iosDTO);
        AndroidDTO androidDTO = new AndroidDTO();
        Ups ups = new Ups();
        ThirdNotification notification1 = new ThirdNotification();
        ups.setNotification(notification1);
        notification1.setTitle(title);
        notification1.setBody(content);
        notification1.setClickType("intent");
        notification1.setIntent("intent:#Intent;action=android.intent.action.oppopush;launchFlags=0x14000000;package=" + this.getPackName() + ";component=" + this.getPackName() + "/io.dcloud.PandoraEntry;S.UP-OL-SU=true;S.title=" + title + ";S.content=" + content + ";S.payload=" + params + ";end");
        if (addNum) {
            ups.addOption("HW", "/message/android/notification/badge/class", (Object)"io.dcloud.PandoraEntry");
            ups.addOption("HW", "/message/android/notification/badge/add_num", (Object)1);
        }
        ups.addOption("HW", "/message/android/notification/importance", (Object)"HIGH");
        ups.addOption("VV", "classification", (Object)1);
        ups.addOption("VV", "category", (Object)"TODO");
        androidDTO.setUps(ups);
        pushChannel.setAndroid(androidDTO);
        pushDTO.setPushChannel(pushChannel);
        PushMessage pushMessage = new PushMessage();
        pushDTO.setPushMessage(pushMessage);
        GTNotification notice = new GTNotification();
        notice.setTitle(title);
        notice.setBody(content);
        notice.setPayload(params);
        notice.setClickType("payload");
        notice.setChannelLevel("4");
        pushMessage.setNotification(notice);
        ApiResult task = this.getPushApi().createMsg(pushDTO);
        Audience audience = new Audience();
        AudienceDTO adto = new AudienceDTO();
        adto.setTaskid(((TaskIdDTO)task.getData()).getTaskId());
        adto.setAudience(audience);
        audience.setCid(clientIds);
        ApiResult apiResult = this.getPushApi().pushListByCid(adto);
        return this.getMapValue((ApiResult<Map<String, Map<String, String>>>)apiResult, clientIds);
    }

    private Map<String, Object> getMapValue(ApiResult<Map<String, Map<String, String>>> apiResult, List<String> cids) {
        HashMap map = MapUtil.newHashMap();
        if (apiResult.isSuccess()) {
            Map data = (Map)apiResult.getData();
            Optional first = data.entrySet().stream().findFirst();
            Map.Entry stringMapEntry = (Map.Entry)first.get();
            Map value = (Map)stringMapEntry.getValue();
            String result = (String)value.get(cids);
            map.put("code", 200);
            map.put("result", result);
        } else {
            map.put("code", apiResult.getCode());
            map.put("result", apiResult.getMsg());
        }
        return map;
    }

    public static void main(String[] args) throws IOException {
    }
}

