/*
 * Decompiled with CFR 0.152.
 */
package dm.sql;

import dm.jdbc.dataConvertion.CType2JType;
import dm.jdbc.dbaccess.Const;
import dm.jdbc.dbaccess.DBError;
import dm.jdbc.desc.CommDesc;
import dm.jdbc.driver.DmdbConnection_bs;
import dm.sql.ARRAY;
import dm.sql.TypeData;
import dm.sql.TypeDescriptor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DmdbArrayDataResultSet
implements ResultSet {
    private ARRAY m_array = null;
    private long m_startIndex = 1L;
    private int m_rowCount = 0;
    private int m_curRowNum = (int)(this.m_startIndex - 1L);
    private boolean m_isClosed = false;
    private boolean m_wasPrivColNull = false;
    private DmdbConnection_bs m_conn = null;
    private int m_direction = 1000;
    private int m_type = 1003;
    private int m_conCurrency = 1007;
    private int m_fetchSize = -1;

    DmdbArrayDataResultSet(ARRAY arr) {
        this.m_array = arr;
        TypeDescriptor arrItemDesc = this.m_array.m_arrDesc.getItemDesc();
        this.m_rowCount = this.m_array.m_arrData.length;
        this.m_conn = arrItemDesc.m_conn;
        this.m_startIndex = 1L;
        this.m_curRowNum = (int)(this.m_startIndex - 1L);
    }

    public DmdbArrayDataResultSet(ARRAY arr, long index, int count) {
        this(arr);
        this.m_startIndex = index;
        this.m_rowCount = this.m_rowCount < count ? this.m_rowCount : count;
        this.m_curRowNum = (int)(this.m_startIndex - 1L);
    }

    private void checkClose() throws SQLException {
        if (this.m_isClosed) {
            DBError.throwSQLException(6034);
        }
    }

    private void checkCurrentRow() throws SQLException {
        this.checkClose();
        if ((long)this.m_curRowNum < this.m_startIndex && this.m_curRowNum > this.m_rowCount) {
            throw new SQLException(Const.res.getString("error.cursorNotInResultSet"));
        }
    }

    private boolean checkIsNull(TypeData typeData) {
        this.m_wasPrivColNull = typeData.m_dataBuf == null && typeData.m_dumyData == null;
        return this.m_wasPrivColNull;
    }

    private void release() {
        this.m_conn = null;
        this.m_array = null;
        this.m_rowCount = 0;
        this.m_startIndex = 1L;
        this.m_isClosed = true;
    }

    private void checkUpdatable() throws SQLException {
        throw new SQLException(Const.res.getString("error.arrayRsUptNotSpt"));
    }

    public boolean next() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > this.m_curRowNum) {
            ++this.m_curRowNum;
            return true;
        }
        return false;
    }

    public void close() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        this.release();
    }

    public boolean wasNull() throws SQLException {
        return this.m_wasPrivColNull;
    }

    public String getString(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof String) {
            return (String)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getString(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return false;
        }
        if (typeData.m_dumyData instanceof Boolean) {
            return (Boolean)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getBoolean(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public byte getByte(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Byte) {
            return (Byte)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getByte(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public short getShort(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Short) {
            return (Short)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getShort(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public int getInt(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Integer) {
            return (Integer)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getInt(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public long getLong(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0L;
        }
        if (typeData.m_dumyData instanceof Long) {
            return (Long)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getLong(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public float getFloat(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0.0f;
        }
        if (typeData.m_dumyData instanceof Float) {
            return ((Float)typeData.m_dumyData).longValue();
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getFloat(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public double getDouble(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0.0;
        }
        if (typeData.m_dumyData instanceof Double) {
            return (Double)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getDouble(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bg = this.getBigDecimal(columnIndex);
        if (bg == null) {
            return null;
        }
        return bg.setScale(scale, 4);
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Byte[]) {
            return (byte[])typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getBytes(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public Date getDate(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Date) {
            return (Date)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getDate(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public Time getTime(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Time) {
            return (Time)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getTime(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Timestamp) {
            return (Timestamp)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getTimestamp(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getAsciiStream(typeData.m_dataBuf, desc, this.m_conn);
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getUnicodeStream(typeData.m_dataBuf, desc, this.m_conn);
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getBinaryStream(typeData.m_dataBuf, desc, this.m_conn);
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    public SQLWarning getWarnings() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public void clearWarnings() throws SQLException {
        DBError.throwUnsupportedSQLException();
    }

    public String getCursorName() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Object getObject(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        return typeData.m_dumyData;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return 0;
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getCharacterStream(typeData.m_dataBuf, desc, this.m_conn);
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof BigDecimal) {
            return (BigDecimal)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return CType2JType.getBigDecimal(typeData.m_dataBuf, desc, 0, this.m_conn);
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.m_curRowNum + 1 <= 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.m_curRowNum + 1 > this.m_rowCount;
    }

    public boolean isFirst() throws SQLException {
        return this.m_curRowNum + 1 == 1;
    }

    public boolean isLast() throws SQLException {
        return this.m_curRowNum + 1 == this.m_rowCount;
    }

    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.m_rowCount <= 0) {
            return;
        }
        this.m_curRowNum = -1;
    }

    public void afterLast() throws SQLException {
        this.checkClose();
        if (this.m_rowCount <= 0) {
            return;
        }
        this.m_curRowNum = this.m_rowCount;
    }

    public boolean first() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > 0) {
            this.m_curRowNum = 0;
            return true;
        }
        return false;
    }

    public boolean last() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > 0) {
            this.m_curRowNum = this.m_rowCount - 1;
            return true;
        }
        return false;
    }

    public int getRow() throws SQLException {
        return this.m_curRowNum + 1;
    }

    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (Math.abs(row) > this.m_rowCount || row == 0) {
            return false;
        }
        if (row < 0) {
            this.m_curRowNum = row + this.m_rowCount;
            return true;
        }
        this.m_curRowNum = row - 1;
        return true;
    }

    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (rows == 0) {
            return !this.isBeforeFirst() && !this.isAfterLast();
        }
        int realRow = this.m_curRowNum + rows;
        if (realRow + 1 > this.m_rowCount || realRow + 1 < 1) {
            return false;
        }
        this.m_curRowNum = realRow;
        return true;
    }

    public boolean previous() throws SQLException {
        this.checkClose();
        int realRow = this.m_curRowNum - 1;
        if (realRow < 0 || realRow >= this.m_rowCount) {
            return false;
        }
        this.m_curRowNum = realRow;
        return true;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.m_direction = direction;
    }

    public int getFetchDirection() throws SQLException {
        return this.m_direction;
    }

    public void setFetchSize(int rows) throws SQLException {
        this.m_fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public int getType() throws SQLException {
        return this.m_type;
    }

    public int getConcurrency() throws SQLException {
        return this.m_conCurrency;
    }

    public boolean rowUpdated() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.checkUpdatable();
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkUpdatable();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.checkUpdatable();
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.checkUpdatable();
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.checkUpdatable();
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x);
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.updateByte(this.findColumn(columnName), x);
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.updateShort(this.findColumn(columnName), x);
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.updateInt(this.findColumn(columnName), x);
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.updateLong(this.findColumn(columnName), x);
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x);
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x);
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x);
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.updateString(this.findColumn(columnName), x);
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x);
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.updateDate(this.findColumn(columnName), x);
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.updateTime(this.findColumn(columnName), x);
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x);
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x, length);
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x, length);
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x, scale);
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.updateObject(this.findColumn(columnName), x);
    }

    public void insertRow() throws SQLException {
        this.checkUpdatable();
    }

    public void updateRow() throws SQLException {
        this.checkUpdatable();
    }

    public void deleteRow() throws SQLException {
        this.checkUpdatable();
    }

    public void refreshRow() throws SQLException {
        this.checkUpdatable();
    }

    public void cancelRowUpdates() throws SQLException {
        this.checkUpdatable();
    }

    public void moveToInsertRow() throws SQLException {
        this.checkUpdatable();
    }

    public void moveToCurrentRow() throws SQLException {
        this.checkUpdatable();
    }

    public Statement getStatement() throws SQLException {
        this.checkUpdatable();
        return null;
    }

    public Object getObject(int i, Map map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, i, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Blob) {
            return (Blob)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, i);
        return CType2JType.getBlob(typeData.m_dataBuf, desc, this.m_conn);
    }

    public Clob getClob(int i) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, i, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Clob) {
            return (Clob)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, i);
        return CType2JType.getClob(typeData.m_dataBuf, desc, this.m_conn);
    }

    public Array getArray(int i) throws SQLException {
        this.checkCurrentRow();
        TypeData typeData = this.m_array.getData(this.m_curRowNum, i, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof ARRAY) {
            return (Array)typeData.m_dumyData;
        }
        CommDesc desc = this.m_array.getDataDesc(this.m_curRowNum, i);
        return CType2JType.getArray(typeData.m_dataBuf, desc, this.m_conn);
    }

    public Object getObject(String colName, Map map) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex);
        if (date == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(date);
        return new Date(cal.getTimeInMillis());
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (time == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (timestamp == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(timestamp.getTime());
        return new Timestamp(cal.getTimeInMillis());
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    public URL getURL(int columnIndex) throws SQLException {
        DBError.throwUnsupportedSQLException();
        return null;
    }

    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        this.updateRef(this.findColumn(columnName), x);
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x);
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        this.updateClob(this.findColumn(columnName), x);
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.checkUpdatable();
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        this.updateArray(this.findColumn(columnName), x);
    }
}

