/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.rowset;

import dm.jdbc.dbaccess.DBError;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.rowset.DmdbRowSetInner;
import dm.jdbc.rowset.DmdbRowSetMetaData;
import dm.sql.DmdbIntervalDT;
import dm.sql.DmdbIntervalYM;
import dm.sql.DmdbTime;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.sql.rowset.JdbcRowSet;
import javax.sql.rowset.RowSetWarning;

public class DmdbJdbcRowSet
extends DmdbRowSetInner
implements JdbcRowSet {
    private DmdbResultSet m_resultSet;
    private DmdbConnection m_connection;
    private DmdbCallableStatement m_callableStmt;
    private static boolean m_driverManagerInitialized;
    private boolean m_Closed;

    public DmdbJdbcRowSet(DmdbConnection conn) {
        this.initialize(conn);
    }

    public DmdbJdbcRowSet() {
        this.initialize(null);
    }

    private void initialize(DmdbConnection conn) {
        this.m_connection = conn;
        m_driverManagerInitialized = false;
        this.m_Closed = false;
    }

    private void preparedConn() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            return;
        }
        if (this.getDataSourceName() != null) {
            try {
                InitialContext initialcontext = new InitialContext();
                DataSource datasource = (DataSource)initialcontext.lookup(this.getDataSourceName());
                this.m_connection = (DmdbConnection)datasource.getConnection();
            }
            catch (NamingException namingexception) {
                throw new SQLException("Unable to connect through the DataSource\n" + namingexception.getMessage());
            }
        }
        if (!m_driverManagerInitialized) {
            try {
                Class.forName("dm.jdbc.driver.DmDriver");
                this.m_connection = (DmdbConnection)DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Can not load Driver class dm.jdbc.driver.DmDriver");
            }
            m_driverManagerInitialized = true;
        } else {
            this.m_connection = (DmdbConnection)DriverManager.getConnection(this.getUrl(), this.getUsername(), this.getPassword());
        }
        this.m_connection.setTransactionIsolation(this.getTransactionIsolation());
        this.m_connection.setReadOnly(super.isReadOnly());
        this.m_connection.setTypeMap(this.getTypeMap());
    }

    private void preparedStmt(boolean reset) throws SQLException {
        if (this.m_callableStmt != null && !this.m_callableStmt.isClosed()) {
            if (reset) {
                this.m_callableStmt.close();
                this.m_callableStmt = null;
            } else {
                return;
            }
        }
        this.preparedConn();
        this.m_callableStmt = (DmdbCallableStatement)this.m_connection.prepareCall(this.getCommand(), this.getType(), this.getConcurrency());
        this.m_callableStmt.setFetchSize(this.getFetchSize());
        this.m_callableStmt.setFetchDirection(this.getFetchDirection());
        this.m_callableStmt.setMaxFieldSize(this.getMaxFieldSize());
        this.m_callableStmt.setMaxRows(this.getMaxRows());
        this.m_callableStmt.setQueryTimeout(this.getQueryTimeout());
        this.m_callableStmt.setEscapeProcessing(this.getEscapeProcessing());
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.m_callableStmt.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.m_callableStmt.setNull(paramIndex, sqlType, typeName);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.m_callableStmt.setBoolean(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.m_callableStmt.setByte(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.m_callableStmt.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.m_callableStmt.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.m_callableStmt.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.m_callableStmt.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.m_callableStmt.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.m_callableStmt.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.m_callableStmt.setString(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.m_callableStmt.setBytes(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.m_callableStmt.setDate(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.m_callableStmt.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.m_callableStmt.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.m_callableStmt.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.m_callableStmt.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.m_callableStmt.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.m_callableStmt.setObject(parameterIndex, x, targetSqlType, scale);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.m_callableStmt.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.m_callableStmt.setObject(parameterIndex, x);
    }

    @Override
    public void setRef(int i, Ref x) throws SQLException {
        this.m_callableStmt.setRef(i, x);
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.m_callableStmt.setBlob(i, x);
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.m_callableStmt.setClob(i, x);
    }

    @Override
    public void setArray(int i, Array x) throws SQLException {
        this.m_callableStmt.setArray(i, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.m_callableStmt.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.m_callableStmt.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.m_callableStmt.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.m_callableStmt.clearParameters();
    }

    @Override
    public void execute() throws SQLException {
        this.preparedStmt(false);
        this.m_resultSet = (DmdbResultSet)this.m_callableStmt.executeQuery();
    }

    @Override
    public boolean next() throws SQLException {
        boolean flag = this.m_resultSet.next();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_Closed) {
            return;
        }
        if (this.m_resultSet != null) {
            this.m_resultSet.close();
        }
        this.m_resultSet = null;
        if (this.m_callableStmt != null) {
            this.m_callableStmt.close();
        }
        this.m_callableStmt = null;
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.commit();
            this.m_connection.close();
            this.m_connection = null;
        }
        this.m_Closed = true;
        this.notifyRowSetChanged();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_resultSet.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.m_resultSet.getString(columnIndex);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.m_resultSet.getBoolean(columnIndex);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.m_resultSet.getByte(columnIndex);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.m_resultSet.getShort(columnIndex);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.m_resultSet.getInt(columnIndex);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.m_resultSet.getLong(columnIndex);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.m_resultSet.getFloat(columnIndex);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.m_resultSet.getDouble(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.m_resultSet.getBigDecimal(columnIndex, scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.m_resultSet.getBytes(columnIndex);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.m_resultSet.getDate(columnIndex);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.m_resultSet.getTime(columnIndex);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.m_resultSet.getTimestamp(columnIndex);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getAsciiStream(columnIndex);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getUnicodeStream(columnIndex);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getBinaryStream(columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.m_resultSet.getString(columnName);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.m_resultSet.getBoolean(columnName);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.m_resultSet.getByte(columnName);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.m_resultSet.getShort(columnName);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.m_resultSet.getInt(columnName);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.m_resultSet.getLong(columnName);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.m_resultSet.getFloat(columnName);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.m_resultSet.getDouble(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.m_resultSet.getBigDecimal(columnName, scale);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.m_resultSet.getBytes(columnName);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.m_resultSet.getDate(columnName);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.m_resultSet.getTime(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.m_resultSet.getTimestamp(columnName);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.m_resultSet.getAsciiStream(columnName);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.m_resultSet.getUnicodeStream(columnName);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.m_resultSet.getBinaryStream(columnName);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.m_resultSet.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.m_resultSet.clearWarnings();
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.m_resultSet.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return new DmdbRowSetMetaData((DmdbResultSetMetaData)this.m_resultSet.getMetaData());
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.m_resultSet.getObject(columnIndex, (Map)this.getTypeMap());
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.m_resultSet.getObject(columnName, (Map)this.getTypeMap());
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.m_resultSet.getCharacterStream(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.m_resultSet.getBigDecimal(columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.m_resultSet.getBigDecimal(columnName);
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.m_resultSet.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.m_resultSet.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.m_resultSet.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.m_resultSet.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (!this.isBeforeFirst()) {
            this.m_resultSet.beforeFirst();
            this.notifyCursorMovement();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (!this.isAfterLast()) {
            this.m_resultSet.afterLast();
            this.notifyCursorMovement();
        }
    }

    @Override
    public boolean first() throws SQLException {
        boolean flag = this.m_resultSet.first();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean last() throws SQLException {
        boolean flag = this.m_resultSet.last();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public int getRow() throws SQLException {
        return this.m_resultSet.getRow();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        boolean flag = this.m_resultSet.absolute(row);
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        boolean flag = this.m_resultSet.relative(rows);
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean previous() throws SQLException {
        boolean flag = this.m_resultSet.previous();
        if (flag) {
            this.notifyCursorMovement();
        }
        return flag;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return this.m_resultSet.rowUpdated();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return this.m_resultSet.rowInserted();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return this.m_resultSet.rowDeleted();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.m_resultSet.updateNull(columnIndex);
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.m_resultSet.updateBoolean(columnIndex, x);
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.m_resultSet.updateByte(columnIndex, x);
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.m_resultSet.updateShort(columnIndex, x);
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.m_resultSet.updateInt(columnIndex, x);
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.m_resultSet.updateLong(columnIndex, x);
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.m_resultSet.updateFloat(columnIndex, x);
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.m_resultSet.updateDouble(columnIndex, x);
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.m_resultSet.updateBigDecimal(columnIndex, x);
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.m_resultSet.updateString(columnIndex, x);
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.m_resultSet.updateBytes(columnIndex, x);
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.m_resultSet.updateDate(columnIndex, x);
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.m_resultSet.updateTime(columnIndex, x);
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.m_resultSet.updateTimestamp(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.m_resultSet.updateObject(columnIndex, x, scale);
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.m_resultSet.updateObject(columnIndex, x);
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.m_resultSet.updateNull(columnName);
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.m_resultSet.updateBoolean(columnName, x);
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        this.m_resultSet.updateByte(columnName, x);
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        this.m_resultSet.updateShort(columnName, x);
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        this.m_resultSet.updateInt(columnName, x);
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        this.m_resultSet.updateLong(columnName, x);
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        this.m_resultSet.updateFloat(columnName, x);
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        this.m_resultSet.updateDouble(columnName, x);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.m_resultSet.updateBigDecimal(columnName, x);
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        this.m_resultSet.updateString(columnName, x);
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.m_resultSet.updateBytes(columnName, x);
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        this.m_resultSet.updateDate(columnName, x);
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        this.m_resultSet.updateTime(columnName, x);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.m_resultSet.updateTimestamp(columnName, x);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnName, x, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnName, x, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnName, reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.m_resultSet.updateObject(columnName, x, scale);
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        this.m_resultSet.updateObject(columnName, x);
    }

    @Override
    public void insertRow() throws SQLException {
        this.m_resultSet.insertRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void updateRow() throws SQLException {
        this.m_resultSet.updateRow();
        this.notifyUpdateListeners();
        this.notifyRowSetChanged();
        this.notifyRowChanged();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.m_resultSet.deleteRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.m_resultSet.refreshRow();
        this.notifyRowSetChanged();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.m_resultSet.cancelRowUpdates();
        this.notifyRowChanged();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.m_resultSet.moveToInsertRow();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.m_resultSet.moveToCurrentRow();
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.m_resultSet.getStatement();
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            return this.m_resultSet.getObject(i, (Map)map);
        }
        return this.m_resultSet.getObject(i, (Map)this.getTypeMap());
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        return this.m_resultSet.getRef(i);
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        return this.m_resultSet.getBlob(i);
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        return this.m_resultSet.getClob(i);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        return this.m_resultSet.getArray(i);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        if (map != null) {
            return this.m_resultSet.getObject(colName, (Map)map);
        }
        return this.m_resultSet.getObject(colName, (Map)this.getTypeMap());
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.m_resultSet.getRef(colName);
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.m_resultSet.getBlob(colName);
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.m_resultSet.getClob(colName);
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.m_resultSet.getArray(colName);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.getDate(columnIndex, cal);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.getDate(columnName, cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.getTime(columnIndex, cal);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.getTime(columnName, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.m_resultSet.getTimestamp(columnIndex, cal);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.m_resultSet.getTimestamp(columnName, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.m_resultSet.getURL(columnIndex);
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.m_resultSet.getURL(columnName);
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.m_resultSet.updateRef(columnIndex, x);
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        this.m_resultSet.updateRef(columnName, x);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.m_resultSet.updateBlob(columnIndex, x);
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        this.m_resultSet.updateBlob(columnName, x);
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.m_resultSet.updateClob(columnIndex, x);
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        this.m_resultSet.updateClob(columnName, x);
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.m_resultSet.updateArray(columnIndex, x);
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        this.m_resultSet.updateArray(columnName, x);
    }

    @Override
    public void setShowDeleted(boolean b) throws SQLException {
        if (b) {
            DBError.throwSQLException(20016);
        }
        super.setShowDeleted(b);
    }

    @Override
    public RowSetWarning getRowSetWarnings() throws SQLException {
        return null;
    }

    @Override
    public void commit() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.commit();
        } else {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            return this.m_connection.getAutoCommit();
        }
        DBError.throwSQLException(6060);
        return false;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.setAutoCommit(autoCommit);
        } else {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.rollback();
        } else {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public void rollback(Savepoint s) throws SQLException {
        if (this.m_connection != null && !this.m_connection.isClosed()) {
            this.m_connection.rollback(s);
        } else {
            DBError.throwSQLException(6060);
        }
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        return this.m_resultSet.findColumn(columnName);
    }

    @Override
    public void setCommand(String cmd) throws SQLException {
        super.setCommand(cmd);
        this.preparedStmt(true);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.m_callableStmt.setNull(parameterName, sqlType);
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.m_callableStmt.setNull(parameterName, sqlType, typeName);
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this.m_callableStmt.setBoolean(parameterName, x);
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        this.m_callableStmt.setByte(parameterName, x);
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        this.m_callableStmt.setShort(parameterName, x);
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        this.m_callableStmt.setInt(parameterName, x);
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        this.m_callableStmt.setLong(parameterName, x);
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        this.m_callableStmt.setFloat(parameterName, x);
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        this.m_callableStmt.setDouble(parameterName, x);
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this.m_callableStmt.setBigDecimal(parameterName, x);
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        this.m_callableStmt.setString(parameterName, x);
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this.m_callableStmt.setBytes(parameterName, x);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this.m_callableStmt.setTimestamp(parameterName, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this.m_callableStmt.setAsciiStream(parameterName, x, length);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this.m_callableStmt.setBinaryStream(parameterName, x, length);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this.m_callableStmt.setCharacterStream(parameterName, reader, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.m_callableStmt.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        this.m_callableStmt.setAsciiStream(parameterName, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.m_callableStmt.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        this.m_callableStmt.setBinaryStream(parameterName, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.setCharacterStream(parameterName, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.m_callableStmt.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this.m_callableStmt.setObject(parameterName, x, targetSqlType, scale);
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this.m_callableStmt.setObject(parameterName, x, targetSqlType);
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        this.m_callableStmt.setObject(parameterName, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.m_callableStmt.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.m_callableStmt.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        this.m_callableStmt.setBlob(parameterName, inputStream, length);
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        this.m_callableStmt.setBlob(parameterName, x);
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        this.m_callableStmt.setBlob(parameterName, inputStream);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.m_callableStmt.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        this.m_callableStmt.setClob(parameterName, reader, length);
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        this.m_callableStmt.setClob(parameterName, x);
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.setClob(parameterName, reader);
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        this.m_callableStmt.setDate(parameterName, x);
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this.m_callableStmt.setDate(parameterName, x, cal);
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        this.m_callableStmt.setTime(parameterName, x);
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this.m_callableStmt.setTime(parameterName, x, cal);
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this.m_callableStmt.setTimestamp(parameterName, x, cal);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.m_callableStmt.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.m_callableStmt.setSQLXML(parameterName, xmlObject);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.m_callableStmt.setRowId(parameterIndex, x);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        this.m_callableStmt.setRowId(parameterName, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.m_callableStmt.setNString(parameterIndex, value);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        this.m_callableStmt.setNString(parameterName, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.m_callableStmt.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        this.m_callableStmt.setNCharacterStream(parameterName, value, length);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        this.m_callableStmt.setNCharacterStream(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        this.m_callableStmt.setNClob(parameterName, value);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        this.m_callableStmt.setNClob(parameterName, reader, length);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        this.m_callableStmt.setNClob(parameterName, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.m_callableStmt.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.m_callableStmt.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.m_callableStmt.setNClob(parameterIndex, reader);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.m_callableStmt.setURL(parameterIndex, x);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        return this.m_resultSet.getRowId(columnIndex);
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        return this.m_resultSet.getRowId(columnLabel);
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.m_resultSet.updateRowId(columnIndex, x);
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.m_resultSet.updateRowId(columnLabel, x);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.m_resultSet.getHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_Closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.m_resultSet.updateNString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.m_resultSet.updateNString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.m_resultSet.updateNClob(columnIndex, nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.m_resultSet.updateNClob(columnLabel, nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.m_resultSet.getNClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.m_resultSet.getNClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.m_resultSet.getSQLXML(columnIndex);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.m_resultSet.getSQLXML(columnLabel);
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.m_resultSet.updateSQLXML(columnIndex, xmlObject);
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.m_resultSet.updateSQLXML(columnLabel, xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.m_resultSet.getNString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.m_resultSet.getNString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.m_resultSet.getNCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.m_resultSet.getNCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.m_resultSet.updateNCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateNCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnIndex, x, length);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnIndex, x, length);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnIndex, x, length);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnLabel, x, length);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnLabel, x, length);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.m_resultSet.updateBlob(columnIndex, inputStream, length);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.m_resultSet.updateBlob(columnLabel, inputStream, length);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateNClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.m_resultSet.updateNClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.m_resultSet.updateNCharacterStream(columnIndex, x);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.updateNCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnIndex, x);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnIndex, x);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnIndex, x);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.m_resultSet.updateAsciiStream(columnLabel, x);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.m_resultSet.updateBinaryStream(columnLabel, x);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.m_resultSet.updateBlob(columnIndex, inputStream);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.m_resultSet.updateBlob(columnLabel, inputStream);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.m_resultSet.updateClob(columnIndex, reader);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.updateClob(columnLabel, reader);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.m_resultSet.updateNClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.m_resultSet.updateNClob(columnLabel, reader);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.m_resultSet.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.m_resultSet.isWrapperFor(iface);
    }

    public void setINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        this.m_callableStmt.setINTERVALYM(i, ym);
    }

    public void setINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        this.m_callableStmt.setINTERVALDT(i, dt);
    }

    public void setTIME(int i, DmdbTime t) throws SQLException {
        this.m_callableStmt.setTIME(i, t);
    }

    public void updateINTERVALYM(int i, DmdbIntervalYM ym) throws SQLException {
        this.m_resultSet.updateINTERVALYM(i, ym);
    }

    public void updateINTERVALYM(String s, DmdbIntervalYM ym) throws SQLException {
        this.m_resultSet.updateINTERVALYM(s, ym);
    }

    public void updateINTERVALDT(int i, DmdbIntervalDT dt) throws SQLException {
        this.m_resultSet.updateINTERVALDT(i, dt);
    }

    public void updateINTERVALDT(String s, DmdbIntervalDT dt) throws SQLException {
        this.m_resultSet.updateINTERVALDT(s, dt);
    }
}

